# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MemberArgs', 'Member']

@pulumi.input_type
class MemberArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Member resource.
        :param pulumi.Input[_builtins.str] account_id: The ID of the member AWS account.
        :param pulumi.Input[_builtins.str] email: The email of the member AWS account.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "account_id", account_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if invite is not None:
            pulumi.set(__self__, "invite", invite)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the member AWS account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the member AWS account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def invite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        return pulumi.get(self, "invite")

    @invite.setter
    def invite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "invite", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MemberState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 master_id: Optional[pulumi.Input[_builtins.str]] = None,
                 member_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Member resources.
        :param pulumi.Input[_builtins.str] account_id: The ID of the member AWS account.
        :param pulumi.Input[_builtins.str] email: The email of the member AWS account.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        :param pulumi.Input[_builtins.str] master_id: The ID of the master Security Hub AWS account.
        :param pulumi.Input[_builtins.str] member_status: The status of the member account relationship.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if invite is not None:
            pulumi.set(__self__, "invite", invite)
        if master_id is not None:
            pulumi.set(__self__, "master_id", master_id)
        if member_status is not None:
            pulumi.set(__self__, "member_status", member_status)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the member AWS account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the member AWS account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def invite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        return pulumi.get(self, "invite")

    @invite.setter
    def invite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "invite", value)

    @_builtins.property
    @pulumi.getter(name="masterId")
    def master_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the master Security Hub AWS account.
        """
        return pulumi.get(self, "master_id")

    @master_id.setter
    def master_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_id", value)

    @_builtins.property
    @pulumi.getter(name="memberStatus")
    def member_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the member account relationship.
        """
        return pulumi.get(self, "member_status")

    @member_status.setter
    def member_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_status", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:securityhub/member:Member")
class Member(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Security Hub member resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_member = aws.securityhub.Member("example",
            account_id="123456789012",
            email="example@example.com",
            invite=True,
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        Using `pulumi import`, import Security Hub members using their account ID. For example:

        ```sh
        $ pulumi import aws:securityhub/member:Member example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The ID of the member AWS account.
        :param pulumi.Input[_builtins.str] email: The email of the member AWS account.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Security Hub member resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_member = aws.securityhub.Member("example",
            account_id="123456789012",
            email="example@example.com",
            invite=True,
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        Using `pulumi import`, import Security Hub members using their account ID. For example:

        ```sh
        $ pulumi import aws:securityhub/member:Member example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param MemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MemberArgs.__new__(MemberArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["email"] = email
            __props__.__dict__["invite"] = invite
            __props__.__dict__["region"] = region
            __props__.__dict__["master_id"] = None
            __props__.__dict__["member_status"] = None
        super(Member, __self__).__init__(
            'aws:securityhub/member:Member',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            invite: Optional[pulumi.Input[_builtins.bool]] = None,
            master_id: Optional[pulumi.Input[_builtins.str]] = None,
            member_status: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'Member':
        """
        Get an existing Member resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The ID of the member AWS account.
        :param pulumi.Input[_builtins.str] email: The email of the member AWS account.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        :param pulumi.Input[_builtins.str] master_id: The ID of the master Security Hub AWS account.
        :param pulumi.Input[_builtins.str] member_status: The status of the member account relationship.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MemberState.__new__(_MemberState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["email"] = email
        __props__.__dict__["invite"] = invite
        __props__.__dict__["master_id"] = master_id
        __props__.__dict__["member_status"] = member_status
        __props__.__dict__["region"] = region
        return Member(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the member AWS account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The email of the member AWS account.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def invite(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        return pulumi.get(self, "invite")

    @_builtins.property
    @pulumi.getter(name="masterId")
    def master_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the master Security Hub AWS account.
        """
        return pulumi.get(self, "master_id")

    @_builtins.property
    @pulumi.getter(name="memberStatus")
    def member_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the member account relationship.
        """
        return pulumi.get(self, "member_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

