# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServiceDnsConfigArgs',
    'ServiceDnsConfigArgsDict',
    'ServiceDnsConfigDnsRecordArgs',
    'ServiceDnsConfigDnsRecordArgsDict',
    'ServiceHealthCheckConfigArgs',
    'ServiceHealthCheckConfigArgsDict',
    'ServiceHealthCheckCustomConfigArgs',
    'ServiceHealthCheckCustomConfigArgsDict',
]

MYPY = False

if not MYPY:
    class ServiceDnsConfigArgsDict(TypedDict):
        dns_records: pulumi.Input[Sequence[pulumi.Input['ServiceDnsConfigDnsRecordArgsDict']]]
        """
        An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
        """
        namespace_id: pulumi.Input[_builtins.str]
        """
        The ID of the namespace to use for DNS configuration.
        """
        routing_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
        """
elif False:
    ServiceDnsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceDnsConfigArgs:
    def __init__(__self__, *,
                 dns_records: pulumi.Input[Sequence[pulumi.Input['ServiceDnsConfigDnsRecordArgs']]],
                 namespace_id: pulumi.Input[_builtins.str],
                 routing_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDnsConfigDnsRecordArgs']]] dns_records: An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the namespace to use for DNS configuration.
        :param pulumi.Input[_builtins.str] routing_policy: The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
        """
        pulumi.set(__self__, "dns_records", dns_records)
        pulumi.set(__self__, "namespace_id", namespace_id)
        if routing_policy is not None:
            pulumi.set(__self__, "routing_policy", routing_policy)

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceDnsConfigDnsRecordArgs']]]:
        """
        An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
        """
        return pulumi.get(self, "dns_records")

    @dns_records.setter
    def dns_records(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceDnsConfigDnsRecordArgs']]]):
        pulumi.set(self, "dns_records", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the namespace to use for DNS configuration.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="routingPolicy")
    def routing_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
        """
        return pulumi.get(self, "routing_policy")

    @routing_policy.setter
    def routing_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_policy", value)


if not MYPY:
    class ServiceDnsConfigDnsRecordArgsDict(TypedDict):
        ttl: pulumi.Input[_builtins.int]
        """
        The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
        """
elif False:
    ServiceDnsConfigDnsRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceDnsConfigDnsRecordArgs:
    def __init__(__self__, *,
                 ttl: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.int] ttl: The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
        :param pulumi.Input[_builtins.str] type: The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
        """
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[_builtins.int]:
        """
        The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ServiceHealthCheckConfigArgsDict(TypedDict):
        failure_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive health checks. Maximum value of 10.
        """
        resource_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
elif False:
    ServiceHealthCheckConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceHealthCheckConfigArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_path: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] failure_threshold: The number of consecutive health checks. Maximum value of 10.
        :param pulumi.Input[_builtins.str] resource_path: The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
        :param pulumi.Input[_builtins.str] type: The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive health checks. Maximum value of 10.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_threshold", value)

    @_builtins.property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
        """
        return pulumi.get(self, "resource_path")

    @resource_path.setter
    def resource_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ServiceHealthCheckCustomConfigArgsDict(TypedDict):
        failure_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Value is always set to 1.
        """
elif False:
    ServiceHealthCheckCustomConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceHealthCheckCustomConfigArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] failure_threshold: The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Value is always set to 1.
        """
        if failure_threshold is not None:
            warnings.warn("""failure_threshold is deprecated. The argument is no longer supported by AWS and the value is always set to 1. The attribute will be removed in a future major version.""", DeprecationWarning)
            pulumi.log.warn("""failure_threshold is deprecated: failure_threshold is deprecated. The argument is no longer supported by AWS and the value is always set to 1. The attribute will be removed in a future major version.""")
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    @_utilities.deprecated("""failure_threshold is deprecated. The argument is no longer supported by AWS and the value is always set to 1. The attribute will be removed in a future major version.""")
    def failure_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Value is always set to 1.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_threshold", value)


