# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetActiveReceiptRuleSetResult',
    'AwaitableGetActiveReceiptRuleSetResult',
    'get_active_receipt_rule_set',
    'get_active_receipt_rule_set_output',
]

@pulumi.output_type
class GetActiveReceiptRuleSetResult:
    """
    A collection of values returned by getActiveReceiptRuleSet.
    """
    def __init__(__self__, arn=None, id=None, region=None, rule_set_name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rule_set_name and not isinstance(rule_set_name, str):
            raise TypeError("Expected argument 'rule_set_name' to be a str")
        pulumi.set(__self__, "rule_set_name", rule_set_name)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        SES receipt rule set ARN.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleSetName")
    def rule_set_name(self) -> _builtins.str:
        """
        Name of the rule set
        """
        return pulumi.get(self, "rule_set_name")


class AwaitableGetActiveReceiptRuleSetResult(GetActiveReceiptRuleSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActiveReceiptRuleSetResult(
            arn=self.arn,
            id=self.id,
            region=self.region,
            rule_set_name=self.rule_set_name)


def get_active_receipt_rule_set(region: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActiveReceiptRuleSetResult:
    """
    Retrieve the active SES receipt rule set

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.ses.get_active_receipt_rule_set()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ses/getActiveReceiptRuleSet:getActiveReceiptRuleSet', __args__, opts=opts, typ=GetActiveReceiptRuleSetResult).value

    return AwaitableGetActiveReceiptRuleSetResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        rule_set_name=pulumi.get(__ret__, 'rule_set_name'))
def get_active_receipt_rule_set_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetActiveReceiptRuleSetResult]:
    """
    Retrieve the active SES receipt rule set

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.ses.get_active_receipt_rule_set()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ses/getActiveReceiptRuleSet:getActiveReceiptRuleSet', __args__, opts=opts, typ=GetActiveReceiptRuleSetResult)
    return __ret__.apply(lambda __response__: GetActiveReceiptRuleSetResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        rule_set_name=pulumi.get(__response__, 'rule_set_name')))
