# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityNotificationTopicArgs', 'IdentityNotificationTopic']

@pulumi.input_type
class IdentityNotificationTopicArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input[_builtins.str],
                 notification_type: pulumi.Input[_builtins.str],
                 include_original_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IdentityNotificationTopic resource.
        :param pulumi.Input[_builtins.str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[_builtins.str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
        :param pulumi.Input[_builtins.bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. `false` by default.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "notification_type", notification_type)
        if include_original_headers is not None:
            pulumi.set(__self__, "include_original_headers", include_original_headers)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input[_builtins.str]:
        """
        The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "notification_type", value)

    @_builtins.property
    @pulumi.getter(name="includeOriginalHeaders")
    def include_original_headers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SES should include original email headers in SNS notifications of this type. `false` by default.
        """
        return pulumi.get(self, "include_original_headers")

    @include_original_headers.setter
    def include_original_headers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_original_headers", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class _IdentityNotificationTopicState:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 include_original_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IdentityNotificationTopic resources.
        :param pulumi.Input[_builtins.str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[_builtins.bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. `false` by default.
        :param pulumi.Input[_builtins.str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if include_original_headers is not None:
            pulumi.set(__self__, "include_original_headers", include_original_headers)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="includeOriginalHeaders")
    def include_original_headers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SES should include original email headers in SNS notifications of this type. `false` by default.
        """
        return pulumi.get(self, "include_original_headers")

    @include_original_headers.setter
    def include_original_headers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_original_headers", value)

    @_builtins.property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.type_token("aws:ses/identityNotificationTopic:IdentityNotificationTopic")
class IdentityNotificationTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 include_original_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing SES Identity Notification Topics

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ses.IdentityNotificationTopic("test",
            topic_arn=example_aws_sns_topic["arn"],
            notification_type="Bounce",
            identity=example["domain"],
            include_original_headers=True)
        ```

        ## Import

        Using `pulumi import`, import Identity Notification Topics using the ID of the record. The ID is made up as `IDENTITY|TYPE` where `IDENTITY` is the SES Identity and `TYPE` is the Notification Type. For example:

        ```sh
        $ pulumi import aws:ses/identityNotificationTopic:IdentityNotificationTopic test 'example.com|Bounce'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[_builtins.bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. `false` by default.
        :param pulumi.Input[_builtins.str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityNotificationTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing SES Identity Notification Topics

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ses.IdentityNotificationTopic("test",
            topic_arn=example_aws_sns_topic["arn"],
            notification_type="Bounce",
            identity=example["domain"],
            include_original_headers=True)
        ```

        ## Import

        Using `pulumi import`, import Identity Notification Topics using the ID of the record. The ID is made up as `IDENTITY|TYPE` where `IDENTITY` is the SES Identity and `TYPE` is the Notification Type. For example:

        ```sh
        $ pulumi import aws:ses/identityNotificationTopic:IdentityNotificationTopic test 'example.com|Bounce'
        ```

        :param str resource_name: The name of the resource.
        :param IdentityNotificationTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityNotificationTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 include_original_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityNotificationTopicArgs.__new__(IdentityNotificationTopicArgs)

            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["include_original_headers"] = include_original_headers
            if notification_type is None and not opts.urn:
                raise TypeError("Missing required property 'notification_type'")
            __props__.__dict__["notification_type"] = notification_type
            __props__.__dict__["region"] = region
            __props__.__dict__["topic_arn"] = topic_arn
        super(IdentityNotificationTopic, __self__).__init__(
            'aws:ses/identityNotificationTopic:IdentityNotificationTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity: Optional[pulumi.Input[_builtins.str]] = None,
            include_original_headers: Optional[pulumi.Input[_builtins.bool]] = None,
            notification_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            topic_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'IdentityNotificationTopic':
        """
        Get an existing IdentityNotificationTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[_builtins.bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. `false` by default.
        :param pulumi.Input[_builtins.str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityNotificationTopicState.__new__(_IdentityNotificationTopicState)

        __props__.__dict__["identity"] = identity
        __props__.__dict__["include_original_headers"] = include_original_headers
        __props__.__dict__["notification_type"] = notification_type
        __props__.__dict__["region"] = region
        __props__.__dict__["topic_arn"] = topic_arn
        return IdentityNotificationTopic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[_builtins.str]:
        """
        The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="includeOriginalHeaders")
    def include_original_headers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether SES should include original email headers in SNS notifications of this type. `false` by default.
        """
        return pulumi.get(self, "include_original_headers")

    @_builtins.property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
        """
        return pulumi.get(self, "notification_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `""` (an empty string) to disable publishing.
        """
        return pulumi.get(self, "topic_arn")

