# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetStateMachineResult',
    'AwaitableGetStateMachineResult',
    'get_state_machine',
    'get_state_machine_output',
]

@pulumi.output_type
class GetStateMachineResult:
    """
    A collection of values returned by getStateMachine.
    """
    def __init__(__self__, arn=None, creation_date=None, definition=None, description=None, id=None, name=None, region=None, revision_id=None, role_arn=None, status=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if definition and not isinstance(definition, str):
            raise TypeError("Expected argument 'definition' to be a str")
        pulumi.set(__self__, "definition", definition)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if revision_id and not isinstance(revision_id, str):
            raise TypeError("Expected argument 'revision_id' to be a str")
        pulumi.set(__self__, "revision_id", revision_id)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Set to the arn of the state function.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Date the state machine was created.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def definition(self) -> _builtins.str:
        """
        Set to the state machine definition.
        """
        return pulumi.get(self, "definition")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> _builtins.str:
        """
        The revision identifier for the state machine.
        """
        return pulumi.get(self, "revision_id")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        Set to the role_arn used by the state function.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Set to the current status of the state machine.
        """
        return pulumi.get(self, "status")


class AwaitableGetStateMachineResult(GetStateMachineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStateMachineResult(
            arn=self.arn,
            creation_date=self.creation_date,
            definition=self.definition,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            revision_id=self.revision_id,
            role_arn=self.role_arn,
            status=self.status)


def get_state_machine(name: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStateMachineResult:
    """
    Use this data source to get the ARN of a State Machine in AWS Step
    Function (SFN). By using this data source, you can reference a
    state machine without having to hard code the ARNs as input.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.sfn.get_state_machine(name="an_example_sfn_name")
    ```


    :param _builtins.str name: Friendly name of the state machine to match.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:sfn/getStateMachine:getStateMachine', __args__, opts=opts, typ=GetStateMachineResult).value

    return AwaitableGetStateMachineResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        definition=pulumi.get(__ret__, 'definition'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        revision_id=pulumi.get(__ret__, 'revision_id'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        status=pulumi.get(__ret__, 'status'))
def get_state_machine_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStateMachineResult]:
    """
    Use this data source to get the ARN of a State Machine in AWS Step
    Function (SFN). By using this data source, you can reference a
    state machine without having to hard code the ARNs as input.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.sfn.get_state_machine(name="an_example_sfn_name")
    ```


    :param _builtins.str name: Friendly name of the state machine to match.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:sfn/getStateMachine:getStateMachine', __args__, opts=opts, typ=GetStateMachineResult)
    return __ret__.apply(lambda __response__: GetStateMachineResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        definition=pulumi.get(__response__, 'definition'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        revision_id=pulumi.get(__response__, 'revision_id'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        status=pulumi.get(__response__, 'status')))
