# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProactiveEngagementArgs', 'ProactiveEngagement']

@pulumi.input_type
class ProactiveEngagementArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 emergency_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]] = None):
        """
        The set of arguments for constructing a ProactiveEngagement resource.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value indicating if Proactive Engagement should be enabled or not.
        :param pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]] emergency_contacts: One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if emergency_contacts is not None:
            pulumi.set(__self__, "emergency_contacts", emergency_contacts)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Boolean value indicating if Proactive Engagement should be enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="emergencyContacts")
    def emergency_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]]:
        """
        One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
        """
        return pulumi.get(self, "emergency_contacts")

    @emergency_contacts.setter
    def emergency_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]]):
        pulumi.set(self, "emergency_contacts", value)


@pulumi.input_type
class _ProactiveEngagementState:
    def __init__(__self__, *,
                 emergency_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ProactiveEngagement resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]] emergency_contacts: One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value indicating if Proactive Engagement should be enabled or not.
        """
        if emergency_contacts is not None:
            pulumi.set(__self__, "emergency_contacts", emergency_contacts)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="emergencyContacts")
    def emergency_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]]:
        """
        One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
        """
        return pulumi.get(self, "emergency_contacts")

    @emergency_contacts.setter
    def emergency_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]]):
        pulumi.set(self, "emergency_contacts", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value indicating if Proactive Engagement should be enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.type_token("aws:shield/proactiveEngagement:ProactiveEngagement")
class ProactiveEngagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 emergency_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProactiveEngagementEmergencyContactArgs', 'ProactiveEngagementEmergencyContactArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Resource for managing a AWS Shield Proactive Engagement.
        Proactive engagement authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_role = aws.iam.Role("example",
            name="example-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Sid": "",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "drt.shield.amazonaws.com",
                    },
                    "Action": "sts:AssumeRole",
                }],
            }))
        example_drt_access_role_arn_association = aws.shield.DrtAccessRoleArnAssociation("example", role_arn=example_role.arn)
        example = aws.shield.ProactiveEngagement("example",
            enabled=True,
            emergency_contacts=[
                {
                    "contact_notes": "Notes",
                    "email_address": "contact1@example.com",
                    "phone_number": "+12358132134",
                },
                {
                    "contact_notes": "Notes 2",
                    "email_address": "contact2@example.com",
                    "phone_number": "+12358132134",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_drt_access_role_arn_association]))
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            role=example_role.name,
            policy_arn="arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
        example_protection_group = aws.shield.ProtectionGroup("example",
            protection_group_id="example",
            aggregation="MAX",
            pattern="ALL")
        ```

        ## Import

        Using `pulumi import`, import Shield proactive engagement using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:shield/proactiveEngagement:ProactiveEngagement example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProactiveEngagementEmergencyContactArgs', 'ProactiveEngagementEmergencyContactArgsDict']]]] emergency_contacts: One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value indicating if Proactive Engagement should be enabled or not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProactiveEngagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a AWS Shield Proactive Engagement.
        Proactive engagement authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_role = aws.iam.Role("example",
            name="example-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Sid": "",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "drt.shield.amazonaws.com",
                    },
                    "Action": "sts:AssumeRole",
                }],
            }))
        example_drt_access_role_arn_association = aws.shield.DrtAccessRoleArnAssociation("example", role_arn=example_role.arn)
        example = aws.shield.ProactiveEngagement("example",
            enabled=True,
            emergency_contacts=[
                {
                    "contact_notes": "Notes",
                    "email_address": "contact1@example.com",
                    "phone_number": "+12358132134",
                },
                {
                    "contact_notes": "Notes 2",
                    "email_address": "contact2@example.com",
                    "phone_number": "+12358132134",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_drt_access_role_arn_association]))
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            role=example_role.name,
            policy_arn="arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
        example_protection_group = aws.shield.ProtectionGroup("example",
            protection_group_id="example",
            aggregation="MAX",
            pattern="ALL")
        ```

        ## Import

        Using `pulumi import`, import Shield proactive engagement using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:shield/proactiveEngagement:ProactiveEngagement example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param ProactiveEngagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProactiveEngagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 emergency_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProactiveEngagementEmergencyContactArgs', 'ProactiveEngagementEmergencyContactArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProactiveEngagementArgs.__new__(ProactiveEngagementArgs)

            __props__.__dict__["emergency_contacts"] = emergency_contacts
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
        super(ProactiveEngagement, __self__).__init__(
            'aws:shield/proactiveEngagement:ProactiveEngagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            emergency_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProactiveEngagementEmergencyContactArgs', 'ProactiveEngagementEmergencyContactArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ProactiveEngagement':
        """
        Get an existing ProactiveEngagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProactiveEngagementEmergencyContactArgs', 'ProactiveEngagementEmergencyContactArgsDict']]]] emergency_contacts: One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value indicating if Proactive Engagement should be enabled or not.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProactiveEngagementState.__new__(_ProactiveEngagementState)

        __props__.__dict__["emergency_contacts"] = emergency_contacts
        __props__.__dict__["enabled"] = enabled
        return ProactiveEngagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="emergencyContacts")
    def emergency_contacts(self) -> pulumi.Output[Optional[Sequence['outputs.ProactiveEngagementEmergencyContact']]]:
        """
        One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
        """
        return pulumi.get(self, "emergency_contacts")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean value indicating if Proactive Engagement should be enabled or not.
        """
        return pulumi.get(self, "enabled")

