# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssociationArgs', 'Association']

@pulumi.input_type
class AssociationArgs:
    def __init__(__self__, *,
                 apply_only_at_cron_interval: Optional[pulumi.Input[_builtins.bool]] = None,
                 association_name: Optional[pulumi.Input[_builtins.str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compliance_severity: Optional[pulumi.Input[_builtins.str]] = None,
                 document_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 max_errors: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_location: Optional[pulumi.Input['AssociationOutputLocationArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_compliance: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Association resource.
        :param pulumi.Input[_builtins.bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[_builtins.str] association_name: The descriptive name for the association.
        :param pulumi.Input[_builtins.str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[_builtins.str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[_builtins.str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[_builtins.str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[_builtins.str] name: The name of the SSM document to apply.
        :param pulumi.Input['AssociationOutputLocationArgs'] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[_builtins.str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[_builtins.int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        if apply_only_at_cron_interval is not None:
            pulumi.set(__self__, "apply_only_at_cron_interval", apply_only_at_cron_interval)
        if association_name is not None:
            pulumi.set(__self__, "association_name", association_name)
        if automation_target_parameter_name is not None:
            pulumi.set(__self__, "automation_target_parameter_name", automation_target_parameter_name)
        if compliance_severity is not None:
            pulumi.set(__self__, "compliance_severity", compliance_severity)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors is not None:
            pulumi.set(__self__, "max_errors", max_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if sync_compliance is not None:
            pulumi.set(__self__, "sync_compliance", sync_compliance)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if wait_for_success_timeout_seconds is not None:
            pulumi.set(__self__, "wait_for_success_timeout_seconds", wait_for_success_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @apply_only_at_cron_interval.setter
    def apply_only_at_cron_interval(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_only_at_cron_interval", value)

    @_builtins.property
    @pulumi.getter(name="associationName")
    def association_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The descriptive name for the association.
        """
        return pulumi.get(self, "association_name")

    @association_name.setter
    def association_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_name", value)

    @_builtins.property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @automation_target_parameter_name.setter
    def automation_target_parameter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automation_target_parameter_name", value)

    @_builtins.property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        """
        return pulumi.get(self, "compliance_severity")

    @compliance_severity.setter
    def compliance_severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compliance_severity", value)

    @_builtins.property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The document version you want to associate with the target(s). Can be a specific version or the default version.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "document_version", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        """
        return pulumi.get(self, "max_errors")

    @max_errors.setter
    def max_errors(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_errors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SSM document to apply.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['AssociationOutputLocationArgs']]:
        """
        An output location block. Output Location is documented below.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['AssociationOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A block of arbitrary string parameters to pass to the SSM document.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_expression", value)

    @_builtins.property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        """
        return pulumi.get(self, "sync_compliance")

    @sync_compliance.setter
    def sync_compliance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_compliance", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]:
        """
        A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.

        Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

    @wait_for_success_timeout_seconds.setter
    def wait_for_success_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_for_success_timeout_seconds", value)


@pulumi.input_type
class _AssociationState:
    def __init__(__self__, *,
                 apply_only_at_cron_interval: Optional[pulumi.Input[_builtins.bool]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 association_name: Optional[pulumi.Input[_builtins.str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compliance_severity: Optional[pulumi.Input[_builtins.str]] = None,
                 document_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 max_errors: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_location: Optional[pulumi.Input['AssociationOutputLocationArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_compliance: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Association resources.
        :param pulumi.Input[_builtins.bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[_builtins.str] arn: The ARN of the SSM association
        :param pulumi.Input[_builtins.str] association_id: The ID of the SSM association.
        :param pulumi.Input[_builtins.str] association_name: The descriptive name for the association.
        :param pulumi.Input[_builtins.str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[_builtins.str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[_builtins.str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[_builtins.str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[_builtins.str] name: The name of the SSM document to apply.
        :param pulumi.Input['AssociationOutputLocationArgs'] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[_builtins.str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[_builtins.int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        if apply_only_at_cron_interval is not None:
            pulumi.set(__self__, "apply_only_at_cron_interval", apply_only_at_cron_interval)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if association_name is not None:
            pulumi.set(__self__, "association_name", association_name)
        if automation_target_parameter_name is not None:
            pulumi.set(__self__, "automation_target_parameter_name", automation_target_parameter_name)
        if compliance_severity is not None:
            pulumi.set(__self__, "compliance_severity", compliance_severity)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors is not None:
            pulumi.set(__self__, "max_errors", max_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if sync_compliance is not None:
            pulumi.set(__self__, "sync_compliance", sync_compliance)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if wait_for_success_timeout_seconds is not None:
            pulumi.set(__self__, "wait_for_success_timeout_seconds", wait_for_success_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @apply_only_at_cron_interval.setter
    def apply_only_at_cron_interval(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_only_at_cron_interval", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the SSM association
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SSM association.
        """
        return pulumi.get(self, "association_id")

    @association_id.setter
    def association_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_id", value)

    @_builtins.property
    @pulumi.getter(name="associationName")
    def association_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The descriptive name for the association.
        """
        return pulumi.get(self, "association_name")

    @association_name.setter
    def association_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_name", value)

    @_builtins.property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @automation_target_parameter_name.setter
    def automation_target_parameter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automation_target_parameter_name", value)

    @_builtins.property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        """
        return pulumi.get(self, "compliance_severity")

    @compliance_severity.setter
    def compliance_severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compliance_severity", value)

    @_builtins.property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The document version you want to associate with the target(s). Can be a specific version or the default version.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "document_version", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        """
        return pulumi.get(self, "max_errors")

    @max_errors.setter
    def max_errors(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_errors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SSM document to apply.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['AssociationOutputLocationArgs']]:
        """
        An output location block. Output Location is documented below.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['AssociationOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A block of arbitrary string parameters to pass to the SSM document.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_expression", value)

    @_builtins.property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        """
        return pulumi.get(self, "sync_compliance")

    @sync_compliance.setter
    def sync_compliance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_compliance", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]:
        """
        A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.

        Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

    @wait_for_success_timeout_seconds.setter
    def wait_for_success_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_for_success_timeout_seconds", value)


@pulumi.type_token("aws:ssm/association:Association")
class Association(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_only_at_cron_interval: Optional[pulumi.Input[_builtins.bool]] = None,
                 association_name: Optional[pulumi.Input[_builtins.str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compliance_severity: Optional[pulumi.Input[_builtins.str]] = None,
                 document_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 max_errors: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_location: Optional[pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_compliance: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Associates an SSM Document to an instance or EC2 tag.

        ## Example Usage

        ### Create an association for a specific instance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ### Create an association for all managed instances in an AWS account

        To target all managed instances in an AWS account, set the `key` as `"InstanceIds"` with `values` set as `["*"]`. This example also illustrates how to use an Amazon owned SSM document named `AmazonCloudWatch-ManageAgent`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])
        ```

        ### Create an association for a specific tag

        This example shows how to target all managed instances that are assigned a tag key of `Environment` and value of `Development`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "tag:Environment",
                "values": ["Development"],
            }])
        ```

        ### Create an association with a specific schedule

        This example shows how to schedule an association in various ways.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ### Create an association with multiple instances with their instance ids

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        # First EC2 instance
        web_server1 = aws.ec2.Instance("web_server_1",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=public["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
        \"\"\")
        # Second EC2 instance
        web_server2 = aws.ec2.Instance("web_server_2",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=public["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
        \"\"\")
        # Removed EC2 provisioning dependencies for brevity
        system_update = aws.ssm.Association("system_update",
            name="AWS-RunShellScript",
            targets=[{
                "key": "InstanceIds",
                "values": [
                    web_server1.id,
                    web_server2.id,
                ],
            }],
            schedule_expression="cron(0 2 ? * SUN *)",
            parameters={
                "commands": std.join(separator="\\n",
                    input=[
                        "#!/bin/bash",
                        "echo 'Starting system update on $(hostname)'",
                        "echo 'Instance ID: $(curl -s http://169.254.169.254/latest/meta-data/instance-id)'",
                        "yum update -y",
                        "echo 'System update completed successfully'",
                        "systemctl status httpd",
                        "df -h",
                        "free -m",
                    ]).result,
                "workingDirectory": "/tmp",
                "executionTimeout": "3600",
            },
            association_name="weekly-system-update",
            compliance_severity="MEDIUM",
            max_concurrency="1",
            max_errors="0",
            tags={
                "Name": "Weekly System Update",
                "Environment": "demo",
                "Purpose": "maintenance",
            })
        ```

        ### Create an association with multiple instances with their values matching their tags

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        # SSM Association for Webbased Servers
        database_association = aws.ssm.Association("database_association",
            name=system_update["name"],
            targets=[{
                "key": "tag:Role",
                "values": [
                    "WebServer",
                    "Database",
                ],
            }],
            parameters={
                "restartServices": "true",
            },
            schedule_expression="cron(0 3 ? * SUN *)")
        # EC2 Instance 1 - Web Server with "ServerType" tag
        web_server = aws.ec2.Instance("web_server",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=default["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=std.base64encode(input=f\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
            
        # Install Apache web server
        yum install -y httpd
        systemctl enable httpd
        systemctl start httpd
        echo "<h1>Web Server - {prefix}</h1>" > /var/www/html/index.html
        \"\"\").result,
            tags={
                "Name": f"{prefix}-web-server",
                "ServerType": "WebServer",
                "Role": "WebServer",
                "Environment": environment,
                "Owner": owner,
            })
        # EC2 Instance 2 - Database Server with "Role" tag
        database_server = aws.ec2.Instance("database_server",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=default["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=std.base64encode(input=\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
            
        # Install MySQL
        yum install -y mysql-server
        systemctl enable mysqld
        systemctl start mysqld
        \"\"\").result,
            tags={
                "Name": f"{prefix}-database-server",
                "Role": "Database",
                "Environment": environment,
                "Owner": owner,
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `association_id` - (String) ID of the SSM association.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `region` (String) Region where this resource is managed.

        Using `pulumi import`, import SSM associations using the `association_id`. For example:

        console

        % pulumi import aws_ssm_association.example 10abcdef-0abc-1234-5678-90abcdef123456

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[_builtins.str] association_name: The descriptive name for the association.
        :param pulumi.Input[_builtins.str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[_builtins.str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[_builtins.str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[_builtins.str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[_builtins.str] name: The name of the SSM document to apply.
        :param pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[_builtins.str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[_builtins.int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AssociationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates an SSM Document to an instance or EC2 tag.

        ## Example Usage

        ### Create an association for a specific instance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ### Create an association for all managed instances in an AWS account

        To target all managed instances in an AWS account, set the `key` as `"InstanceIds"` with `values` set as `["*"]`. This example also illustrates how to use an Amazon owned SSM document named `AmazonCloudWatch-ManageAgent`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])
        ```

        ### Create an association for a specific tag

        This example shows how to target all managed instances that are assigned a tag key of `Environment` and value of `Development`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "tag:Environment",
                "values": ["Development"],
            }])
        ```

        ### Create an association with a specific schedule

        This example shows how to schedule an association in various ways.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ### Create an association with multiple instances with their instance ids

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        # First EC2 instance
        web_server1 = aws.ec2.Instance("web_server_1",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=public["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
        \"\"\")
        # Second EC2 instance
        web_server2 = aws.ec2.Instance("web_server_2",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=public["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
        \"\"\")
        # Removed EC2 provisioning dependencies for brevity
        system_update = aws.ssm.Association("system_update",
            name="AWS-RunShellScript",
            targets=[{
                "key": "InstanceIds",
                "values": [
                    web_server1.id,
                    web_server2.id,
                ],
            }],
            schedule_expression="cron(0 2 ? * SUN *)",
            parameters={
                "commands": std.join(separator="\\n",
                    input=[
                        "#!/bin/bash",
                        "echo 'Starting system update on $(hostname)'",
                        "echo 'Instance ID: $(curl -s http://169.254.169.254/latest/meta-data/instance-id)'",
                        "yum update -y",
                        "echo 'System update completed successfully'",
                        "systemctl status httpd",
                        "df -h",
                        "free -m",
                    ]).result,
                "workingDirectory": "/tmp",
                "executionTimeout": "3600",
            },
            association_name="weekly-system-update",
            compliance_severity="MEDIUM",
            max_concurrency="1",
            max_errors="0",
            tags={
                "Name": "Weekly System Update",
                "Environment": "demo",
                "Purpose": "maintenance",
            })
        ```

        ### Create an association with multiple instances with their values matching their tags

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        # SSM Association for Webbased Servers
        database_association = aws.ssm.Association("database_association",
            name=system_update["name"],
            targets=[{
                "key": "tag:Role",
                "values": [
                    "WebServer",
                    "Database",
                ],
            }],
            parameters={
                "restartServices": "true",
            },
            schedule_expression="cron(0 3 ? * SUN *)")
        # EC2 Instance 1 - Web Server with "ServerType" tag
        web_server = aws.ec2.Instance("web_server",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=default["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=std.base64encode(input=f\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
            
        # Install Apache web server
        yum install -y httpd
        systemctl enable httpd
        systemctl start httpd
        echo "<h1>Web Server - {prefix}</h1>" > /var/www/html/index.html
        \"\"\").result,
            tags={
                "Name": f"{prefix}-web-server",
                "ServerType": "WebServer",
                "Role": "WebServer",
                "Environment": environment,
                "Owner": owner,
            })
        # EC2 Instance 2 - Database Server with "Role" tag
        database_server = aws.ec2.Instance("database_server",
            ami=amazon_linux["id"],
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            subnet_id=default["id"],
            vpc_security_group_ids=[ec2_sg["id"]],
            iam_instance_profile=ec2_ssm_profile["name"],
            user_data=std.base64encode(input=\"\"\"#!/bin/bash
        yum update -y
        yum install -y amazon-ssm-agent
        systemctl enable amazon-ssm-agent
        systemctl start amazon-ssm-agent
            
        # Install MySQL
        yum install -y mysql-server
        systemctl enable mysqld
        systemctl start mysqld
        \"\"\").result,
            tags={
                "Name": f"{prefix}-database-server",
                "Role": "Database",
                "Environment": environment,
                "Owner": owner,
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `association_id` - (String) ID of the SSM association.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `region` (String) Region where this resource is managed.

        Using `pulumi import`, import SSM associations using the `association_id`. For example:

        console

        % pulumi import aws_ssm_association.example 10abcdef-0abc-1234-5678-90abcdef123456

        :param str resource_name: The name of the resource.
        :param AssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_only_at_cron_interval: Optional[pulumi.Input[_builtins.bool]] = None,
                 association_name: Optional[pulumi.Input[_builtins.str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compliance_severity: Optional[pulumi.Input[_builtins.str]] = None,
                 document_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
                 max_errors: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_location: Optional[pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_compliance: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssociationArgs.__new__(AssociationArgs)

            __props__.__dict__["apply_only_at_cron_interval"] = apply_only_at_cron_interval
            __props__.__dict__["association_name"] = association_name
            __props__.__dict__["automation_target_parameter_name"] = automation_target_parameter_name
            __props__.__dict__["compliance_severity"] = compliance_severity
            __props__.__dict__["document_version"] = document_version
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["max_errors"] = max_errors
            __props__.__dict__["name"] = name
            __props__.__dict__["output_location"] = output_location
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["region"] = region
            __props__.__dict__["schedule_expression"] = schedule_expression
            __props__.__dict__["sync_compliance"] = sync_compliance
            __props__.__dict__["tags"] = tags
            __props__.__dict__["targets"] = targets
            __props__.__dict__["wait_for_success_timeout_seconds"] = wait_for_success_timeout_seconds
            __props__.__dict__["arn"] = None
            __props__.__dict__["association_id"] = None
            __props__.__dict__["tags_all"] = None
        super(Association, __self__).__init__(
            'aws:ssm/association:Association',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_only_at_cron_interval: Optional[pulumi.Input[_builtins.bool]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            association_id: Optional[pulumi.Input[_builtins.str]] = None,
            association_name: Optional[pulumi.Input[_builtins.str]] = None,
            automation_target_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
            compliance_severity: Optional[pulumi.Input[_builtins.str]] = None,
            document_version: Optional[pulumi.Input[_builtins.str]] = None,
            max_concurrency: Optional[pulumi.Input[_builtins.str]] = None,
            max_errors: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_location: Optional[pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_expression: Optional[pulumi.Input[_builtins.str]] = None,
            sync_compliance: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
            wait_for_success_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'Association':
        """
        Get an existing Association resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[_builtins.str] arn: The ARN of the SSM association
        :param pulumi.Input[_builtins.str] association_id: The ID of the SSM association.
        :param pulumi.Input[_builtins.str] association_name: The descriptive name for the association.
        :param pulumi.Input[_builtins.str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[_builtins.str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[_builtins.str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[_builtins.str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[_builtins.str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[_builtins.str] name: The name of the SSM document to apply.
        :param pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[_builtins.str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[_builtins.int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssociationState.__new__(_AssociationState)

        __props__.__dict__["apply_only_at_cron_interval"] = apply_only_at_cron_interval
        __props__.__dict__["arn"] = arn
        __props__.__dict__["association_id"] = association_id
        __props__.__dict__["association_name"] = association_name
        __props__.__dict__["automation_target_parameter_name"] = automation_target_parameter_name
        __props__.__dict__["compliance_severity"] = compliance_severity
        __props__.__dict__["document_version"] = document_version
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["max_errors"] = max_errors
        __props__.__dict__["name"] = name
        __props__.__dict__["output_location"] = output_location
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region"] = region
        __props__.__dict__["schedule_expression"] = schedule_expression
        __props__.__dict__["sync_compliance"] = sync_compliance
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["targets"] = targets
        __props__.__dict__["wait_for_success_timeout_seconds"] = wait_for_success_timeout_seconds
        return Association(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the SSM association
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the SSM association.
        """
        return pulumi.get(self, "association_id")

    @_builtins.property
    @pulumi.getter(name="associationName")
    def association_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The descriptive name for the association.
        """
        return pulumi.get(self, "association_name")

    @_builtins.property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @_builtins.property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        """
        return pulumi.get(self, "compliance_severity")

    @_builtins.property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> pulumi.Output[_builtins.str]:
        """
        The document version you want to associate with the target(s). Can be a specific version or the default version.
        """
        return pulumi.get(self, "document_version")

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        """
        return pulumi.get(self, "max_concurrency")

    @_builtins.property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        """
        return pulumi.get(self, "max_errors")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SSM document to apply.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Output[Optional['outputs.AssociationOutputLocation']]:
        """
        An output location block. Output Location is documented below.
        """
        return pulumi.get(self, "output_location")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A block of arbitrary string parameters to pass to the SSM document.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        """
        return pulumi.get(self, "schedule_expression")

    @_builtins.property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        """
        return pulumi.get(self, "sync_compliance")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence['outputs.AssociationTarget']]:
        """
        A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.

        Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

