# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPatchBaselinesResult',
    'AwaitableGetPatchBaselinesResult',
    'get_patch_baselines',
    'get_patch_baselines_output',
]

@pulumi.output_type
class GetPatchBaselinesResult:
    """
    A collection of values returned by getPatchBaselines.
    """
    def __init__(__self__, baseline_identities=None, default_baselines=None, filters=None, id=None, region=None):
        if baseline_identities and not isinstance(baseline_identities, list):
            raise TypeError("Expected argument 'baseline_identities' to be a list")
        pulumi.set(__self__, "baseline_identities", baseline_identities)
        if default_baselines and not isinstance(default_baselines, bool):
            raise TypeError("Expected argument 'default_baselines' to be a bool")
        pulumi.set(__self__, "default_baselines", default_baselines)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="baselineIdentities")
    def baseline_identities(self) -> Sequence['outputs.GetPatchBaselinesBaselineIdentityResult']:
        """
        List of baseline identities. See `baseline_identities` below.
        """
        return pulumi.get(self, "baseline_identities")

    @_builtins.property
    @pulumi.getter(name="defaultBaselines")
    def default_baselines(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "default_baselines")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPatchBaselinesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetPatchBaselinesResult(GetPatchBaselinesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPatchBaselinesResult(
            baseline_identities=self.baseline_identities,
            default_baselines=self.default_baselines,
            filters=self.filters,
            id=self.id,
            region=self.region)


def get_patch_baselines(default_baselines: Optional[_builtins.bool] = None,
                        filters: Optional[Sequence[Union['GetPatchBaselinesFilterArgs', 'GetPatchBaselinesFilterArgsDict']]] = None,
                        region: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPatchBaselinesResult:
    """
    Data source for retrieving AWS SSM (Systems Manager) Patch Baselines.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssm.get_patch_baselines()
    ```

    ### With Filters

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssm.get_patch_baselines(filters=[
        {
            "key": "OWNER",
            "values": ["AWS"],
        },
        {
            "key": "OPERATING_SYSTEM",
            "values": ["WINDOWS"],
        },
    ])
    ```


    :param _builtins.bool default_baselines: Only return baseline identities where `default_baseline` is `true`.
    :param Sequence[Union['GetPatchBaselinesFilterArgs', 'GetPatchBaselinesFilterArgsDict']] filters: Key-value pairs used to filter the results. See `filter` below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['defaultBaselines'] = default_baselines
    __args__['filters'] = filters
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ssm/getPatchBaselines:getPatchBaselines', __args__, opts=opts, typ=GetPatchBaselinesResult).value

    return AwaitableGetPatchBaselinesResult(
        baseline_identities=pulumi.get(__ret__, 'baseline_identities'),
        default_baselines=pulumi.get(__ret__, 'default_baselines'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_patch_baselines_output(default_baselines: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPatchBaselinesFilterArgs', 'GetPatchBaselinesFilterArgsDict']]]]] = None,
                               region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPatchBaselinesResult]:
    """
    Data source for retrieving AWS SSM (Systems Manager) Patch Baselines.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssm.get_patch_baselines()
    ```

    ### With Filters

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssm.get_patch_baselines(filters=[
        {
            "key": "OWNER",
            "values": ["AWS"],
        },
        {
            "key": "OPERATING_SYSTEM",
            "values": ["WINDOWS"],
        },
    ])
    ```


    :param _builtins.bool default_baselines: Only return baseline identities where `default_baseline` is `true`.
    :param Sequence[Union['GetPatchBaselinesFilterArgs', 'GetPatchBaselinesFilterArgsDict']] filters: Key-value pairs used to filter the results. See `filter` below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['defaultBaselines'] = default_baselines
    __args__['filters'] = filters
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ssm/getPatchBaselines:getPatchBaselines', __args__, opts=opts, typ=GetPatchBaselinesResult)
    return __ret__.apply(lambda __response__: GetPatchBaselinesResult(
        baseline_identities=pulumi.get(__response__, 'baseline_identities'),
        default_baselines=pulumi.get(__response__, 'default_baselines'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
