# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CanaryArtifactConfigArgs',
    'CanaryArtifactConfigArgsDict',
    'CanaryArtifactConfigS3EncryptionArgs',
    'CanaryArtifactConfigS3EncryptionArgsDict',
    'CanaryRunConfigArgs',
    'CanaryRunConfigArgsDict',
    'CanaryScheduleArgs',
    'CanaryScheduleArgsDict',
    'CanaryScheduleRetryConfigArgs',
    'CanaryScheduleRetryConfigArgsDict',
    'CanaryTimelineArgs',
    'CanaryTimelineArgsDict',
    'CanaryVpcConfigArgs',
    'CanaryVpcConfigArgsDict',
]

MYPY = False

if not MYPY:
    class CanaryArtifactConfigArgsDict(TypedDict):
        s3_encryption: NotRequired[pulumi.Input['CanaryArtifactConfigS3EncryptionArgsDict']]
        """
        Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
        """
elif False:
    CanaryArtifactConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryArtifactConfigArgs:
    def __init__(__self__, *,
                 s3_encryption: Optional[pulumi.Input['CanaryArtifactConfigS3EncryptionArgs']] = None):
        """
        :param pulumi.Input['CanaryArtifactConfigS3EncryptionArgs'] s3_encryption: Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
        """
        if s3_encryption is not None:
            pulumi.set(__self__, "s3_encryption", s3_encryption)

    @_builtins.property
    @pulumi.getter(name="s3Encryption")
    def s3_encryption(self) -> Optional[pulumi.Input['CanaryArtifactConfigS3EncryptionArgs']]:
        """
        Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
        """
        return pulumi.get(self, "s3_encryption")

    @s3_encryption.setter
    def s3_encryption(self, value: Optional[pulumi.Input['CanaryArtifactConfigS3EncryptionArgs']]):
        pulumi.set(self, "s3_encryption", value)


if not MYPY:
    class CanaryArtifactConfigS3EncryptionArgsDict(TypedDict):
        encryption_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption method to use for artifacts created by this canary. Valid values are: `SSE_S3` and `SSE_KMS`.
        """
        kms_key_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ARN of the customer-managed KMS key to use, if you specify `SSE_KMS` for `encryption_mode`.
        """
elif False:
    CanaryArtifactConfigS3EncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryArtifactConfigS3EncryptionArgs:
    def __init__(__self__, *,
                 encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] encryption_mode: The encryption method to use for artifacts created by this canary. Valid values are: `SSE_S3` and `SSE_KMS`.
        :param pulumi.Input[_builtins.str] kms_key_arn: The ARN of the customer-managed KMS key to use, if you specify `SSE_KMS` for `encryption_mode`.
        """
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption method to use for artifacts created by this canary. Valid values are: `SSE_S3` and `SSE_KMS`.
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the customer-managed KMS key to use, if you specify `SSE_KMS` for `encryption_mode`.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)


if not MYPY:
    class CanaryRunConfigArgsDict(TypedDict):
        active_tracing: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
        """
        environment_variables: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
        """
        ephemeral_storage: NotRequired[pulumi.Input[_builtins.int]]
        """
        Amount of ephemeral storage (in MB) allocated for the canary run during execution. Defaults to 1024.
        """
        memory_in_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
        """
        timeout_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
        """
elif False:
    CanaryRunConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryRunConfigArgs:
    def __init__(__self__, *,
                 active_tracing: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_in_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] active_tracing: Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
        :param pulumi.Input[_builtins.int] ephemeral_storage: Amount of ephemeral storage (in MB) allocated for the canary run during execution. Defaults to 1024.
        :param pulumi.Input[_builtins.int] memory_in_mb: Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
        :param pulumi.Input[_builtins.int] timeout_in_seconds: Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
        """
        if active_tracing is not None:
            pulumi.set(__self__, "active_tracing", active_tracing)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if memory_in_mb is not None:
            pulumi.set(__self__, "memory_in_mb", memory_in_mb)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @_builtins.property
    @pulumi.getter(name="activeTracing")
    def active_tracing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
        """
        return pulumi.get(self, "active_tracing")

    @active_tracing.setter
    def active_tracing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active_tracing", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of ephemeral storage (in MB) allocated for the canary run during execution. Defaults to 1024.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="memoryInMb")
    def memory_in_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
        """
        return pulumi.get(self, "memory_in_mb")

    @memory_in_mb.setter
    def memory_in_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_in_mb", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)


if not MYPY:
    class CanaryScheduleArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        Rate expression or cron expression that defines how often the canary is to run. For rate expression, the syntax is `rate(number unit)`. _unit_ can be `minute`, `minutes`, or `hour`. For cron expression, the syntax is `cron(expression)`. For more information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
        """
        duration_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Duration in seconds, for the canary to continue making regular runs according to the schedule in the Expression value.
        """
        retry_config: NotRequired[pulumi.Input['CanaryScheduleRetryConfigArgsDict']]
        """
        Configuration block for canary retries. Detailed below.
        """
elif False:
    CanaryScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryScheduleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_config: Optional[pulumi.Input['CanaryScheduleRetryConfigArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] expression: Rate expression or cron expression that defines how often the canary is to run. For rate expression, the syntax is `rate(number unit)`. _unit_ can be `minute`, `minutes`, or `hour`. For cron expression, the syntax is `cron(expression)`. For more information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
        :param pulumi.Input[_builtins.int] duration_in_seconds: Duration in seconds, for the canary to continue making regular runs according to the schedule in the Expression value.
        :param pulumi.Input['CanaryScheduleRetryConfigArgs'] retry_config: Configuration block for canary retries. Detailed below.
        """
        pulumi.set(__self__, "expression", expression)
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)
        if retry_config is not None:
            pulumi.set(__self__, "retry_config", retry_config)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Rate expression or cron expression that defines how often the canary is to run. For rate expression, the syntax is `rate(number unit)`. _unit_ can be `minute`, `minutes`, or `hour`. For cron expression, the syntax is `cron(expression)`. For more information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in seconds, for the canary to continue making regular runs according to the schedule in the Expression value.
        """
        return pulumi.get(self, "duration_in_seconds")

    @duration_in_seconds.setter
    def duration_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="retryConfig")
    def retry_config(self) -> Optional[pulumi.Input['CanaryScheduleRetryConfigArgs']]:
        """
        Configuration block for canary retries. Detailed below.
        """
        return pulumi.get(self, "retry_config")

    @retry_config.setter
    def retry_config(self, value: Optional[pulumi.Input['CanaryScheduleRetryConfigArgs']]):
        pulumi.set(self, "retry_config", value)


if not MYPY:
    class CanaryScheduleRetryConfigArgsDict(TypedDict):
        max_retries: pulumi.Input[_builtins.int]
        """
        Maximum number of retries. The value must be less than or equal to `2`. If `max_retries` is `2`, `run_config.timeout_in_seconds` should be less than 600 seconds. Defaults to `0`.
        """
elif False:
    CanaryScheduleRetryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryScheduleRetryConfigArgs:
    def __init__(__self__, *,
                 max_retries: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] max_retries: Maximum number of retries. The value must be less than or equal to `2`. If `max_retries` is `2`, `run_config.timeout_in_seconds` should be less than 600 seconds. Defaults to `0`.
        """
        pulumi.set(__self__, "max_retries", max_retries)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum number of retries. The value must be less than or equal to `2`. If `max_retries` is `2`, `run_config.timeout_in_seconds` should be less than 600 seconds. Defaults to `0`.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_retries", value)


if not MYPY:
    class CanaryTimelineArgsDict(TypedDict):
        created: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date and time the canary was created.
        """
        last_modified: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date and time the canary was most recently modified.
        """
        last_started: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date and time that the canary's most recent run started.
        """
        last_stopped: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date and time that the canary's most recent run ended.
        """
elif False:
    CanaryTimelineArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryTimelineArgs:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 last_started: Optional[pulumi.Input[_builtins.str]] = None,
                 last_stopped: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] created: Date and time the canary was created.
        :param pulumi.Input[_builtins.str] last_modified: Date and time the canary was most recently modified.
        :param pulumi.Input[_builtins.str] last_started: Date and time that the canary's most recent run started.
        :param pulumi.Input[_builtins.str] last_stopped: Date and time that the canary's most recent run ended.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if last_started is not None:
            pulumi.set(__self__, "last_started", last_started)
        if last_stopped is not None:
            pulumi.set(__self__, "last_stopped", last_stopped)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time the canary was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time the canary was most recently modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @_builtins.property
    @pulumi.getter(name="lastStarted")
    def last_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time that the canary's most recent run started.
        """
        return pulumi.get(self, "last_started")

    @last_started.setter
    def last_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_started", value)

    @_builtins.property
    @pulumi.getter(name="lastStopped")
    def last_stopped(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time that the canary's most recent run ended.
        """
        return pulumi.get(self, "last_stopped")

    @last_stopped.setter
    def last_stopped(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_stopped", value)


if not MYPY:
    class CanaryVpcConfigArgsDict(TypedDict):
        ipv6_allowed_for_dual_stack: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If `true`, allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets. The default is `false`.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        IDs of the security groups for this canary.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        IDs of the subnets where this canary is to run.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the VPC where this canary is to run.
        """
elif False:
    CanaryVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryVpcConfigArgs:
    def __init__(__self__, *,
                 ipv6_allowed_for_dual_stack: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] ipv6_allowed_for_dual_stack: If `true`, allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets. The default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: IDs of the security groups for this canary.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: IDs of the subnets where this canary is to run.
        :param pulumi.Input[_builtins.str] vpc_id: ID of the VPC where this canary is to run.
        """
        if ipv6_allowed_for_dual_stack is not None:
            pulumi.set(__self__, "ipv6_allowed_for_dual_stack", ipv6_allowed_for_dual_stack)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="ipv6AllowedForDualStack")
    def ipv6_allowed_for_dual_stack(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets. The default is `false`.
        """
        return pulumi.get(self, "ipv6_allowed_for_dual_stack")

    @ipv6_allowed_for_dual_stack.setter
    def ipv6_allowed_for_dual_stack(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_allowed_for_dual_stack", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IDs of the security groups for this canary.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IDs of the subnets where this canary is to run.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the VPC where this canary is to run.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


