# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointPrivateDnsArgs', 'EndpointPrivateDns']

@pulumi.input_type
class EndpointPrivateDnsArgs:
    def __init__(__self__, *,
                 private_dns_enabled: pulumi.Input[_builtins.bool],
                 vpc_endpoint_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EndpointPrivateDns resource.
        :param pulumi.Input[_builtins.bool] private_dns_enabled: Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: VPC endpoint identifier.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "private_dns_enabled", private_dns_enabled)
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="privateDnsEnabled")
    def private_dns_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
        """
        return pulumi.get(self, "private_dns_enabled")

    @private_dns_enabled.setter
    def private_dns_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "private_dns_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        VPC endpoint identifier.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EndpointPrivateDnsState:
    def __init__(__self__, *,
                 private_dns_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EndpointPrivateDns resources.
        :param pulumi.Input[_builtins.bool] private_dns_enabled: Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: VPC endpoint identifier.
        """
        if private_dns_enabled is not None:
            pulumi.set(__self__, "private_dns_enabled", private_dns_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="privateDnsEnabled")
    def private_dns_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
        """
        return pulumi.get(self, "private_dns_enabled")

    @private_dns_enabled.setter
    def private_dns_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_dns_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC endpoint identifier.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_id", value)


@pulumi.type_token("aws:vpc/endpointPrivateDns:EndpointPrivateDns")
class EndpointPrivateDns(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 private_dns_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for enabling private DNS on an AWS VPC (Virtual Private Cloud) Endpoint.

        > When using this resource, the `private_dns_enabled` argument should be omitted on the parent `ec2.VpcEndpoint` resource.
        Setting the value both places can lead to unintended behavior and persistent differences.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpc.EndpointPrivateDns("example",
            vpc_endpoint_id=example_aws_vpc_endpoint["id"],
            private_dns_enabled=True)
        ```

        ## Import

        Using `pulumi import`, import a VPC (Virtual Private Cloud) Endpoint Private DNS using the `vpc_endpoint_id`. For example:

        ```sh
        $ pulumi import aws:vpc/endpointPrivateDns:EndpointPrivateDns example vpce-abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] private_dns_enabled: Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: VPC endpoint identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointPrivateDnsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for enabling private DNS on an AWS VPC (Virtual Private Cloud) Endpoint.

        > When using this resource, the `private_dns_enabled` argument should be omitted on the parent `ec2.VpcEndpoint` resource.
        Setting the value both places can lead to unintended behavior and persistent differences.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpc.EndpointPrivateDns("example",
            vpc_endpoint_id=example_aws_vpc_endpoint["id"],
            private_dns_enabled=True)
        ```

        ## Import

        Using `pulumi import`, import a VPC (Virtual Private Cloud) Endpoint Private DNS using the `vpc_endpoint_id`. For example:

        ```sh
        $ pulumi import aws:vpc/endpointPrivateDns:EndpointPrivateDns example vpce-abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param EndpointPrivateDnsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointPrivateDnsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 private_dns_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointPrivateDnsArgs.__new__(EndpointPrivateDnsArgs)

            if private_dns_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'private_dns_enabled'")
            __props__.__dict__["private_dns_enabled"] = private_dns_enabled
            __props__.__dict__["region"] = region
            if vpc_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_endpoint_id'")
            __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
        super(EndpointPrivateDns, __self__).__init__(
            'aws:vpc/endpointPrivateDns:EndpointPrivateDns',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            private_dns_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EndpointPrivateDns':
        """
        Get an existing EndpointPrivateDns resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] private_dns_enabled: Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: VPC endpoint identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointPrivateDnsState.__new__(_EndpointPrivateDnsState)

        __props__.__dict__["private_dns_enabled"] = private_dns_enabled
        __props__.__dict__["region"] = region
        __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
        return EndpointPrivateDns(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="privateDnsEnabled")
    def private_dns_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
        """
        return pulumi.get(self, "private_dns_enabled")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        VPC endpoint identifier.
        """
        return pulumi.get(self, "vpc_endpoint_id")

