# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ListenerDefaultAction',
    'ListenerDefaultActionFixedResponse',
    'ListenerDefaultActionForward',
    'ListenerDefaultActionForwardTargetGroup',
    'ListenerRuleAction',
    'ListenerRuleActionFixedResponse',
    'ListenerRuleActionForward',
    'ListenerRuleActionForwardTargetGroup',
    'ListenerRuleMatch',
    'ListenerRuleMatchHttpMatch',
    'ListenerRuleMatchHttpMatchHeaderMatch',
    'ListenerRuleMatchHttpMatchHeaderMatchMatch',
    'ListenerRuleMatchHttpMatchPathMatch',
    'ListenerRuleMatchHttpMatchPathMatchMatch',
    'ResourceConfigurationResourceConfigurationDefinition',
    'ResourceConfigurationResourceConfigurationDefinitionArnResource',
    'ResourceConfigurationResourceConfigurationDefinitionDnsResource',
    'ResourceConfigurationResourceConfigurationDefinitionIpResource',
    'ResourceConfigurationTimeouts',
    'ResourceGatewayTimeouts',
    'ServiceDnsEntry',
    'ServiceNetworkResourceAssociationDnsEntry',
    'ServiceNetworkResourceAssociationTimeouts',
    'ServiceNetworkServiceAssociationDnsEntry',
    'TargetGroupAttachmentTarget',
    'TargetGroupConfig',
    'TargetGroupConfigHealthCheck',
    'TargetGroupConfigHealthCheckMatcher',
    'GetListenerDefaultActionResult',
    'GetListenerDefaultActionFixedResponseResult',
    'GetListenerDefaultActionForwardResult',
    'GetListenerDefaultActionForwardTargetGroupResult',
    'GetServiceDnsEntryResult',
]

@pulumi.output_type
class ListenerDefaultAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedResponse":
            suggest = "fixed_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_response: Optional['outputs.ListenerDefaultActionFixedResponse'] = None,
                 forwards: Optional[Sequence['outputs.ListenerDefaultActionForward']] = None):
        """
        :param Sequence['ListenerDefaultActionForwardArgs'] forwards: Route requests to one or more target groups. See Forward blocks below.
               
               > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
        """
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forwards is not None:
            pulumi.set(__self__, "forwards", forwards)

    @_builtins.property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.ListenerDefaultActionFixedResponse']:
        return pulumi.get(self, "fixed_response")

    @_builtins.property
    @pulumi.getter
    def forwards(self) -> Optional[Sequence['outputs.ListenerDefaultActionForward']]:
        """
        Route requests to one or more target groups. See Forward blocks below.

        > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
        """
        return pulumi.get(self, "forwards")


@pulumi.output_type
class ListenerDefaultActionFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: _builtins.int):
        """
        :param _builtins.int status_code: Custom HTTP status code to return, e.g. a 404 response code. See [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the AWS documentation for a list of supported codes.
        """
        pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        """
        Custom HTTP status code to return, e.g. a 404 response code. See [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the AWS documentation for a list of supported codes.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ListenerDefaultActionForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Optional[Sequence['outputs.ListenerDefaultActionForwardTargetGroup']] = None):
        """
        :param Sequence['ListenerDefaultActionForwardTargetGroupArgs'] target_groups: One or more target group blocks.
        """
        if target_groups is not None:
            pulumi.set(__self__, "target_groups", target_groups)

    @_builtins.property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Optional[Sequence['outputs.ListenerDefaultActionForwardTargetGroup']]:
        """
        One or more target group blocks.
        """
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class ListenerDefaultActionForwardTargetGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroupIdentifier":
            suggest = "target_group_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionForwardTargetGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionForwardTargetGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionForwardTargetGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_group_identifier: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str target_group_identifier: ID or Amazon Resource Name (ARN) of the target group.
        :param _builtins.int weight: Determines how requests are distributed to the target group. Only required if you specify multiple target groups for a forward action. For example, if you specify two target groups, one with a
               weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. See [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the AWS documentation for additional examples. Default: `100`.
        """
        if target_group_identifier is not None:
            pulumi.set(__self__, "target_group_identifier", target_group_identifier)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> Optional[_builtins.str]:
        """
        ID or Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Determines how requests are distributed to the target group. Only required if you specify multiple target groups for a forward action. For example, if you specify two target groups, one with a
        weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. See [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the AWS documentation for additional examples. Default: `100`.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ListenerRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedResponse":
            suggest = "fixed_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_response: Optional['outputs.ListenerRuleActionFixedResponse'] = None,
                 forward: Optional['outputs.ListenerRuleActionForward'] = None):
        """
        :param 'ListenerRuleActionFixedResponseArgs' fixed_response: Describes the rule action that returns a custom HTTP response.
               See `fixed_response` Block for details.
        :param 'ListenerRuleActionForwardArgs' forward: The forward action. Traffic that matches the rule is forwarded to the specified target groups.
               See `forward` Block for details.
        """
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)

    @_builtins.property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.ListenerRuleActionFixedResponse']:
        """
        Describes the rule action that returns a custom HTTP response.
        See `fixed_response` Block for details.
        """
        return pulumi.get(self, "fixed_response")

    @_builtins.property
    @pulumi.getter
    def forward(self) -> Optional['outputs.ListenerRuleActionForward']:
        """
        The forward action. Traffic that matches the rule is forwarded to the specified target groups.
        See `forward` Block for details.
        """
        return pulumi.get(self, "forward")


@pulumi.output_type
class ListenerRuleActionFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: _builtins.int):
        """
        :param _builtins.int status_code: The HTTP response code.
        """
        pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        """
        The HTTP response code.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ListenerRuleActionForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Sequence['outputs.ListenerRuleActionForwardTargetGroup']):
        """
        :param Sequence['ListenerRuleActionForwardTargetGroupArgs'] target_groups: The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
               
               The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
        """
        pulumi.set(__self__, "target_groups", target_groups)

    @_builtins.property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.ListenerRuleActionForwardTargetGroup']:
        """
        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.

        The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
        """
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class ListenerRuleActionForwardTargetGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroupIdentifier":
            suggest = "target_group_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionForwardTargetGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionForwardTargetGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionForwardTargetGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_group_identifier: _builtins.str,
                 weight: Optional[_builtins.int] = None):
        pulumi.set(__self__, "target_group_identifier", target_group_identifier)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> _builtins.str:
        return pulumi.get(self, "target_group_identifier")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "weight")


@pulumi.output_type
class ListenerRuleMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpMatch":
            suggest = "http_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_match: 'outputs.ListenerRuleMatchHttpMatch'):
        """
        :param 'ListenerRuleMatchHttpMatchArgs' http_match: The HTTP criteria that a rule must match.
               See `http_match` Block for details.
        """
        pulumi.set(__self__, "http_match", http_match)

    @_builtins.property
    @pulumi.getter(name="httpMatch")
    def http_match(self) -> 'outputs.ListenerRuleMatchHttpMatch':
        """
        The HTTP criteria that a rule must match.
        See `http_match` Block for details.
        """
        return pulumi.get(self, "http_match")


@pulumi.output_type
class ListenerRuleMatchHttpMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerMatches":
            suggest = "header_matches"
        elif key == "pathMatch":
            suggest = "path_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleMatchHttpMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleMatchHttpMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleMatchHttpMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_matches: Optional[Sequence['outputs.ListenerRuleMatchHttpMatchHeaderMatch']] = None,
                 method: Optional[_builtins.str] = None,
                 path_match: Optional['outputs.ListenerRuleMatchHttpMatchPathMatch'] = None):
        """
        :param Sequence['ListenerRuleMatchHttpMatchHeaderMatchArgs'] header_matches: The header matches.
               Matches incoming requests with rule based on request header value before applying rule action.
               See `header_matches` Block for details.
        :param _builtins.str method: The HTTP method type.
        :param 'ListenerRuleMatchHttpMatchPathMatchArgs' path_match: The path match.
               See `path_match` Block for details.
        """
        if header_matches is not None:
            pulumi.set(__self__, "header_matches", header_matches)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path_match is not None:
            pulumi.set(__self__, "path_match", path_match)

    @_builtins.property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Optional[Sequence['outputs.ListenerRuleMatchHttpMatchHeaderMatch']]:
        """
        The header matches.
        Matches incoming requests with rule based on request header value before applying rule action.
        See `header_matches` Block for details.
        """
        return pulumi.get(self, "header_matches")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The HTTP method type.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="pathMatch")
    def path_match(self) -> Optional['outputs.ListenerRuleMatchHttpMatchPathMatch']:
        """
        The path match.
        See `path_match` Block for details.
        """
        return pulumi.get(self, "path_match")


@pulumi.output_type
class ListenerRuleMatchHttpMatchHeaderMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleMatchHttpMatchHeaderMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleMatchHttpMatchHeaderMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleMatchHttpMatchHeaderMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match: 'outputs.ListenerRuleMatchHttpMatchHeaderMatchMatch',
                 name: _builtins.str,
                 case_sensitive: Optional[_builtins.bool] = None):
        """
        :param 'ListenerRuleMatchHttpMatchHeaderMatchMatchArgs' match: The header match type.
               See Header Match `match` Block for details.
        :param _builtins.str name: The name of the header.
        :param _builtins.bool case_sensitive: Indicates whether the match is case sensitive.
               Default is `false`.
        """
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "name", name)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @_builtins.property
    @pulumi.getter
    def match(self) -> 'outputs.ListenerRuleMatchHttpMatchHeaderMatchMatch':
        """
        The header match type.
        See Header Match `match` Block for details.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the header.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the match is case sensitive.
        Default is `false`.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class ListenerRuleMatchHttpMatchHeaderMatchMatch(dict):
    def __init__(__self__, *,
                 contains: Optional[_builtins.str] = None,
                 exact: Optional[_builtins.str] = None,
                 prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str contains: Specifies a contains type match.
        :param _builtins.str exact: Specifies an exact type match.
        :param _builtins.str prefix: Specifies a prefix type match.
               Matches the value with the prefix.
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def contains(self) -> Optional[_builtins.str]:
        """
        Specifies a contains type match.
        """
        return pulumi.get(self, "contains")

    @_builtins.property
    @pulumi.getter
    def exact(self) -> Optional[_builtins.str]:
        """
        Specifies an exact type match.
        """
        return pulumi.get(self, "exact")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Specifies a prefix type match.
        Matches the value with the prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ListenerRuleMatchHttpMatchPathMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleMatchHttpMatchPathMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleMatchHttpMatchPathMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleMatchHttpMatchPathMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match: 'outputs.ListenerRuleMatchHttpMatchPathMatchMatch',
                 case_sensitive: Optional[_builtins.bool] = None):
        """
        :param 'ListenerRuleMatchHttpMatchPathMatchMatchArgs' match: The header match type.
               See Path Match `match` Block for details.
        :param _builtins.bool case_sensitive: Indicates whether the match is case sensitive.
               Default is `false`.
        """
        pulumi.set(__self__, "match", match)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @_builtins.property
    @pulumi.getter
    def match(self) -> 'outputs.ListenerRuleMatchHttpMatchPathMatchMatch':
        """
        The header match type.
        See Path Match `match` Block for details.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the match is case sensitive.
        Default is `false`.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class ListenerRuleMatchHttpMatchPathMatchMatch(dict):
    def __init__(__self__, *,
                 exact: Optional[_builtins.str] = None,
                 prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str exact: Specifies an exact type match.
        :param _builtins.str prefix: Specifies a prefix type match.
               Matches the value with the prefix.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def exact(self) -> Optional[_builtins.str]:
        """
        Specifies an exact type match.
        """
        return pulumi.get(self, "exact")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Specifies a prefix type match.
        Matches the value with the prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ResourceConfigurationResourceConfigurationDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arnResource":
            suggest = "arn_resource"
        elif key == "dnsResource":
            suggest = "dns_resource"
        elif key == "ipResource":
            suggest = "ip_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigurationResourceConfigurationDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigurationResourceConfigurationDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigurationResourceConfigurationDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn_resource: Optional['outputs.ResourceConfigurationResourceConfigurationDefinitionArnResource'] = None,
                 dns_resource: Optional['outputs.ResourceConfigurationResourceConfigurationDefinitionDnsResource'] = None,
                 ip_resource: Optional['outputs.ResourceConfigurationResourceConfigurationDefinitionIpResource'] = None):
        """
        :param 'ResourceConfigurationResourceConfigurationDefinitionArnResourceArgs' arn_resource: Resource DNS Configuration. See `arn_resource` Block for details.
        :param 'ResourceConfigurationResourceConfigurationDefinitionDnsResourceArgs' dns_resource: Resource DNS Configuration. See `dns_resource` Block for details.
        :param 'ResourceConfigurationResourceConfigurationDefinitionIpResourceArgs' ip_resource: Resource DNS Configuration. See `ip_resource` Block for details.
        """
        if arn_resource is not None:
            pulumi.set(__self__, "arn_resource", arn_resource)
        if dns_resource is not None:
            pulumi.set(__self__, "dns_resource", dns_resource)
        if ip_resource is not None:
            pulumi.set(__self__, "ip_resource", ip_resource)

    @_builtins.property
    @pulumi.getter(name="arnResource")
    def arn_resource(self) -> Optional['outputs.ResourceConfigurationResourceConfigurationDefinitionArnResource']:
        """
        Resource DNS Configuration. See `arn_resource` Block for details.
        """
        return pulumi.get(self, "arn_resource")

    @_builtins.property
    @pulumi.getter(name="dnsResource")
    def dns_resource(self) -> Optional['outputs.ResourceConfigurationResourceConfigurationDefinitionDnsResource']:
        """
        Resource DNS Configuration. See `dns_resource` Block for details.
        """
        return pulumi.get(self, "dns_resource")

    @_builtins.property
    @pulumi.getter(name="ipResource")
    def ip_resource(self) -> Optional['outputs.ResourceConfigurationResourceConfigurationDefinitionIpResource']:
        """
        Resource DNS Configuration. See `ip_resource` Block for details.
        """
        return pulumi.get(self, "ip_resource")


@pulumi.output_type
class ResourceConfigurationResourceConfigurationDefinitionArnResource(dict):
    def __init__(__self__, *,
                 arn: _builtins.str):
        """
        :param _builtins.str arn: The ARN of the Resource for this configuration.
        """
        pulumi.set(__self__, "arn", arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The ARN of the Resource for this configuration.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class ResourceConfigurationResourceConfigurationDefinitionDnsResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "ipAddressType":
            suggest = "ip_address_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigurationResourceConfigurationDefinitionDnsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigurationResourceConfigurationDefinitionDnsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigurationResourceConfigurationDefinitionDnsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 ip_address_type: _builtins.str):
        """
        :param _builtins.str domain_name: The hostname of the Resource for this configuration.
        :param _builtins.str ip_address_type: The IP Address type either `IPV4` or `IPV6`
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "ip_address_type", ip_address_type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The hostname of the Resource for this configuration.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> _builtins.str:
        """
        The IP Address type either `IPV4` or `IPV6`
        """
        return pulumi.get(self, "ip_address_type")


@pulumi.output_type
class ResourceConfigurationResourceConfigurationDefinitionIpResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigurationResourceConfigurationDefinitionIpResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigurationResourceConfigurationDefinitionIpResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigurationResourceConfigurationDefinitionIpResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: _builtins.str):
        """
        :param _builtins.str ip_address: The IP Address of the Resource for this configuration.
        """
        pulumi.set(__self__, "ip_address", ip_address)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP Address of the Resource for this configuration.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class ResourceConfigurationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ResourceGatewayTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ServiceDnsEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "hostedZoneId":
            suggest = "hosted_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDnsEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDnsEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDnsEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 hosted_zone_id: Optional[_builtins.str] = None):
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "hosted_zone_id")


@pulumi.output_type
class ServiceNetworkResourceAssociationDnsEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "hostedZoneId":
            suggest = "hosted_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkResourceAssociationDnsEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkResourceAssociationDnsEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkResourceAssociationDnsEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 hosted_zone_id: _builtins.str):
        """
        :param _builtins.str domain_name: The domain name of the association in the service network.
        :param _builtins.str hosted_zone_id: The ID of the hosted zone containing the domain name.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The domain name of the association in the service network.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> _builtins.str:
        """
        The ID of the hosted zone containing the domain name.
        """
        return pulumi.get(self, "hosted_zone_id")


@pulumi.output_type
class ServiceNetworkResourceAssociationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class ServiceNetworkServiceAssociationDnsEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "hostedZoneId":
            suggest = "hosted_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkServiceAssociationDnsEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkServiceAssociationDnsEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkServiceAssociationDnsEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 hosted_zone_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: The domain name of the service.
        :param _builtins.str hosted_zone_id: The ID of the hosted zone.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The domain name of the service.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[_builtins.str]:
        """
        The ID of the hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")


@pulumi.output_type
class TargetGroupAttachmentTarget(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: The ID of the target. If the target type of the target group is INSTANCE, this is an instance ID. If the target type is IP , this is an IP address. If the target type is LAMBDA, this is the ARN of the Lambda function. If the target type is ALB, this is the ARN of the Application Load Balancer.
        :param _builtins.int port: This port is used for routing traffic to the target, and defaults to the target group port. However, you can override the default and specify a custom port.
        """
        pulumi.set(__self__, "id", id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the target. If the target type of the target group is INSTANCE, this is an instance ID. If the target type is IP , this is an IP address. If the target type is LAMBDA, this is the ARN of the Lambda function. If the target type is ALB, this is the ARN of the Application Load Balancer.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        This port is used for routing traffic to the target, and defaults to the target group port. However, you can override the default and specify a custom port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class TargetGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheck":
            suggest = "health_check"
        elif key == "ipAddressType":
            suggest = "ip_address_type"
        elif key == "lambdaEventStructureVersion":
            suggest = "lambda_event_structure_version"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "vpcIdentifier":
            suggest = "vpc_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check: Optional['outputs.TargetGroupConfigHealthCheck'] = None,
                 ip_address_type: Optional[_builtins.str] = None,
                 lambda_event_structure_version: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None,
                 protocol_version: Optional[_builtins.str] = None,
                 vpc_identifier: Optional[_builtins.str] = None):
        """
        :param 'TargetGroupConfigHealthCheckArgs' health_check: The health check configuration.
        :param _builtins.str ip_address_type: The type of IP address used for the target group. Valid values: `IPV4` | `IPV6`.
        :param _builtins.str lambda_event_structure_version: The version of the event structure that the Lambda function receives. Supported only if `type` is `LAMBDA`. Valid Values are `V1` | `V2`.
        :param _builtins.int port: The port on which the targets are listening.
        :param _builtins.str protocol: The protocol to use for routing traffic to the targets. Valid Values are `HTTP` | `HTTPS`.
        :param _builtins.str protocol_version: The protocol version. Valid Values are `HTTP1` | `HTTP2` | `GRPC`. Default value is `HTTP1`.
        :param _builtins.str vpc_identifier: The ID of the VPC.
        """
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if lambda_event_structure_version is not None:
            pulumi.set(__self__, "lambda_event_structure_version", lambda_event_structure_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if vpc_identifier is not None:
            pulumi.set(__self__, "vpc_identifier", vpc_identifier)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.TargetGroupConfigHealthCheck']:
        """
        The health check configuration.
        """
        return pulumi.get(self, "health_check")

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[_builtins.str]:
        """
        The type of IP address used for the target group. Valid values: `IPV4` | `IPV6`.
        """
        return pulumi.get(self, "ip_address_type")

    @_builtins.property
    @pulumi.getter(name="lambdaEventStructureVersion")
    def lambda_event_structure_version(self) -> Optional[_builtins.str]:
        """
        The version of the event structure that the Lambda function receives. Supported only if `type` is `LAMBDA`. Valid Values are `V1` | `V2`.
        """
        return pulumi.get(self, "lambda_event_structure_version")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port on which the targets are listening.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol to use for routing traffic to the targets. Valid Values are `HTTP` | `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[_builtins.str]:
        """
        The protocol version. Valid Values are `HTTP1` | `HTTP2` | `GRPC`. Default value is `HTTP1`.
        """
        return pulumi.get(self, "protocol_version")

    @_builtins.property
    @pulumi.getter(name="vpcIdentifier")
    def vpc_identifier(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_identifier")


@pulumi.output_type
class TargetGroupConfigHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckIntervalSeconds":
            suggest = "health_check_interval_seconds"
        elif key == "healthCheckTimeoutSeconds":
            suggest = "health_check_timeout_seconds"
        elif key == "healthyThresholdCount":
            suggest = "healthy_threshold_count"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "unhealthyThresholdCount":
            suggest = "unhealthy_threshold_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupConfigHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupConfigHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupConfigHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 health_check_interval_seconds: Optional[_builtins.int] = None,
                 health_check_timeout_seconds: Optional[_builtins.int] = None,
                 healthy_threshold_count: Optional[_builtins.int] = None,
                 matcher: Optional['outputs.TargetGroupConfigHealthCheckMatcher'] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None,
                 protocol_version: Optional[_builtins.str] = None,
                 unhealthy_threshold_count: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Indicates whether health checking is enabled. Defaults to `true`.
        :param _builtins.int health_check_interval_seconds: The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
        :param _builtins.int health_check_timeout_seconds: The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
               * `healthy_threshold_count ` - (Optional) The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
        :param 'TargetGroupConfigHealthCheckMatcherArgs' matcher: The codes to use when checking for a successful response from a target. These are called _Success codes_ in the console.
        :param _builtins.str path: The destination for health checks on the targets. If the protocol version is HTTP/1.1 or HTTP/2, specify a valid URI (for example, /path?query). The default path is `/`. Health checks are not supported if the protocol version is gRPC, however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
        :param _builtins.int port: The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
        :param _builtins.str protocol: The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`.
        :param _builtins.str protocol_version: The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`. The default is `HTTP1`.
        :param _builtins.int unhealthy_threshold_count: The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_timeout_seconds is not None:
            pulumi.set(__self__, "health_check_timeout_seconds", health_check_timeout_seconds)
        if healthy_threshold_count is not None:
            pulumi.set(__self__, "healthy_threshold_count", healthy_threshold_count)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if unhealthy_threshold_count is not None:
            pulumi.set(__self__, "unhealthy_threshold_count", unhealthy_threshold_count)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether health checking is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[_builtins.int]:
        """
        The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeoutSeconds")
    def health_check_timeout_seconds(self) -> Optional[_builtins.int]:
        """
        The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
        * `healthy_threshold_count ` - (Optional) The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
        """
        return pulumi.get(self, "health_check_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="healthyThresholdCount")
    def healthy_threshold_count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "healthy_threshold_count")

    @_builtins.property
    @pulumi.getter
    def matcher(self) -> Optional['outputs.TargetGroupConfigHealthCheckMatcher']:
        """
        The codes to use when checking for a successful response from a target. These are called _Success codes_ in the console.
        """
        return pulumi.get(self, "matcher")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The destination for health checks on the targets. If the protocol version is HTTP/1.1 or HTTP/2, specify a valid URI (for example, /path?query). The default path is `/`. Health checks are not supported if the protocol version is gRPC, however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[_builtins.str]:
        """
        The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`. The default is `HTTP1`.
        """
        return pulumi.get(self, "protocol_version")

    @_builtins.property
    @pulumi.getter(name="unhealthyThresholdCount")
    def unhealthy_threshold_count(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
        """
        return pulumi.get(self, "unhealthy_threshold_count")


@pulumi.output_type
class TargetGroupConfigHealthCheckMatcher(dict):
    def __init__(__self__, *,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: The HTTP codes to use when checking for a successful response from a target.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The HTTP codes to use when checking for a successful response from a target.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetListenerDefaultActionResult(dict):
    def __init__(__self__, *,
                 fixed_responses: Sequence['outputs.GetListenerDefaultActionFixedResponseResult'],
                 forwards: Sequence['outputs.GetListenerDefaultActionForwardResult']):
        pulumi.set(__self__, "fixed_responses", fixed_responses)
        pulumi.set(__self__, "forwards", forwards)

    @_builtins.property
    @pulumi.getter(name="fixedResponses")
    def fixed_responses(self) -> Sequence['outputs.GetListenerDefaultActionFixedResponseResult']:
        return pulumi.get(self, "fixed_responses")

    @_builtins.property
    @pulumi.getter
    def forwards(self) -> Sequence['outputs.GetListenerDefaultActionForwardResult']:
        return pulumi.get(self, "forwards")


@pulumi.output_type
class GetListenerDefaultActionFixedResponseResult(dict):
    def __init__(__self__, *,
                 status_code: _builtins.int):
        pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetListenerDefaultActionForwardResult(dict):
    def __init__(__self__, *,
                 target_groups: Sequence['outputs.GetListenerDefaultActionForwardTargetGroupResult']):
        pulumi.set(__self__, "target_groups", target_groups)

    @_builtins.property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.GetListenerDefaultActionForwardTargetGroupResult']:
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class GetListenerDefaultActionForwardTargetGroupResult(dict):
    def __init__(__self__, *,
                 target_group_identifier: _builtins.str,
                 weight: _builtins.int):
        pulumi.set(__self__, "target_group_identifier", target_group_identifier)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> _builtins.str:
        return pulumi.get(self, "target_group_identifier")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetServiceDnsEntryResult(dict):
    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 hosted_zone_id: _builtins.str):
        """
        :param _builtins.str domain_name: DNS name for the service.
        :param _builtins.str hosted_zone_id: Hosted zone ID where the DNS name is registered.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        DNS name for the service.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> _builtins.str:
        """
        Hosted zone ID where the DNS name is registered.
        """
        return pulumi.get(self, "hosted_zone_id")


