# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubscribedRuleGroupResult',
    'AwaitableGetSubscribedRuleGroupResult',
    'get_subscribed_rule_group',
    'get_subscribed_rule_group_output',
]

@pulumi.output_type
class GetSubscribedRuleGroupResult:
    """
    A collection of values returned by getSubscribedRuleGroup.
    """
    def __init__(__self__, id=None, metric_name=None, name=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metric_name and not isinstance(metric_name, str):
            raise TypeError("Expected argument 'metric_name' to be a str")
        pulumi.set(__self__, "metric_name", metric_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetSubscribedRuleGroupResult(GetSubscribedRuleGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscribedRuleGroupResult(
            id=self.id,
            metric_name=self.metric_name,
            name=self.name,
            region=self.region)


def get_subscribed_rule_group(metric_name: Optional[_builtins.str] = None,
                              name: Optional[_builtins.str] = None,
                              region: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscribedRuleGroupResult:
    """
    `wafregional_get_subscribed_rule_group` retrieves information about a Managed WAF Rule Group from AWS Marketplace for use in WAF Regional (needs to be subscribed to first).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    by_name = aws.wafregional.get_subscribed_rule_group(name="F5 Bot Detection Signatures For AWS WAF")
    by_metric_name = aws.wafregional.get_subscribed_rule_group(metric_name="F5BotDetectionSignatures")
    acl = aws.wafregional.WebAcl("acl", rules=[
        {
            "priority": 1,
            "rule_id": by_name.id,
            "type": "GROUP",
        },
        {
            "priority": 2,
            "rule_id": by_metric_name.id,
            "type": "GROUP",
        },
    ])
    ```


    :param _builtins.str metric_name: Name of the WAF rule group.
           
           At least one of `name` or `metric_name` must be configured.
    :param _builtins.str name: Name of the WAF rule group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['metricName'] = metric_name
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:wafregional/getSubscribedRuleGroup:getSubscribedRuleGroup', __args__, opts=opts, typ=GetSubscribedRuleGroupResult).value

    return AwaitableGetSubscribedRuleGroupResult(
        id=pulumi.get(__ret__, 'id'),
        metric_name=pulumi.get(__ret__, 'metric_name'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_subscribed_rule_group_output(metric_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscribedRuleGroupResult]:
    """
    `wafregional_get_subscribed_rule_group` retrieves information about a Managed WAF Rule Group from AWS Marketplace for use in WAF Regional (needs to be subscribed to first).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    by_name = aws.wafregional.get_subscribed_rule_group(name="F5 Bot Detection Signatures For AWS WAF")
    by_metric_name = aws.wafregional.get_subscribed_rule_group(metric_name="F5BotDetectionSignatures")
    acl = aws.wafregional.WebAcl("acl", rules=[
        {
            "priority": 1,
            "rule_id": by_name.id,
            "type": "GROUP",
        },
        {
            "priority": 2,
            "rule_id": by_metric_name.id,
            "type": "GROUP",
        },
    ])
    ```


    :param _builtins.str metric_name: Name of the WAF rule group.
           
           At least one of `name` or `metric_name` must be configured.
    :param _builtins.str name: Name of the WAF rule group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['metricName'] = metric_name
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:wafregional/getSubscribedRuleGroup:getSubscribedRuleGroup', __args__, opts=opts, typ=GetSubscribedRuleGroupResult)
    return __ret__.apply(lambda __response__: GetSubscribedRuleGroupResult(
        id=pulumi.get(__response__, 'id'),
        metric_name=pulumi.get(__response__, 'metric_name'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
