# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWebAclResult',
    'AwaitableGetWebAclResult',
    'get_web_acl',
    'get_web_acl_output',
]

@pulumi.output_type
class GetWebAclResult:
    """
    A collection of values returned by getWebAcl.
    """
    def __init__(__self__, arn=None, description=None, id=None, name=None, region=None, resource_arn=None, scope=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_arn and not isinstance(resource_arn, str):
            raise TypeError("Expected argument 'resource_arn' to be a str")
        pulumi.set(__self__, "resource_arn", resource_arn)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the entity.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the WebACL that helps with identification.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_arn")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        return pulumi.get(self, "scope")


class AwaitableGetWebAclResult(GetWebAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebAclResult(
            arn=self.arn,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            resource_arn=self.resource_arn,
            scope=self.scope)


def get_web_acl(name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                resource_arn: Optional[_builtins.str] = None,
                scope: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebAclResult:
    """
    Retrieves the summary of a WAFv2 Web ACL.


    :param _builtins.str name: Name of the WAFv2 Web ACL. Exactly one of `name` or `resource_arn` must be specified.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resource_arn: ARN of the AWS resource associated with the Web ACL. This can be an ARN of an Application Load Balancer, Amazon API Gateway REST API, AWS AppSync GraphQL API, Amazon Cognito user pool, AWS App Runner service, AWS Verified Access instance, or AWS Amplify application. Exactly one of `name` or `resource_arn` must be specified.
    :param _builtins.str scope: Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceArn'] = resource_arn
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:wafv2/getWebAcl:getWebAcl', __args__, opts=opts, typ=GetWebAclResult).value

    return AwaitableGetWebAclResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        resource_arn=pulumi.get(__ret__, 'resource_arn'),
        scope=pulumi.get(__ret__, 'scope'))
def get_web_acl_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       resource_arn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       scope: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebAclResult]:
    """
    Retrieves the summary of a WAFv2 Web ACL.


    :param _builtins.str name: Name of the WAFv2 Web ACL. Exactly one of `name` or `resource_arn` must be specified.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resource_arn: ARN of the AWS resource associated with the Web ACL. This can be an ARN of an Application Load Balancer, Amazon API Gateway REST API, AWS AppSync GraphQL API, Amazon Cognito user pool, AWS App Runner service, AWS Verified Access instance, or AWS Amplify application. Exactly one of `name` or `resource_arn` must be specified.
    :param _builtins.str scope: Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceArn'] = resource_arn
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:wafv2/getWebAcl:getWebAcl', __args__, opts=opts, typ=GetWebAclResult)
    return __ret__.apply(lambda __response__: GetWebAclResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        resource_arn=pulumi.get(__response__, 'resource_arn'),
        scope=pulumi.get(__response__, 'scope')))
