# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectionAliasTimeouts',
    'DirectoryActiveDirectoryConfig',
    'DirectoryCertificateBasedAuthProperties',
    'DirectorySamlProperties',
    'DirectorySelfServicePermissions',
    'DirectoryWorkspaceAccessProperties',
    'DirectoryWorkspaceCreationProperties',
    'IpGroupRule',
    'WorkspaceWorkspaceProperties',
    'GetBundleComputeTypeResult',
    'GetBundleRootStorageResult',
    'GetBundleUserStorageResult',
    'GetDirectoryActiveDirectoryConfigResult',
    'GetDirectoryCertificateBasedAuthPropertyResult',
    'GetDirectorySamlPropertyResult',
    'GetDirectorySelfServicePermissionResult',
    'GetDirectoryWorkspaceAccessPropertyResult',
    'GetDirectoryWorkspaceCreationPropertyResult',
    'GetWorkspaceWorkspacePropertyResult',
]

@pulumi.output_type
class ConnectionAliasTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class DirectoryActiveDirectoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "serviceAccountSecretArn":
            suggest = "service_account_secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryActiveDirectoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryActiveDirectoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryActiveDirectoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 service_account_secret_arn: _builtins.str):
        """
        :param _builtins.str domain_name: Fully qualified domain name of the AWS Directory Service directory.
        :param _builtins.str service_account_secret_arn: ARN of the Secrets Manager secret that contains the credentials for the service account. For more information, see [Service Account Details](https://docs.aws.amazon.com/workspaces/latest/adminguide/pools-service-account-details.html).
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "service_account_secret_arn", service_account_secret_arn)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        Fully qualified domain name of the AWS Directory Service directory.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountSecretArn")
    def service_account_secret_arn(self) -> _builtins.str:
        """
        ARN of the Secrets Manager secret that contains the credentials for the service account. For more information, see [Service Account Details](https://docs.aws.amazon.com/workspaces/latest/adminguide/pools-service-account-details.html).
        """
        return pulumi.get(self, "service_account_secret_arn")


@pulumi.output_type
class DirectoryCertificateBasedAuthProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityArn":
            suggest = "certificate_authority_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryCertificateBasedAuthProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryCertificateBasedAuthProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryCertificateBasedAuthProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_arn: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_authority_arn: The Amazon Resource Name (ARN) of the certificate manager private certificate authority (ACM-PCA) that is used for certificate-based authentication.
        :param _builtins.str status: Status of certificate-based authentication. Default `DISABLED`.
        """
        if certificate_authority_arn is not None:
            pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the certificate manager private certificate authority (ACM-PCA) that is used for certificate-based authentication.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of certificate-based authentication. Default `DISABLED`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DirectorySamlProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relayStateParameterName":
            suggest = "relay_state_parameter_name"
        elif key == "userAccessUrl":
            suggest = "user_access_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectorySamlProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectorySamlProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectorySamlProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relay_state_parameter_name: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 user_access_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str relay_state_parameter_name: The relay state parameter name supported by the SAML 2.0 identity provider (IdP). Default `RelayState`.
        :param _builtins.str status: Status of SAML 2.0 authentication. Default `DISABLED`.
        :param _builtins.str user_access_url: The SAML 2.0 identity provider (IdP) user access URL.
        """
        if relay_state_parameter_name is not None:
            pulumi.set(__self__, "relay_state_parameter_name", relay_state_parameter_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_access_url is not None:
            pulumi.set(__self__, "user_access_url", user_access_url)

    @_builtins.property
    @pulumi.getter(name="relayStateParameterName")
    def relay_state_parameter_name(self) -> Optional[_builtins.str]:
        """
        The relay state parameter name supported by the SAML 2.0 identity provider (IdP). Default `RelayState`.
        """
        return pulumi.get(self, "relay_state_parameter_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of SAML 2.0 authentication. Default `DISABLED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userAccessUrl")
    def user_access_url(self) -> Optional[_builtins.str]:
        """
        The SAML 2.0 identity provider (IdP) user access URL.
        """
        return pulumi.get(self, "user_access_url")


@pulumi.output_type
class DirectorySelfServicePermissions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changeComputeType":
            suggest = "change_compute_type"
        elif key == "increaseVolumeSize":
            suggest = "increase_volume_size"
        elif key == "rebuildWorkspace":
            suggest = "rebuild_workspace"
        elif key == "restartWorkspace":
            suggest = "restart_workspace"
        elif key == "switchRunningMode":
            suggest = "switch_running_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectorySelfServicePermissions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectorySelfServicePermissions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectorySelfServicePermissions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 change_compute_type: Optional[_builtins.bool] = None,
                 increase_volume_size: Optional[_builtins.bool] = None,
                 rebuild_workspace: Optional[_builtins.bool] = None,
                 restart_workspace: Optional[_builtins.bool] = None,
                 switch_running_mode: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool change_compute_type: Whether WorkSpaces directory users can change the compute type (bundle) for their workspace. Default `false`.
        :param _builtins.bool increase_volume_size: Whether WorkSpaces directory users can increase the volume size of the drives on their workspace. Default `false`.
        :param _builtins.bool rebuild_workspace: Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state. Default `false`.
        :param _builtins.bool restart_workspace: Whether WorkSpaces directory users can restart their workspace. Default `true`.
        :param _builtins.bool switch_running_mode: Whether WorkSpaces directory users can switch the running mode of their workspace. Default `false`.
        """
        if change_compute_type is not None:
            pulumi.set(__self__, "change_compute_type", change_compute_type)
        if increase_volume_size is not None:
            pulumi.set(__self__, "increase_volume_size", increase_volume_size)
        if rebuild_workspace is not None:
            pulumi.set(__self__, "rebuild_workspace", rebuild_workspace)
        if restart_workspace is not None:
            pulumi.set(__self__, "restart_workspace", restart_workspace)
        if switch_running_mode is not None:
            pulumi.set(__self__, "switch_running_mode", switch_running_mode)

    @_builtins.property
    @pulumi.getter(name="changeComputeType")
    def change_compute_type(self) -> Optional[_builtins.bool]:
        """
        Whether WorkSpaces directory users can change the compute type (bundle) for their workspace. Default `false`.
        """
        return pulumi.get(self, "change_compute_type")

    @_builtins.property
    @pulumi.getter(name="increaseVolumeSize")
    def increase_volume_size(self) -> Optional[_builtins.bool]:
        """
        Whether WorkSpaces directory users can increase the volume size of the drives on their workspace. Default `false`.
        """
        return pulumi.get(self, "increase_volume_size")

    @_builtins.property
    @pulumi.getter(name="rebuildWorkspace")
    def rebuild_workspace(self) -> Optional[_builtins.bool]:
        """
        Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state. Default `false`.
        """
        return pulumi.get(self, "rebuild_workspace")

    @_builtins.property
    @pulumi.getter(name="restartWorkspace")
    def restart_workspace(self) -> Optional[_builtins.bool]:
        """
        Whether WorkSpaces directory users can restart their workspace. Default `true`.
        """
        return pulumi.get(self, "restart_workspace")

    @_builtins.property
    @pulumi.getter(name="switchRunningMode")
    def switch_running_mode(self) -> Optional[_builtins.bool]:
        """
        Whether WorkSpaces directory users can switch the running mode of their workspace. Default `false`.
        """
        return pulumi.get(self, "switch_running_mode")


@pulumi.output_type
class DirectoryWorkspaceAccessProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceTypeAndroid":
            suggest = "device_type_android"
        elif key == "deviceTypeChromeos":
            suggest = "device_type_chromeos"
        elif key == "deviceTypeIos":
            suggest = "device_type_ios"
        elif key == "deviceTypeLinux":
            suggest = "device_type_linux"
        elif key == "deviceTypeOsx":
            suggest = "device_type_osx"
        elif key == "deviceTypeWeb":
            suggest = "device_type_web"
        elif key == "deviceTypeWindows":
            suggest = "device_type_windows"
        elif key == "deviceTypeZeroclient":
            suggest = "device_type_zeroclient"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryWorkspaceAccessProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryWorkspaceAccessProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryWorkspaceAccessProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_type_android: Optional[_builtins.str] = None,
                 device_type_chromeos: Optional[_builtins.str] = None,
                 device_type_ios: Optional[_builtins.str] = None,
                 device_type_linux: Optional[_builtins.str] = None,
                 device_type_osx: Optional[_builtins.str] = None,
                 device_type_web: Optional[_builtins.str] = None,
                 device_type_windows: Optional[_builtins.str] = None,
                 device_type_zeroclient: Optional[_builtins.str] = None):
        """
        :param _builtins.str device_type_android: Indicates whether users can use Android devices to access their WorkSpaces.
        :param _builtins.str device_type_chromeos: Indicates whether users can use Chromebooks to access their WorkSpaces.
        :param _builtins.str device_type_ios: Indicates whether users can use iOS devices to access their WorkSpaces.
        :param _builtins.str device_type_linux: Indicates whether users can use Linux clients to access their WorkSpaces.
        :param _builtins.str device_type_osx: Indicates whether users can use macOS clients to access their WorkSpaces.
        :param _builtins.str device_type_web: Indicates whether users can access their WorkSpaces through a web browser.
        :param _builtins.str device_type_windows: Indicates whether users can use Windows clients to access their WorkSpaces.
        :param _builtins.str device_type_zeroclient: Indicates whether users can use zero client devices to access their WorkSpaces.
        """
        if device_type_android is not None:
            pulumi.set(__self__, "device_type_android", device_type_android)
        if device_type_chromeos is not None:
            pulumi.set(__self__, "device_type_chromeos", device_type_chromeos)
        if device_type_ios is not None:
            pulumi.set(__self__, "device_type_ios", device_type_ios)
        if device_type_linux is not None:
            pulumi.set(__self__, "device_type_linux", device_type_linux)
        if device_type_osx is not None:
            pulumi.set(__self__, "device_type_osx", device_type_osx)
        if device_type_web is not None:
            pulumi.set(__self__, "device_type_web", device_type_web)
        if device_type_windows is not None:
            pulumi.set(__self__, "device_type_windows", device_type_windows)
        if device_type_zeroclient is not None:
            pulumi.set(__self__, "device_type_zeroclient", device_type_zeroclient)

    @_builtins.property
    @pulumi.getter(name="deviceTypeAndroid")
    def device_type_android(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can use Android devices to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_android")

    @_builtins.property
    @pulumi.getter(name="deviceTypeChromeos")
    def device_type_chromeos(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can use Chromebooks to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_chromeos")

    @_builtins.property
    @pulumi.getter(name="deviceTypeIos")
    def device_type_ios(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can use iOS devices to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_ios")

    @_builtins.property
    @pulumi.getter(name="deviceTypeLinux")
    def device_type_linux(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can use Linux clients to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_linux")

    @_builtins.property
    @pulumi.getter(name="deviceTypeOsx")
    def device_type_osx(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can use macOS clients to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_osx")

    @_builtins.property
    @pulumi.getter(name="deviceTypeWeb")
    def device_type_web(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can access their WorkSpaces through a web browser.
        """
        return pulumi.get(self, "device_type_web")

    @_builtins.property
    @pulumi.getter(name="deviceTypeWindows")
    def device_type_windows(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can use Windows clients to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_windows")

    @_builtins.property
    @pulumi.getter(name="deviceTypeZeroclient")
    def device_type_zeroclient(self) -> Optional[_builtins.str]:
        """
        Indicates whether users can use zero client devices to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_zeroclient")


@pulumi.output_type
class DirectoryWorkspaceCreationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customSecurityGroupId":
            suggest = "custom_security_group_id"
        elif key == "defaultOu":
            suggest = "default_ou"
        elif key == "enableInternetAccess":
            suggest = "enable_internet_access"
        elif key == "enableMaintenanceMode":
            suggest = "enable_maintenance_mode"
        elif key == "userEnabledAsLocalAdministrator":
            suggest = "user_enabled_as_local_administrator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryWorkspaceCreationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryWorkspaceCreationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryWorkspaceCreationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_security_group_id: Optional[_builtins.str] = None,
                 default_ou: Optional[_builtins.str] = None,
                 enable_internet_access: Optional[_builtins.bool] = None,
                 enable_maintenance_mode: Optional[_builtins.bool] = None,
                 user_enabled_as_local_administrator: Optional[_builtins.bool] = None):
        """
        :param _builtins.str custom_security_group_id: The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
        :param _builtins.str default_ou: The default organizational unit (OU) for your WorkSpace directories. Should conform `"OU=<value>,DC=<value>,...,DC=<value>"` pattern.
        :param _builtins.bool enable_internet_access: Indicates whether internet access is enabled for your WorkSpaces.
        :param _builtins.bool enable_maintenance_mode: Indicates whether maintenance mode is enabled for your WorkSpaces. Valid only if `workspace_type` is set to `PERSONAL`.
        :param _builtins.bool user_enabled_as_local_administrator: Indicates whether users are local administrators of their WorkSpaces. Valid only if `workspace_type` is set to `PERSONAL`.
        """
        if custom_security_group_id is not None:
            pulumi.set(__self__, "custom_security_group_id", custom_security_group_id)
        if default_ou is not None:
            pulumi.set(__self__, "default_ou", default_ou)
        if enable_internet_access is not None:
            pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        if enable_maintenance_mode is not None:
            pulumi.set(__self__, "enable_maintenance_mode", enable_maintenance_mode)
        if user_enabled_as_local_administrator is not None:
            pulumi.set(__self__, "user_enabled_as_local_administrator", user_enabled_as_local_administrator)

    @_builtins.property
    @pulumi.getter(name="customSecurityGroupId")
    def custom_security_group_id(self) -> Optional[_builtins.str]:
        """
        The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
        """
        return pulumi.get(self, "custom_security_group_id")

    @_builtins.property
    @pulumi.getter(name="defaultOu")
    def default_ou(self) -> Optional[_builtins.str]:
        """
        The default organizational unit (OU) for your WorkSpace directories. Should conform `"OU=<value>,DC=<value>,...,DC=<value>"` pattern.
        """
        return pulumi.get(self, "default_ou")

    @_builtins.property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> Optional[_builtins.bool]:
        """
        Indicates whether internet access is enabled for your WorkSpaces.
        """
        return pulumi.get(self, "enable_internet_access")

    @_builtins.property
    @pulumi.getter(name="enableMaintenanceMode")
    def enable_maintenance_mode(self) -> Optional[_builtins.bool]:
        """
        Indicates whether maintenance mode is enabled for your WorkSpaces. Valid only if `workspace_type` is set to `PERSONAL`.
        """
        return pulumi.get(self, "enable_maintenance_mode")

    @_builtins.property
    @pulumi.getter(name="userEnabledAsLocalAdministrator")
    def user_enabled_as_local_administrator(self) -> Optional[_builtins.bool]:
        """
        Indicates whether users are local administrators of their WorkSpaces. Valid only if `workspace_type` is set to `PERSONAL`.
        """
        return pulumi.get(self, "user_enabled_as_local_administrator")


@pulumi.output_type
class IpGroupRule(dict):
    def __init__(__self__, *,
                 source: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str source: The IP address range, in CIDR notation, e.g., `10.0.0.0/16`
        :param _builtins.str description: The description of the IP group.
        """
        pulumi.set(__self__, "source", source)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The IP address range, in CIDR notation, e.g., `10.0.0.0/16`
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the IP group.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class WorkspaceWorkspaceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeTypeName":
            suggest = "compute_type_name"
        elif key == "rootVolumeSizeGib":
            suggest = "root_volume_size_gib"
        elif key == "runningMode":
            suggest = "running_mode"
        elif key == "runningModeAutoStopTimeoutInMinutes":
            suggest = "running_mode_auto_stop_timeout_in_minutes"
        elif key == "userVolumeSizeGib":
            suggest = "user_volume_size_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceWorkspaceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceWorkspaceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceWorkspaceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type_name: Optional[_builtins.str] = None,
                 root_volume_size_gib: Optional[_builtins.int] = None,
                 running_mode: Optional[_builtins.str] = None,
                 running_mode_auto_stop_timeout_in_minutes: Optional[_builtins.int] = None,
                 user_volume_size_gib: Optional[_builtins.int] = None):
        """
        :param _builtins.str compute_type_name: The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO`, `GRAPHICSPRO`, `GRAPHICS_G4DN`, and `GRAPHICSPRO_G4DN`.
        :param _builtins.int root_volume_size_gib: The size of the root volume.
        :param _builtins.str running_mode: The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
        :param _builtins.int running_mode_auto_stop_timeout_in_minutes: The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
        :param _builtins.int user_volume_size_gib: The size of the user storage.
        """
        if compute_type_name is not None:
            pulumi.set(__self__, "compute_type_name", compute_type_name)
        if root_volume_size_gib is not None:
            pulumi.set(__self__, "root_volume_size_gib", root_volume_size_gib)
        if running_mode is not None:
            pulumi.set(__self__, "running_mode", running_mode)
        if running_mode_auto_stop_timeout_in_minutes is not None:
            pulumi.set(__self__, "running_mode_auto_stop_timeout_in_minutes", running_mode_auto_stop_timeout_in_minutes)
        if user_volume_size_gib is not None:
            pulumi.set(__self__, "user_volume_size_gib", user_volume_size_gib)

    @_builtins.property
    @pulumi.getter(name="computeTypeName")
    def compute_type_name(self) -> Optional[_builtins.str]:
        """
        The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO`, `GRAPHICSPRO`, `GRAPHICS_G4DN`, and `GRAPHICSPRO_G4DN`.
        """
        return pulumi.get(self, "compute_type_name")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSizeGib")
    def root_volume_size_gib(self) -> Optional[_builtins.int]:
        """
        The size of the root volume.
        """
        return pulumi.get(self, "root_volume_size_gib")

    @_builtins.property
    @pulumi.getter(name="runningMode")
    def running_mode(self) -> Optional[_builtins.str]:
        """
        The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
        """
        return pulumi.get(self, "running_mode")

    @_builtins.property
    @pulumi.getter(name="runningModeAutoStopTimeoutInMinutes")
    def running_mode_auto_stop_timeout_in_minutes(self) -> Optional[_builtins.int]:
        """
        The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
        """
        return pulumi.get(self, "running_mode_auto_stop_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="userVolumeSizeGib")
    def user_volume_size_gib(self) -> Optional[_builtins.int]:
        """
        The size of the user storage.
        """
        return pulumi.get(self, "user_volume_size_gib")


@pulumi.output_type
class GetBundleComputeTypeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Name of the bundle. You cannot combine this parameter with `bundle_id`.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the bundle. You cannot combine this parameter with `bundle_id`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetBundleRootStorageResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.str):
        """
        :param _builtins.str capacity: Size of the user storage.
        """
        pulumi.set(__self__, "capacity", capacity)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.str:
        """
        Size of the user storage.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class GetBundleUserStorageResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.str):
        """
        :param _builtins.str capacity: Size of the user storage.
        """
        pulumi.set(__self__, "capacity", capacity)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.str:
        """
        Size of the user storage.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class GetDirectoryActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 service_account_secret_arn: _builtins.str):
        """
        :param _builtins.str domain_name: Fully qualified domain name of the AWS Directory Service directory.
        :param _builtins.str service_account_secret_arn: ARN of the Secrets Manager secret that contains the credentials for the service account.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "service_account_secret_arn", service_account_secret_arn)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        Fully qualified domain name of the AWS Directory Service directory.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountSecretArn")
    def service_account_secret_arn(self) -> _builtins.str:
        """
        ARN of the Secrets Manager secret that contains the credentials for the service account.
        """
        return pulumi.get(self, "service_account_secret_arn")


@pulumi.output_type
class GetDirectoryCertificateBasedAuthPropertyResult(dict):
    def __init__(__self__, *,
                 certificate_authority_arn: _builtins.str,
                 status: _builtins.str):
        pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> _builtins.str:
        return pulumi.get(self, "certificate_authority_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDirectorySamlPropertyResult(dict):
    def __init__(__self__, *,
                 relay_state_parameter_name: _builtins.str,
                 status: _builtins.str,
                 user_access_url: _builtins.str):
        pulumi.set(__self__, "relay_state_parameter_name", relay_state_parameter_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "user_access_url", user_access_url)

    @_builtins.property
    @pulumi.getter(name="relayStateParameterName")
    def relay_state_parameter_name(self) -> _builtins.str:
        return pulumi.get(self, "relay_state_parameter_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userAccessUrl")
    def user_access_url(self) -> _builtins.str:
        return pulumi.get(self, "user_access_url")


@pulumi.output_type
class GetDirectorySelfServicePermissionResult(dict):
    def __init__(__self__, *,
                 change_compute_type: _builtins.bool,
                 increase_volume_size: _builtins.bool,
                 rebuild_workspace: _builtins.bool,
                 restart_workspace: _builtins.bool,
                 switch_running_mode: _builtins.bool):
        """
        :param _builtins.bool change_compute_type: Whether WorkSpaces directory users can change the compute type (bundle) for their workspace.
        :param _builtins.bool increase_volume_size: Whether WorkSpaces directory users can increase the volume size of the drives on their workspace.
        :param _builtins.bool rebuild_workspace: Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state.
        :param _builtins.bool restart_workspace: Whether WorkSpaces directory users can restart their workspace.
        :param _builtins.bool switch_running_mode: Whether WorkSpaces directory users can switch the running mode of their workspace.
        """
        pulumi.set(__self__, "change_compute_type", change_compute_type)
        pulumi.set(__self__, "increase_volume_size", increase_volume_size)
        pulumi.set(__self__, "rebuild_workspace", rebuild_workspace)
        pulumi.set(__self__, "restart_workspace", restart_workspace)
        pulumi.set(__self__, "switch_running_mode", switch_running_mode)

    @_builtins.property
    @pulumi.getter(name="changeComputeType")
    def change_compute_type(self) -> _builtins.bool:
        """
        Whether WorkSpaces directory users can change the compute type (bundle) for their workspace.
        """
        return pulumi.get(self, "change_compute_type")

    @_builtins.property
    @pulumi.getter(name="increaseVolumeSize")
    def increase_volume_size(self) -> _builtins.bool:
        """
        Whether WorkSpaces directory users can increase the volume size of the drives on their workspace.
        """
        return pulumi.get(self, "increase_volume_size")

    @_builtins.property
    @pulumi.getter(name="rebuildWorkspace")
    def rebuild_workspace(self) -> _builtins.bool:
        """
        Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state.
        """
        return pulumi.get(self, "rebuild_workspace")

    @_builtins.property
    @pulumi.getter(name="restartWorkspace")
    def restart_workspace(self) -> _builtins.bool:
        """
        Whether WorkSpaces directory users can restart their workspace.
        """
        return pulumi.get(self, "restart_workspace")

    @_builtins.property
    @pulumi.getter(name="switchRunningMode")
    def switch_running_mode(self) -> _builtins.bool:
        """
        Whether WorkSpaces directory users can switch the running mode of their workspace.
        """
        return pulumi.get(self, "switch_running_mode")


@pulumi.output_type
class GetDirectoryWorkspaceAccessPropertyResult(dict):
    def __init__(__self__, *,
                 device_type_android: _builtins.str,
                 device_type_chromeos: _builtins.str,
                 device_type_ios: _builtins.str,
                 device_type_linux: _builtins.str,
                 device_type_osx: _builtins.str,
                 device_type_web: _builtins.str,
                 device_type_windows: _builtins.str,
                 device_type_zeroclient: _builtins.str):
        """
        :param _builtins.str device_type_android: (Optional) Indicates whether users can use Android devices to access their WorkSpaces.
        :param _builtins.str device_type_chromeos: (Optional) Indicates whether users can use Chromebooks to access their WorkSpaces.
        :param _builtins.str device_type_ios: (Optional) Indicates whether users can use iOS devices to access their WorkSpaces.
        :param _builtins.str device_type_linux: (Optional) Indicates whether users can use Linux clients to access their WorkSpaces.
        :param _builtins.str device_type_osx: (Optional) Indicates whether users can use macOS clients to access their WorkSpaces.
        :param _builtins.str device_type_web: (Optional) Indicates whether users can access their WorkSpaces through a web browser.
        :param _builtins.str device_type_windows: (Optional) Indicates whether users can use Windows clients to access their WorkSpaces.
        :param _builtins.str device_type_zeroclient: (Optional) Indicates whether users can use zero client devices to access their WorkSpaces.
        """
        pulumi.set(__self__, "device_type_android", device_type_android)
        pulumi.set(__self__, "device_type_chromeos", device_type_chromeos)
        pulumi.set(__self__, "device_type_ios", device_type_ios)
        pulumi.set(__self__, "device_type_linux", device_type_linux)
        pulumi.set(__self__, "device_type_osx", device_type_osx)
        pulumi.set(__self__, "device_type_web", device_type_web)
        pulumi.set(__self__, "device_type_windows", device_type_windows)
        pulumi.set(__self__, "device_type_zeroclient", device_type_zeroclient)

    @_builtins.property
    @pulumi.getter(name="deviceTypeAndroid")
    def device_type_android(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can use Android devices to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_android")

    @_builtins.property
    @pulumi.getter(name="deviceTypeChromeos")
    def device_type_chromeos(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can use Chromebooks to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_chromeos")

    @_builtins.property
    @pulumi.getter(name="deviceTypeIos")
    def device_type_ios(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can use iOS devices to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_ios")

    @_builtins.property
    @pulumi.getter(name="deviceTypeLinux")
    def device_type_linux(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can use Linux clients to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_linux")

    @_builtins.property
    @pulumi.getter(name="deviceTypeOsx")
    def device_type_osx(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can use macOS clients to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_osx")

    @_builtins.property
    @pulumi.getter(name="deviceTypeWeb")
    def device_type_web(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can access their WorkSpaces through a web browser.
        """
        return pulumi.get(self, "device_type_web")

    @_builtins.property
    @pulumi.getter(name="deviceTypeWindows")
    def device_type_windows(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can use Windows clients to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_windows")

    @_builtins.property
    @pulumi.getter(name="deviceTypeZeroclient")
    def device_type_zeroclient(self) -> _builtins.str:
        """
        (Optional) Indicates whether users can use zero client devices to access their WorkSpaces.
        """
        return pulumi.get(self, "device_type_zeroclient")


@pulumi.output_type
class GetDirectoryWorkspaceCreationPropertyResult(dict):
    def __init__(__self__, *,
                 custom_security_group_id: _builtins.str,
                 default_ou: _builtins.str,
                 enable_internet_access: _builtins.bool,
                 enable_maintenance_mode: _builtins.bool,
                 user_enabled_as_local_administrator: _builtins.bool):
        """
        :param _builtins.str custom_security_group_id: The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
        :param _builtins.str default_ou: The default organizational unit (OU) for your WorkSpace directories.
        :param _builtins.bool enable_internet_access: Indicates whether internet access is enabled for your WorkSpaces.
        :param _builtins.bool enable_maintenance_mode: Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
        :param _builtins.bool user_enabled_as_local_administrator: Indicates whether users are local administrators of their WorkSpaces.
        """
        pulumi.set(__self__, "custom_security_group_id", custom_security_group_id)
        pulumi.set(__self__, "default_ou", default_ou)
        pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        pulumi.set(__self__, "enable_maintenance_mode", enable_maintenance_mode)
        pulumi.set(__self__, "user_enabled_as_local_administrator", user_enabled_as_local_administrator)

    @_builtins.property
    @pulumi.getter(name="customSecurityGroupId")
    def custom_security_group_id(self) -> _builtins.str:
        """
        The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
        """
        return pulumi.get(self, "custom_security_group_id")

    @_builtins.property
    @pulumi.getter(name="defaultOu")
    def default_ou(self) -> _builtins.str:
        """
        The default organizational unit (OU) for your WorkSpace directories.
        """
        return pulumi.get(self, "default_ou")

    @_builtins.property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> _builtins.bool:
        """
        Indicates whether internet access is enabled for your WorkSpaces.
        """
        return pulumi.get(self, "enable_internet_access")

    @_builtins.property
    @pulumi.getter(name="enableMaintenanceMode")
    def enable_maintenance_mode(self) -> _builtins.bool:
        """
        Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
        """
        return pulumi.get(self, "enable_maintenance_mode")

    @_builtins.property
    @pulumi.getter(name="userEnabledAsLocalAdministrator")
    def user_enabled_as_local_administrator(self) -> _builtins.bool:
        """
        Indicates whether users are local administrators of their WorkSpaces.
        """
        return pulumi.get(self, "user_enabled_as_local_administrator")


@pulumi.output_type
class GetWorkspaceWorkspacePropertyResult(dict):
    def __init__(__self__, *,
                 compute_type_name: _builtins.str,
                 root_volume_size_gib: _builtins.int,
                 running_mode: _builtins.str,
                 running_mode_auto_stop_timeout_in_minutes: _builtins.int,
                 user_volume_size_gib: _builtins.int):
        """
        :param _builtins.str compute_type_name: Compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO` and `GRAPHICSPRO`.
        :param _builtins.int root_volume_size_gib: Size of the root volume.
        :param _builtins.str running_mode: Running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
        :param _builtins.int running_mode_auto_stop_timeout_in_minutes: Time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
        :param _builtins.int user_volume_size_gib: Size of the user storage.
        """
        pulumi.set(__self__, "compute_type_name", compute_type_name)
        pulumi.set(__self__, "root_volume_size_gib", root_volume_size_gib)
        pulumi.set(__self__, "running_mode", running_mode)
        pulumi.set(__self__, "running_mode_auto_stop_timeout_in_minutes", running_mode_auto_stop_timeout_in_minutes)
        pulumi.set(__self__, "user_volume_size_gib", user_volume_size_gib)

    @_builtins.property
    @pulumi.getter(name="computeTypeName")
    def compute_type_name(self) -> _builtins.str:
        """
        Compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO` and `GRAPHICSPRO`.
        """
        return pulumi.get(self, "compute_type_name")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSizeGib")
    def root_volume_size_gib(self) -> _builtins.int:
        """
        Size of the root volume.
        """
        return pulumi.get(self, "root_volume_size_gib")

    @_builtins.property
    @pulumi.getter(name="runningMode")
    def running_mode(self) -> _builtins.str:
        """
        Running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
        """
        return pulumi.get(self, "running_mode")

    @_builtins.property
    @pulumi.getter(name="runningModeAutoStopTimeoutInMinutes")
    def running_mode_auto_stop_timeout_in_minutes(self) -> _builtins.int:
        """
        Time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
        """
        return pulumi.get(self, "running_mode_auto_stop_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="userVolumeSizeGib")
    def user_volume_size_gib(self) -> _builtins.int:
        """
        Size of the user storage.
        """
        return pulumi.get(self, "user_volume_size_gib")


