# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityProviderArgs', 'IdentityProvider']

@pulumi.input_type
class IdentityProviderArgs:
    def __init__(__self__, *,
                 identity_provider_details: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 identity_provider_name: pulumi.Input[_builtins.str],
                 identity_provider_type: pulumi.Input[_builtins.str],
                 portal_arn: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IdentityProvider resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] identity_provider_details: Identity provider details. The following list describes the provider detail keys for each identity provider type:
               * For Google and Login with Amazon:
        :param pulumi.Input[_builtins.str] identity_provider_name: Identity provider name.
        :param pulumi.Input[_builtins.str] identity_provider_type: Identity provider type. Valid values: `SAML`, `Facebook`, `Google`, `LoginWithAmazon`, `SignInWithApple`, `OIDC`.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the web portal. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        pulumi.set(__self__, "identity_provider_name", identity_provider_name)
        pulumi.set(__self__, "identity_provider_type", identity_provider_type)
        pulumi.set(__self__, "portal_arn", portal_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Identity provider details. The following list describes the provider detail keys for each identity provider type:
        * For Google and Login with Amazon:
        """
        return pulumi.get(self, "identity_provider_details")

    @identity_provider_details.setter
    def identity_provider_details(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "identity_provider_details", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> pulumi.Input[_builtins.str]:
        """
        Identity provider name.
        """
        return pulumi.get(self, "identity_provider_name")

    @identity_provider_name.setter
    def identity_provider_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_provider_name", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> pulumi.Input[_builtins.str]:
        """
        Identity provider type. Valid values: `SAML`, `Facebook`, `Google`, `LoginWithAmazon`, `SignInWithApple`, `OIDC`.
        """
        return pulumi.get(self, "identity_provider_type")

    @identity_provider_type.setter
    def identity_provider_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_provider_type", value)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the web portal. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "portal_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IdentityProviderState:
    def __init__(__self__, *,
                 identity_provider_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IdentityProvider resources.
        :param pulumi.Input[_builtins.str] identity_provider_arn: ARN of the identity provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] identity_provider_details: Identity provider details. The following list describes the provider detail keys for each identity provider type:
               * For Google and Login with Amazon:
        :param pulumi.Input[_builtins.str] identity_provider_name: Identity provider name.
        :param pulumi.Input[_builtins.str] identity_provider_type: Identity provider type. Valid values: `SAML`, `Facebook`, `Google`, `LoginWithAmazon`, `SignInWithApple`, `OIDC`.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the web portal. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if identity_provider_arn is not None:
            pulumi.set(__self__, "identity_provider_arn", identity_provider_arn)
        if identity_provider_details is not None:
            pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        if identity_provider_name is not None:
            pulumi.set(__self__, "identity_provider_name", identity_provider_name)
        if identity_provider_type is not None:
            pulumi.set(__self__, "identity_provider_type", identity_provider_type)
        if portal_arn is not None:
            pulumi.set(__self__, "portal_arn", portal_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="identityProviderArn")
    def identity_provider_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the identity provider.
        """
        return pulumi.get(self, "identity_provider_arn")

    @identity_provider_arn.setter
    def identity_provider_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_provider_arn", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Identity provider details. The following list describes the provider detail keys for each identity provider type:
        * For Google and Login with Amazon:
        """
        return pulumi.get(self, "identity_provider_details")

    @identity_provider_details.setter
    def identity_provider_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_provider_details", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity provider name.
        """
        return pulumi.get(self, "identity_provider_name")

    @identity_provider_name.setter
    def identity_provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_provider_name", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity provider type. Valid values: `SAML`, `Facebook`, `Google`, `LoginWithAmazon`, `SignInWithApple`, `OIDC`.
        """
        return pulumi.get(self, "identity_provider_type")

    @identity_provider_type.setter
    def identity_provider_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_provider_type", value)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the web portal. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:workspacesweb/identityProvider:IdentityProvider")
class IdentityProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_provider_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web Identity Provider.

        ## Example Usage

        ### Basic Usage with SAML

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.Portal("example", display_name="example")
        example_identity_provider = aws.workspacesweb.IdentityProvider("example",
            identity_provider_name="example-saml",
            identity_provider_type="SAML",
            portal_arn=example.portal_arn,
            identity_provider_details={
                "MetadataURL": "https://example.com/metadata",
            })
        ```

        ### OIDC Identity Provider

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.workspacesweb.Portal("test", display_name="test")
        test_identity_provider = aws.workspacesweb.IdentityProvider("test",
            identity_provider_name="test-updated",
            identity_provider_type="OIDC",
            portal_arn=test.portal_arn,
            identity_provider_details={
                "client_id": "test-client-id",
                "client_secret": "test-client-secret",
                "oidc_issuer": "https://accounts.google.com",
                "attributes_request_method": "POST",
                "authorize_scopes": "openid, email",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Identity Provider using the `identity_provider_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/identityProvider:IdentityProvider example arn:aws:workspaces-web:us-west-2:123456789012:identityprovider/abcdef12345678/12345678-1234-1234-1234-123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] identity_provider_details: Identity provider details. The following list describes the provider detail keys for each identity provider type:
               * For Google and Login with Amazon:
        :param pulumi.Input[_builtins.str] identity_provider_name: Identity provider name.
        :param pulumi.Input[_builtins.str] identity_provider_type: Identity provider type. Valid values: `SAML`, `Facebook`, `Google`, `LoginWithAmazon`, `SignInWithApple`, `OIDC`.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the web portal. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web Identity Provider.

        ## Example Usage

        ### Basic Usage with SAML

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.Portal("example", display_name="example")
        example_identity_provider = aws.workspacesweb.IdentityProvider("example",
            identity_provider_name="example-saml",
            identity_provider_type="SAML",
            portal_arn=example.portal_arn,
            identity_provider_details={
                "MetadataURL": "https://example.com/metadata",
            })
        ```

        ### OIDC Identity Provider

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.workspacesweb.Portal("test", display_name="test")
        test_identity_provider = aws.workspacesweb.IdentityProvider("test",
            identity_provider_name="test-updated",
            identity_provider_type="OIDC",
            portal_arn=test.portal_arn,
            identity_provider_details={
                "client_id": "test-client-id",
                "client_secret": "test-client-secret",
                "oidc_issuer": "https://accounts.google.com",
                "attributes_request_method": "POST",
                "authorize_scopes": "openid, email",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Identity Provider using the `identity_provider_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/identityProvider:IdentityProvider example arn:aws:workspaces-web:us-west-2:123456789012:identityprovider/abcdef12345678/12345678-1234-1234-1234-123456789012
        ```

        :param str resource_name: The name of the resource.
        :param IdentityProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_provider_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityProviderArgs.__new__(IdentityProviderArgs)

            if identity_provider_details is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_details'")
            __props__.__dict__["identity_provider_details"] = identity_provider_details
            if identity_provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_name'")
            __props__.__dict__["identity_provider_name"] = identity_provider_name
            if identity_provider_type is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_type'")
            __props__.__dict__["identity_provider_type"] = identity_provider_type
            if portal_arn is None and not opts.urn:
                raise TypeError("Missing required property 'portal_arn'")
            __props__.__dict__["portal_arn"] = portal_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["identity_provider_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(IdentityProvider, __self__).__init__(
            'aws:workspacesweb/identityProvider:IdentityProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity_provider_arn: Optional[pulumi.Input[_builtins.str]] = None,
            identity_provider_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            identity_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
            identity_provider_type: Optional[pulumi.Input[_builtins.str]] = None,
            portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'IdentityProvider':
        """
        Get an existing IdentityProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_provider_arn: ARN of the identity provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] identity_provider_details: Identity provider details. The following list describes the provider detail keys for each identity provider type:
               * For Google and Login with Amazon:
        :param pulumi.Input[_builtins.str] identity_provider_name: Identity provider name.
        :param pulumi.Input[_builtins.str] identity_provider_type: Identity provider type. Valid values: `SAML`, `Facebook`, `Google`, `LoginWithAmazon`, `SignInWithApple`, `OIDC`.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the web portal. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityProviderState.__new__(_IdentityProviderState)

        __props__.__dict__["identity_provider_arn"] = identity_provider_arn
        __props__.__dict__["identity_provider_details"] = identity_provider_details
        __props__.__dict__["identity_provider_name"] = identity_provider_name
        __props__.__dict__["identity_provider_type"] = identity_provider_type
        __props__.__dict__["portal_arn"] = portal_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return IdentityProvider(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="identityProviderArn")
    def identity_provider_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the identity provider.
        """
        return pulumi.get(self, "identity_provider_arn")

    @_builtins.property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Identity provider details. The following list describes the provider detail keys for each identity provider type:
        * For Google and Login with Amazon:
        """
        return pulumi.get(self, "identity_provider_details")

    @_builtins.property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> pulumi.Output[_builtins.str]:
        """
        Identity provider name.
        """
        return pulumi.get(self, "identity_provider_name")

    @_builtins.property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> pulumi.Output[_builtins.str]:
        """
        Identity provider type. Valid values: `SAML`, `Facebook`, `Google`, `LoginWithAmazon`, `SignInWithApple`, `OIDC`.
        """
        return pulumi.get(self, "identity_provider_type")

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the web portal. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

