# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PortalArgs', 'Portal']

@pulumi.input_type
class PortalArgs:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrent_sessions: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['PortalTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Portal resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Additional encryption context for the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type for the portal. Valid values: `Standard`, `IAM_Identity_Center`.
        :param pulumi.Input[_builtins.str] browser_settings_arn: ARN of the browser settings to use for the portal.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] display_name: Display name of the portal.
        :param pulumi.Input[_builtins.str] instance_type: Instance type for the portal. Valid values: `standard.regular`, `standard.large`.
        :param pulumi.Input[_builtins.int] max_concurrent_sessions: Maximum number of concurrent sessions for the portal.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if browser_settings_arn is not None:
            pulumi.set(__self__, "browser_settings_arn", browser_settings_arn)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if max_concurrent_sessions is not None:
            pulumi.set(__self__, "max_concurrent_sessions", max_concurrent_sessions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional encryption context for the customer managed key. Forces replacement if changed.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication type for the portal. Valid values: `Standard`, `IAM_Identity_Center`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="browserSettingsArn")
    def browser_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the browser settings to use for the portal.
        """
        return pulumi.get(self, "browser_settings_arn")

    @browser_settings_arn.setter
    def browser_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_settings_arn", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the customer managed key. Forces replacement if changed.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the portal.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type for the portal. Valid values: `standard.regular`, `standard.large`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrentSessions")
    def max_concurrent_sessions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of concurrent sessions for the portal.
        """
        return pulumi.get(self, "max_concurrent_sessions")

    @max_concurrent_sessions.setter
    def max_concurrent_sessions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrent_sessions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PortalTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PortalTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _PortalState:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_type: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 data_protection_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_access_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrent_sessions: Optional[pulumi.Input[_builtins.int]] = None,
                 network_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 renderer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 session_logger_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['PortalTimeoutsArgs']] = None,
                 trust_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_logging_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 user_settings_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Portal resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Additional encryption context for the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type for the portal. Valid values: `Standard`, `IAM_Identity_Center`.
        :param pulumi.Input[_builtins.str] browser_settings_arn: ARN of the browser settings to use for the portal.
        :param pulumi.Input[_builtins.str] browser_type: Browser type of the portal.
        :param pulumi.Input[_builtins.str] creation_date: Creation date of the portal.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] data_protection_settings_arn: ARN of the data protection settings associated with the portal.
        :param pulumi.Input[_builtins.str] display_name: Display name of the portal.
        :param pulumi.Input[_builtins.str] instance_type: Instance type for the portal. Valid values: `standard.regular`, `standard.large`.
        :param pulumi.Input[_builtins.str] ip_access_settings_arn: ARN of the IP access settings associated with the portal.
        :param pulumi.Input[_builtins.int] max_concurrent_sessions: Maximum number of concurrent sessions for the portal.
        :param pulumi.Input[_builtins.str] network_settings_arn: ARN of the network settings associated with the portal.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal.
        :param pulumi.Input[_builtins.str] portal_endpoint: Endpoint URL of the portal.
        :param pulumi.Input[_builtins.str] portal_status: Status of the portal.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] renderer_type: Renderer type of the portal.
        :param pulumi.Input[_builtins.str] session_logger_arn: ARN of the session logger associated with the portal.
        :param pulumi.Input[_builtins.str] status_reason: Reason for the current status of the portal.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] trust_store_arn: ARN of the trust store associated with the portal.
        :param pulumi.Input[_builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings associated with the portal.
        :param pulumi.Input[_builtins.str] user_settings_arn: ARN of the user settings associated with the portal.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if browser_settings_arn is not None:
            pulumi.set(__self__, "browser_settings_arn", browser_settings_arn)
        if browser_type is not None:
            pulumi.set(__self__, "browser_type", browser_type)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if data_protection_settings_arn is not None:
            pulumi.set(__self__, "data_protection_settings_arn", data_protection_settings_arn)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ip_access_settings_arn is not None:
            pulumi.set(__self__, "ip_access_settings_arn", ip_access_settings_arn)
        if max_concurrent_sessions is not None:
            pulumi.set(__self__, "max_concurrent_sessions", max_concurrent_sessions)
        if network_settings_arn is not None:
            pulumi.set(__self__, "network_settings_arn", network_settings_arn)
        if portal_arn is not None:
            pulumi.set(__self__, "portal_arn", portal_arn)
        if portal_endpoint is not None:
            pulumi.set(__self__, "portal_endpoint", portal_endpoint)
        if portal_status is not None:
            pulumi.set(__self__, "portal_status", portal_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if renderer_type is not None:
            pulumi.set(__self__, "renderer_type", renderer_type)
        if session_logger_arn is not None:
            pulumi.set(__self__, "session_logger_arn", session_logger_arn)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if trust_store_arn is not None:
            pulumi.set(__self__, "trust_store_arn", trust_store_arn)
        if user_access_logging_settings_arn is not None:
            pulumi.set(__self__, "user_access_logging_settings_arn", user_access_logging_settings_arn)
        if user_settings_arn is not None:
            pulumi.set(__self__, "user_settings_arn", user_settings_arn)

    @_builtins.property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional encryption context for the customer managed key. Forces replacement if changed.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication type for the portal. Valid values: `Standard`, `IAM_Identity_Center`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="browserSettingsArn")
    def browser_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the browser settings to use for the portal.
        """
        return pulumi.get(self, "browser_settings_arn")

    @browser_settings_arn.setter
    def browser_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_settings_arn", value)

    @_builtins.property
    @pulumi.getter(name="browserType")
    def browser_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Browser type of the portal.
        """
        return pulumi.get(self, "browser_type")

    @browser_type.setter
    def browser_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_type", value)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation date of the portal.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the customer managed key. Forces replacement if changed.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="dataProtectionSettingsArn")
    def data_protection_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the data protection settings associated with the portal.
        """
        return pulumi.get(self, "data_protection_settings_arn")

    @data_protection_settings_arn.setter
    def data_protection_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_protection_settings_arn", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the portal.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type for the portal. Valid values: `standard.regular`, `standard.large`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipAccessSettingsArn")
    def ip_access_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IP access settings associated with the portal.
        """
        return pulumi.get(self, "ip_access_settings_arn")

    @ip_access_settings_arn.setter
    def ip_access_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_access_settings_arn", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrentSessions")
    def max_concurrent_sessions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of concurrent sessions for the portal.
        """
        return pulumi.get(self, "max_concurrent_sessions")

    @max_concurrent_sessions.setter
    def max_concurrent_sessions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrent_sessions", value)

    @_builtins.property
    @pulumi.getter(name="networkSettingsArn")
    def network_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the network settings associated with the portal.
        """
        return pulumi.get(self, "network_settings_arn")

    @network_settings_arn.setter
    def network_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_settings_arn", value)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the portal.
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_arn", value)

    @_builtins.property
    @pulumi.getter(name="portalEndpoint")
    def portal_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Endpoint URL of the portal.
        """
        return pulumi.get(self, "portal_endpoint")

    @portal_endpoint.setter
    def portal_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="portalStatus")
    def portal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the portal.
        """
        return pulumi.get(self, "portal_status")

    @portal_status.setter
    def portal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_status", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rendererType")
    def renderer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renderer type of the portal.
        """
        return pulumi.get(self, "renderer_type")

    @renderer_type.setter
    def renderer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renderer_type", value)

    @_builtins.property
    @pulumi.getter(name="sessionLoggerArn")
    def session_logger_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the session logger associated with the portal.
        """
        return pulumi.get(self, "session_logger_arn")

    @session_logger_arn.setter
    def session_logger_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_logger_arn", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reason for the current status of the portal.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PortalTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PortalTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the trust store associated with the portal.
        """
        return pulumi.get(self, "trust_store_arn")

    @trust_store_arn.setter
    def trust_store_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_store_arn", value)

    @_builtins.property
    @pulumi.getter(name="userAccessLoggingSettingsArn")
    def user_access_logging_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the user access logging settings associated with the portal.
        """
        return pulumi.get(self, "user_access_logging_settings_arn")

    @user_access_logging_settings_arn.setter
    def user_access_logging_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_access_logging_settings_arn", value)

    @_builtins.property
    @pulumi.getter(name="userSettingsArn")
    def user_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the user settings associated with the portal.
        """
        return pulumi.get(self, "user_settings_arn")

    @user_settings_arn.setter
    def user_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_settings_arn", value)


@pulumi.type_token("aws:workspacesweb/portal:Portal")
class Portal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrent_sessions: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['PortalTimeoutsArgs', 'PortalTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web Portal.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.Portal("example",
            display_name="example-portal",
            instance_type="standard.regular")
        ```

        ### Complete Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Portal",
            deletion_window_in_days=7)
        example_portal = aws.workspacesweb.Portal("example",
            display_name="example-portal",
            instance_type="standard.large",
            authentication_type="IAM_Identity_Center",
            customer_managed_key=example.arn,
            max_concurrent_sessions=10,
            additional_encryption_context={
                "Environment": "Production",
            },
            tags={
                "Name": "example-portal",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Portal using the `portal_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/portal:Portal example arn:aws:workspaces-web:us-west-2:123456789012:portal/abcdef12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Additional encryption context for the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type for the portal. Valid values: `Standard`, `IAM_Identity_Center`.
        :param pulumi.Input[_builtins.str] browser_settings_arn: ARN of the browser settings to use for the portal.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] display_name: Display name of the portal.
        :param pulumi.Input[_builtins.str] instance_type: Instance type for the portal. Valid values: `standard.regular`, `standard.large`.
        :param pulumi.Input[_builtins.int] max_concurrent_sessions: Maximum number of concurrent sessions for the portal.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PortalArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web Portal.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.Portal("example",
            display_name="example-portal",
            instance_type="standard.regular")
        ```

        ### Complete Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Portal",
            deletion_window_in_days=7)
        example_portal = aws.workspacesweb.Portal("example",
            display_name="example-portal",
            instance_type="standard.large",
            authentication_type="IAM_Identity_Center",
            customer_managed_key=example.arn,
            max_concurrent_sessions=10,
            additional_encryption_context={
                "Environment": "Production",
            },
            tags={
                "Name": "example-portal",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Portal using the `portal_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/portal:Portal example arn:aws:workspaces-web:us-west-2:123456789012:portal/abcdef12345678
        ```

        :param str resource_name: The name of the resource.
        :param PortalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PortalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrent_sessions: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['PortalTimeoutsArgs', 'PortalTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PortalArgs.__new__(PortalArgs)

            __props__.__dict__["additional_encryption_context"] = additional_encryption_context
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["browser_settings_arn"] = browser_settings_arn
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["max_concurrent_sessions"] = max_concurrent_sessions
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["browser_type"] = None
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["data_protection_settings_arn"] = None
            __props__.__dict__["ip_access_settings_arn"] = None
            __props__.__dict__["network_settings_arn"] = None
            __props__.__dict__["portal_arn"] = None
            __props__.__dict__["portal_endpoint"] = None
            __props__.__dict__["portal_status"] = None
            __props__.__dict__["renderer_type"] = None
            __props__.__dict__["session_logger_arn"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["trust_store_arn"] = None
            __props__.__dict__["user_access_logging_settings_arn"] = None
            __props__.__dict__["user_settings_arn"] = None
        super(Portal, __self__).__init__(
            'aws:workspacesweb/portal:Portal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            browser_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
            browser_type: Optional[pulumi.Input[_builtins.str]] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
            data_protection_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ip_access_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
            max_concurrent_sessions: Optional[pulumi.Input[_builtins.int]] = None,
            network_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
            portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
            portal_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            portal_status: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            renderer_type: Optional[pulumi.Input[_builtins.str]] = None,
            session_logger_arn: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['PortalTimeoutsArgs', 'PortalTimeoutsArgsDict']]] = None,
            trust_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
            user_access_logging_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
            user_settings_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'Portal':
        """
        Get an existing Portal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Additional encryption context for the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type for the portal. Valid values: `Standard`, `IAM_Identity_Center`.
        :param pulumi.Input[_builtins.str] browser_settings_arn: ARN of the browser settings to use for the portal.
        :param pulumi.Input[_builtins.str] browser_type: Browser type of the portal.
        :param pulumi.Input[_builtins.str] creation_date: Creation date of the portal.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed key. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] data_protection_settings_arn: ARN of the data protection settings associated with the portal.
        :param pulumi.Input[_builtins.str] display_name: Display name of the portal.
        :param pulumi.Input[_builtins.str] instance_type: Instance type for the portal. Valid values: `standard.regular`, `standard.large`.
        :param pulumi.Input[_builtins.str] ip_access_settings_arn: ARN of the IP access settings associated with the portal.
        :param pulumi.Input[_builtins.int] max_concurrent_sessions: Maximum number of concurrent sessions for the portal.
        :param pulumi.Input[_builtins.str] network_settings_arn: ARN of the network settings associated with the portal.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal.
        :param pulumi.Input[_builtins.str] portal_endpoint: Endpoint URL of the portal.
        :param pulumi.Input[_builtins.str] portal_status: Status of the portal.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] renderer_type: Renderer type of the portal.
        :param pulumi.Input[_builtins.str] session_logger_arn: ARN of the session logger associated with the portal.
        :param pulumi.Input[_builtins.str] status_reason: Reason for the current status of the portal.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] trust_store_arn: ARN of the trust store associated with the portal.
        :param pulumi.Input[_builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings associated with the portal.
        :param pulumi.Input[_builtins.str] user_settings_arn: ARN of the user settings associated with the portal.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PortalState.__new__(_PortalState)

        __props__.__dict__["additional_encryption_context"] = additional_encryption_context
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["browser_settings_arn"] = browser_settings_arn
        __props__.__dict__["browser_type"] = browser_type
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["data_protection_settings_arn"] = data_protection_settings_arn
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ip_access_settings_arn"] = ip_access_settings_arn
        __props__.__dict__["max_concurrent_sessions"] = max_concurrent_sessions
        __props__.__dict__["network_settings_arn"] = network_settings_arn
        __props__.__dict__["portal_arn"] = portal_arn
        __props__.__dict__["portal_endpoint"] = portal_endpoint
        __props__.__dict__["portal_status"] = portal_status
        __props__.__dict__["region"] = region
        __props__.__dict__["renderer_type"] = renderer_type
        __props__.__dict__["session_logger_arn"] = session_logger_arn
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["trust_store_arn"] = trust_store_arn
        __props__.__dict__["user_access_logging_settings_arn"] = user_access_logging_settings_arn
        __props__.__dict__["user_settings_arn"] = user_settings_arn
        return Portal(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Additional encryption context for the customer managed key. Forces replacement if changed.
        """
        return pulumi.get(self, "additional_encryption_context")

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[_builtins.str]:
        """
        Authentication type for the portal. Valid values: `Standard`, `IAM_Identity_Center`.
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="browserSettingsArn")
    def browser_settings_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the browser settings to use for the portal.
        """
        return pulumi.get(self, "browser_settings_arn")

    @_builtins.property
    @pulumi.getter(name="browserType")
    def browser_type(self) -> pulumi.Output[_builtins.str]:
        """
        Browser type of the portal.
        """
        return pulumi.get(self, "browser_type")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        Creation date of the portal.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the customer managed key. Forces replacement if changed.
        """
        return pulumi.get(self, "customer_managed_key")

    @_builtins.property
    @pulumi.getter(name="dataProtectionSettingsArn")
    def data_protection_settings_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the data protection settings associated with the portal.
        """
        return pulumi.get(self, "data_protection_settings_arn")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name of the portal.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type for the portal. Valid values: `standard.regular`, `standard.large`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipAccessSettingsArn")
    def ip_access_settings_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IP access settings associated with the portal.
        """
        return pulumi.get(self, "ip_access_settings_arn")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentSessions")
    def max_concurrent_sessions(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum number of concurrent sessions for the portal.
        """
        return pulumi.get(self, "max_concurrent_sessions")

    @_builtins.property
    @pulumi.getter(name="networkSettingsArn")
    def network_settings_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the network settings associated with the portal.
        """
        return pulumi.get(self, "network_settings_arn")

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the portal.
        """
        return pulumi.get(self, "portal_arn")

    @_builtins.property
    @pulumi.getter(name="portalEndpoint")
    def portal_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Endpoint URL of the portal.
        """
        return pulumi.get(self, "portal_endpoint")

    @_builtins.property
    @pulumi.getter(name="portalStatus")
    def portal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the portal.
        """
        return pulumi.get(self, "portal_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rendererType")
    def renderer_type(self) -> pulumi.Output[_builtins.str]:
        """
        Renderer type of the portal.
        """
        return pulumi.get(self, "renderer_type")

    @_builtins.property
    @pulumi.getter(name="sessionLoggerArn")
    def session_logger_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the session logger associated with the portal.
        """
        return pulumi.get(self, "session_logger_arn")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Reason for the current status of the portal.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.PortalTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the trust store associated with the portal.
        """
        return pulumi.get(self, "trust_store_arn")

    @_builtins.property
    @pulumi.getter(name="userAccessLoggingSettingsArn")
    def user_access_logging_settings_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the user access logging settings associated with the portal.
        """
        return pulumi.get(self, "user_access_logging_settings_arn")

    @_builtins.property
    @pulumi.getter(name="userSettingsArn")
    def user_settings_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the user settings associated with the portal.
        """
        return pulumi.get(self, "user_settings_arn")

