# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrustStoreAssociationArgs', 'TrustStoreAssociation']

@pulumi.input_type
class TrustStoreAssociationArgs:
    def __init__(__self__, *,
                 portal_arn: pulumi.Input[_builtins.str],
                 trust_store_arn: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TrustStoreAssociation resource.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the trust store. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] trust_store_arn: ARN of the trust store to associate with the portal. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "portal_arn", portal_arn)
        pulumi.set(__self__, "trust_store_arn", trust_store_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the portal to associate with the trust store. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "portal_arn", value)

    @_builtins.property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the trust store to associate with the portal. Forces replacement if changed.
        """
        return pulumi.get(self, "trust_store_arn")

    @trust_store_arn.setter
    def trust_store_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trust_store_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TrustStoreAssociationState:
    def __init__(__self__, *,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_store_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrustStoreAssociation resources.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the trust store. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] trust_store_arn: ARN of the trust store to associate with the portal. Forces replacement if changed.
        """
        if portal_arn is not None:
            pulumi.set(__self__, "portal_arn", portal_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trust_store_arn is not None:
            pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the portal to associate with the trust store. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the trust store to associate with the portal. Forces replacement if changed.
        """
        return pulumi.get(self, "trust_store_arn")

    @trust_store_arn.setter
    def trust_store_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_store_arn", value)


@pulumi.type_token("aws:workspacesweb/trustStoreAssociation:TrustStoreAssociation")
class TrustStoreAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web Trust Store Association.

        ## Example Usage

        ### Basic Usage

        ## Import

        Using `pulumi import`, import WorkSpaces Web Trust Store Association using the `trust_store_arn,portal_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/trustStoreAssociation:TrustStoreAssociation example arn:aws:workspaces-web:us-west-2:123456789012:trustStore/trust_store-id-12345678,arn:aws:workspaces-web:us-west-2:123456789012:portal/portal-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the trust store. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] trust_store_arn: ARN of the trust store to associate with the portal. Forces replacement if changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrustStoreAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web Trust Store Association.

        ## Example Usage

        ### Basic Usage

        ## Import

        Using `pulumi import`, import WorkSpaces Web Trust Store Association using the `trust_store_arn,portal_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/trustStoreAssociation:TrustStoreAssociation example arn:aws:workspaces-web:us-west-2:123456789012:trustStore/trust_store-id-12345678,arn:aws:workspaces-web:us-west-2:123456789012:portal/portal-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param TrustStoreAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrustStoreAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrustStoreAssociationArgs.__new__(TrustStoreAssociationArgs)

            if portal_arn is None and not opts.urn:
                raise TypeError("Missing required property 'portal_arn'")
            __props__.__dict__["portal_arn"] = portal_arn
            __props__.__dict__["region"] = region
            if trust_store_arn is None and not opts.urn:
                raise TypeError("Missing required property 'trust_store_arn'")
            __props__.__dict__["trust_store_arn"] = trust_store_arn
        super(TrustStoreAssociation, __self__).__init__(
            'aws:workspacesweb/trustStoreAssociation:TrustStoreAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            trust_store_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrustStoreAssociation':
        """
        Get an existing TrustStoreAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the trust store. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] trust_store_arn: ARN of the trust store to associate with the portal. Forces replacement if changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrustStoreAssociationState.__new__(_TrustStoreAssociationState)

        __props__.__dict__["portal_arn"] = portal_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["trust_store_arn"] = trust_store_arn
        return TrustStoreAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the portal to associate with the trust store. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the trust store to associate with the portal. Forces replacement if changed.
        """
        return pulumi.get(self, "trust_store_arn")

