# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResourcePolicyArgs', 'ResourcePolicy']

@pulumi.input_type
class ResourcePolicyArgs:
    def __init__(__self__, *,
                 policy_document: pulumi.Input[_builtins.str],
                 policy_name: pulumi.Input[_builtins.str],
                 bypass_policy_lockout_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ResourcePolicy resource.
        :param pulumi.Input[_builtins.str] policy_document: JSON string of the resource policy or resource policy document, which can be up to 5kb in size.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] policy_name: name of the resource policy. Must be unique within a specific Amazon Web Services account.
        :param pulumi.Input[_builtins.bool] bypass_policy_lockout_check: Flag to indicate whether to bypass the resource policy lockout safety check. Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately. Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent PutResourcePolicy request. The default value is `false`.
        :param pulumi.Input[_builtins.str] policy_revision_id: Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account. If the policy revision id does not match the latest revision id, the operation will fail with an InvalidPolicyRevisionIdException exception. You can also provide a PolicyRevisionId of 0. In this case, the operation will fail with an InvalidPolicyRevisionIdException exception if a resource policy with the same name already exists.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)
        if bypass_policy_lockout_check is not None:
            pulumi.set(__self__, "bypass_policy_lockout_check", bypass_policy_lockout_check)
        if policy_revision_id is not None:
            pulumi.set(__self__, "policy_revision_id", policy_revision_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Input[_builtins.str]:
        """
        JSON string of the resource policy or resource policy document, which can be up to 5kb in size.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        name of the resource policy. Must be unique within a specific Amazon Web Services account.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="bypassPolicyLockoutCheck")
    def bypass_policy_lockout_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to indicate whether to bypass the resource policy lockout safety check. Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately. Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent PutResourcePolicy request. The default value is `false`.
        """
        return pulumi.get(self, "bypass_policy_lockout_check")

    @bypass_policy_lockout_check.setter
    def bypass_policy_lockout_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_policy_lockout_check", value)

    @_builtins.property
    @pulumi.getter(name="policyRevisionId")
    def policy_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account. If the policy revision id does not match the latest revision id, the operation will fail with an InvalidPolicyRevisionIdException exception. You can also provide a PolicyRevisionId of 0. In this case, the operation will fail with an InvalidPolicyRevisionIdException exception if a resource policy with the same name already exists.
        """
        return pulumi.get(self, "policy_revision_id")

    @policy_revision_id.setter
    def policy_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_revision_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ResourcePolicyState:
    def __init__(__self__, *,
                 bypass_policy_lockout_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourcePolicy resources.
        :param pulumi.Input[_builtins.bool] bypass_policy_lockout_check: Flag to indicate whether to bypass the resource policy lockout safety check. Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately. Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent PutResourcePolicy request. The default value is `false`.
        :param pulumi.Input[_builtins.str] last_updated_time: When the policy was last updated, in Unix time seconds.
        :param pulumi.Input[_builtins.str] policy_document: JSON string of the resource policy or resource policy document, which can be up to 5kb in size.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] policy_name: name of the resource policy. Must be unique within a specific Amazon Web Services account.
        :param pulumi.Input[_builtins.str] policy_revision_id: Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account. If the policy revision id does not match the latest revision id, the operation will fail with an InvalidPolicyRevisionIdException exception. You can also provide a PolicyRevisionId of 0. In this case, the operation will fail with an InvalidPolicyRevisionIdException exception if a resource policy with the same name already exists.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if bypass_policy_lockout_check is not None:
            pulumi.set(__self__, "bypass_policy_lockout_check", bypass_policy_lockout_check)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_revision_id is not None:
            pulumi.set(__self__, "policy_revision_id", policy_revision_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="bypassPolicyLockoutCheck")
    def bypass_policy_lockout_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to indicate whether to bypass the resource policy lockout safety check. Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately. Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent PutResourcePolicy request. The default value is `false`.
        """
        return pulumi.get(self, "bypass_policy_lockout_check")

    @bypass_policy_lockout_check.setter
    def bypass_policy_lockout_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_policy_lockout_check", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the policy was last updated, in Unix time seconds.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string of the resource policy or resource policy document, which can be up to 5kb in size.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the resource policy. Must be unique within a specific Amazon Web Services account.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="policyRevisionId")
    def policy_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account. If the policy revision id does not match the latest revision id, the operation will fail with an InvalidPolicyRevisionIdException exception. You can also provide a PolicyRevisionId of 0. In this case, the operation will fail with an InvalidPolicyRevisionIdException exception if a resource policy with the same name already exists.
        """
        return pulumi.get(self, "policy_revision_id")

    @policy_revision_id.setter
    def policy_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_revision_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:xray/resourcePolicy:ResourcePolicy")
class ResourcePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_policy_lockout_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS X-Ray Resource Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.xray.ResourcePolicy("test",
            policy_name="test",
            policy_document="{\\"Version\\":\\"2012-10-17\\",\\"Statement\\":[{\\"Sid\\":\\"AllowXRayAccess\\",\\"Effect\\":\\"Allow\\",\\"Principal\\":{\\"AWS\\":\\"*\\"},\\"Action\\":[\\"xray:*\\",\\"xray:PutResourcePolicy\\"],\\"Resource\\":\\"*\\"}]}",
            bypass_policy_lockout_check=True)
        ```

        ## Import

        Using `pulumi import`, import X-Ray Resource Policy using the `policy_name`. For example:

        ```sh
        $ pulumi import aws:xray/resourcePolicy:ResourcePolicy example resource_policy-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] bypass_policy_lockout_check: Flag to indicate whether to bypass the resource policy lockout safety check. Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately. Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent PutResourcePolicy request. The default value is `false`.
        :param pulumi.Input[_builtins.str] policy_document: JSON string of the resource policy or resource policy document, which can be up to 5kb in size.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] policy_name: name of the resource policy. Must be unique within a specific Amazon Web Services account.
        :param pulumi.Input[_builtins.str] policy_revision_id: Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account. If the policy revision id does not match the latest revision id, the operation will fail with an InvalidPolicyRevisionIdException exception. You can also provide a PolicyRevisionId of 0. In this case, the operation will fail with an InvalidPolicyRevisionIdException exception if a resource policy with the same name already exists.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourcePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS X-Ray Resource Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.xray.ResourcePolicy("test",
            policy_name="test",
            policy_document="{\\"Version\\":\\"2012-10-17\\",\\"Statement\\":[{\\"Sid\\":\\"AllowXRayAccess\\",\\"Effect\\":\\"Allow\\",\\"Principal\\":{\\"AWS\\":\\"*\\"},\\"Action\\":[\\"xray:*\\",\\"xray:PutResourcePolicy\\"],\\"Resource\\":\\"*\\"}]}",
            bypass_policy_lockout_check=True)
        ```

        ## Import

        Using `pulumi import`, import X-Ray Resource Policy using the `policy_name`. For example:

        ```sh
        $ pulumi import aws:xray/resourcePolicy:ResourcePolicy example resource_policy-name
        ```

        :param str resource_name: The name of the resource.
        :param ResourcePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourcePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_policy_lockout_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourcePolicyArgs.__new__(ResourcePolicyArgs)

            __props__.__dict__["bypass_policy_lockout_check"] = bypass_policy_lockout_check
            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
            __props__.__dict__["policy_revision_id"] = policy_revision_id
            __props__.__dict__["region"] = region
            __props__.__dict__["last_updated_time"] = None
        super(ResourcePolicy, __self__).__init__(
            'aws:xray/resourcePolicy:ResourcePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypass_policy_lockout_check: Optional[pulumi.Input[_builtins.bool]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            policy_document: Optional[pulumi.Input[_builtins.str]] = None,
            policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ResourcePolicy':
        """
        Get an existing ResourcePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] bypass_policy_lockout_check: Flag to indicate whether to bypass the resource policy lockout safety check. Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately. Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent PutResourcePolicy request. The default value is `false`.
        :param pulumi.Input[_builtins.str] last_updated_time: When the policy was last updated, in Unix time seconds.
        :param pulumi.Input[_builtins.str] policy_document: JSON string of the resource policy or resource policy document, which can be up to 5kb in size.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] policy_name: name of the resource policy. Must be unique within a specific Amazon Web Services account.
        :param pulumi.Input[_builtins.str] policy_revision_id: Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account. If the policy revision id does not match the latest revision id, the operation will fail with an InvalidPolicyRevisionIdException exception. You can also provide a PolicyRevisionId of 0. In this case, the operation will fail with an InvalidPolicyRevisionIdException exception if a resource policy with the same name already exists.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourcePolicyState.__new__(_ResourcePolicyState)

        __props__.__dict__["bypass_policy_lockout_check"] = bypass_policy_lockout_check
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["policy_revision_id"] = policy_revision_id
        __props__.__dict__["region"] = region
        return ResourcePolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bypassPolicyLockoutCheck")
    def bypass_policy_lockout_check(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to indicate whether to bypass the resource policy lockout safety check. Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately. Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent PutResourcePolicy request. The default value is `false`.
        """
        return pulumi.get(self, "bypass_policy_lockout_check")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        When the policy was last updated, in Unix time seconds.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[_builtins.str]:
        """
        JSON string of the resource policy or resource policy document, which can be up to 5kb in size.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy_document")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        name of the resource policy. Must be unique within a specific Amazon Web Services account.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="policyRevisionId")
    def policy_revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account. If the policy revision id does not match the latest revision id, the operation will fail with an InvalidPolicyRevisionIdException exception. You can also provide a PolicyRevisionId of 0. In this case, the operation will fail with an InvalidPolicyRevisionIdException exception if a resource policy with the same name already exists.
        """
        return pulumi.get(self, "policy_revision_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

