import datetime

from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf import duration_pb2 as _duration_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class Side(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    SIDE_UNSPECIFIED: _ClassVar[Side]
    SIDE_BUY: _ClassVar[Side]
    SIDE_SELL: _ClassVar[Side]

class OrderType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    ORDER_TYPE_UNSPECIFIED: _ClassVar[OrderType]
    ORDER_TYPE_MARKET: _ClassVar[OrderType]
    ORDER_TYPE_LIMIT: _ClassVar[OrderType]
    ORDER_TYPE_STOP_MARKET: _ClassVar[OrderType]

class Interval(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    INTERVAL_UNSPECIFIED: _ClassVar[Interval]
    INTERVAL_1S: _ClassVar[Interval]
    INTERVAL_1M: _ClassVar[Interval]
    INTERVAL_5M: _ClassVar[Interval]
    INTERVAL_15M: _ClassVar[Interval]
    INTERVAL_1H: _ClassVar[Interval]
    INTERVAL_4H: _ClassVar[Interval]
    INTERVAL_1D: _ClassVar[Interval]
SIDE_UNSPECIFIED: Side
SIDE_BUY: Side
SIDE_SELL: Side
ORDER_TYPE_UNSPECIFIED: OrderType
ORDER_TYPE_MARKET: OrderType
ORDER_TYPE_LIMIT: OrderType
ORDER_TYPE_STOP_MARKET: OrderType
INTERVAL_UNSPECIFIED: Interval
INTERVAL_1S: Interval
INTERVAL_1M: Interval
INTERVAL_5M: Interval
INTERVAL_15M: Interval
INTERVAL_1H: Interval
INTERVAL_4H: Interval
INTERVAL_1D: Interval

class Decimal(_message.Message):
    __slots__ = ("value",)
    VALUE_FIELD_NUMBER: _ClassVar[int]
    value: str
    def __init__(self, value: _Optional[str] = ...) -> None: ...

class Tick(_message.Message):
    __slots__ = ("symbol", "price", "size", "side", "exchange_timestamp", "received_at")
    SYMBOL_FIELD_NUMBER: _ClassVar[int]
    PRICE_FIELD_NUMBER: _ClassVar[int]
    SIZE_FIELD_NUMBER: _ClassVar[int]
    SIDE_FIELD_NUMBER: _ClassVar[int]
    EXCHANGE_TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    RECEIVED_AT_FIELD_NUMBER: _ClassVar[int]
    symbol: str
    price: Decimal
    size: Decimal
    side: Side
    exchange_timestamp: _timestamp_pb2.Timestamp
    received_at: _timestamp_pb2.Timestamp
    def __init__(self, symbol: _Optional[str] = ..., price: _Optional[_Union[Decimal, _Mapping]] = ..., size: _Optional[_Union[Decimal, _Mapping]] = ..., side: _Optional[_Union[Side, str]] = ..., exchange_timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., received_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class Candle(_message.Message):
    __slots__ = ("symbol", "interval", "open", "high", "low", "close", "volume", "timestamp")
    SYMBOL_FIELD_NUMBER: _ClassVar[int]
    INTERVAL_FIELD_NUMBER: _ClassVar[int]
    OPEN_FIELD_NUMBER: _ClassVar[int]
    HIGH_FIELD_NUMBER: _ClassVar[int]
    LOW_FIELD_NUMBER: _ClassVar[int]
    CLOSE_FIELD_NUMBER: _ClassVar[int]
    VOLUME_FIELD_NUMBER: _ClassVar[int]
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    symbol: str
    interval: Interval
    open: Decimal
    high: Decimal
    low: Decimal
    close: Decimal
    volume: Decimal
    timestamp: _timestamp_pb2.Timestamp
    def __init__(self, symbol: _Optional[str] = ..., interval: _Optional[_Union[Interval, str]] = ..., open: _Optional[_Union[Decimal, _Mapping]] = ..., high: _Optional[_Union[Decimal, _Mapping]] = ..., low: _Optional[_Union[Decimal, _Mapping]] = ..., close: _Optional[_Union[Decimal, _Mapping]] = ..., volume: _Optional[_Union[Decimal, _Mapping]] = ..., timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class OrderBookLevel(_message.Message):
    __slots__ = ("price", "size")
    PRICE_FIELD_NUMBER: _ClassVar[int]
    SIZE_FIELD_NUMBER: _ClassVar[int]
    price: Decimal
    size: Decimal
    def __init__(self, price: _Optional[_Union[Decimal, _Mapping]] = ..., size: _Optional[_Union[Decimal, _Mapping]] = ...) -> None: ...

class OrderBook(_message.Message):
    __slots__ = ("symbol", "bids", "asks", "timestamp")
    SYMBOL_FIELD_NUMBER: _ClassVar[int]
    BIDS_FIELD_NUMBER: _ClassVar[int]
    ASKS_FIELD_NUMBER: _ClassVar[int]
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    symbol: str
    bids: _containers.RepeatedCompositeFieldContainer[OrderBookLevel]
    asks: _containers.RepeatedCompositeFieldContainer[OrderBookLevel]
    timestamp: _timestamp_pb2.Timestamp
    def __init__(self, symbol: _Optional[str] = ..., bids: _Optional[_Iterable[_Union[OrderBookLevel, _Mapping]]] = ..., asks: _Optional[_Iterable[_Union[OrderBookLevel, _Mapping]]] = ..., timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class Position(_message.Message):
    __slots__ = ("symbol", "side", "quantity", "entry_price", "unrealized_pnl", "updated_at")
    SYMBOL_FIELD_NUMBER: _ClassVar[int]
    SIDE_FIELD_NUMBER: _ClassVar[int]
    QUANTITY_FIELD_NUMBER: _ClassVar[int]
    ENTRY_PRICE_FIELD_NUMBER: _ClassVar[int]
    UNREALIZED_PNL_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    symbol: str
    side: Side
    quantity: Decimal
    entry_price: Decimal
    unrealized_pnl: Decimal
    updated_at: _timestamp_pb2.Timestamp
    def __init__(self, symbol: _Optional[str] = ..., side: _Optional[_Union[Side, str]] = ..., quantity: _Optional[_Union[Decimal, _Mapping]] = ..., entry_price: _Optional[_Union[Decimal, _Mapping]] = ..., unrealized_pnl: _Optional[_Union[Decimal, _Mapping]] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class StrategyContext(_message.Message):
    __slots__ = ("positions",)
    POSITIONS_FIELD_NUMBER: _ClassVar[int]
    positions: _containers.RepeatedCompositeFieldContainer[Position]
    def __init__(self, positions: _Optional[_Iterable[_Union[Position, _Mapping]]] = ...) -> None: ...

class Fill(_message.Message):
    __slots__ = ("order_id", "symbol", "side", "fill_price", "fill_quantity", "fee", "timestamp")
    ORDER_ID_FIELD_NUMBER: _ClassVar[int]
    SYMBOL_FIELD_NUMBER: _ClassVar[int]
    SIDE_FIELD_NUMBER: _ClassVar[int]
    FILL_PRICE_FIELD_NUMBER: _ClassVar[int]
    FILL_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    FEE_FIELD_NUMBER: _ClassVar[int]
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    order_id: str
    symbol: str
    side: Side
    fill_price: Decimal
    fill_quantity: Decimal
    fee: Decimal
    timestamp: _timestamp_pb2.Timestamp
    def __init__(self, order_id: _Optional[str] = ..., symbol: _Optional[str] = ..., side: _Optional[_Union[Side, str]] = ..., fill_price: _Optional[_Union[Decimal, _Mapping]] = ..., fill_quantity: _Optional[_Union[Decimal, _Mapping]] = ..., fee: _Optional[_Union[Decimal, _Mapping]] = ..., timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class TwapHint(_message.Message):
    __slots__ = ("duration",)
    DURATION_FIELD_NUMBER: _ClassVar[int]
    duration: _duration_pb2.Duration
    def __init__(self, duration: _Optional[_Union[datetime.timedelta, _duration_pb2.Duration, _Mapping]] = ...) -> None: ...

class VwapHint(_message.Message):
    __slots__ = ("duration", "participation_rate")
    DURATION_FIELD_NUMBER: _ClassVar[int]
    PARTICIPATION_RATE_FIELD_NUMBER: _ClassVar[int]
    duration: _duration_pb2.Duration
    participation_rate: Decimal
    def __init__(self, duration: _Optional[_Union[datetime.timedelta, _duration_pb2.Duration, _Mapping]] = ..., participation_rate: _Optional[_Union[Decimal, _Mapping]] = ...) -> None: ...

class IcebergHint(_message.Message):
    __slots__ = ("display_size", "limit_offset_bps")
    DISPLAY_SIZE_FIELD_NUMBER: _ClassVar[int]
    LIMIT_OFFSET_BPS_FIELD_NUMBER: _ClassVar[int]
    display_size: Decimal
    limit_offset_bps: Decimal
    def __init__(self, display_size: _Optional[_Union[Decimal, _Mapping]] = ..., limit_offset_bps: _Optional[_Union[Decimal, _Mapping]] = ...) -> None: ...

class PeggedHint(_message.Message):
    __slots__ = ("offset_bps", "clip_size", "refresh_secs")
    OFFSET_BPS_FIELD_NUMBER: _ClassVar[int]
    CLIP_SIZE_FIELD_NUMBER: _ClassVar[int]
    REFRESH_SECS_FIELD_NUMBER: _ClassVar[int]
    offset_bps: Decimal
    clip_size: Decimal
    refresh_secs: int
    def __init__(self, offset_bps: _Optional[_Union[Decimal, _Mapping]] = ..., clip_size: _Optional[_Union[Decimal, _Mapping]] = ..., refresh_secs: _Optional[int] = ...) -> None: ...

class SniperHint(_message.Message):
    __slots__ = ("trigger_price", "timeout")
    TRIGGER_PRICE_FIELD_NUMBER: _ClassVar[int]
    TIMEOUT_FIELD_NUMBER: _ClassVar[int]
    trigger_price: Decimal
    timeout: _duration_pb2.Duration
    def __init__(self, trigger_price: _Optional[_Union[Decimal, _Mapping]] = ..., timeout: _Optional[_Union[datetime.timedelta, _duration_pb2.Duration, _Mapping]] = ...) -> None: ...

class ExecutionHint(_message.Message):
    __slots__ = ("twap", "vwap", "iceberg", "pegged", "sniper")
    TWAP_FIELD_NUMBER: _ClassVar[int]
    VWAP_FIELD_NUMBER: _ClassVar[int]
    ICEBERG_FIELD_NUMBER: _ClassVar[int]
    PEGGED_FIELD_NUMBER: _ClassVar[int]
    SNIPER_FIELD_NUMBER: _ClassVar[int]
    twap: TwapHint
    vwap: VwapHint
    iceberg: IcebergHint
    pegged: PeggedHint
    sniper: SniperHint
    def __init__(self, twap: _Optional[_Union[TwapHint, _Mapping]] = ..., vwap: _Optional[_Union[VwapHint, _Mapping]] = ..., iceberg: _Optional[_Union[IcebergHint, _Mapping]] = ..., pegged: _Optional[_Union[PeggedHint, _Mapping]] = ..., sniper: _Optional[_Union[SniperHint, _Mapping]] = ...) -> None: ...

class Signal(_message.Message):
    __slots__ = ("symbol", "kind", "confidence", "stop_loss", "take_profit", "execution_hint", "note")
    class Kind(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        KIND_UNSPECIFIED: _ClassVar[Signal.Kind]
        KIND_ENTER_LONG: _ClassVar[Signal.Kind]
        KIND_EXIT_LONG: _ClassVar[Signal.Kind]
        KIND_ENTER_SHORT: _ClassVar[Signal.Kind]
        KIND_EXIT_SHORT: _ClassVar[Signal.Kind]
        KIND_FLATTEN: _ClassVar[Signal.Kind]
    KIND_UNSPECIFIED: Signal.Kind
    KIND_ENTER_LONG: Signal.Kind
    KIND_EXIT_LONG: Signal.Kind
    KIND_ENTER_SHORT: Signal.Kind
    KIND_EXIT_SHORT: Signal.Kind
    KIND_FLATTEN: Signal.Kind
    SYMBOL_FIELD_NUMBER: _ClassVar[int]
    KIND_FIELD_NUMBER: _ClassVar[int]
    CONFIDENCE_FIELD_NUMBER: _ClassVar[int]
    STOP_LOSS_FIELD_NUMBER: _ClassVar[int]
    TAKE_PROFIT_FIELD_NUMBER: _ClassVar[int]
    EXECUTION_HINT_FIELD_NUMBER: _ClassVar[int]
    NOTE_FIELD_NUMBER: _ClassVar[int]
    symbol: str
    kind: Signal.Kind
    confidence: float
    stop_loss: Decimal
    take_profit: Decimal
    execution_hint: ExecutionHint
    note: str
    def __init__(self, symbol: _Optional[str] = ..., kind: _Optional[_Union[Signal.Kind, str]] = ..., confidence: _Optional[float] = ..., stop_loss: _Optional[_Union[Decimal, _Mapping]] = ..., take_profit: _Optional[_Union[Decimal, _Mapping]] = ..., execution_hint: _Optional[_Union[ExecutionHint, _Mapping]] = ..., note: _Optional[str] = ...) -> None: ...

class SignalList(_message.Message):
    __slots__ = ("signals",)
    SIGNALS_FIELD_NUMBER: _ClassVar[int]
    signals: _containers.RepeatedCompositeFieldContainer[Signal]
    def __init__(self, signals: _Optional[_Iterable[_Union[Signal, _Mapping]]] = ...) -> None: ...

class InitRequest(_message.Message):
    __slots__ = ("config_json",)
    CONFIG_JSON_FIELD_NUMBER: _ClassVar[int]
    config_json: str
    def __init__(self, config_json: _Optional[str] = ...) -> None: ...

class InitResponse(_message.Message):
    __slots__ = ("symbols", "success", "error_message")
    SYMBOLS_FIELD_NUMBER: _ClassVar[int]
    SUCCESS_FIELD_NUMBER: _ClassVar[int]
    ERROR_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    symbols: _containers.RepeatedScalarFieldContainer[str]
    success: bool
    error_message: str
    def __init__(self, symbols: _Optional[_Iterable[str]] = ..., success: bool = ..., error_message: _Optional[str] = ...) -> None: ...

class TickRequest(_message.Message):
    __slots__ = ("tick", "context")
    TICK_FIELD_NUMBER: _ClassVar[int]
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    tick: Tick
    context: StrategyContext
    def __init__(self, tick: _Optional[_Union[Tick, _Mapping]] = ..., context: _Optional[_Union[StrategyContext, _Mapping]] = ...) -> None: ...

class CandleRequest(_message.Message):
    __slots__ = ("candle", "context")
    CANDLE_FIELD_NUMBER: _ClassVar[int]
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    candle: Candle
    context: StrategyContext
    def __init__(self, candle: _Optional[_Union[Candle, _Mapping]] = ..., context: _Optional[_Union[StrategyContext, _Mapping]] = ...) -> None: ...

class OrderBookRequest(_message.Message):
    __slots__ = ("order_book", "context")
    ORDER_BOOK_FIELD_NUMBER: _ClassVar[int]
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    order_book: OrderBook
    context: StrategyContext
    def __init__(self, order_book: _Optional[_Union[OrderBook, _Mapping]] = ..., context: _Optional[_Union[StrategyContext, _Mapping]] = ...) -> None: ...

class FillRequest(_message.Message):
    __slots__ = ("fill", "context")
    FILL_FIELD_NUMBER: _ClassVar[int]
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    fill: Fill
    context: StrategyContext
    def __init__(self, fill: _Optional[_Union[Fill, _Mapping]] = ..., context: _Optional[_Union[StrategyContext, _Mapping]] = ...) -> None: ...

class HeartbeatRequest(_message.Message):
    __slots__ = ("timestamp",)
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    timestamp: _timestamp_pb2.Timestamp
    def __init__(self, timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class HeartbeatResponse(_message.Message):
    __slots__ = ("healthy", "status_msg")
    HEALTHY_FIELD_NUMBER: _ClassVar[int]
    STATUS_MSG_FIELD_NUMBER: _ClassVar[int]
    healthy: bool
    status_msg: str
    def __init__(self, healthy: bool = ..., status_msg: _Optional[str] = ...) -> None: ...
