

#include "cdfpp/chrono/cdf-chrono.hpp"
#include <array>
#include <cstdint>

struct test_entry
{
    int64_t        unix_epoch;
    cdf::tt2000_t  tt2000_epoch;
    cdf::epoch     epoch_epoch;
    cdf::epoch16   epoch16_epoch;
    
};

test_entry test_values[] = {

    //1950-01-01 00:00:00+00:00
    test_entry{ -631152000, { -1577879967816000000 }, { 61536067200000.0 }, { 61536067200.0, 0.0 } },

    //1950-04-11 00:00:00+00:00
    test_entry{ -622512000, { -1569239967816000000 }, { 61544707200000.0 }, { 61544707200.0, 0.0 } },

    //1950-07-20 00:00:00+00:00
    test_entry{ -613872000, { -1560599967816000000 }, { 61553347200000.0 }, { 61553347200.0, 0.0 } },

    //1950-10-28 00:00:00+00:00
    test_entry{ -605232000, { -1551959967816000000 }, { 61561987200000.0 }, { 61561987200.0, 0.0 } },

    //1951-02-05 00:00:00+00:00
    test_entry{ -596592000, { -1543319967816000000 }, { 61570627200000.0 }, { 61570627200.0, 0.0 } },

    //1951-05-16 00:00:00+00:00
    test_entry{ -587952000, { -1534679967816000000 }, { 61579267200000.0 }, { 61579267200.0, 0.0 } },

    //1951-08-24 00:00:00+00:00
    test_entry{ -579312000, { -1526039967816000000 }, { 61587907200000.0 }, { 61587907200.0, 0.0 } },

    //1951-12-02 00:00:00+00:00
    test_entry{ -570672000, { -1517399967816000000 }, { 61596547200000.0 }, { 61596547200.0, 0.0 } },

    //1952-03-11 00:00:00+00:00
    test_entry{ -562032000, { -1508759967816000000 }, { 61605187200000.0 }, { 61605187200.0, 0.0 } },

    //1952-06-19 00:00:00+00:00
    test_entry{ -553392000, { -1500119967816000000 }, { 61613827200000.0 }, { 61613827200.0, 0.0 } },

    //1952-09-27 00:00:00+00:00
    test_entry{ -544752000, { -1491479967816000000 }, { 61622467200000.0 }, { 61622467200.0, 0.0 } },

    //1953-01-05 00:00:00+00:00
    test_entry{ -536112000, { -1482839967816000000 }, { 61631107200000.0 }, { 61631107200.0, 0.0 } },

    //1953-04-15 00:00:00+00:00
    test_entry{ -527472000, { -1474199967816000000 }, { 61639747200000.0 }, { 61639747200.0, 0.0 } },

    //1953-07-24 00:00:00+00:00
    test_entry{ -518832000, { -1465559967816000000 }, { 61648387200000.0 }, { 61648387200.0, 0.0 } },

    //1953-11-01 00:00:00+00:00
    test_entry{ -510192000, { -1456919967816000000 }, { 61657027200000.0 }, { 61657027200.0, 0.0 } },

    //1954-02-09 00:00:00+00:00
    test_entry{ -501552000, { -1448279967816000000 }, { 61665667200000.0 }, { 61665667200.0, 0.0 } },

    //1954-05-20 00:00:00+00:00
    test_entry{ -492912000, { -1439639967816000000 }, { 61674307200000.0 }, { 61674307200.0, 0.0 } },

    //1954-08-28 00:00:00+00:00
    test_entry{ -484272000, { -1430999967816000000 }, { 61682947200000.0 }, { 61682947200.0, 0.0 } },

    //1954-12-06 00:00:00+00:00
    test_entry{ -475632000, { -1422359967816000000 }, { 61691587200000.0 }, { 61691587200.0, 0.0 } },

    //1955-03-16 00:00:00+00:00
    test_entry{ -466992000, { -1413719967816000000 }, { 61700227200000.0 }, { 61700227200.0, 0.0 } },

    //1955-06-24 00:00:00+00:00
    test_entry{ -458352000, { -1405079967816000000 }, { 61708867200000.0 }, { 61708867200.0, 0.0 } },

    //1955-10-02 00:00:00+00:00
    test_entry{ -449712000, { -1396439967816000000 }, { 61717507200000.0 }, { 61717507200.0, 0.0 } },

    //1956-01-10 00:00:00+00:00
    test_entry{ -441072000, { -1387799967816000000 }, { 61726147200000.0 }, { 61726147200.0, 0.0 } },

    //1956-04-19 00:00:00+00:00
    test_entry{ -432432000, { -1379159967816000000 }, { 61734787200000.0 }, { 61734787200.0, 0.0 } },

    //1956-07-28 00:00:00+00:00
    test_entry{ -423792000, { -1370519967816000000 }, { 61743427200000.0 }, { 61743427200.0, 0.0 } },

    //1956-11-05 00:00:00+00:00
    test_entry{ -415152000, { -1361879967816000000 }, { 61752067200000.0 }, { 61752067200.0, 0.0 } },

    //1957-02-13 00:00:00+00:00
    test_entry{ -406512000, { -1353239967816000000 }, { 61760707200000.0 }, { 61760707200.0, 0.0 } },

    //1957-05-24 00:00:00+00:00
    test_entry{ -397872000, { -1344599967816000000 }, { 61769347200000.0 }, { 61769347200.0, 0.0 } },

    //1957-09-01 00:00:00+00:00
    test_entry{ -389232000, { -1335959967816000000 }, { 61777987200000.0 }, { 61777987200.0, 0.0 } },

    //1957-12-10 00:00:00+00:00
    test_entry{ -380592000, { -1327319967816000000 }, { 61786627200000.0 }, { 61786627200.0, 0.0 } },

    //1958-03-20 00:00:00+00:00
    test_entry{ -371952000, { -1318679967816000000 }, { 61795267200000.0 }, { 61795267200.0, 0.0 } },

    //1958-06-28 00:00:00+00:00
    test_entry{ -363312000, { -1310039967816000000 }, { 61803907200000.0 }, { 61803907200.0, 0.0 } },

    //1958-10-06 00:00:00+00:00
    test_entry{ -354672000, { -1301399967816000000 }, { 61812547200000.0 }, { 61812547200.0, 0.0 } },

    //1959-01-14 00:00:00+00:00
    test_entry{ -346032000, { -1292759967816000000 }, { 61821187200000.0 }, { 61821187200.0, 0.0 } },

    //1959-04-24 00:00:00+00:00
    test_entry{ -337392000, { -1284119967816000000 }, { 61829827200000.0 }, { 61829827200.0, 0.0 } },

    //1959-08-02 00:00:00+00:00
    test_entry{ -328752000, { -1275479967816000000 }, { 61838467200000.0 }, { 61838467200.0, 0.0 } },

    //1959-11-10 00:00:00+00:00
    test_entry{ -320112000, { -1266839967816000000 }, { 61847107200000.0 }, { 61847107200.0, 0.0 } },

    //1960-02-18 00:00:00+00:00
    test_entry{ -311472000, { -1258199966809662000 }, { 61855747200000.0 }, { 61855747200.0, 0.0 } },

    //1960-05-28 00:00:00+00:00
    test_entry{ -302832000, { -1249559966680062000 }, { 61864387200000.0 }, { 61864387200.0, 0.0 } },

    //1960-09-05 00:00:00+00:00
    test_entry{ -294192000, { -1240919966550462000 }, { 61873027200000.0 }, { 61873027200.0, 0.0 } },

    //1960-12-14 00:00:00+00:00
    test_entry{ -285552000, { -1232279966420862000 }, { 61881667200000.0 }, { 61881667200.0, 0.0 } },

    //1961-03-24 00:00:00+00:00
    test_entry{ -276912000, { -1223639966286262001 }, { 61890307200000.0 }, { 61890307200.0, 0.0 } },

    //1961-07-02 00:00:00+00:00
    test_entry{ -268272000, { -1214999966156662000 }, { 61898947200000.0 }, { 61898947200.0, 0.0 } },

    //1961-10-10 00:00:00+00:00
    test_entry{ -259632000, { -1206359966077062000 }, { 61907587200000.0 }, { 61907587200.0, 0.0 } },

    //1962-01-18 00:00:00+00:00
    test_entry{ -250992000, { -1197719965950486000 }, { 61916227200000.0 }, { 61916227200.0, 0.0 } },

    //1962-04-28 00:00:00+00:00
    test_entry{ -242352000, { -1189079965838166000 }, { 61924867200000.0 }, { 61924867200.0, 0.0 } },

    //1962-08-06 00:00:00+00:00
    test_entry{ -233712000, { -1180439965725846000 }, { 61933507200000.0 }, { 61933507200.0, 0.0 } },

    //1962-11-14 00:00:00+00:00
    test_entry{ -225072000, { -1171799965613526000 }, { 61942147200000.0 }, { 61942147200.0, 0.0 } },

    //1963-02-22 00:00:00+00:00
    test_entry{ -216432000, { -1163159965501206000 }, { 61950787200000.0 }, { 61950787200.0, 0.0 } },

    //1963-06-02 00:00:00+00:00
    test_entry{ -207792000, { -1154519965388886000 }, { 61959427200000.0 }, { 61959427200.0, 0.0 } },

    //1963-09-10 00:00:00+00:00
    test_entry{ -199152000, { -1145879965276566000 }, { 61968067200000.0 }, { 61968067200.0, 0.0 } },

    //1963-12-19 00:00:00+00:00
    test_entry{ -190512000, { -1137239965064246000 }, { 61976707200000.0 }, { 61976707200.0, 0.0 } },

    //1964-03-28 00:00:00+00:00
    test_entry{ -181872000, { -1128599964936806000 }, { 61985347200000.0 }, { 61985347200.0, 0.0 } },

    //1964-07-06 00:00:00+00:00
    test_entry{ -173232000, { -1119959964707206001 }, { 61993987200000.0 }, { 61993987200.0, 0.0 } },

    //1964-10-14 00:00:00+00:00
    test_entry{ -164592000, { -1111319964477606000 }, { 62002627200000.0 }, { 62002627200.0, 0.0 } },

    //1965-01-22 00:00:00+00:00
    test_entry{ -155952000, { -1102679964248006000 }, { 62011267200000.0 }, { 62011267200.0, 0.0 } },

    //1965-05-02 00:00:00+00:00
    test_entry{ -147312000, { -1094039964018406000 }, { 62019907200000.0 }, { 62019907200.0, 0.0 } },

    //1965-08-10 00:00:00+00:00
    test_entry{ -138672000, { -1085399963788806001 }, { 62028547200000.0 }, { 62028547200.0, 0.0 } },

    //1965-11-18 00:00:00+00:00
    test_entry{ -130032000, { -1076759963559206000 }, { 62037187200000.0 }, { 62037187200.0, 0.0 } },

    //1966-02-26 00:00:00+00:00
    test_entry{ -121392000, { -1068119963356382000 }, { 62045827200000.0 }, { 62045827200.0, 0.0 } },

    //1966-06-06 00:00:00+00:00
    test_entry{ -112752000, { -1059479963097182000 }, { 62054467200000.0 }, { 62054467200.0, 0.0 } },

    //1966-09-14 00:00:00+00:00
    test_entry{ -104112000, { -1050839962837982000 }, { 62063107200000.0 }, { 62063107200.0, 0.0 } },

    //1966-12-23 00:00:00+00:00
    test_entry{ -95472000, { -1042199962578782000 }, { 62071747200000.0 }, { 62071747200.0, 0.0 } },

    //1967-04-02 00:00:00+00:00
    test_entry{ -86832000, { -1033559962319582000 }, { 62080387200000.0 }, { 62080387200.0, 0.0 } },

    //1967-07-11 00:00:00+00:00
    test_entry{ -78192000, { -1024919962060382000 }, { 62089027200000.0 }, { 62089027200.0, 0.0 } },

    //1967-10-19 00:00:00+00:00
    test_entry{ -69552000, { -1016279961801182000 }, { 62097667200000.0 }, { 62097667200.0, 0.0 } },

    //1968-01-27 00:00:00+00:00
    test_entry{ -60912000, { -1007639961541982000 }, { 62106307200000.0 }, { 62106307200.0, 0.0 } },

    //1968-05-06 00:00:00+00:00
    test_entry{ -52272000, { -998999961382782000 }, { 62114947200000.0 }, { 62114947200.0, 0.0 } },

    //1968-08-14 00:00:00+00:00
    test_entry{ -43632000, { -990359961123582000 }, { 62123587200000.0 }, { 62123587200.0, 0.0 } },

    //1968-11-22 00:00:00+00:00
    test_entry{ -34992000, { -981719960864382000 }, { 62132227200000.0 }, { 62132227200.0, 0.0 } },

    //1969-03-02 00:00:00+00:00
    test_entry{ -26352000, { -973079960605182000 }, { 62140867200000.0 }, { 62140867200.0, 0.0 } },

    //1969-06-10 00:00:00+00:00
    test_entry{ -17712000, { -964439960345982000 }, { 62149507200000.0 }, { 62149507200.0, 0.0 } },

    //1969-09-18 00:00:00+00:00
    test_entry{ -9072000, { -955799960086782001 }, { 62158147200000.0 }, { 62158147200.0, 0.0 } },

    //1969-12-27 00:00:00+00:00
    test_entry{ -432000, { -947159959827582000 }, { 62166787200000.0 }, { 62166787200.0, 0.0 } },

    //1970-04-06 00:00:00+00:00
    test_entry{ 8208000, { -938519959568382001 }, { 62175427200000.0 }, { 62175427200.0, 0.0 } },

    //1970-07-15 00:00:00+00:00
    test_entry{ 16848000, { -929879959309182001 }, { 62184067200000.0 }, { 62184067200.0, 0.0 } },

    //1970-10-23 00:00:00+00:00
    test_entry{ 25488000, { -921239959049982001 }, { 62192707200000.0 }, { 62192707200.0, 0.0 } },

    //1971-01-31 00:00:00+00:00
    test_entry{ 34128000, { -912599958790782001 }, { 62201347200000.0 }, { 62201347200.0, 0.0 } },

    //1971-05-11 00:00:00+00:00
    test_entry{ 42768000, { -903959958531582000 }, { 62209987200000.0 }, { 62209987200.0, 0.0 } },

    //1971-08-19 00:00:00+00:00
    test_entry{ 51408000, { -895319958272382000 }, { 62218627200000.0 }, { 62218627200.0, 0.0 } },

    //1971-11-27 00:00:00+00:00
    test_entry{ 60048000, { -886679958013182000 }, { 62227267200000.0 }, { 62227267200.0, 0.0 } },

    //1972-03-06 00:00:00+00:00
    test_entry{ 68688000, { -878039957816000000 }, { 62235907200000.0 }, { 62235907200.0, 0.0 } },

    //1972-06-14 00:00:00+00:00
    test_entry{ 77328000, { -869399957816000000 }, { 62244547200000.0 }, { 62244547200.0, 0.0 } },

    //1972-09-22 00:00:00+00:00
    test_entry{ 85968000, { -860759956816000000 }, { 62253187200000.0 }, { 62253187200.0, 0.0 } },

    //1972-12-31 00:00:00+00:00
    test_entry{ 94608000, { -852119956816000000 }, { 62261827200000.0 }, { 62261827200.0, 0.0 } },

    //1973-04-10 00:00:00+00:00
    test_entry{ 103248000, { -843479955816000000 }, { 62270467200000.0 }, { 62270467200.0, 0.0 } },

    //1973-07-19 00:00:00+00:00
    test_entry{ 111888000, { -834839955816000000 }, { 62279107200000.0 }, { 62279107200.0, 0.0 } },

    //1973-10-27 00:00:00+00:00
    test_entry{ 120528000, { -826199955816000000 }, { 62287747200000.0 }, { 62287747200.0, 0.0 } },

    //1974-02-04 00:00:00+00:00
    test_entry{ 129168000, { -817559954816000000 }, { 62296387200000.0 }, { 62296387200.0, 0.0 } },

    //1974-05-15 00:00:00+00:00
    test_entry{ 137808000, { -808919954816000000 }, { 62305027200000.0 }, { 62305027200.0, 0.0 } },

    //1974-08-23 00:00:00+00:00
    test_entry{ 146448000, { -800279954816000000 }, { 62313667200000.0 }, { 62313667200.0, 0.0 } },

    //1974-12-01 00:00:00+00:00
    test_entry{ 155088000, { -791639954816000000 }, { 62322307200000.0 }, { 62322307200.0, 0.0 } },

    //1975-03-11 00:00:00+00:00
    test_entry{ 163728000, { -782999953816000000 }, { 62330947200000.0 }, { 62330947200.0, 0.0 } },

    //1975-06-19 00:00:00+00:00
    test_entry{ 172368000, { -774359953816000000 }, { 62339587200000.0 }, { 62339587200.0, 0.0 } },

    //1975-09-27 00:00:00+00:00
    test_entry{ 181008000, { -765719953816000000 }, { 62348227200000.0 }, { 62348227200.0, 0.0 } },

    //1976-01-05 00:00:00+00:00
    test_entry{ 189648000, { -757079952816000000 }, { 62356867200000.0 }, { 62356867200.0, 0.0 } },

    //1976-04-14 00:00:00+00:00
    test_entry{ 198288000, { -748439952816000000 }, { 62365507200000.0 }, { 62365507200.0, 0.0 } },

    //1976-07-23 00:00:00+00:00
    test_entry{ 206928000, { -739799952816000000 }, { 62374147200000.0 }, { 62374147200.0, 0.0 } },

    //1976-10-31 00:00:00+00:00
    test_entry{ 215568000, { -731159952816000000 }, { 62382787200000.0 }, { 62382787200.0, 0.0 } },

    //1977-02-08 00:00:00+00:00
    test_entry{ 224208000, { -722519951816000000 }, { 62391427200000.0 }, { 62391427200.0, 0.0 } },

    //1977-05-19 00:00:00+00:00
    test_entry{ 232848000, { -713879951816000000 }, { 62400067200000.0 }, { 62400067200.0, 0.0 } },

    //1977-08-27 00:00:00+00:00
    test_entry{ 241488000, { -705239951816000000 }, { 62408707200000.0 }, { 62408707200.0, 0.0 } },

    //1977-12-05 00:00:00+00:00
    test_entry{ 250128000, { -696599951816000000 }, { 62417347200000.0 }, { 62417347200.0, 0.0 } },

    //1978-03-15 00:00:00+00:00
    test_entry{ 258768000, { -687959950816000000 }, { 62425987200000.0 }, { 62425987200.0, 0.0 } },

    //1978-06-23 00:00:00+00:00
    test_entry{ 267408000, { -679319950816000000 }, { 62434627200000.0 }, { 62434627200.0, 0.0 } },

    //1978-10-01 00:00:00+00:00
    test_entry{ 276048000, { -670679950816000000 }, { 62443267200000.0 }, { 62443267200.0, 0.0 } },

    //1979-01-09 00:00:00+00:00
    test_entry{ 284688000, { -662039949816000000 }, { 62451907200000.0 }, { 62451907200.0, 0.0 } },

    //1979-04-19 00:00:00+00:00
    test_entry{ 293328000, { -653399949816000000 }, { 62460547200000.0 }, { 62460547200.0, 0.0 } },

    //1979-07-28 00:00:00+00:00
    test_entry{ 301968000, { -644759949816000000 }, { 62469187200000.0 }, { 62469187200.0, 0.0 } },

    //1979-11-05 00:00:00+00:00
    test_entry{ 310608000, { -636119949816000000 }, { 62477827200000.0 }, { 62477827200.0, 0.0 } },

    //1980-02-13 00:00:00+00:00
    test_entry{ 319248000, { -627479948816000000 }, { 62486467200000.0 }, { 62486467200.0, 0.0 } },

    //1980-05-23 00:00:00+00:00
    test_entry{ 327888000, { -618839948816000000 }, { 62495107200000.0 }, { 62495107200.0, 0.0 } },

    //1980-08-31 00:00:00+00:00
    test_entry{ 336528000, { -610199948816000000 }, { 62503747200000.0 }, { 62503747200.0, 0.0 } },

    //1980-12-09 00:00:00+00:00
    test_entry{ 345168000, { -601559948816000000 }, { 62512387200000.0 }, { 62512387200.0, 0.0 } },

    //1981-03-19 00:00:00+00:00
    test_entry{ 353808000, { -592919948816000000 }, { 62521027200000.0 }, { 62521027200.0, 0.0 } },

    //1981-06-27 00:00:00+00:00
    test_entry{ 362448000, { -584279948816000000 }, { 62529667200000.0 }, { 62529667200.0, 0.0 } },

    //1981-10-05 00:00:00+00:00
    test_entry{ 371088000, { -575639947816000000 }, { 62538307200000.0 }, { 62538307200.0, 0.0 } },

    //1982-01-13 00:00:00+00:00
    test_entry{ 379728000, { -566999947816000000 }, { 62546947200000.0 }, { 62546947200.0, 0.0 } },

    //1982-04-23 00:00:00+00:00
    test_entry{ 388368000, { -558359947816000000 }, { 62555587200000.0 }, { 62555587200.0, 0.0 } },

    //1982-08-01 00:00:00+00:00
    test_entry{ 397008000, { -549719946816000000 }, { 62564227200000.0 }, { 62564227200.0, 0.0 } },

    //1982-11-09 00:00:00+00:00
    test_entry{ 405648000, { -541079946816000000 }, { 62572867200000.0 }, { 62572867200.0, 0.0 } },

    //1983-02-17 00:00:00+00:00
    test_entry{ 414288000, { -532439946816000000 }, { 62581507200000.0 }, { 62581507200.0, 0.0 } },

    //1983-05-28 00:00:00+00:00
    test_entry{ 422928000, { -523799946816000000 }, { 62590147200000.0 }, { 62590147200.0, 0.0 } },

    //1983-09-05 00:00:00+00:00
    test_entry{ 431568000, { -515159945816000000 }, { 62598787200000.0 }, { 62598787200.0, 0.0 } },

    //1983-12-14 00:00:00+00:00
    test_entry{ 440208000, { -506519945816000000 }, { 62607427200000.0 }, { 62607427200.0, 0.0 } },

    //1984-03-23 00:00:00+00:00
    test_entry{ 448848000, { -497879945816000000 }, { 62616067200000.0 }, { 62616067200.0, 0.0 } },

    //1984-07-01 00:00:00+00:00
    test_entry{ 457488000, { -489239945816000000 }, { 62624707200000.0 }, { 62624707200.0, 0.0 } },

    //1984-10-09 00:00:00+00:00
    test_entry{ 466128000, { -480599945816000000 }, { 62633347200000.0 }, { 62633347200.0, 0.0 } },

    //1985-01-17 00:00:00+00:00
    test_entry{ 474768000, { -471959945816000000 }, { 62641987200000.0 }, { 62641987200.0, 0.0 } },

    //1985-04-27 00:00:00+00:00
    test_entry{ 483408000, { -463319945816000000 }, { 62650627200000.0 }, { 62650627200.0, 0.0 } },

    //1985-08-05 00:00:00+00:00
    test_entry{ 492048000, { -454679944816000000 }, { 62659267200000.0 }, { 62659267200.0, 0.0 } },

    //1985-11-13 00:00:00+00:00
    test_entry{ 500688000, { -446039944816000000 }, { 62667907200000.0 }, { 62667907200.0, 0.0 } },

    //1986-02-21 00:00:00+00:00
    test_entry{ 509328000, { -437399944816000000 }, { 62676547200000.0 }, { 62676547200.0, 0.0 } },

    //1986-06-01 00:00:00+00:00
    test_entry{ 517968000, { -428759944816000000 }, { 62685187200000.0 }, { 62685187200.0, 0.0 } },

    //1986-09-09 00:00:00+00:00
    test_entry{ 526608000, { -420119944816000000 }, { 62693827200000.0 }, { 62693827200.0, 0.0 } },

    //1986-12-18 00:00:00+00:00
    test_entry{ 535248000, { -411479944816000000 }, { 62702467200000.0 }, { 62702467200.0, 0.0 } },

    //1987-03-28 00:00:00+00:00
    test_entry{ 543888000, { -402839944816000000 }, { 62711107200000.0 }, { 62711107200.0, 0.0 } },

    //1987-07-06 00:00:00+00:00
    test_entry{ 552528000, { -394199944816000000 }, { 62719747200000.0 }, { 62719747200.0, 0.0 } },

    //1987-10-14 00:00:00+00:00
    test_entry{ 561168000, { -385559944816000000 }, { 62728387200000.0 }, { 62728387200.0, 0.0 } },

    //1988-01-22 00:00:00+00:00
    test_entry{ 569808000, { -376919943816000000 }, { 62737027200000.0 }, { 62737027200.0, 0.0 } },

    //1988-05-01 00:00:00+00:00
    test_entry{ 578448000, { -368279943816000000 }, { 62745667200000.0 }, { 62745667200.0, 0.0 } },

    //1988-08-09 00:00:00+00:00
    test_entry{ 587088000, { -359639943816000000 }, { 62754307200000.0 }, { 62754307200.0, 0.0 } },

    //1988-11-17 00:00:00+00:00
    test_entry{ 595728000, { -350999943816000000 }, { 62762947200000.0 }, { 62762947200.0, 0.0 } },

    //1989-02-25 00:00:00+00:00
    test_entry{ 604368000, { -342359943816000000 }, { 62771587200000.0 }, { 62771587200.0, 0.0 } },

    //1989-06-05 00:00:00+00:00
    test_entry{ 613008000, { -333719943816000000 }, { 62780227200000.0 }, { 62780227200.0, 0.0 } },

    //1989-09-13 00:00:00+00:00
    test_entry{ 621648000, { -325079943816000000 }, { 62788867200000.0 }, { 62788867200.0, 0.0 } },

    //1989-12-22 00:00:00+00:00
    test_entry{ 630288000, { -316439943816000000 }, { 62797507200000.0 }, { 62797507200.0, 0.0 } },

    //1990-04-01 00:00:00+00:00
    test_entry{ 638928000, { -307799942816000000 }, { 62806147200000.0 }, { 62806147200.0, 0.0 } },

    //1990-07-10 00:00:00+00:00
    test_entry{ 647568000, { -299159942816000000 }, { 62814787200000.0 }, { 62814787200.0, 0.0 } },

    //1990-10-18 00:00:00+00:00
    test_entry{ 656208000, { -290519942816000000 }, { 62823427200000.0 }, { 62823427200.0, 0.0 } },

    //1991-01-26 00:00:00+00:00
    test_entry{ 664848000, { -281879941816000000 }, { 62832067200000.0 }, { 62832067200.0, 0.0 } },

    //1991-05-06 00:00:00+00:00
    test_entry{ 673488000, { -273239941816000000 }, { 62840707200000.0 }, { 62840707200.0, 0.0 } },

    //1991-08-14 00:00:00+00:00
    test_entry{ 682128000, { -264599941816000000 }, { 62849347200000.0 }, { 62849347200.0, 0.0 } },

    //1991-11-22 00:00:00+00:00
    test_entry{ 690768000, { -255959941816000000 }, { 62857987200000.0 }, { 62857987200.0, 0.0 } },

    //1992-03-01 00:00:00+00:00
    test_entry{ 699408000, { -247319941816000000 }, { 62866627200000.0 }, { 62866627200.0, 0.0 } },

    //1992-06-09 00:00:00+00:00
    test_entry{ 708048000, { -238679941816000000 }, { 62875267200000.0 }, { 62875267200.0, 0.0 } },

    //1992-09-17 00:00:00+00:00
    test_entry{ 716688000, { -230039940816000000 }, { 62883907200000.0 }, { 62883907200.0, 0.0 } },

    //1992-12-26 00:00:00+00:00
    test_entry{ 725328000, { -221399940816000000 }, { 62892547200000.0 }, { 62892547200.0, 0.0 } },

    //1993-04-05 00:00:00+00:00
    test_entry{ 733968000, { -212759940816000000 }, { 62901187200000.0 }, { 62901187200.0, 0.0 } },

    //1993-07-14 00:00:00+00:00
    test_entry{ 742608000, { -204119939816000000 }, { 62909827200000.0 }, { 62909827200.0, 0.0 } },

    //1993-10-22 00:00:00+00:00
    test_entry{ 751248000, { -195479939816000000 }, { 62918467200000.0 }, { 62918467200.0, 0.0 } },

    //1994-01-30 00:00:00+00:00
    test_entry{ 759888000, { -186839939816000000 }, { 62927107200000.0 }, { 62927107200.0, 0.0 } },

    //1994-05-10 00:00:00+00:00
    test_entry{ 768528000, { -178199939816000000 }, { 62935747200000.0 }, { 62935747200.0, 0.0 } },

    //1994-08-18 00:00:00+00:00
    test_entry{ 777168000, { -169559938816000000 }, { 62944387200000.0 }, { 62944387200.0, 0.0 } },

    //1994-11-26 00:00:00+00:00
    test_entry{ 785808000, { -160919938816000000 }, { 62953027200000.0 }, { 62953027200.0, 0.0 } },

    //1995-03-06 00:00:00+00:00
    test_entry{ 794448000, { -152279938816000000 }, { 62961667200000.0 }, { 62961667200.0, 0.0 } },

    //1995-06-14 00:00:00+00:00
    test_entry{ 803088000, { -143639938816000000 }, { 62970307200000.0 }, { 62970307200.0, 0.0 } },

    //1995-09-22 00:00:00+00:00
    test_entry{ 811728000, { -134999938816000000 }, { 62978947200000.0 }, { 62978947200.0, 0.0 } },

    //1995-12-31 00:00:00+00:00
    test_entry{ 820368000, { -126359938816000000 }, { 62987587200000.0 }, { 62987587200.0, 0.0 } },

    //1996-04-09 00:00:00+00:00
    test_entry{ 829008000, { -117719937816000000 }, { 62996227200000.0 }, { 62996227200.0, 0.0 } },

    //1996-07-18 00:00:00+00:00
    test_entry{ 837648000, { -109079937816000000 }, { 63004867200000.0 }, { 63004867200.0, 0.0 } },

    //1996-10-26 00:00:00+00:00
    test_entry{ 846288000, { -100439937816000000 }, { 63013507200000.0 }, { 63013507200.0, 0.0 } },

    //1997-02-03 00:00:00+00:00
    test_entry{ 854928000, { -91799937816000000 }, { 63022147200000.0 }, { 63022147200.0, 0.0 } },

    //1997-05-14 00:00:00+00:00
    test_entry{ 863568000, { -83159937816000000 }, { 63030787200000.0 }, { 63030787200.0, 0.0 } },

    //1997-08-22 00:00:00+00:00
    test_entry{ 872208000, { -74519936816000000 }, { 63039427200000.0 }, { 63039427200.0, 0.0 } },

    //1997-11-30 00:00:00+00:00
    test_entry{ 880848000, { -65879936816000000 }, { 63048067200000.0 }, { 63048067200.0, 0.0 } },

    //1998-03-10 00:00:00+00:00
    test_entry{ 889488000, { -57239936816000000 }, { 63056707200000.0 }, { 63056707200.0, 0.0 } },

    //1998-06-18 00:00:00+00:00
    test_entry{ 898128000, { -48599936816000000 }, { 63065347200000.0 }, { 63065347200.0, 0.0 } },

    //1998-09-26 00:00:00+00:00
    test_entry{ 906768000, { -39959936816000000 }, { 63073987200000.0 }, { 63073987200.0, 0.0 } },

    //1999-01-04 00:00:00+00:00
    test_entry{ 915408000, { -31319935816000000 }, { 63082627200000.0 }, { 63082627200.0, 0.0 } },

    //1999-04-14 00:00:00+00:00
    test_entry{ 924048000, { -22679935816000000 }, { 63091267200000.0 }, { 63091267200.0, 0.0 } },

    //1999-07-23 00:00:00+00:00
    test_entry{ 932688000, { -14039935816000000 }, { 63099907200000.0 }, { 63099907200.0, 0.0 } },

    //1999-10-31 00:00:00+00:00
    test_entry{ 941328000, { -5399935816000000 }, { 63108547200000.0 }, { 63108547200.0, 0.0 } },

    //2000-02-08 00:00:00+00:00
    test_entry{ 949968000, { 3240064184000000 }, { 63117187200000.0 }, { 63117187200.0, 0.0 } },

    //2000-05-18 00:00:00+00:00
    test_entry{ 958608000, { 11880064184000000 }, { 63125827200000.0 }, { 63125827200.0, 0.0 } },

    //2000-08-26 00:00:00+00:00
    test_entry{ 967248000, { 20520064184000000 }, { 63134467200000.0 }, { 63134467200.0, 0.0 } },

    //2000-12-04 00:00:00+00:00
    test_entry{ 975888000, { 29160064184000000 }, { 63143107200000.0 }, { 63143107200.0, 0.0 } },

    //2001-03-14 00:00:00+00:00
    test_entry{ 984528000, { 37800064184000000 }, { 63151747200000.0 }, { 63151747200.0, 0.0 } },

    //2001-06-22 00:00:00+00:00
    test_entry{ 993168000, { 46440064184000000 }, { 63160387200000.0 }, { 63160387200.0, 0.0 } },

    //2001-09-30 00:00:00+00:00
    test_entry{ 1001808000, { 55080064184000000 }, { 63169027200000.0 }, { 63169027200.0, 0.0 } },

    //2002-01-08 00:00:00+00:00
    test_entry{ 1010448000, { 63720064184000000 }, { 63177667200000.0 }, { 63177667200.0, 0.0 } },

    //2002-04-18 00:00:00+00:00
    test_entry{ 1019088000, { 72360064184000000 }, { 63186307200000.0 }, { 63186307200.0, 0.0 } },

    //2002-07-27 00:00:00+00:00
    test_entry{ 1027728000, { 81000064184000000 }, { 63194947200000.0 }, { 63194947200.0, 0.0 } },

    //2002-11-04 00:00:00+00:00
    test_entry{ 1036368000, { 89640064184000000 }, { 63203587200000.0 }, { 63203587200.0, 0.0 } },

    //2003-02-12 00:00:00+00:00
    test_entry{ 1045008000, { 98280064184000000 }, { 63212227200000.0 }, { 63212227200.0, 0.0 } },

    //2003-05-23 00:00:00+00:00
    test_entry{ 1053648000, { 106920064184000000 }, { 63220867200000.0 }, { 63220867200.0, 0.0 } },

    //2003-08-31 00:00:00+00:00
    test_entry{ 1062288000, { 115560064184000000 }, { 63229507200000.0 }, { 63229507200.0, 0.0 } },

    //2003-12-09 00:00:00+00:00
    test_entry{ 1070928000, { 124200064184000000 }, { 63238147200000.0 }, { 63238147200.0, 0.0 } },

    //2004-03-18 00:00:00+00:00
    test_entry{ 1079568000, { 132840064184000000 }, { 63246787200000.0 }, { 63246787200.0, 0.0 } },

    //2004-06-26 00:00:00+00:00
    test_entry{ 1088208000, { 141480064184000000 }, { 63255427200000.0 }, { 63255427200.0, 0.0 } },

    //2004-10-04 00:00:00+00:00
    test_entry{ 1096848000, { 150120064184000000 }, { 63264067200000.0 }, { 63264067200.0, 0.0 } },

    //2005-01-12 00:00:00+00:00
    test_entry{ 1105488000, { 158760064184000000 }, { 63272707200000.0 }, { 63272707200.0, 0.0 } },

    //2005-04-22 00:00:00+00:00
    test_entry{ 1114128000, { 167400064184000000 }, { 63281347200000.0 }, { 63281347200.0, 0.0 } },

    //2005-07-31 00:00:00+00:00
    test_entry{ 1122768000, { 176040064184000000 }, { 63289987200000.0 }, { 63289987200.0, 0.0 } },

    //2005-11-08 00:00:00+00:00
    test_entry{ 1131408000, { 184680064184000000 }, { 63298627200000.0 }, { 63298627200.0, 0.0 } },

    //2006-02-16 00:00:00+00:00
    test_entry{ 1140048000, { 193320065184000000 }, { 63307267200000.0 }, { 63307267200.0, 0.0 } },

    //2006-05-27 00:00:00+00:00
    test_entry{ 1148688000, { 201960065184000000 }, { 63315907200000.0 }, { 63315907200.0, 0.0 } },

    //2006-09-04 00:00:00+00:00
    test_entry{ 1157328000, { 210600065184000000 }, { 63324547200000.0 }, { 63324547200.0, 0.0 } },

    //2006-12-13 00:00:00+00:00
    test_entry{ 1165968000, { 219240065184000000 }, { 63333187200000.0 }, { 63333187200.0, 0.0 } },

    //2007-03-23 00:00:00+00:00
    test_entry{ 1174608000, { 227880065184000000 }, { 63341827200000.0 }, { 63341827200.0, 0.0 } },

    //2007-07-01 00:00:00+00:00
    test_entry{ 1183248000, { 236520065184000000 }, { 63350467200000.0 }, { 63350467200.0, 0.0 } },

    //2007-10-09 00:00:00+00:00
    test_entry{ 1191888000, { 245160065184000000 }, { 63359107200000.0 }, { 63359107200.0, 0.0 } },

    //2008-01-17 00:00:00+00:00
    test_entry{ 1200528000, { 253800065184000000 }, { 63367747200000.0 }, { 63367747200.0, 0.0 } },

    //2008-04-26 00:00:00+00:00
    test_entry{ 1209168000, { 262440065184000000 }, { 63376387200000.0 }, { 63376387200.0, 0.0 } },

    //2008-08-04 00:00:00+00:00
    test_entry{ 1217808000, { 271080065184000000 }, { 63385027200000.0 }, { 63385027200.0, 0.0 } },

    //2008-11-12 00:00:00+00:00
    test_entry{ 1226448000, { 279720065184000000 }, { 63393667200000.0 }, { 63393667200.0, 0.0 } },

    //2009-02-20 00:00:00+00:00
    test_entry{ 1235088000, { 288360066184000000 }, { 63402307200000.0 }, { 63402307200.0, 0.0 } },

    //2009-05-31 00:00:00+00:00
    test_entry{ 1243728000, { 297000066184000000 }, { 63410947200000.0 }, { 63410947200.0, 0.0 } },

    //2009-09-08 00:00:00+00:00
    test_entry{ 1252368000, { 305640066184000000 }, { 63419587200000.0 }, { 63419587200.0, 0.0 } },

    //2009-12-17 00:00:00+00:00
    test_entry{ 1261008000, { 314280066184000000 }, { 63428227200000.0 }, { 63428227200.0, 0.0 } },

    //2010-03-27 00:00:00+00:00
    test_entry{ 1269648000, { 322920066184000000 }, { 63436867200000.0 }, { 63436867200.0, 0.0 } },

    //2010-07-05 00:00:00+00:00
    test_entry{ 1278288000, { 331560066184000000 }, { 63445507200000.0 }, { 63445507200.0, 0.0 } },

    //2010-10-13 00:00:00+00:00
    test_entry{ 1286928000, { 340200066184000000 }, { 63454147200000.0 }, { 63454147200.0, 0.0 } },

    //2011-01-21 00:00:00+00:00
    test_entry{ 1295568000, { 348840066184000000 }, { 63462787200000.0 }, { 63462787200.0, 0.0 } },

    //2011-05-01 00:00:00+00:00
    test_entry{ 1304208000, { 357480066184000000 }, { 63471427200000.0 }, { 63471427200.0, 0.0 } },

    //2011-08-09 00:00:00+00:00
    test_entry{ 1312848000, { 366120066184000000 }, { 63480067200000.0 }, { 63480067200.0, 0.0 } },

    //2011-11-17 00:00:00+00:00
    test_entry{ 1321488000, { 374760066184000000 }, { 63488707200000.0 }, { 63488707200.0, 0.0 } },

    //2012-02-25 00:00:00+00:00
    test_entry{ 1330128000, { 383400066184000000 }, { 63497347200000.0 }, { 63497347200.0, 0.0 } },

    //2012-06-04 00:00:00+00:00
    test_entry{ 1338768000, { 392040066184000000 }, { 63505987200000.0 }, { 63505987200.0, 0.0 } },

    //2012-09-12 00:00:00+00:00
    test_entry{ 1347408000, { 400680067184000000 }, { 63514627200000.0 }, { 63514627200.0, 0.0 } },

    //2012-12-21 00:00:00+00:00
    test_entry{ 1356048000, { 409320067184000000 }, { 63523267200000.0 }, { 63523267200.0, 0.0 } },

    //2013-03-31 00:00:00+00:00
    test_entry{ 1364688000, { 417960067184000000 }, { 63531907200000.0 }, { 63531907200.0, 0.0 } },

    //2013-07-09 00:00:00+00:00
    test_entry{ 1373328000, { 426600067184000000 }, { 63540547200000.0 }, { 63540547200.0, 0.0 } },

    //2013-10-17 00:00:00+00:00
    test_entry{ 1381968000, { 435240067184000000 }, { 63549187200000.0 }, { 63549187200.0, 0.0 } },

    //2014-01-25 00:00:00+00:00
    test_entry{ 1390608000, { 443880067184000000 }, { 63557827200000.0 }, { 63557827200.0, 0.0 } },

    //2014-05-05 00:00:00+00:00
    test_entry{ 1399248000, { 452520067184000000 }, { 63566467200000.0 }, { 63566467200.0, 0.0 } },

    //2014-08-13 00:00:00+00:00
    test_entry{ 1407888000, { 461160067184000000 }, { 63575107200000.0 }, { 63575107200.0, 0.0 } },

    //2014-11-21 00:00:00+00:00
    test_entry{ 1416528000, { 469800067184000000 }, { 63583747200000.0 }, { 63583747200.0, 0.0 } },

    //2015-03-01 00:00:00+00:00
    test_entry{ 1425168000, { 478440067184000000 }, { 63592387200000.0 }, { 63592387200.0, 0.0 } },

    //2015-06-09 00:00:00+00:00
    test_entry{ 1433808000, { 487080067184000000 }, { 63601027200000.0 }, { 63601027200.0, 0.0 } },

    //2015-09-17 00:00:00+00:00
    test_entry{ 1442448000, { 495720068184000000 }, { 63609667200000.0 }, { 63609667200.0, 0.0 } },

    //2015-12-26 00:00:00+00:00
    test_entry{ 1451088000, { 504360068184000000 }, { 63618307200000.0 }, { 63618307200.0, 0.0 } },

    //2016-04-04 00:00:00+00:00
    test_entry{ 1459728000, { 513000068184000000 }, { 63626947200000.0 }, { 63626947200.0, 0.0 } },

    //2016-07-13 00:00:00+00:00
    test_entry{ 1468368000, { 521640068184000000 }, { 63635587200000.0 }, { 63635587200.0, 0.0 } },

    //2016-10-21 00:00:00+00:00
    test_entry{ 1477008000, { 530280068184000000 }, { 63644227200000.0 }, { 63644227200.0, 0.0 } },

    //2017-01-29 00:00:00+00:00
    test_entry{ 1485648000, { 538920069184000000 }, { 63652867200000.0 }, { 63652867200.0, 0.0 } },

    //2017-05-09 00:00:00+00:00
    test_entry{ 1494288000, { 547560069184000000 }, { 63661507200000.0 }, { 63661507200.0, 0.0 } },

    //2017-08-17 00:00:00+00:00
    test_entry{ 1502928000, { 556200069184000000 }, { 63670147200000.0 }, { 63670147200.0, 0.0 } },

    //2017-11-25 00:00:00+00:00
    test_entry{ 1511568000, { 564840069184000000 }, { 63678787200000.0 }, { 63678787200.0, 0.0 } },

    //2018-03-05 00:00:00+00:00
    test_entry{ 1520208000, { 573480069184000000 }, { 63687427200000.0 }, { 63687427200.0, 0.0 } },

    //2018-06-13 00:00:00+00:00
    test_entry{ 1528848000, { 582120069184000000 }, { 63696067200000.0 }, { 63696067200.0, 0.0 } },

    //2018-09-21 00:00:00+00:00
    test_entry{ 1537488000, { 590760069184000000 }, { 63704707200000.0 }, { 63704707200.0, 0.0 } },

    //2018-12-30 00:00:00+00:00
    test_entry{ 1546128000, { 599400069184000000 }, { 63713347200000.0 }, { 63713347200.0, 0.0 } },

    //2019-04-09 00:00:00+00:00
    test_entry{ 1554768000, { 608040069184000000 }, { 63721987200000.0 }, { 63721987200.0, 0.0 } },

    //2019-07-18 00:00:00+00:00
    test_entry{ 1563408000, { 616680069184000000 }, { 63730627200000.0 }, { 63730627200.0, 0.0 } },

    //2019-10-26 00:00:00+00:00
    test_entry{ 1572048000, { 625320069184000000 }, { 63739267200000.0 }, { 63739267200.0, 0.0 } },

    //2020-02-03 00:00:00+00:00
    test_entry{ 1580688000, { 633960069184000000 }, { 63747907200000.0 }, { 63747907200.0, 0.0 } },

    //2020-05-13 00:00:00+00:00
    test_entry{ 1589328000, { 642600069184000000 }, { 63756547200000.0 }, { 63756547200.0, 0.0 } },

    //2020-08-21 00:00:00+00:00
    test_entry{ 1597968000, { 651240069184000000 }, { 63765187200000.0 }, { 63765187200.0, 0.0 } },

    //2020-11-29 00:00:00+00:00
    test_entry{ 1606608000, { 659880069184000000 }, { 63773827200000.0 }, { 63773827200.0, 0.0 } },

    //2021-03-09 00:00:00+00:00
    test_entry{ 1615248000, { 668520069184000000 }, { 63782467200000.0 }, { 63782467200.0, 0.0 } },

    //2021-06-17 00:00:00+00:00
    test_entry{ 1623888000, { 677160069184000000 }, { 63791107200000.0 }, { 63791107200.0, 0.0 } },

    //2021-09-25 00:00:00+00:00
    test_entry{ 1632528000, { 685800069184000000 }, { 63799747200000.0 }, { 63799747200.0, 0.0 } },

    //2022-01-03 00:00:00+00:00
    test_entry{ 1641168000, { 694440069184000000 }, { 63808387200000.0 }, { 63808387200.0, 0.0 } },

    //2022-04-13 00:00:00+00:00
    test_entry{ 1649808000, { 703080069184000000 }, { 63817027200000.0 }, { 63817027200.0, 0.0 } },

    //2022-07-22 00:00:00+00:00
    test_entry{ 1658448000, { 711720069184000000 }, { 63825667200000.0 }, { 63825667200.0, 0.0 } },

    //2022-10-30 00:00:00+00:00
    test_entry{ 1667088000, { 720360069184000000 }, { 63834307200000.0 }, { 63834307200.0, 0.0 } },

    //2023-02-07 00:00:00+00:00
    test_entry{ 1675728000, { 729000069184000000 }, { 63842947200000.0 }, { 63842947200.0, 0.0 } },

    //2023-05-18 00:00:00+00:00
    test_entry{ 1684368000, { 737640069184000000 }, { 63851587200000.0 }, { 63851587200.0, 0.0 } },

    //2023-08-26 00:00:00+00:00
    test_entry{ 1693008000, { 746280069184000000 }, { 63860227200000.0 }, { 63860227200.0, 0.0 } },

    //2023-12-04 00:00:00+00:00
    test_entry{ 1701648000, { 754920069184000000 }, { 63868867200000.0 }, { 63868867200.0, 0.0 } },

    //2024-03-13 00:00:00+00:00
    test_entry{ 1710288000, { 763560069184000000 }, { 63877507200000.0 }, { 63877507200.0, 0.0 } },

    //2024-06-21 00:00:00+00:00
    test_entry{ 1718928000, { 772200069184000000 }, { 63886147200000.0 }, { 63886147200.0, 0.0 } },

    //2024-09-29 00:00:00+00:00
    test_entry{ 1727568000, { 780840069184000000 }, { 63894787200000.0 }, { 63894787200.0, 0.0 } },

    //2025-01-07 00:00:00+00:00
    test_entry{ 1736208000, { 789480069184000000 }, { 63903427200000.0 }, { 63903427200.0, 0.0 } },

    //2025-04-17 00:00:00+00:00
    test_entry{ 1744848000, { 798120069184000000 }, { 63912067200000.0 }, { 63912067200.0, 0.0 } },

    //2025-07-26 00:00:00+00:00
    test_entry{ 1753488000, { 806760069184000000 }, { 63920707200000.0 }, { 63920707200.0, 0.0 } },

    //2025-11-03 00:00:00+00:00
    test_entry{ 1762128000, { 815400069184000000 }, { 63929347200000.0 }, { 63929347200.0, 0.0 } },

    //2026-02-11 00:00:00+00:00
    test_entry{ 1770768000, { 824040069184000000 }, { 63937987200000.0 }, { 63937987200.0, 0.0 } },

    //2026-05-22 00:00:00+00:00
    test_entry{ 1779408000, { 832680069184000000 }, { 63946627200000.0 }, { 63946627200.0, 0.0 } },

    //2026-08-30 00:00:00+00:00
    test_entry{ 1788048000, { 841320069184000000 }, { 63955267200000.0 }, { 63955267200.0, 0.0 } },

    //2026-12-08 00:00:00+00:00
    test_entry{ 1796688000, { 849960069184000000 }, { 63963907200000.0 }, { 63963907200.0, 0.0 } },

    //2027-03-18 00:00:00+00:00
    test_entry{ 1805328000, { 858600069184000000 }, { 63972547200000.0 }, { 63972547200.0, 0.0 } },

    //2027-06-26 00:00:00+00:00
    test_entry{ 1813968000, { 867240069184000000 }, { 63981187200000.0 }, { 63981187200.0, 0.0 } },

    //2027-10-04 00:00:00+00:00
    test_entry{ 1822608000, { 875880069184000000 }, { 63989827200000.0 }, { 63989827200.0, 0.0 } },

    //2028-01-12 00:00:00+00:00
    test_entry{ 1831248000, { 884520069184000000 }, { 63998467200000.0 }, { 63998467200.0, 0.0 } },

    //2028-04-21 00:00:00+00:00
    test_entry{ 1839888000, { 893160069184000000 }, { 64007107200000.0 }, { 64007107200.0, 0.0 } },

    //2028-07-30 00:00:00+00:00
    test_entry{ 1848528000, { 901800069184000000 }, { 64015747200000.0 }, { 64015747200.0, 0.0 } },

    //2028-11-07 00:00:00+00:00
    test_entry{ 1857168000, { 910440069184000000 }, { 64024387200000.0 }, { 64024387200.0, 0.0 } },

    //2029-02-15 00:00:00+00:00
    test_entry{ 1865808000, { 919080069184000000 }, { 64033027200000.0 }, { 64033027200.0, 0.0 } },

    //2029-05-26 00:00:00+00:00
    test_entry{ 1874448000, { 927720069184000000 }, { 64041667200000.0 }, { 64041667200.0, 0.0 } },

    //2029-09-03 00:00:00+00:00
    test_entry{ 1883088000, { 936360069184000000 }, { 64050307200000.0 }, { 64050307200.0, 0.0 } },

    //2029-12-12 00:00:00+00:00
    test_entry{ 1891728000, { 945000069184000000 }, { 64058947200000.0 }, { 64058947200.0, 0.0 } },

    //2030-03-22 00:00:00+00:00
    test_entry{ 1900368000, { 953640069184000000 }, { 64067587200000.0 }, { 64067587200.0, 0.0 } },

    //2030-06-30 00:00:00+00:00
    test_entry{ 1909008000, { 962280069184000000 }, { 64076227200000.0 }, { 64076227200.0, 0.0 } },

    //2030-10-08 00:00:00+00:00
    test_entry{ 1917648000, { 970920069184000000 }, { 64084867200000.0 }, { 64084867200.0, 0.0 } },

    //2031-01-16 00:00:00+00:00
    test_entry{ 1926288000, { 979560069184000000 }, { 64093507200000.0 }, { 64093507200.0, 0.0 } },

    //2031-04-26 00:00:00+00:00
    test_entry{ 1934928000, { 988200069184000000 }, { 64102147200000.0 }, { 64102147200.0, 0.0 } },

    //2031-08-04 00:00:00+00:00
    test_entry{ 1943568000, { 996840069184000000 }, { 64110787200000.0 }, { 64110787200.0, 0.0 } },

    //2031-11-12 00:00:00+00:00
    test_entry{ 1952208000, { 1005480069184000000 }, { 64119427200000.0 }, { 64119427200.0, 0.0 } },

    //2032-02-20 00:00:00+00:00
    test_entry{ 1960848000, { 1014120069184000000 }, { 64128067200000.0 }, { 64128067200.0, 0.0 } },

    //2032-05-30 00:00:00+00:00
    test_entry{ 1969488000, { 1022760069184000000 }, { 64136707200000.0 }, { 64136707200.0, 0.0 } },

    //2032-09-07 00:00:00+00:00
    test_entry{ 1978128000, { 1031400069184000000 }, { 64145347200000.0 }, { 64145347200.0, 0.0 } },

    //2032-12-16 00:00:00+00:00
    test_entry{ 1986768000, { 1040040069184000000 }, { 64153987200000.0 }, { 64153987200.0, 0.0 } },

    //2033-03-26 00:00:00+00:00
    test_entry{ 1995408000, { 1048680069184000000 }, { 64162627200000.0 }, { 64162627200.0, 0.0 } },

    //2033-07-04 00:00:00+00:00
    test_entry{ 2004048000, { 1057320069184000000 }, { 64171267200000.0 }, { 64171267200.0, 0.0 } },

    //2033-10-12 00:00:00+00:00
    test_entry{ 2012688000, { 1065960069184000000 }, { 64179907200000.0 }, { 64179907200.0, 0.0 } },

    //2034-01-20 00:00:00+00:00
    test_entry{ 2021328000, { 1074600069184000000 }, { 64188547200000.0 }, { 64188547200.0, 0.0 } },

    //2034-04-30 00:00:00+00:00
    test_entry{ 2029968000, { 1083240069184000000 }, { 64197187200000.0 }, { 64197187200.0, 0.0 } },

    //2034-08-08 00:00:00+00:00
    test_entry{ 2038608000, { 1091880069184000000 }, { 64205827200000.0 }, { 64205827200.0, 0.0 } },

    //2034-11-16 00:00:00+00:00
    test_entry{ 2047248000, { 1100520069184000000 }, { 64214467200000.0 }, { 64214467200.0, 0.0 } },

    //2035-02-24 00:00:00+00:00
    test_entry{ 2055888000, { 1109160069184000000 }, { 64223107200000.0 }, { 64223107200.0, 0.0 } },

    //2035-06-04 00:00:00+00:00
    test_entry{ 2064528000, { 1117800069184000000 }, { 64231747200000.0 }, { 64231747200.0, 0.0 } },

    //2035-09-12 00:00:00+00:00
    test_entry{ 2073168000, { 1126440069184000000 }, { 64240387200000.0 }, { 64240387200.0, 0.0 } },

    //2035-12-21 00:00:00+00:00
    test_entry{ 2081808000, { 1135080069184000000 }, { 64249027200000.0 }, { 64249027200.0, 0.0 } },

    //2036-03-30 00:00:00+00:00
    test_entry{ 2090448000, { 1143720069184000000 }, { 64257667200000.0 }, { 64257667200.0, 0.0 } },

    //2036-07-08 00:00:00+00:00
    test_entry{ 2099088000, { 1152360069184000000 }, { 64266307200000.0 }, { 64266307200.0, 0.0 } },

    //2036-10-16 00:00:00+00:00
    test_entry{ 2107728000, { 1161000069184000000 }, { 64274947200000.0 }, { 64274947200.0, 0.0 } },

    //2037-01-24 00:00:00+00:00
    test_entry{ 2116368000, { 1169640069184000000 }, { 64283587200000.0 }, { 64283587200.0, 0.0 } },

    //2037-05-04 00:00:00+00:00
    test_entry{ 2125008000, { 1178280069184000000 }, { 64292227200000.0 }, { 64292227200.0, 0.0 } },

    //2037-08-12 00:00:00+00:00
    test_entry{ 2133648000, { 1186920069184000000 }, { 64300867200000.0 }, { 64300867200.0, 0.0 } },

    //2037-11-20 00:00:00+00:00
    test_entry{ 2142288000, { 1195560069184000000 }, { 64309507200000.0 }, { 64309507200.0, 0.0 } },

    //2038-02-28 00:00:00+00:00
    test_entry{ 2150928000, { 1204200069184000000 }, { 64318147200000.0 }, { 64318147200.0, 0.0 } },

    //2038-06-08 00:00:00+00:00
    test_entry{ 2159568000, { 1212840069184000000 }, { 64326787200000.0 }, { 64326787200.0, 0.0 } },

    //2038-09-16 00:00:00+00:00
    test_entry{ 2168208000, { 1221480069184000000 }, { 64335427200000.0 }, { 64335427200.0, 0.0 } },

    //2038-12-25 00:00:00+00:00
    test_entry{ 2176848000, { 1230120069184000000 }, { 64344067200000.0 }, { 64344067200.0, 0.0 } },

    //2039-04-04 00:00:00+00:00
    test_entry{ 2185488000, { 1238760069184000000 }, { 64352707200000.0 }, { 64352707200.0, 0.0 } },

    //2039-07-13 00:00:00+00:00
    test_entry{ 2194128000, { 1247400069184000000 }, { 64361347200000.0 }, { 64361347200.0, 0.0 } },

    //2039-10-21 00:00:00+00:00
    test_entry{ 2202768000, { 1256040069184000000 }, { 64369987200000.0 }, { 64369987200.0, 0.0 } },

    //2040-01-29 00:00:00+00:00
    test_entry{ 2211408000, { 1264680069184000000 }, { 64378627200000.0 }, { 64378627200.0, 0.0 } },

    //2040-05-08 00:00:00+00:00
    test_entry{ 2220048000, { 1273320069184000000 }, { 64387267200000.0 }, { 64387267200.0, 0.0 } },

    //2040-08-16 00:00:00+00:00
    test_entry{ 2228688000, { 1281960069184000000 }, { 64395907200000.0 }, { 64395907200.0, 0.0 } },

    //2040-11-24 00:00:00+00:00
    test_entry{ 2237328000, { 1290600069184000000 }, { 64404547200000.0 }, { 64404547200.0, 0.0 } },

    //2041-03-04 00:00:00+00:00
    test_entry{ 2245968000, { 1299240069184000000 }, { 64413187200000.0 }, { 64413187200.0, 0.0 } },

    //2041-06-12 00:00:00+00:00
    test_entry{ 2254608000, { 1307880069184000000 }, { 64421827200000.0 }, { 64421827200.0, 0.0 } },

    //2041-09-20 00:00:00+00:00
    test_entry{ 2263248000, { 1316520069184000000 }, { 64430467200000.0 }, { 64430467200.0, 0.0 } },

    //2041-12-29 00:00:00+00:00
    test_entry{ 2271888000, { 1325160069184000000 }, { 64439107200000.0 }, { 64439107200.0, 0.0 } },

    //2042-04-08 00:00:00+00:00
    test_entry{ 2280528000, { 1333800069184000000 }, { 64447747200000.0 }, { 64447747200.0, 0.0 } },

    //2042-07-17 00:00:00+00:00
    test_entry{ 2289168000, { 1342440069184000000 }, { 64456387200000.0 }, { 64456387200.0, 0.0 } },

    //2042-10-25 00:00:00+00:00
    test_entry{ 2297808000, { 1351080069184000000 }, { 64465027200000.0 }, { 64465027200.0, 0.0 } },

    //2043-02-02 00:00:00+00:00
    test_entry{ 2306448000, { 1359720069184000000 }, { 64473667200000.0 }, { 64473667200.0, 0.0 } },

    //2043-05-13 00:00:00+00:00
    test_entry{ 2315088000, { 1368360069184000000 }, { 64482307200000.0 }, { 64482307200.0, 0.0 } },

    //2043-08-21 00:00:00+00:00
    test_entry{ 2323728000, { 1377000069184000000 }, { 64490947200000.0 }, { 64490947200.0, 0.0 } },

    //2043-11-29 00:00:00+00:00
    test_entry{ 2332368000, { 1385640069184000000 }, { 64499587200000.0 }, { 64499587200.0, 0.0 } },

    //2044-03-08 00:00:00+00:00
    test_entry{ 2341008000, { 1394280069184000000 }, { 64508227200000.0 }, { 64508227200.0, 0.0 } },

    //2044-06-16 00:00:00+00:00
    test_entry{ 2349648000, { 1402920069184000000 }, { 64516867200000.0 }, { 64516867200.0, 0.0 } },

    //2044-09-24 00:00:00+00:00
    test_entry{ 2358288000, { 1411560069184000000 }, { 64525507200000.0 }, { 64525507200.0, 0.0 } },

    //2045-01-02 00:00:00+00:00
    test_entry{ 2366928000, { 1420200069184000000 }, { 64534147200000.0 }, { 64534147200.0, 0.0 } },

    //2045-04-12 00:00:00+00:00
    test_entry{ 2375568000, { 1428840069184000000 }, { 64542787200000.0 }, { 64542787200.0, 0.0 } },

    //2045-07-21 00:00:00+00:00
    test_entry{ 2384208000, { 1437480069184000000 }, { 64551427200000.0 }, { 64551427200.0, 0.0 } },

    //2045-10-29 00:00:00+00:00
    test_entry{ 2392848000, { 1446120069184000000 }, { 64560067200000.0 }, { 64560067200.0, 0.0 } },

    //2046-02-06 00:00:00+00:00
    test_entry{ 2401488000, { 1454760069184000000 }, { 64568707200000.0 }, { 64568707200.0, 0.0 } },

    //2046-05-17 00:00:00+00:00
    test_entry{ 2410128000, { 1463400069184000000 }, { 64577347200000.0 }, { 64577347200.0, 0.0 } },

    //2046-08-25 00:00:00+00:00
    test_entry{ 2418768000, { 1472040069184000000 }, { 64585987200000.0 }, { 64585987200.0, 0.0 } },

    //2046-12-03 00:00:00+00:00
    test_entry{ 2427408000, { 1480680069184000000 }, { 64594627200000.0 }, { 64594627200.0, 0.0 } },

    //2047-03-13 00:00:00+00:00
    test_entry{ 2436048000, { 1489320069184000000 }, { 64603267200000.0 }, { 64603267200.0, 0.0 } },

    //2047-06-21 00:00:00+00:00
    test_entry{ 2444688000, { 1497960069184000000 }, { 64611907200000.0 }, { 64611907200.0, 0.0 } },

    //2047-09-29 00:00:00+00:00
    test_entry{ 2453328000, { 1506600069184000000 }, { 64620547200000.0 }, { 64620547200.0, 0.0 } },

    //2048-01-07 00:00:00+00:00
    test_entry{ 2461968000, { 1515240069184000000 }, { 64629187200000.0 }, { 64629187200.0, 0.0 } },

    //2048-04-16 00:00:00+00:00
    test_entry{ 2470608000, { 1523880069184000000 }, { 64637827200000.0 }, { 64637827200.0, 0.0 } },

    //2048-07-25 00:00:00+00:00
    test_entry{ 2479248000, { 1532520069184000000 }, { 64646467200000.0 }, { 64646467200.0, 0.0 } },

    //2048-11-02 00:00:00+00:00
    test_entry{ 2487888000, { 1541160069184000000 }, { 64655107200000.0 }, { 64655107200.0, 0.0 } },

    //2049-02-10 00:00:00+00:00
    test_entry{ 2496528000, { 1549800069184000000 }, { 64663747200000.0 }, { 64663747200.0, 0.0 } },

    //2049-05-21 00:00:00+00:00
    test_entry{ 2505168000, { 1558440069184000000 }, { 64672387200000.0 }, { 64672387200.0, 0.0 } },

    //2049-08-29 00:00:00+00:00
    test_entry{ 2513808000, { 1567080069184000000 }, { 64681027200000.0 }, { 64681027200.0, 0.0 } },

    //2049-12-07 00:00:00+00:00
    test_entry{ 2522448000, { 1575720069184000000 }, { 64689667200000.0 }, { 64689667200.0, 0.0 } },

    //2050-03-17 00:00:00+00:00
    test_entry{ 2531088000, { 1584360069184000000 }, { 64698307200000.0 }, { 64698307200.0, 0.0 } },

    //2050-06-25 00:00:00+00:00
    test_entry{ 2539728000, { 1593000069184000000 }, { 64706947200000.0 }, { 64706947200.0, 0.0 } },

    //2050-10-03 00:00:00+00:00
    test_entry{ 2548368000, { 1601640069184000000 }, { 64715587200000.0 }, { 64715587200.0, 0.0 } },

    //2051-01-11 00:00:00+00:00
    test_entry{ 2557008000, { 1610280069184000000 }, { 64724227200000.0 }, { 64724227200.0, 0.0 } },

    //2051-04-21 00:00:00+00:00
    test_entry{ 2565648000, { 1618920069184000000 }, { 64732867200000.0 }, { 64732867200.0, 0.0 } },

    //2051-07-30 00:00:00+00:00
    test_entry{ 2574288000, { 1627560069184000000 }, { 64741507200000.0 }, { 64741507200.0, 0.0 } },

    //2051-11-07 00:00:00+00:00
    test_entry{ 2582928000, { 1636200069184000000 }, { 64750147200000.0 }, { 64750147200.0, 0.0 } },

    //2052-02-15 00:00:00+00:00
    test_entry{ 2591568000, { 1644840069184000000 }, { 64758787200000.0 }, { 64758787200.0, 0.0 } },

    //2052-05-25 00:00:00+00:00
    test_entry{ 2600208000, { 1653480069184000000 }, { 64767427200000.0 }, { 64767427200.0, 0.0 } },

    //2052-09-02 00:00:00+00:00
    test_entry{ 2608848000, { 1662120069184000000 }, { 64776067200000.0 }, { 64776067200.0, 0.0 } },

    //2052-12-11 00:00:00+00:00
    test_entry{ 2617488000, { 1670760069184000000 }, { 64784707200000.0 }, { 64784707200.0, 0.0 } },

    //2053-03-21 00:00:00+00:00
    test_entry{ 2626128000, { 1679400069184000000 }, { 64793347200000.0 }, { 64793347200.0, 0.0 } },

    //2053-06-29 00:00:00+00:00
    test_entry{ 2634768000, { 1688040069184000000 }, { 64801987200000.0 }, { 64801987200.0, 0.0 } },

    //2053-10-07 00:00:00+00:00
    test_entry{ 2643408000, { 1696680069184000000 }, { 64810627200000.0 }, { 64810627200.0, 0.0 } },

    //2054-01-15 00:00:00+00:00
    test_entry{ 2652048000, { 1705320069184000000 }, { 64819267200000.0 }, { 64819267200.0, 0.0 } },

    //2054-04-25 00:00:00+00:00
    test_entry{ 2660688000, { 1713960069184000000 }, { 64827907200000.0 }, { 64827907200.0, 0.0 } },

    //2054-08-03 00:00:00+00:00
    test_entry{ 2669328000, { 1722600069184000000 }, { 64836547200000.0 }, { 64836547200.0, 0.0 } },

    //2054-11-11 00:00:00+00:00
    test_entry{ 2677968000, { 1731240069184000000 }, { 64845187200000.0 }, { 64845187200.0, 0.0 } },

    //2055-02-19 00:00:00+00:00
    test_entry{ 2686608000, { 1739880069184000000 }, { 64853827200000.0 }, { 64853827200.0, 0.0 } },

    //2055-05-30 00:00:00+00:00
    test_entry{ 2695248000, { 1748520069184000000 }, { 64862467200000.0 }, { 64862467200.0, 0.0 } },

    //2055-09-07 00:00:00+00:00
    test_entry{ 2703888000, { 1757160069184000000 }, { 64871107200000.0 }, { 64871107200.0, 0.0 } },

    //2055-12-16 00:00:00+00:00
    test_entry{ 2712528000, { 1765800069184000000 }, { 64879747200000.0 }, { 64879747200.0, 0.0 } },

    //2056-03-25 00:00:00+00:00
    test_entry{ 2721168000, { 1774440069184000000 }, { 64888387200000.0 }, { 64888387200.0, 0.0 } },

    //2056-07-03 00:00:00+00:00
    test_entry{ 2729808000, { 1783080069184000000 }, { 64897027200000.0 }, { 64897027200.0, 0.0 } },

    //2056-10-11 00:00:00+00:00
    test_entry{ 2738448000, { 1791720069184000000 }, { 64905667200000.0 }, { 64905667200.0, 0.0 } },

    //2057-01-19 00:00:00+00:00
    test_entry{ 2747088000, { 1800360069184000000 }, { 64914307200000.0 }, { 64914307200.0, 0.0 } },

    //2057-04-29 00:00:00+00:00
    test_entry{ 2755728000, { 1809000069184000000 }, { 64922947200000.0 }, { 64922947200.0, 0.0 } },

    //2057-08-07 00:00:00+00:00
    test_entry{ 2764368000, { 1817640069184000000 }, { 64931587200000.0 }, { 64931587200.0, 0.0 } },

    //2057-11-15 00:00:00+00:00
    test_entry{ 2773008000, { 1826280069184000000 }, { 64940227200000.0 }, { 64940227200.0, 0.0 } },

    //2058-02-23 00:00:00+00:00
    test_entry{ 2781648000, { 1834920069184000000 }, { 64948867200000.0 }, { 64948867200.0, 0.0 } },

    //2058-06-03 00:00:00+00:00
    test_entry{ 2790288000, { 1843560069184000000 }, { 64957507200000.0 }, { 64957507200.0, 0.0 } },

    //2058-09-11 00:00:00+00:00
    test_entry{ 2798928000, { 1852200069184000000 }, { 64966147200000.0 }, { 64966147200.0, 0.0 } },

    //2058-12-20 00:00:00+00:00
    test_entry{ 2807568000, { 1860840069184000000 }, { 64974787200000.0 }, { 64974787200.0, 0.0 } },

    //2059-03-30 00:00:00+00:00
    test_entry{ 2816208000, { 1869480069184000000 }, { 64983427200000.0 }, { 64983427200.0, 0.0 } },

    //2059-07-08 00:00:00+00:00
    test_entry{ 2824848000, { 1878120069184000000 }, { 64992067200000.0 }, { 64992067200.0, 0.0 } },

    //2059-10-16 00:00:00+00:00
    test_entry{ 2833488000, { 1886760069184000000 }, { 65000707200000.0 }, { 65000707200.0, 0.0 } },

    //2060-01-24 00:00:00+00:00
    test_entry{ 2842128000, { 1895400069184000000 }, { 65009347200000.0 }, { 65009347200.0, 0.0 } },

    //2060-05-03 00:00:00+00:00
    test_entry{ 2850768000, { 1904040069184000000 }, { 65017987200000.0 }, { 65017987200.0, 0.0 } },

    //2060-08-11 00:00:00+00:00
    test_entry{ 2859408000, { 1912680069184000000 }, { 65026627200000.0 }, { 65026627200.0, 0.0 } },

    //2060-11-19 00:00:00+00:00
    test_entry{ 2868048000, { 1921320069184000000 }, { 65035267200000.0 }, { 65035267200.0, 0.0 } },

    //2061-02-27 00:00:00+00:00
    test_entry{ 2876688000, { 1929960069184000000 }, { 65043907200000.0 }, { 65043907200.0, 0.0 } },

    //2061-06-07 00:00:00+00:00
    test_entry{ 2885328000, { 1938600069184000000 }, { 65052547200000.0 }, { 65052547200.0, 0.0 } },

    //2061-09-15 00:00:00+00:00
    test_entry{ 2893968000, { 1947240069184000000 }, { 65061187200000.0 }, { 65061187200.0, 0.0 } },

    //2061-12-24 00:00:00+00:00
    test_entry{ 2902608000, { 1955880069184000000 }, { 65069827200000.0 }, { 65069827200.0, 0.0 } },

    //2062-04-03 00:00:00+00:00
    test_entry{ 2911248000, { 1964520069184000000 }, { 65078467200000.0 }, { 65078467200.0, 0.0 } },

    //2062-07-12 00:00:00+00:00
    test_entry{ 2919888000, { 1973160069184000000 }, { 65087107200000.0 }, { 65087107200.0, 0.0 } },

    //2062-10-20 00:00:00+00:00
    test_entry{ 2928528000, { 1981800069184000000 }, { 65095747200000.0 }, { 65095747200.0, 0.0 } },

    //2063-01-28 00:00:00+00:00
    test_entry{ 2937168000, { 1990440069184000000 }, { 65104387200000.0 }, { 65104387200.0, 0.0 } },

    //2063-05-08 00:00:00+00:00
    test_entry{ 2945808000, { 1999080069184000000 }, { 65113027200000.0 }, { 65113027200.0, 0.0 } },

    //2063-08-16 00:00:00+00:00
    test_entry{ 2954448000, { 2007720069184000000 }, { 65121667200000.0 }, { 65121667200.0, 0.0 } },

    //2063-11-24 00:00:00+00:00
    test_entry{ 2963088000, { 2016360069184000000 }, { 65130307200000.0 }, { 65130307200.0, 0.0 } },

    //2064-03-03 00:00:00+00:00
    test_entry{ 2971728000, { 2025000069184000000 }, { 65138947200000.0 }, { 65138947200.0, 0.0 } },

    //2064-06-11 00:00:00+00:00
    test_entry{ 2980368000, { 2033640069184000000 }, { 65147587200000.0 }, { 65147587200.0, 0.0 } },

    //2064-09-19 00:00:00+00:00
    test_entry{ 2989008000, { 2042280069184000000 }, { 65156227200000.0 }, { 65156227200.0, 0.0 } },

    //2064-12-28 00:00:00+00:00
    test_entry{ 2997648000, { 2050920069184000000 }, { 65164867200000.0 }, { 65164867200.0, 0.0 } },

    //2065-04-07 00:00:00+00:00
    test_entry{ 3006288000, { 2059560069184000000 }, { 65173507200000.0 }, { 65173507200.0, 0.0 } },

    //2065-07-16 00:00:00+00:00
    test_entry{ 3014928000, { 2068200069184000000 }, { 65182147200000.0 }, { 65182147200.0, 0.0 } },

    //2065-10-24 00:00:00+00:00
    test_entry{ 3023568000, { 2076840069184000000 }, { 65190787200000.0 }, { 65190787200.0, 0.0 } },

    //2066-02-01 00:00:00+00:00
    test_entry{ 3032208000, { 2085480069184000000 }, { 65199427200000.0 }, { 65199427200.0, 0.0 } },

    //2066-05-12 00:00:00+00:00
    test_entry{ 3040848000, { 2094120069184000000 }, { 65208067200000.0 }, { 65208067200.0, 0.0 } },

    //2066-08-20 00:00:00+00:00
    test_entry{ 3049488000, { 2102760069184000000 }, { 65216707200000.0 }, { 65216707200.0, 0.0 } },

    //2066-11-28 00:00:00+00:00
    test_entry{ 3058128000, { 2111400069184000000 }, { 65225347200000.0 }, { 65225347200.0, 0.0 } },

    //2067-03-08 00:00:00+00:00
    test_entry{ 3066768000, { 2120040069184000000 }, { 65233987200000.0 }, { 65233987200.0, 0.0 } },

    //2067-06-16 00:00:00+00:00
    test_entry{ 3075408000, { 2128680069184000000 }, { 65242627200000.0 }, { 65242627200.0, 0.0 } },

    //2067-09-24 00:00:00+00:00
    test_entry{ 3084048000, { 2137320069184000000 }, { 65251267200000.0 }, { 65251267200.0, 0.0 } },

    //2068-01-02 00:00:00+00:00
    test_entry{ 3092688000, { 2145960069184000000 }, { 65259907200000.0 }, { 65259907200.0, 0.0 } },

    //2068-04-11 00:00:00+00:00
    test_entry{ 3101328000, { 2154600069184000000 }, { 65268547200000.0 }, { 65268547200.0, 0.0 } },

    //2068-07-20 00:00:00+00:00
    test_entry{ 3109968000, { 2163240069184000000 }, { 65277187200000.0 }, { 65277187200.0, 0.0 } },

    //2068-10-28 00:00:00+00:00
    test_entry{ 3118608000, { 2171880069184000000 }, { 65285827200000.0 }, { 65285827200.0, 0.0 } },

    //2069-02-05 00:00:00+00:00
    test_entry{ 3127248000, { 2180520069184000000 }, { 65294467200000.0 }, { 65294467200.0, 0.0 } },

    //2069-05-16 00:00:00+00:00
    test_entry{ 3135888000, { 2189160069184000000 }, { 65303107200000.0 }, { 65303107200.0, 0.0 } },

    //2069-08-24 00:00:00+00:00
    test_entry{ 3144528000, { 2197800069184000000 }, { 65311747200000.0 }, { 65311747200.0, 0.0 } },

    //2069-12-02 00:00:00+00:00
    test_entry{ 3153168000, { 2206440069184000000 }, { 65320387200000.0 }, { 65320387200.0, 0.0 } },

    //2070-03-12 00:00:00+00:00
    test_entry{ 3161808000, { 2215080069184000000 }, { 65329027200000.0 }, { 65329027200.0, 0.0 } },

    //2070-06-20 00:00:00+00:00
    test_entry{ 3170448000, { 2223720069184000000 }, { 65337667200000.0 }, { 65337667200.0, 0.0 } },

    //2070-09-28 00:00:00+00:00
    test_entry{ 3179088000, { 2232360069184000000 }, { 65346307200000.0 }, { 65346307200.0, 0.0 } },

    //2071-01-06 00:00:00+00:00
    test_entry{ 3187728000, { 2241000069184000000 }, { 65354947200000.0 }, { 65354947200.0, 0.0 } },

    //2071-04-16 00:00:00+00:00
    test_entry{ 3196368000, { 2249640069184000000 }, { 65363587200000.0 }, { 65363587200.0, 0.0 } },

    //2071-07-25 00:00:00+00:00
    test_entry{ 3205008000, { 2258280069184000000 }, { 65372227200000.0 }, { 65372227200.0, 0.0 } },

    //2071-11-02 00:00:00+00:00
    test_entry{ 3213648000, { 2266920069184000000 }, { 65380867200000.0 }, { 65380867200.0, 0.0 } },

    //2072-02-10 00:00:00+00:00
    test_entry{ 3222288000, { 2275560069184000000 }, { 65389507200000.0 }, { 65389507200.0, 0.0 } },

    //2072-05-20 00:00:00+00:00
    test_entry{ 3230928000, { 2284200069184000000 }, { 65398147200000.0 }, { 65398147200.0, 0.0 } },

    //2072-08-28 00:00:00+00:00
    test_entry{ 3239568000, { 2292840069184000000 }, { 65406787200000.0 }, { 65406787200.0, 0.0 } },

    //2072-12-06 00:00:00+00:00
    test_entry{ 3248208000, { 2301480069184000000 }, { 65415427200000.0 }, { 65415427200.0, 0.0 } },

    //2073-03-16 00:00:00+00:00
    test_entry{ 3256848000, { 2310120069184000000 }, { 65424067200000.0 }, { 65424067200.0, 0.0 } },

    //2073-06-24 00:00:00+00:00
    test_entry{ 3265488000, { 2318760069184000000 }, { 65432707200000.0 }, { 65432707200.0, 0.0 } },

    //2073-10-02 00:00:00+00:00
    test_entry{ 3274128000, { 2327400069184000000 }, { 65441347200000.0 }, { 65441347200.0, 0.0 } },

    //2074-01-10 00:00:00+00:00
    test_entry{ 3282768000, { 2336040069184000000 }, { 65449987200000.0 }, { 65449987200.0, 0.0 } },

    //2074-04-20 00:00:00+00:00
    test_entry{ 3291408000, { 2344680069184000000 }, { 65458627200000.0 }, { 65458627200.0, 0.0 } },

    //2074-07-29 00:00:00+00:00
    test_entry{ 3300048000, { 2353320069184000000 }, { 65467267200000.0 }, { 65467267200.0, 0.0 } },

    //2074-11-06 00:00:00+00:00
    test_entry{ 3308688000, { 2361960069184000000 }, { 65475907200000.0 }, { 65475907200.0, 0.0 } },

    //2075-02-14 00:00:00+00:00
    test_entry{ 3317328000, { 2370600069184000000 }, { 65484547200000.0 }, { 65484547200.0, 0.0 } },

    //2075-05-25 00:00:00+00:00
    test_entry{ 3325968000, { 2379240069184000000 }, { 65493187200000.0 }, { 65493187200.0, 0.0 } },

    //2075-09-02 00:00:00+00:00
    test_entry{ 3334608000, { 2387880069184000000 }, { 65501827200000.0 }, { 65501827200.0, 0.0 } },

    //2075-12-11 00:00:00+00:00
    test_entry{ 3343248000, { 2396520069184000000 }, { 65510467200000.0 }, { 65510467200.0, 0.0 } },

    //2076-03-20 00:00:00+00:00
    test_entry{ 3351888000, { 2405160069184000000 }, { 65519107200000.0 }, { 65519107200.0, 0.0 } },

    //2076-06-28 00:00:00+00:00
    test_entry{ 3360528000, { 2413800069184000000 }, { 65527747200000.0 }, { 65527747200.0, 0.0 } },

    //2076-10-06 00:00:00+00:00
    test_entry{ 3369168000, { 2422440069184000000 }, { 65536387200000.0 }, { 65536387200.0, 0.0 } },

    //2077-01-14 00:00:00+00:00
    test_entry{ 3377808000, { 2431080069184000000 }, { 65545027200000.0 }, { 65545027200.0, 0.0 } },

    //2077-04-24 00:00:00+00:00
    test_entry{ 3386448000, { 2439720069184000000 }, { 65553667200000.0 }, { 65553667200.0, 0.0 } },

    //2077-08-02 00:00:00+00:00
    test_entry{ 3395088000, { 2448360069184000000 }, { 65562307200000.0 }, { 65562307200.0, 0.0 } },

    //2077-11-10 00:00:00+00:00
    test_entry{ 3403728000, { 2457000069184000000 }, { 65570947200000.0 }, { 65570947200.0, 0.0 } },

    //2078-02-18 00:00:00+00:00
    test_entry{ 3412368000, { 2465640069184000000 }, { 65579587200000.0 }, { 65579587200.0, 0.0 } },

    //2078-05-29 00:00:00+00:00
    test_entry{ 3421008000, { 2474280069184000000 }, { 65588227200000.0 }, { 65588227200.0, 0.0 } },

    //2078-09-06 00:00:00+00:00
    test_entry{ 3429648000, { 2482920069184000000 }, { 65596867200000.0 }, { 65596867200.0, 0.0 } },

    //2078-12-15 00:00:00+00:00
    test_entry{ 3438288000, { 2491560069184000000 }, { 65605507200000.0 }, { 65605507200.0, 0.0 } },

    //2079-03-25 00:00:00+00:00
    test_entry{ 3446928000, { 2500200069184000000 }, { 65614147200000.0 }, { 65614147200.0, 0.0 } },

    //2079-07-03 00:00:00+00:00
    test_entry{ 3455568000, { 2508840069184000000 }, { 65622787200000.0 }, { 65622787200.0, 0.0 } },

    //2079-10-11 00:00:00+00:00
    test_entry{ 3464208000, { 2517480069184000000 }, { 65631427200000.0 }, { 65631427200.0, 0.0 } },

    //2080-01-19 00:00:00+00:00
    test_entry{ 3472848000, { 2526120069184000000 }, { 65640067200000.0 }, { 65640067200.0, 0.0 } },

    //2080-04-28 00:00:00+00:00
    test_entry{ 3481488000, { 2534760069184000000 }, { 65648707200000.0 }, { 65648707200.0, 0.0 } },

    //2080-08-06 00:00:00+00:00
    test_entry{ 3490128000, { 2543400069184000000 }, { 65657347200000.0 }, { 65657347200.0, 0.0 } },

    //2080-11-14 00:00:00+00:00
    test_entry{ 3498768000, { 2552040069184000000 }, { 65665987200000.0 }, { 65665987200.0, 0.0 } },

    //2081-02-22 00:00:00+00:00
    test_entry{ 3507408000, { 2560680069184000000 }, { 65674627200000.0 }, { 65674627200.0, 0.0 } },

    //2081-06-02 00:00:00+00:00
    test_entry{ 3516048000, { 2569320069184000000 }, { 65683267200000.0 }, { 65683267200.0, 0.0 } },

    //2081-09-10 00:00:00+00:00
    test_entry{ 3524688000, { 2577960069184000000 }, { 65691907200000.0 }, { 65691907200.0, 0.0 } },

    //2081-12-19 00:00:00+00:00
    test_entry{ 3533328000, { 2586600069184000000 }, { 65700547200000.0 }, { 65700547200.0, 0.0 } },

    //2082-03-29 00:00:00+00:00
    test_entry{ 3541968000, { 2595240069184000000 }, { 65709187200000.0 }, { 65709187200.0, 0.0 } },

    //2082-07-07 00:00:00+00:00
    test_entry{ 3550608000, { 2603880069184000000 }, { 65717827200000.0 }, { 65717827200.0, 0.0 } },

    //2082-10-15 00:00:00+00:00
    test_entry{ 3559248000, { 2612520069184000000 }, { 65726467200000.0 }, { 65726467200.0, 0.0 } },

    //2083-01-23 00:00:00+00:00
    test_entry{ 3567888000, { 2621160069184000000 }, { 65735107200000.0 }, { 65735107200.0, 0.0 } },

    //2083-05-03 00:00:00+00:00
    test_entry{ 3576528000, { 2629800069184000000 }, { 65743747200000.0 }, { 65743747200.0, 0.0 } },

    //2083-08-11 00:00:00+00:00
    test_entry{ 3585168000, { 2638440069184000000 }, { 65752387200000.0 }, { 65752387200.0, 0.0 } },

    //2083-11-19 00:00:00+00:00
    test_entry{ 3593808000, { 2647080069184000000 }, { 65761027200000.0 }, { 65761027200.0, 0.0 } },

    //2084-02-27 00:00:00+00:00
    test_entry{ 3602448000, { 2655720069184000000 }, { 65769667200000.0 }, { 65769667200.0, 0.0 } },

    //2084-06-06 00:00:00+00:00
    test_entry{ 3611088000, { 2664360069184000000 }, { 65778307200000.0 }, { 65778307200.0, 0.0 } },

    //2084-09-14 00:00:00+00:00
    test_entry{ 3619728000, { 2673000069184000000 }, { 65786947200000.0 }, { 65786947200.0, 0.0 } },

    //2084-12-23 00:00:00+00:00
    test_entry{ 3628368000, { 2681640069184000000 }, { 65795587200000.0 }, { 65795587200.0, 0.0 } },

    //2085-04-02 00:00:00+00:00
    test_entry{ 3637008000, { 2690280069184000000 }, { 65804227200000.0 }, { 65804227200.0, 0.0 } },

    //2085-07-11 00:00:00+00:00
    test_entry{ 3645648000, { 2698920069184000000 }, { 65812867200000.0 }, { 65812867200.0, 0.0 } },

    //2085-10-19 00:00:00+00:00
    test_entry{ 3654288000, { 2707560069184000000 }, { 65821507200000.0 }, { 65821507200.0, 0.0 } },

    //2086-01-27 00:00:00+00:00
    test_entry{ 3662928000, { 2716200069184000000 }, { 65830147200000.0 }, { 65830147200.0, 0.0 } },

    //2086-05-07 00:00:00+00:00
    test_entry{ 3671568000, { 2724840069184000000 }, { 65838787200000.0 }, { 65838787200.0, 0.0 } },

    //2086-08-15 00:00:00+00:00
    test_entry{ 3680208000, { 2733480069184000000 }, { 65847427200000.0 }, { 65847427200.0, 0.0 } },

    //2086-11-23 00:00:00+00:00
    test_entry{ 3688848000, { 2742120069184000000 }, { 65856067200000.0 }, { 65856067200.0, 0.0 } },

    //2087-03-03 00:00:00+00:00
    test_entry{ 3697488000, { 2750760069184000000 }, { 65864707200000.0 }, { 65864707200.0, 0.0 } },

    //2087-06-11 00:00:00+00:00
    test_entry{ 3706128000, { 2759400069184000000 }, { 65873347200000.0 }, { 65873347200.0, 0.0 } },

    //2087-09-19 00:00:00+00:00
    test_entry{ 3714768000, { 2768040069184000000 }, { 65881987200000.0 }, { 65881987200.0, 0.0 } },

    //2087-12-28 00:00:00+00:00
    test_entry{ 3723408000, { 2776680069184000000 }, { 65890627200000.0 }, { 65890627200.0, 0.0 } },

    //2088-04-06 00:00:00+00:00
    test_entry{ 3732048000, { 2785320069184000000 }, { 65899267200000.0 }, { 65899267200.0, 0.0 } },

    //2088-07-15 00:00:00+00:00
    test_entry{ 3740688000, { 2793960069184000000 }, { 65907907200000.0 }, { 65907907200.0, 0.0 } },

    //2088-10-23 00:00:00+00:00
    test_entry{ 3749328000, { 2802600069184000000 }, { 65916547200000.0 }, { 65916547200.0, 0.0 } },

    //2089-01-31 00:00:00+00:00
    test_entry{ 3757968000, { 2811240069184000000 }, { 65925187200000.0 }, { 65925187200.0, 0.0 } },

    //2089-05-11 00:00:00+00:00
    test_entry{ 3766608000, { 2819880069184000000 }, { 65933827200000.0 }, { 65933827200.0, 0.0 } },

    //2089-08-19 00:00:00+00:00
    test_entry{ 3775248000, { 2828520069184000000 }, { 65942467200000.0 }, { 65942467200.0, 0.0 } },

    //2089-11-27 00:00:00+00:00
    test_entry{ 3783888000, { 2837160069184000000 }, { 65951107200000.0 }, { 65951107200.0, 0.0 } },

    //2090-03-07 00:00:00+00:00
    test_entry{ 3792528000, { 2845800069184000000 }, { 65959747200000.0 }, { 65959747200.0, 0.0 } },

    //2090-06-15 00:00:00+00:00
    test_entry{ 3801168000, { 2854440069184000000 }, { 65968387200000.0 }, { 65968387200.0, 0.0 } },

    //2090-09-23 00:00:00+00:00
    test_entry{ 3809808000, { 2863080069184000000 }, { 65977027200000.0 }, { 65977027200.0, 0.0 } },

    //2091-01-01 00:00:00+00:00
    test_entry{ 3818448000, { 2871720069184000000 }, { 65985667200000.0 }, { 65985667200.0, 0.0 } },

    //2091-04-11 00:00:00+00:00
    test_entry{ 3827088000, { 2880360069184000000 }, { 65994307200000.0 }, { 65994307200.0, 0.0 } },

    //2091-07-20 00:00:00+00:00
    test_entry{ 3835728000, { 2889000069184000000 }, { 66002947200000.0 }, { 66002947200.0, 0.0 } },

    //2091-10-28 00:00:00+00:00
    test_entry{ 3844368000, { 2897640069184000000 }, { 66011587200000.0 }, { 66011587200.0, 0.0 } },

    //2092-02-05 00:00:00+00:00
    test_entry{ 3853008000, { 2906280069184000000 }, { 66020227200000.0 }, { 66020227200.0, 0.0 } },

    //2092-05-15 00:00:00+00:00
    test_entry{ 3861648000, { 2914920069184000000 }, { 66028867200000.0 }, { 66028867200.0, 0.0 } },

    //2092-08-23 00:00:00+00:00
    test_entry{ 3870288000, { 2923560069184000000 }, { 66037507200000.0 }, { 66037507200.0, 0.0 } },

    //2092-12-01 00:00:00+00:00
    test_entry{ 3878928000, { 2932200069184000000 }, { 66046147200000.0 }, { 66046147200.0, 0.0 } },

    //2093-03-11 00:00:00+00:00
    test_entry{ 3887568000, { 2940840069184000000 }, { 66054787200000.0 }, { 66054787200.0, 0.0 } },

    //2093-06-19 00:00:00+00:00
    test_entry{ 3896208000, { 2949480069184000000 }, { 66063427200000.0 }, { 66063427200.0, 0.0 } },

    //2093-09-27 00:00:00+00:00
    test_entry{ 3904848000, { 2958120069184000000 }, { 66072067200000.0 }, { 66072067200.0, 0.0 } },

    //2094-01-05 00:00:00+00:00
    test_entry{ 3913488000, { 2966760069184000000 }, { 66080707200000.0 }, { 66080707200.0, 0.0 } },

    //2094-04-15 00:00:00+00:00
    test_entry{ 3922128000, { 2975400069184000000 }, { 66089347200000.0 }, { 66089347200.0, 0.0 } },

    //2094-07-24 00:00:00+00:00
    test_entry{ 3930768000, { 2984040069184000000 }, { 66097987200000.0 }, { 66097987200.0, 0.0 } },

    //2094-11-01 00:00:00+00:00
    test_entry{ 3939408000, { 2992680069184000000 }, { 66106627200000.0 }, { 66106627200.0, 0.0 } },

    //2095-02-09 00:00:00+00:00
    test_entry{ 3948048000, { 3001320069184000000 }, { 66115267200000.0 }, { 66115267200.0, 0.0 } },

    //2095-05-20 00:00:00+00:00
    test_entry{ 3956688000, { 3009960069184000000 }, { 66123907200000.0 }, { 66123907200.0, 0.0 } },

    //2095-08-28 00:00:00+00:00
    test_entry{ 3965328000, { 3018600069184000000 }, { 66132547200000.0 }, { 66132547200.0, 0.0 } },

    //2095-12-06 00:00:00+00:00
    test_entry{ 3973968000, { 3027240069184000000 }, { 66141187200000.0 }, { 66141187200.0, 0.0 } },

    //2096-03-15 00:00:00+00:00
    test_entry{ 3982608000, { 3035880069184000000 }, { 66149827200000.0 }, { 66149827200.0, 0.0 } },

    //2096-06-23 00:00:00+00:00
    test_entry{ 3991248000, { 3044520069184000000 }, { 66158467200000.0 }, { 66158467200.0, 0.0 } },

    //2096-10-01 00:00:00+00:00
    test_entry{ 3999888000, { 3053160069184000000 }, { 66167107200000.0 }, { 66167107200.0, 0.0 } },

    //2097-01-09 00:00:00+00:00
    test_entry{ 4008528000, { 3061800069184000000 }, { 66175747200000.0 }, { 66175747200.0, 0.0 } },

    //2097-04-19 00:00:00+00:00
    test_entry{ 4017168000, { 3070440069184000000 }, { 66184387200000.0 }, { 66184387200.0, 0.0 } },

    //2097-07-28 00:00:00+00:00
    test_entry{ 4025808000, { 3079080069184000000 }, { 66193027200000.0 }, { 66193027200.0, 0.0 } },

    //2097-11-05 00:00:00+00:00
    test_entry{ 4034448000, { 3087720069184000000 }, { 66201667200000.0 }, { 66201667200.0, 0.0 } },

    //2098-02-13 00:00:00+00:00
    test_entry{ 4043088000, { 3096360069184000000 }, { 66210307200000.0 }, { 66210307200.0, 0.0 } },

    //2098-05-24 00:00:00+00:00
    test_entry{ 4051728000, { 3105000069184000000 }, { 66218947200000.0 }, { 66218947200.0, 0.0 } },

    //2098-09-01 00:00:00+00:00
    test_entry{ 4060368000, { 3113640069184000000 }, { 66227587200000.0 }, { 66227587200.0, 0.0 } },

    //2098-12-10 00:00:00+00:00
    test_entry{ 4069008000, { 3122280069184000000 }, { 66236227200000.0 }, { 66236227200.0, 0.0 } },

    //2099-03-20 00:00:00+00:00
    test_entry{ 4077648000, { 3130920069184000000 }, { 66244867200000.0 }, { 66244867200.0, 0.0 } },

    //2099-06-28 00:00:00+00:00
    test_entry{ 4086288000, { 3139560069184000000 }, { 66253507200000.0 }, { 66253507200.0, 0.0 } },

    //2099-10-06 00:00:00+00:00
    test_entry{ 4094928000, { 3148200069184000000 }, { 66262147200000.0 }, { 66262147200.0, 0.0 } },

    //1971-12-31 23:59:58+00:00
    test_entry{ 63071998, { -883655959925054000 }, { 62230291198000.0 }, { 62230291198.0, 0.0 } },

    //1971-12-31 23:59:59+00:00
    test_entry{ 63071999, { -883655958925054000 }, { 62230291199000.0 }, { 62230291199.0, 0.0 } },

    //1972-01-01 00:00:00+00:00
    test_entry{ 63072000, { -883655957816000000 }, { 62230291200000.0 }, { 62230291200.0, 0.0 } },

    //1972-01-01 00:00:01+00:00
    test_entry{ 63072001, { -883655956816000000 }, { 62230291201000.0 }, { 62230291201.0, 0.0 } },

    //1972-06-30 23:59:58+00:00
    test_entry{ 78796798, { -867931159816000000 }, { 62246015998000.0 }, { 62246015998.0, 0.0 } },

    //1972-06-30 23:59:59+00:00
    test_entry{ 78796799, { -867931158816000000 }, { 62246015999000.0 }, { 62246015999.0, 0.0 } },

    //1972-07-01 00:00:00+00:00
    test_entry{ 78796800, { -867931156816000000 }, { 62246016000000.0 }, { 62246016000.0, 0.0 } },

    //1972-07-01 00:00:01+00:00
    test_entry{ 78796801, { -867931155816000000 }, { 62246016001000.0 }, { 62246016001.0, 0.0 } },

    //1972-12-31 23:59:58+00:00
    test_entry{ 94694398, { -852033558816000000 }, { 62261913598000.0 }, { 62261913598.0, 0.0 } },

    //1972-12-31 23:59:59+00:00
    test_entry{ 94694399, { -852033557816000000 }, { 62261913599000.0 }, { 62261913599.0, 0.0 } },

    //1973-01-01 00:00:00+00:00
    test_entry{ 94694400, { -852033555816000000 }, { 62261913600000.0 }, { 62261913600.0, 0.0 } },

    //1973-01-01 00:00:01+00:00
    test_entry{ 94694401, { -852033554816000000 }, { 62261913601000.0 }, { 62261913601.0, 0.0 } },

    //1973-06-30 23:59:58+00:00
    test_entry{ 110332798, { -836395157816000000 }, { 62277551998000.0 }, { 62277551998.0, 0.0 } },

    //1973-06-30 23:59:59+00:00
    test_entry{ 110332799, { -836395156816000000 }, { 62277551999000.0 }, { 62277551999.0, 0.0 } },

    //1973-07-01 00:00:00+00:00
    test_entry{ 110332800, { -836395155816000000 }, { 62277552000000.0 }, { 62277552000.0, 0.0 } },

    //1973-07-01 00:00:01+00:00
    test_entry{ 110332801, { -836395154816000000 }, { 62277552001000.0 }, { 62277552001.0, 0.0 } },

    //1973-12-31 23:59:58+00:00
    test_entry{ 126230398, { -820497557816000000 }, { 62293449598000.0 }, { 62293449598.0, 0.0 } },

    //1973-12-31 23:59:59+00:00
    test_entry{ 126230399, { -820497556816000000 }, { 62293449599000.0 }, { 62293449599.0, 0.0 } },

    //1974-01-01 00:00:00+00:00
    test_entry{ 126230400, { -820497554816000000 }, { 62293449600000.0 }, { 62293449600.0, 0.0 } },

    //1974-01-01 00:00:01+00:00
    test_entry{ 126230401, { -820497553816000000 }, { 62293449601000.0 }, { 62293449601.0, 0.0 } },

    //1974-06-30 23:59:58+00:00
    test_entry{ 141868798, { -804859156816000000 }, { 62309087998000.0 }, { 62309087998.0, 0.0 } },

    //1974-06-30 23:59:59+00:00
    test_entry{ 141868799, { -804859155816000000 }, { 62309087999000.0 }, { 62309087999.0, 0.0 } },

    //1974-07-01 00:00:00+00:00
    test_entry{ 141868800, { -804859154816000000 }, { 62309088000000.0 }, { 62309088000.0, 0.0 } },

    //1974-07-01 00:00:01+00:00
    test_entry{ 141868801, { -804859153816000000 }, { 62309088001000.0 }, { 62309088001.0, 0.0 } },

    //1974-12-31 23:59:58+00:00
    test_entry{ 157766398, { -788961556816000000 }, { 62324985598000.0 }, { 62324985598.0, 0.0 } },

    //1974-12-31 23:59:59+00:00
    test_entry{ 157766399, { -788961555816000000 }, { 62324985599000.0 }, { 62324985599.0, 0.0 } },

    //1975-01-01 00:00:00+00:00
    test_entry{ 157766400, { -788961553816000000 }, { 62324985600000.0 }, { 62324985600.0, 0.0 } },

    //1975-01-01 00:00:01+00:00
    test_entry{ 157766401, { -788961552816000000 }, { 62324985601000.0 }, { 62324985601.0, 0.0 } },

    //1975-06-30 23:59:58+00:00
    test_entry{ 173404798, { -773323155816000000 }, { 62340623998000.0 }, { 62340623998.0, 0.0 } },

    //1975-06-30 23:59:59+00:00
    test_entry{ 173404799, { -773323154816000000 }, { 62340623999000.0 }, { 62340623999.0, 0.0 } },

    //1975-07-01 00:00:00+00:00
    test_entry{ 173404800, { -773323153816000000 }, { 62340624000000.0 }, { 62340624000.0, 0.0 } },

    //1975-07-01 00:00:01+00:00
    test_entry{ 173404801, { -773323152816000000 }, { 62340624001000.0 }, { 62340624001.0, 0.0 } },

    //1975-12-31 23:59:58+00:00
    test_entry{ 189302398, { -757425555816000000 }, { 62356521598000.0 }, { 62356521598.0, 0.0 } },

    //1975-12-31 23:59:59+00:00
    test_entry{ 189302399, { -757425554816000000 }, { 62356521599000.0 }, { 62356521599.0, 0.0 } },

    //1976-01-01 00:00:00+00:00
    test_entry{ 189302400, { -757425552816000000 }, { 62356521600000.0 }, { 62356521600.0, 0.0 } },

    //1976-01-01 00:00:01+00:00
    test_entry{ 189302401, { -757425551816000000 }, { 62356521601000.0 }, { 62356521601.0, 0.0 } },

    //1976-06-30 23:59:58+00:00
    test_entry{ 205027198, { -741700754816000000 }, { 62372246398000.0 }, { 62372246398.0, 0.0 } },

    //1976-06-30 23:59:59+00:00
    test_entry{ 205027199, { -741700753816000000 }, { 62372246399000.0 }, { 62372246399.0, 0.0 } },

    //1976-07-01 00:00:00+00:00
    test_entry{ 205027200, { -741700752816000000 }, { 62372246400000.0 }, { 62372246400.0, 0.0 } },

    //1976-07-01 00:00:01+00:00
    test_entry{ 205027201, { -741700751816000000 }, { 62372246401000.0 }, { 62372246401.0, 0.0 } },

    //1976-12-31 23:59:58+00:00
    test_entry{ 220924798, { -725803154816000000 }, { 62388143998000.0 }, { 62388143998.0, 0.0 } },

    //1976-12-31 23:59:59+00:00
    test_entry{ 220924799, { -725803153816000000 }, { 62388143999000.0 }, { 62388143999.0, 0.0 } },

    //1977-01-01 00:00:00+00:00
    test_entry{ 220924800, { -725803151816000000 }, { 62388144000000.0 }, { 62388144000.0, 0.0 } },

    //1977-01-01 00:00:01+00:00
    test_entry{ 220924801, { -725803150816000000 }, { 62388144001000.0 }, { 62388144001.0, 0.0 } },

    //1977-06-30 23:59:58+00:00
    test_entry{ 236563198, { -710164753816000000 }, { 62403782398000.0 }, { 62403782398.0, 0.0 } },

    //1977-06-30 23:59:59+00:00
    test_entry{ 236563199, { -710164752816000000 }, { 62403782399000.0 }, { 62403782399.0, 0.0 } },

    //1977-07-01 00:00:00+00:00
    test_entry{ 236563200, { -710164751816000000 }, { 62403782400000.0 }, { 62403782400.0, 0.0 } },

    //1977-07-01 00:00:01+00:00
    test_entry{ 236563201, { -710164750816000000 }, { 62403782401000.0 }, { 62403782401.0, 0.0 } },

    //1977-12-31 23:59:58+00:00
    test_entry{ 252460798, { -694267153816000000 }, { 62419679998000.0 }, { 62419679998.0, 0.0 } },

    //1977-12-31 23:59:59+00:00
    test_entry{ 252460799, { -694267152816000000 }, { 62419679999000.0 }, { 62419679999.0, 0.0 } },

    //1978-01-01 00:00:00+00:00
    test_entry{ 252460800, { -694267150816000000 }, { 62419680000000.0 }, { 62419680000.0, 0.0 } },

    //1978-01-01 00:00:01+00:00
    test_entry{ 252460801, { -694267149816000000 }, { 62419680001000.0 }, { 62419680001.0, 0.0 } },

    //1978-06-30 23:59:58+00:00
    test_entry{ 268099198, { -678628752816000000 }, { 62435318398000.0 }, { 62435318398.0, 0.0 } },

    //1978-06-30 23:59:59+00:00
    test_entry{ 268099199, { -678628751816000000 }, { 62435318399000.0 }, { 62435318399.0, 0.0 } },

    //1978-07-01 00:00:00+00:00
    test_entry{ 268099200, { -678628750816000000 }, { 62435318400000.0 }, { 62435318400.0, 0.0 } },

    //1978-07-01 00:00:01+00:00
    test_entry{ 268099201, { -678628749816000000 }, { 62435318401000.0 }, { 62435318401.0, 0.0 } },

    //1978-12-31 23:59:58+00:00
    test_entry{ 283996798, { -662731152816000000 }, { 62451215998000.0 }, { 62451215998.0, 0.0 } },

    //1978-12-31 23:59:59+00:00
    test_entry{ 283996799, { -662731151816000000 }, { 62451215999000.0 }, { 62451215999.0, 0.0 } },

    //1979-01-01 00:00:00+00:00
    test_entry{ 283996800, { -662731149816000000 }, { 62451216000000.0 }, { 62451216000.0, 0.0 } },

    //1979-01-01 00:00:01+00:00
    test_entry{ 283996801, { -662731148816000000 }, { 62451216001000.0 }, { 62451216001.0, 0.0 } },

    //1979-06-30 23:59:58+00:00
    test_entry{ 299635198, { -647092751816000000 }, { 62466854398000.0 }, { 62466854398.0, 0.0 } },

    //1979-06-30 23:59:59+00:00
    test_entry{ 299635199, { -647092750816000000 }, { 62466854399000.0 }, { 62466854399.0, 0.0 } },

    //1979-07-01 00:00:00+00:00
    test_entry{ 299635200, { -647092749816000000 }, { 62466854400000.0 }, { 62466854400.0, 0.0 } },

    //1979-07-01 00:00:01+00:00
    test_entry{ 299635201, { -647092748816000000 }, { 62466854401000.0 }, { 62466854401.0, 0.0 } },

    //1979-12-31 23:59:58+00:00
    test_entry{ 315532798, { -631195151816000000 }, { 62482751998000.0 }, { 62482751998.0, 0.0 } },

    //1979-12-31 23:59:59+00:00
    test_entry{ 315532799, { -631195150816000000 }, { 62482751999000.0 }, { 62482751999.0, 0.0 } },

    //1980-01-01 00:00:00+00:00
    test_entry{ 315532800, { -631195148816000000 }, { 62482752000000.0 }, { 62482752000.0, 0.0 } },

    //1980-01-01 00:00:01+00:00
    test_entry{ 315532801, { -631195147816000000 }, { 62482752001000.0 }, { 62482752001.0, 0.0 } },

    //1980-06-30 23:59:58+00:00
    test_entry{ 331257598, { -615470350816000000 }, { 62498476798000.0 }, { 62498476798.0, 0.0 } },

    //1980-06-30 23:59:59+00:00
    test_entry{ 331257599, { -615470349816000000 }, { 62498476799000.0 }, { 62498476799.0, 0.0 } },

    //1980-07-01 00:00:00+00:00
    test_entry{ 331257600, { -615470348816000000 }, { 62498476800000.0 }, { 62498476800.0, 0.0 } },

    //1980-07-01 00:00:01+00:00
    test_entry{ 331257601, { -615470347816000000 }, { 62498476801000.0 }, { 62498476801.0, 0.0 } },

    //1980-12-31 23:59:58+00:00
    test_entry{ 347155198, { -599572750816000000 }, { 62514374398000.0 }, { 62514374398.0, 0.0 } },

    //1980-12-31 23:59:59+00:00
    test_entry{ 347155199, { -599572749816000000 }, { 62514374399000.0 }, { 62514374399.0, 0.0 } },

    //1981-01-01 00:00:00+00:00
    test_entry{ 347155200, { -599572748816000000 }, { 62514374400000.0 }, { 62514374400.0, 0.0 } },

    //1981-01-01 00:00:01+00:00
    test_entry{ 347155201, { -599572747816000000 }, { 62514374401000.0 }, { 62514374401.0, 0.0 } },

    //1981-06-30 23:59:58+00:00
    test_entry{ 362793598, { -583934350816000000 }, { 62530012798000.0 }, { 62530012798.0, 0.0 } },

    //1981-06-30 23:59:59+00:00
    test_entry{ 362793599, { -583934349816000000 }, { 62530012799000.0 }, { 62530012799.0, 0.0 } },

    //1981-07-01 00:00:00+00:00
    test_entry{ 362793600, { -583934347816000000 }, { 62530012800000.0 }, { 62530012800.0, 0.0 } },

    //1981-07-01 00:00:01+00:00
    test_entry{ 362793601, { -583934346816000000 }, { 62530012801000.0 }, { 62530012801.0, 0.0 } },

    //1981-12-31 23:59:58+00:00
    test_entry{ 378691198, { -568036749816000000 }, { 62545910398000.0 }, { 62545910398.0, 0.0 } },

    //1981-12-31 23:59:59+00:00
    test_entry{ 378691199, { -568036748816000000 }, { 62545910399000.0 }, { 62545910399.0, 0.0 } },

    //1982-01-01 00:00:00+00:00
    test_entry{ 378691200, { -568036747816000000 }, { 62545910400000.0 }, { 62545910400.0, 0.0 } },

    //1982-01-01 00:00:01+00:00
    test_entry{ 378691201, { -568036746816000000 }, { 62545910401000.0 }, { 62545910401.0, 0.0 } },

    //1982-06-30 23:59:58+00:00
    test_entry{ 394329598, { -552398349816000000 }, { 62561548798000.0 }, { 62561548798.0, 0.0 } },

    //1982-06-30 23:59:59+00:00
    test_entry{ 394329599, { -552398348816000000 }, { 62561548799000.0 }, { 62561548799.0, 0.0 } },

    //1982-07-01 00:00:00+00:00
    test_entry{ 394329600, { -552398346816000000 }, { 62561548800000.0 }, { 62561548800.0, 0.0 } },

    //1982-07-01 00:00:01+00:00
    test_entry{ 394329601, { -552398345816000000 }, { 62561548801000.0 }, { 62561548801.0, 0.0 } },

    //1982-12-31 23:59:58+00:00
    test_entry{ 410227198, { -536500748816000000 }, { 62577446398000.0 }, { 62577446398.0, 0.0 } },

    //1982-12-31 23:59:59+00:00
    test_entry{ 410227199, { -536500747816000000 }, { 62577446399000.0 }, { 62577446399.0, 0.0 } },

    //1983-01-01 00:00:00+00:00
    test_entry{ 410227200, { -536500746816000000 }, { 62577446400000.0 }, { 62577446400.0, 0.0 } },

    //1983-01-01 00:00:01+00:00
    test_entry{ 410227201, { -536500745816000000 }, { 62577446401000.0 }, { 62577446401.0, 0.0 } },

    //1983-06-30 23:59:58+00:00
    test_entry{ 425865598, { -520862348816000000 }, { 62593084798000.0 }, { 62593084798.0, 0.0 } },

    //1983-06-30 23:59:59+00:00
    test_entry{ 425865599, { -520862347816000000 }, { 62593084799000.0 }, { 62593084799.0, 0.0 } },

    //1983-07-01 00:00:00+00:00
    test_entry{ 425865600, { -520862345816000000 }, { 62593084800000.0 }, { 62593084800.0, 0.0 } },

    //1983-07-01 00:00:01+00:00
    test_entry{ 425865601, { -520862344816000000 }, { 62593084801000.0 }, { 62593084801.0, 0.0 } },

    //1983-12-31 23:59:58+00:00
    test_entry{ 441763198, { -504964747816000000 }, { 62608982398000.0 }, { 62608982398.0, 0.0 } },

    //1983-12-31 23:59:59+00:00
    test_entry{ 441763199, { -504964746816000000 }, { 62608982399000.0 }, { 62608982399.0, 0.0 } },

    //1984-01-01 00:00:00+00:00
    test_entry{ 441763200, { -504964745816000000 }, { 62608982400000.0 }, { 62608982400.0, 0.0 } },

    //1984-01-01 00:00:01+00:00
    test_entry{ 441763201, { -504964744816000000 }, { 62608982401000.0 }, { 62608982401.0, 0.0 } },

    //1984-06-30 23:59:58+00:00
    test_entry{ 457487998, { -489239947816000000 }, { 62624707198000.0 }, { 62624707198.0, 0.0 } },

    //1984-06-30 23:59:59+00:00
    test_entry{ 457487999, { -489239946816000000 }, { 62624707199000.0 }, { 62624707199.0, 0.0 } },

    //1984-07-01 00:00:00+00:00
    test_entry{ 457488000, { -489239945816000000 }, { 62624707200000.0 }, { 62624707200.0, 0.0 } },

    //1984-07-01 00:00:01+00:00
    test_entry{ 457488001, { -489239944816000000 }, { 62624707201000.0 }, { 62624707201.0, 0.0 } },

    //1984-12-31 23:59:58+00:00
    test_entry{ 473385598, { -473342347816000000 }, { 62640604798000.0 }, { 62640604798.0, 0.0 } },

    //1984-12-31 23:59:59+00:00
    test_entry{ 473385599, { -473342346816000000 }, { 62640604799000.0 }, { 62640604799.0, 0.0 } },

    //1985-01-01 00:00:00+00:00
    test_entry{ 473385600, { -473342345816000000 }, { 62640604800000.0 }, { 62640604800.0, 0.0 } },

    //1985-01-01 00:00:01+00:00
    test_entry{ 473385601, { -473342344816000000 }, { 62640604801000.0 }, { 62640604801.0, 0.0 } },

    //1985-06-30 23:59:58+00:00
    test_entry{ 489023998, { -457703947816000000 }, { 62656243198000.0 }, { 62656243198.0, 0.0 } },

    //1985-06-30 23:59:59+00:00
    test_entry{ 489023999, { -457703946816000000 }, { 62656243199000.0 }, { 62656243199.0, 0.0 } },

    //1985-07-01 00:00:00+00:00
    test_entry{ 489024000, { -457703944816000000 }, { 62656243200000.0 }, { 62656243200.0, 0.0 } },

    //1985-07-01 00:00:01+00:00
    test_entry{ 489024001, { -457703943816000000 }, { 62656243201000.0 }, { 62656243201.0, 0.0 } },

    //1985-12-31 23:59:58+00:00
    test_entry{ 504921598, { -441806346816000000 }, { 62672140798000.0 }, { 62672140798.0, 0.0 } },

    //1985-12-31 23:59:59+00:00
    test_entry{ 504921599, { -441806345816000000 }, { 62672140799000.0 }, { 62672140799.0, 0.0 } },

    //1986-01-01 00:00:00+00:00
    test_entry{ 504921600, { -441806344816000000 }, { 62672140800000.0 }, { 62672140800.0, 0.0 } },

    //1986-01-01 00:00:01+00:00
    test_entry{ 504921601, { -441806343816000000 }, { 62672140801000.0 }, { 62672140801.0, 0.0 } },

    //1986-06-30 23:59:58+00:00
    test_entry{ 520559998, { -426167946816000000 }, { 62687779198000.0 }, { 62687779198.0, 0.0 } },

    //1986-06-30 23:59:59+00:00
    test_entry{ 520559999, { -426167945816000000 }, { 62687779199000.0 }, { 62687779199.0, 0.0 } },

    //1986-07-01 00:00:00+00:00
    test_entry{ 520560000, { -426167944816000000 }, { 62687779200000.0 }, { 62687779200.0, 0.0 } },

    //1986-07-01 00:00:01+00:00
    test_entry{ 520560001, { -426167943816000000 }, { 62687779201000.0 }, { 62687779201.0, 0.0 } },

    //1986-12-31 23:59:58+00:00
    test_entry{ 536457598, { -410270346816000000 }, { 62703676798000.0 }, { 62703676798.0, 0.0 } },

    //1986-12-31 23:59:59+00:00
    test_entry{ 536457599, { -410270345816000000 }, { 62703676799000.0 }, { 62703676799.0, 0.0 } },

    //1987-01-01 00:00:00+00:00
    test_entry{ 536457600, { -410270344816000000 }, { 62703676800000.0 }, { 62703676800.0, 0.0 } },

    //1987-01-01 00:00:01+00:00
    test_entry{ 536457601, { -410270343816000000 }, { 62703676801000.0 }, { 62703676801.0, 0.0 } },

    //1987-06-30 23:59:58+00:00
    test_entry{ 552095998, { -394631946816000000 }, { 62719315198000.0 }, { 62719315198.0, 0.0 } },

    //1987-06-30 23:59:59+00:00
    test_entry{ 552095999, { -394631945816000000 }, { 62719315199000.0 }, { 62719315199.0, 0.0 } },

    //1987-07-01 00:00:00+00:00
    test_entry{ 552096000, { -394631944816000000 }, { 62719315200000.0 }, { 62719315200.0, 0.0 } },

    //1987-07-01 00:00:01+00:00
    test_entry{ 552096001, { -394631943816000000 }, { 62719315201000.0 }, { 62719315201.0, 0.0 } },

    //1987-12-31 23:59:58+00:00
    test_entry{ 567993598, { -378734346816000000 }, { 62735212798000.0 }, { 62735212798.0, 0.0 } },

    //1987-12-31 23:59:59+00:00
    test_entry{ 567993599, { -378734345816000000 }, { 62735212799000.0 }, { 62735212799.0, 0.0 } },

    //1988-01-01 00:00:00+00:00
    test_entry{ 567993600, { -378734343816000000 }, { 62735212800000.0 }, { 62735212800.0, 0.0 } },

    //1988-01-01 00:00:01+00:00
    test_entry{ 567993601, { -378734342816000000 }, { 62735212801000.0 }, { 62735212801.0, 0.0 } },

    //1988-06-30 23:59:58+00:00
    test_entry{ 583718398, { -363009545816000000 }, { 62750937598000.0 }, { 62750937598.0, 0.0 } },

    //1988-06-30 23:59:59+00:00
    test_entry{ 583718399, { -363009544816000000 }, { 62750937599000.0 }, { 62750937599.0, 0.0 } },

    //1988-07-01 00:00:00+00:00
    test_entry{ 583718400, { -363009543816000000 }, { 62750937600000.0 }, { 62750937600.0, 0.0 } },

    //1988-07-01 00:00:01+00:00
    test_entry{ 583718401, { -363009542816000000 }, { 62750937601000.0 }, { 62750937601.0, 0.0 } },

    //1988-12-31 23:59:58+00:00
    test_entry{ 599615998, { -347111945816000000 }, { 62766835198000.0 }, { 62766835198.0, 0.0 } },

    //1988-12-31 23:59:59+00:00
    test_entry{ 599615999, { -347111944816000000 }, { 62766835199000.0 }, { 62766835199.0, 0.0 } },

    //1989-01-01 00:00:00+00:00
    test_entry{ 599616000, { -347111943816000000 }, { 62766835200000.0 }, { 62766835200.0, 0.0 } },

    //1989-01-01 00:00:01+00:00
    test_entry{ 599616001, { -347111942816000000 }, { 62766835201000.0 }, { 62766835201.0, 0.0 } },

    //1989-06-30 23:59:58+00:00
    test_entry{ 615254398, { -331473545816000000 }, { 62782473598000.0 }, { 62782473598.0, 0.0 } },

    //1989-06-30 23:59:59+00:00
    test_entry{ 615254399, { -331473544816000000 }, { 62782473599000.0 }, { 62782473599.0, 0.0 } },

    //1989-07-01 00:00:00+00:00
    test_entry{ 615254400, { -331473543816000000 }, { 62782473600000.0 }, { 62782473600.0, 0.0 } },

    //1989-07-01 00:00:01+00:00
    test_entry{ 615254401, { -331473542816000000 }, { 62782473601000.0 }, { 62782473601.0, 0.0 } },

    //1989-12-31 23:59:58+00:00
    test_entry{ 631151998, { -315575945816000000 }, { 62798371198000.0 }, { 62798371198.0, 0.0 } },

    //1989-12-31 23:59:59+00:00
    test_entry{ 631151999, { -315575944816000000 }, { 62798371199000.0 }, { 62798371199.0, 0.0 } },

    //1990-01-01 00:00:00+00:00
    test_entry{ 631152000, { -315575942816000000 }, { 62798371200000.0 }, { 62798371200.0, 0.0 } },

    //1990-01-01 00:00:01+00:00
    test_entry{ 631152001, { -315575941816000000 }, { 62798371201000.0 }, { 62798371201.0, 0.0 } },

    //1990-06-30 23:59:58+00:00
    test_entry{ 646790398, { -299937544816000000 }, { 62814009598000.0 }, { 62814009598.0, 0.0 } },

    //1990-06-30 23:59:59+00:00
    test_entry{ 646790399, { -299937543816000000 }, { 62814009599000.0 }, { 62814009599.0, 0.0 } },

    //1990-07-01 00:00:00+00:00
    test_entry{ 646790400, { -299937542816000000 }, { 62814009600000.0 }, { 62814009600.0, 0.0 } },

    //1990-07-01 00:00:01+00:00
    test_entry{ 646790401, { -299937541816000000 }, { 62814009601000.0 }, { 62814009601.0, 0.0 } },

    //1990-12-31 23:59:58+00:00
    test_entry{ 662687998, { -284039944816000000 }, { 62829907198000.0 }, { 62829907198.0, 0.0 } },

    //1990-12-31 23:59:59+00:00
    test_entry{ 662687999, { -284039943816000000 }, { 62829907199000.0 }, { 62829907199.0, 0.0 } },

    //1991-01-01 00:00:00+00:00
    test_entry{ 662688000, { -284039941816000000 }, { 62829907200000.0 }, { 62829907200.0, 0.0 } },

    //1991-01-01 00:00:01+00:00
    test_entry{ 662688001, { -284039940816000000 }, { 62829907201000.0 }, { 62829907201.0, 0.0 } },

    //1991-06-30 23:59:58+00:00
    test_entry{ 678326398, { -268401543816000000 }, { 62845545598000.0 }, { 62845545598.0, 0.0 } },

    //1991-06-30 23:59:59+00:00
    test_entry{ 678326399, { -268401542816000000 }, { 62845545599000.0 }, { 62845545599.0, 0.0 } },

    //1991-07-01 00:00:00+00:00
    test_entry{ 678326400, { -268401541816000000 }, { 62845545600000.0 }, { 62845545600.0, 0.0 } },

    //1991-07-01 00:00:01+00:00
    test_entry{ 678326401, { -268401540816000000 }, { 62845545601000.0 }, { 62845545601.0, 0.0 } },

    //1991-12-31 23:59:58+00:00
    test_entry{ 694223998, { -252503943816000000 }, { 62861443198000.0 }, { 62861443198.0, 0.0 } },

    //1991-12-31 23:59:59+00:00
    test_entry{ 694223999, { -252503942816000000 }, { 62861443199000.0 }, { 62861443199.0, 0.0 } },

    //1992-01-01 00:00:00+00:00
    test_entry{ 694224000, { -252503941816000000 }, { 62861443200000.0 }, { 62861443200.0, 0.0 } },

    //1992-01-01 00:00:01+00:00
    test_entry{ 694224001, { -252503940816000000 }, { 62861443201000.0 }, { 62861443201.0, 0.0 } },

    //1992-06-30 23:59:58+00:00
    test_entry{ 709948798, { -236779143816000000 }, { 62877167998000.0 }, { 62877167998.0, 0.0 } },

    //1992-06-30 23:59:59+00:00
    test_entry{ 709948799, { -236779142816000000 }, { 62877167999000.0 }, { 62877167999.0, 0.0 } },

    //1992-07-01 00:00:00+00:00
    test_entry{ 709948800, { -236779140816000000 }, { 62877168000000.0 }, { 62877168000.0, 0.0 } },

    //1992-07-01 00:00:01+00:00
    test_entry{ 709948801, { -236779139816000000 }, { 62877168001000.0 }, { 62877168001.0, 0.0 } },

    //1992-12-31 23:59:58+00:00
    test_entry{ 725846398, { -220881542816000000 }, { 62893065598000.0 }, { 62893065598.0, 0.0 } },

    //1992-12-31 23:59:59+00:00
    test_entry{ 725846399, { -220881541816000000 }, { 62893065599000.0 }, { 62893065599.0, 0.0 } },

    //1993-01-01 00:00:00+00:00
    test_entry{ 725846400, { -220881540816000000 }, { 62893065600000.0 }, { 62893065600.0, 0.0 } },

    //1993-01-01 00:00:01+00:00
    test_entry{ 725846401, { -220881539816000000 }, { 62893065601000.0 }, { 62893065601.0, 0.0 } },

    //1993-06-30 23:59:58+00:00
    test_entry{ 741484798, { -205243142816000000 }, { 62908703998000.0 }, { 62908703998.0, 0.0 } },

    //1993-06-30 23:59:59+00:00
    test_entry{ 741484799, { -205243141816000000 }, { 62908703999000.0 }, { 62908703999.0, 0.0 } },

    //1993-07-01 00:00:00+00:00
    test_entry{ 741484800, { -205243139816000000 }, { 62908704000000.0 }, { 62908704000.0, 0.0 } },

    //1993-07-01 00:00:01+00:00
    test_entry{ 741484801, { -205243138816000000 }, { 62908704001000.0 }, { 62908704001.0, 0.0 } },

    //1993-12-31 23:59:58+00:00
    test_entry{ 757382398, { -189345541816000000 }, { 62924601598000.0 }, { 62924601598.0, 0.0 } },

    //1993-12-31 23:59:59+00:00
    test_entry{ 757382399, { -189345540816000000 }, { 62924601599000.0 }, { 62924601599.0, 0.0 } },

    //1994-01-01 00:00:00+00:00
    test_entry{ 757382400, { -189345539816000000 }, { 62924601600000.0 }, { 62924601600.0, 0.0 } },

    //1994-01-01 00:00:01+00:00
    test_entry{ 757382401, { -189345538816000000 }, { 62924601601000.0 }, { 62924601601.0, 0.0 } },

    //1994-06-30 23:59:58+00:00
    test_entry{ 773020798, { -173707141816000000 }, { 62940239998000.0 }, { 62940239998.0, 0.0 } },

    //1994-06-30 23:59:59+00:00
    test_entry{ 773020799, { -173707140816000000 }, { 62940239999000.0 }, { 62940239999.0, 0.0 } },

    //1994-07-01 00:00:00+00:00
    test_entry{ 773020800, { -173707138816000000 }, { 62940240000000.0 }, { 62940240000.0, 0.0 } },

    //1994-07-01 00:00:01+00:00
    test_entry{ 773020801, { -173707137816000000 }, { 62940240001000.0 }, { 62940240001.0, 0.0 } },

    //1994-12-31 23:59:58+00:00
    test_entry{ 788918398, { -157809540816000000 }, { 62956137598000.0 }, { 62956137598.0, 0.0 } },

    //1994-12-31 23:59:59+00:00
    test_entry{ 788918399, { -157809539816000000 }, { 62956137599000.0 }, { 62956137599.0, 0.0 } },

    //1995-01-01 00:00:00+00:00
    test_entry{ 788918400, { -157809538816000000 }, { 62956137600000.0 }, { 62956137600.0, 0.0 } },

    //1995-01-01 00:00:01+00:00
    test_entry{ 788918401, { -157809537816000000 }, { 62956137601000.0 }, { 62956137601.0, 0.0 } },

    //1995-06-30 23:59:58+00:00
    test_entry{ 804556798, { -142171140816000000 }, { 62971775998000.0 }, { 62971775998.0, 0.0 } },

    //1995-06-30 23:59:59+00:00
    test_entry{ 804556799, { -142171139816000000 }, { 62971775999000.0 }, { 62971775999.0, 0.0 } },

    //1995-07-01 00:00:00+00:00
    test_entry{ 804556800, { -142171138816000000 }, { 62971776000000.0 }, { 62971776000.0, 0.0 } },

    //1995-07-01 00:00:01+00:00
    test_entry{ 804556801, { -142171137816000000 }, { 62971776001000.0 }, { 62971776001.0, 0.0 } },

    //1995-12-31 23:59:58+00:00
    test_entry{ 820454398, { -126273540816000000 }, { 62987673598000.0 }, { 62987673598.0, 0.0 } },

    //1995-12-31 23:59:59+00:00
    test_entry{ 820454399, { -126273539816000000 }, { 62987673599000.0 }, { 62987673599.0, 0.0 } },

    //1996-01-01 00:00:00+00:00
    test_entry{ 820454400, { -126273537816000000 }, { 62987673600000.0 }, { 62987673600.0, 0.0 } },

    //1996-01-01 00:00:01+00:00
    test_entry{ 820454401, { -126273536816000000 }, { 62987673601000.0 }, { 62987673601.0, 0.0 } },

    //1996-06-30 23:59:58+00:00
    test_entry{ 836179198, { -110548739816000000 }, { 63003398398000.0 }, { 63003398398.0, 0.0 } },

    //1996-06-30 23:59:59+00:00
    test_entry{ 836179199, { -110548738816000000 }, { 63003398399000.0 }, { 63003398399.0, 0.0 } },

    //1996-07-01 00:00:00+00:00
    test_entry{ 836179200, { -110548737816000000 }, { 63003398400000.0 }, { 63003398400.0, 0.0 } },

    //1996-07-01 00:00:01+00:00
    test_entry{ 836179201, { -110548736816000000 }, { 63003398401000.0 }, { 63003398401.0, 0.0 } },

    //1996-12-31 23:59:58+00:00
    test_entry{ 852076798, { -94651139816000000 }, { 63019295998000.0 }, { 63019295998.0, 0.0 } },

    //1996-12-31 23:59:59+00:00
    test_entry{ 852076799, { -94651138816000000 }, { 63019295999000.0 }, { 63019295999.0, 0.0 } },

    //1997-01-01 00:00:00+00:00
    test_entry{ 852076800, { -94651137816000000 }, { 63019296000000.0 }, { 63019296000.0, 0.0 } },

    //1997-01-01 00:00:01+00:00
    test_entry{ 852076801, { -94651136816000000 }, { 63019296001000.0 }, { 63019296001.0, 0.0 } },

    //1997-06-30 23:59:58+00:00
    test_entry{ 867715198, { -79012739816000000 }, { 63034934398000.0 }, { 63034934398.0, 0.0 } },

    //1997-06-30 23:59:59+00:00
    test_entry{ 867715199, { -79012738816000000 }, { 63034934399000.0 }, { 63034934399.0, 0.0 } },

    //1997-07-01 00:00:00+00:00
    test_entry{ 867715200, { -79012736816000000 }, { 63034934400000.0 }, { 63034934400.0, 0.0 } },

    //1997-07-01 00:00:01+00:00
    test_entry{ 867715201, { -79012735816000000 }, { 63034934401000.0 }, { 63034934401.0, 0.0 } },

    //1997-12-31 23:59:58+00:00
    test_entry{ 883612798, { -63115138816000000 }, { 63050831998000.0 }, { 63050831998.0, 0.0 } },

    //1997-12-31 23:59:59+00:00
    test_entry{ 883612799, { -63115137816000000 }, { 63050831999000.0 }, { 63050831999.0, 0.0 } },

    //1998-01-01 00:00:00+00:00
    test_entry{ 883612800, { -63115136816000000 }, { 63050832000000.0 }, { 63050832000.0, 0.0 } },

    //1998-01-01 00:00:01+00:00
    test_entry{ 883612801, { -63115135816000000 }, { 63050832001000.0 }, { 63050832001.0, 0.0 } },

    //1998-06-30 23:59:58+00:00
    test_entry{ 899251198, { -47476738816000000 }, { 63066470398000.0 }, { 63066470398.0, 0.0 } },

    //1998-06-30 23:59:59+00:00
    test_entry{ 899251199, { -47476737816000000 }, { 63066470399000.0 }, { 63066470399.0, 0.0 } },

    //1998-07-01 00:00:00+00:00
    test_entry{ 899251200, { -47476736816000000 }, { 63066470400000.0 }, { 63066470400.0, 0.0 } },

    //1998-07-01 00:00:01+00:00
    test_entry{ 899251201, { -47476735816000000 }, { 63066470401000.0 }, { 63066470401.0, 0.0 } },

    //1998-12-31 23:59:58+00:00
    test_entry{ 915148798, { -31579138816000000 }, { 63082367998000.0 }, { 63082367998.0, 0.0 } },

    //1998-12-31 23:59:59+00:00
    test_entry{ 915148799, { -31579137816000000 }, { 63082367999000.0 }, { 63082367999.0, 0.0 } },

    //1999-01-01 00:00:00+00:00
    test_entry{ 915148800, { -31579135816000000 }, { 63082368000000.0 }, { 63082368000.0, 0.0 } },

    //1999-01-01 00:00:01+00:00
    test_entry{ 915148801, { -31579134816000000 }, { 63082368001000.0 }, { 63082368001.0, 0.0 } },

    //1999-06-30 23:59:58+00:00
    test_entry{ 930787198, { -15940737816000000 }, { 63098006398000.0 }, { 63098006398.0, 0.0 } },

    //1999-06-30 23:59:59+00:00
    test_entry{ 930787199, { -15940736816000000 }, { 63098006399000.0 }, { 63098006399.0, 0.0 } },

    //1999-07-01 00:00:00+00:00
    test_entry{ 930787200, { -15940735816000000 }, { 63098006400000.0 }, { 63098006400.0, 0.0 } },

    //1999-07-01 00:00:01+00:00
    test_entry{ 930787201, { -15940734816000000 }, { 63098006401000.0 }, { 63098006401.0, 0.0 } },

    //1999-12-31 23:59:58+00:00
    test_entry{ 946684798, { -43137816000000 }, { 63113903998000.0 }, { 63113903998.0, 0.0 } },

    //1999-12-31 23:59:59+00:00
    test_entry{ 946684799, { -43136816000000 }, { 63113903999000.0 }, { 63113903999.0, 0.0 } },

    //2000-01-01 00:00:00+00:00
    test_entry{ 946684800, { -43135816000000 }, { 63113904000000.0 }, { 63113904000.0, 0.0 } },

    //2000-01-01 00:00:01+00:00
    test_entry{ 946684801, { -43134816000000 }, { 63113904001000.0 }, { 63113904001.0, 0.0 } },

    //2000-06-30 23:59:58+00:00
    test_entry{ 962409598, { 15681662184000000 }, { 63129628798000.0 }, { 63129628798.0, 0.0 } },

    //2000-06-30 23:59:59+00:00
    test_entry{ 962409599, { 15681663184000000 }, { 63129628799000.0 }, { 63129628799.0, 0.0 } },

    //2000-07-01 00:00:00+00:00
    test_entry{ 962409600, { 15681664184000000 }, { 63129628800000.0 }, { 63129628800.0, 0.0 } },

    //2000-07-01 00:00:01+00:00
    test_entry{ 962409601, { 15681665184000000 }, { 63129628801000.0 }, { 63129628801.0, 0.0 } },

    //2000-12-31 23:59:58+00:00
    test_entry{ 978307198, { 31579262184000000 }, { 63145526398000.0 }, { 63145526398.0, 0.0 } },

    //2000-12-31 23:59:59+00:00
    test_entry{ 978307199, { 31579263184000000 }, { 63145526399000.0 }, { 63145526399.0, 0.0 } },

    //2001-01-01 00:00:00+00:00
    test_entry{ 978307200, { 31579264184000000 }, { 63145526400000.0 }, { 63145526400.0, 0.0 } },

    //2001-01-01 00:00:01+00:00
    test_entry{ 978307201, { 31579265184000000 }, { 63145526401000.0 }, { 63145526401.0, 0.0 } },

    //2001-06-30 23:59:58+00:00
    test_entry{ 993945598, { 47217662184000000 }, { 63161164798000.0 }, { 63161164798.0, 0.0 } },

    //2001-06-30 23:59:59+00:00
    test_entry{ 993945599, { 47217663184000000 }, { 63161164799000.0 }, { 63161164799.0, 0.0 } },

    //2001-07-01 00:00:00+00:00
    test_entry{ 993945600, { 47217664184000000 }, { 63161164800000.0 }, { 63161164800.0, 0.0 } },

    //2001-07-01 00:00:01+00:00
    test_entry{ 993945601, { 47217665184000000 }, { 63161164801000.0 }, { 63161164801.0, 0.0 } },

    //2001-12-31 23:59:58+00:00
    test_entry{ 1009843198, { 63115262184000000 }, { 63177062398000.0 }, { 63177062398.0, 0.0 } },

    //2001-12-31 23:59:59+00:00
    test_entry{ 1009843199, { 63115263184000000 }, { 63177062399000.0 }, { 63177062399.0, 0.0 } },

    //2002-01-01 00:00:00+00:00
    test_entry{ 1009843200, { 63115264184000000 }, { 63177062400000.0 }, { 63177062400.0, 0.0 } },

    //2002-01-01 00:00:01+00:00
    test_entry{ 1009843201, { 63115265184000000 }, { 63177062401000.0 }, { 63177062401.0, 0.0 } },

    //2002-06-30 23:59:58+00:00
    test_entry{ 1025481598, { 78753662184000000 }, { 63192700798000.0 }, { 63192700798.0, 0.0 } },

    //2002-06-30 23:59:59+00:00
    test_entry{ 1025481599, { 78753663184000000 }, { 63192700799000.0 }, { 63192700799.0, 0.0 } },

    //2002-07-01 00:00:00+00:00
    test_entry{ 1025481600, { 78753664184000000 }, { 63192700800000.0 }, { 63192700800.0, 0.0 } },

    //2002-07-01 00:00:01+00:00
    test_entry{ 1025481601, { 78753665184000000 }, { 63192700801000.0 }, { 63192700801.0, 0.0 } },

    //2002-12-31 23:59:58+00:00
    test_entry{ 1041379198, { 94651262184000000 }, { 63208598398000.0 }, { 63208598398.0, 0.0 } },

    //2002-12-31 23:59:59+00:00
    test_entry{ 1041379199, { 94651263184000000 }, { 63208598399000.0 }, { 63208598399.0, 0.0 } },

    //2003-01-01 00:00:00+00:00
    test_entry{ 1041379200, { 94651264184000000 }, { 63208598400000.0 }, { 63208598400.0, 0.0 } },

    //2003-01-01 00:00:01+00:00
    test_entry{ 1041379201, { 94651265184000000 }, { 63208598401000.0 }, { 63208598401.0, 0.0 } },

    //2003-06-30 23:59:58+00:00
    test_entry{ 1057017598, { 110289662184000000 }, { 63224236798000.0 }, { 63224236798.0, 0.0 } },

    //2003-06-30 23:59:59+00:00
    test_entry{ 1057017599, { 110289663184000000 }, { 63224236799000.0 }, { 63224236799.0, 0.0 } },

    //2003-07-01 00:00:00+00:00
    test_entry{ 1057017600, { 110289664184000000 }, { 63224236800000.0 }, { 63224236800.0, 0.0 } },

    //2003-07-01 00:00:01+00:00
    test_entry{ 1057017601, { 110289665184000000 }, { 63224236801000.0 }, { 63224236801.0, 0.0 } },

    //2003-12-31 23:59:58+00:00
    test_entry{ 1072915198, { 126187262184000000 }, { 63240134398000.0 }, { 63240134398.0, 0.0 } },

    //2003-12-31 23:59:59+00:00
    test_entry{ 1072915199, { 126187263184000000 }, { 63240134399000.0 }, { 63240134399.0, 0.0 } },

    //2004-01-01 00:00:00+00:00
    test_entry{ 1072915200, { 126187264184000000 }, { 63240134400000.0 }, { 63240134400.0, 0.0 } },

    //2004-01-01 00:00:01+00:00
    test_entry{ 1072915201, { 126187265184000000 }, { 63240134401000.0 }, { 63240134401.0, 0.0 } },

    //2004-06-30 23:59:58+00:00
    test_entry{ 1088639998, { 141912062184000000 }, { 63255859198000.0 }, { 63255859198.0, 0.0 } },

    //2004-06-30 23:59:59+00:00
    test_entry{ 1088639999, { 141912063184000000 }, { 63255859199000.0 }, { 63255859199.0, 0.0 } },

    //2004-07-01 00:00:00+00:00
    test_entry{ 1088640000, { 141912064184000000 }, { 63255859200000.0 }, { 63255859200.0, 0.0 } },

    //2004-07-01 00:00:01+00:00
    test_entry{ 1088640001, { 141912065184000000 }, { 63255859201000.0 }, { 63255859201.0, 0.0 } },

    //2004-12-31 23:59:58+00:00
    test_entry{ 1104537598, { 157809662184000000 }, { 63271756798000.0 }, { 63271756798.0, 0.0 } },

    //2004-12-31 23:59:59+00:00
    test_entry{ 1104537599, { 157809663184000000 }, { 63271756799000.0 }, { 63271756799.0, 0.0 } },

    //2005-01-01 00:00:00+00:00
    test_entry{ 1104537600, { 157809664184000000 }, { 63271756800000.0 }, { 63271756800.0, 0.0 } },

    //2005-01-01 00:00:01+00:00
    test_entry{ 1104537601, { 157809665184000000 }, { 63271756801000.0 }, { 63271756801.0, 0.0 } },

    //2005-06-30 23:59:58+00:00
    test_entry{ 1120175998, { 173448062184000000 }, { 63287395198000.0 }, { 63287395198.0, 0.0 } },

    //2005-06-30 23:59:59+00:00
    test_entry{ 1120175999, { 173448063184000000 }, { 63287395199000.0 }, { 63287395199.0, 0.0 } },

    //2005-07-01 00:00:00+00:00
    test_entry{ 1120176000, { 173448064184000000 }, { 63287395200000.0 }, { 63287395200.0, 0.0 } },

    //2005-07-01 00:00:01+00:00
    test_entry{ 1120176001, { 173448065184000000 }, { 63287395201000.0 }, { 63287395201.0, 0.0 } },

    //2005-12-31 23:59:58+00:00
    test_entry{ 1136073598, { 189345662184000000 }, { 63303292798000.0 }, { 63303292798.0, 0.0 } },

    //2005-12-31 23:59:59+00:00
    test_entry{ 1136073599, { 189345663184000000 }, { 63303292799000.0 }, { 63303292799.0, 0.0 } },

    //2006-01-01 00:00:00+00:00
    test_entry{ 1136073600, { 189345665184000000 }, { 63303292800000.0 }, { 63303292800.0, 0.0 } },

    //2006-01-01 00:00:01+00:00
    test_entry{ 1136073601, { 189345666184000000 }, { 63303292801000.0 }, { 63303292801.0, 0.0 } },

    //2006-06-30 23:59:58+00:00
    test_entry{ 1151711998, { 204984063184000000 }, { 63318931198000.0 }, { 63318931198.0, 0.0 } },

    //2006-06-30 23:59:59+00:00
    test_entry{ 1151711999, { 204984064184000000 }, { 63318931199000.0 }, { 63318931199.0, 0.0 } },

    //2006-07-01 00:00:00+00:00
    test_entry{ 1151712000, { 204984065184000000 }, { 63318931200000.0 }, { 63318931200.0, 0.0 } },

    //2006-07-01 00:00:01+00:00
    test_entry{ 1151712001, { 204984066184000000 }, { 63318931201000.0 }, { 63318931201.0, 0.0 } },

    //2006-12-31 23:59:58+00:00
    test_entry{ 1167609598, { 220881663184000000 }, { 63334828798000.0 }, { 63334828798.0, 0.0 } },

    //2006-12-31 23:59:59+00:00
    test_entry{ 1167609599, { 220881664184000000 }, { 63334828799000.0 }, { 63334828799.0, 0.0 } },

    //2007-01-01 00:00:00+00:00
    test_entry{ 1167609600, { 220881665184000000 }, { 63334828800000.0 }, { 63334828800.0, 0.0 } },

    //2007-01-01 00:00:01+00:00
    test_entry{ 1167609601, { 220881666184000000 }, { 63334828801000.0 }, { 63334828801.0, 0.0 } },

    //2007-06-30 23:59:58+00:00
    test_entry{ 1183247998, { 236520063184000000 }, { 63350467198000.0 }, { 63350467198.0, 0.0 } },

    //2007-06-30 23:59:59+00:00
    test_entry{ 1183247999, { 236520064184000000 }, { 63350467199000.0 }, { 63350467199.0, 0.0 } },

    //2007-07-01 00:00:00+00:00
    test_entry{ 1183248000, { 236520065184000000 }, { 63350467200000.0 }, { 63350467200.0, 0.0 } },

    //2007-07-01 00:00:01+00:00
    test_entry{ 1183248001, { 236520066184000000 }, { 63350467201000.0 }, { 63350467201.0, 0.0 } },

    //2007-12-31 23:59:58+00:00
    test_entry{ 1199145598, { 252417663184000000 }, { 63366364798000.0 }, { 63366364798.0, 0.0 } },

    //2007-12-31 23:59:59+00:00
    test_entry{ 1199145599, { 252417664184000000 }, { 63366364799000.0 }, { 63366364799.0, 0.0 } },

    //2008-01-01 00:00:00+00:00
    test_entry{ 1199145600, { 252417665184000000 }, { 63366364800000.0 }, { 63366364800.0, 0.0 } },

    //2008-01-01 00:00:01+00:00
    test_entry{ 1199145601, { 252417666184000000 }, { 63366364801000.0 }, { 63366364801.0, 0.0 } },

    //2008-06-30 23:59:58+00:00
    test_entry{ 1214870398, { 268142463184000000 }, { 63382089598000.0 }, { 63382089598.0, 0.0 } },

    //2008-06-30 23:59:59+00:00
    test_entry{ 1214870399, { 268142464184000000 }, { 63382089599000.0 }, { 63382089599.0, 0.0 } },

    //2008-07-01 00:00:00+00:00
    test_entry{ 1214870400, { 268142465184000000 }, { 63382089600000.0 }, { 63382089600.0, 0.0 } },

    //2008-07-01 00:00:01+00:00
    test_entry{ 1214870401, { 268142466184000000 }, { 63382089601000.0 }, { 63382089601.0, 0.0 } },

    //2008-12-31 23:59:58+00:00
    test_entry{ 1230767998, { 284040063184000000 }, { 63397987198000.0 }, { 63397987198.0, 0.0 } },

    //2008-12-31 23:59:59+00:00
    test_entry{ 1230767999, { 284040064184000000 }, { 63397987199000.0 }, { 63397987199.0, 0.0 } },

    //2009-01-01 00:00:00+00:00
    test_entry{ 1230768000, { 284040066184000000 }, { 63397987200000.0 }, { 63397987200.0, 0.0 } },

    //2009-01-01 00:00:01+00:00
    test_entry{ 1230768001, { 284040067184000000 }, { 63397987201000.0 }, { 63397987201.0, 0.0 } },

    //2009-06-30 23:59:58+00:00
    test_entry{ 1246406398, { 299678464184000000 }, { 63413625598000.0 }, { 63413625598.0, 0.0 } },

    //2009-06-30 23:59:59+00:00
    test_entry{ 1246406399, { 299678465184000000 }, { 63413625599000.0 }, { 63413625599.0, 0.0 } },

    //2009-07-01 00:00:00+00:00
    test_entry{ 1246406400, { 299678466184000000 }, { 63413625600000.0 }, { 63413625600.0, 0.0 } },

    //2009-07-01 00:00:01+00:00
    test_entry{ 1246406401, { 299678467184000000 }, { 63413625601000.0 }, { 63413625601.0, 0.0 } },

    //2009-12-31 23:59:58+00:00
    test_entry{ 1262303998, { 315576064184000000 }, { 63429523198000.0 }, { 63429523198.0, 0.0 } },

    //2009-12-31 23:59:59+00:00
    test_entry{ 1262303999, { 315576065184000000 }, { 63429523199000.0 }, { 63429523199.0, 0.0 } },

    //2010-01-01 00:00:00+00:00
    test_entry{ 1262304000, { 315576066184000000 }, { 63429523200000.0 }, { 63429523200.0, 0.0 } },

    //2010-01-01 00:00:01+00:00
    test_entry{ 1262304001, { 315576067184000000 }, { 63429523201000.0 }, { 63429523201.0, 0.0 } },

    //2010-06-30 23:59:58+00:00
    test_entry{ 1277942398, { 331214464184000000 }, { 63445161598000.0 }, { 63445161598.0, 0.0 } },

    //2010-06-30 23:59:59+00:00
    test_entry{ 1277942399, { 331214465184000000 }, { 63445161599000.0 }, { 63445161599.0, 0.0 } },

    //2010-07-01 00:00:00+00:00
    test_entry{ 1277942400, { 331214466184000000 }, { 63445161600000.0 }, { 63445161600.0, 0.0 } },

    //2010-07-01 00:00:01+00:00
    test_entry{ 1277942401, { 331214467184000000 }, { 63445161601000.0 }, { 63445161601.0, 0.0 } },

    //2010-12-31 23:59:58+00:00
    test_entry{ 1293839998, { 347112064184000000 }, { 63461059198000.0 }, { 63461059198.0, 0.0 } },

    //2010-12-31 23:59:59+00:00
    test_entry{ 1293839999, { 347112065184000000 }, { 63461059199000.0 }, { 63461059199.0, 0.0 } },

    //2011-01-01 00:00:00+00:00
    test_entry{ 1293840000, { 347112066184000000 }, { 63461059200000.0 }, { 63461059200.0, 0.0 } },

    //2011-01-01 00:00:01+00:00
    test_entry{ 1293840001, { 347112067184000000 }, { 63461059201000.0 }, { 63461059201.0, 0.0 } },

    //2011-06-30 23:59:58+00:00
    test_entry{ 1309478398, { 362750464184000000 }, { 63476697598000.0 }, { 63476697598.0, 0.0 } },

    //2011-06-30 23:59:59+00:00
    test_entry{ 1309478399, { 362750465184000000 }, { 63476697599000.0 }, { 63476697599.0, 0.0 } },

    //2011-07-01 00:00:00+00:00
    test_entry{ 1309478400, { 362750466184000000 }, { 63476697600000.0 }, { 63476697600.0, 0.0 } },

    //2011-07-01 00:00:01+00:00
    test_entry{ 1309478401, { 362750467184000000 }, { 63476697601000.0 }, { 63476697601.0, 0.0 } },

    //2011-12-31 23:59:58+00:00
    test_entry{ 1325375998, { 378648064184000000 }, { 63492595198000.0 }, { 63492595198.0, 0.0 } },

    //2011-12-31 23:59:59+00:00
    test_entry{ 1325375999, { 378648065184000000 }, { 63492595199000.0 }, { 63492595199.0, 0.0 } },

    //2012-01-01 00:00:00+00:00
    test_entry{ 1325376000, { 378648066184000000 }, { 63492595200000.0 }, { 63492595200.0, 0.0 } },

    //2012-01-01 00:00:01+00:00
    test_entry{ 1325376001, { 378648067184000000 }, { 63492595201000.0 }, { 63492595201.0, 0.0 } },

    //2012-06-30 23:59:58+00:00
    test_entry{ 1341100798, { 394372864184000000 }, { 63508319998000.0 }, { 63508319998.0, 0.0 } },

    //2012-06-30 23:59:59+00:00
    test_entry{ 1341100799, { 394372865184000000 }, { 63508319999000.0 }, { 63508319999.0, 0.0 } },

    //2012-07-01 00:00:00+00:00
    test_entry{ 1341100800, { 394372867184000000 }, { 63508320000000.0 }, { 63508320000.0, 0.0 } },

    //2012-07-01 00:00:01+00:00
    test_entry{ 1341100801, { 394372868184000000 }, { 63508320001000.0 }, { 63508320001.0, 0.0 } },

    //2012-12-31 23:59:58+00:00
    test_entry{ 1356998398, { 410270465184000000 }, { 63524217598000.0 }, { 63524217598.0, 0.0 } },

    //2012-12-31 23:59:59+00:00
    test_entry{ 1356998399, { 410270466184000000 }, { 63524217599000.0 }, { 63524217599.0, 0.0 } },

    //2013-01-01 00:00:00+00:00
    test_entry{ 1356998400, { 410270467184000000 }, { 63524217600000.0 }, { 63524217600.0, 0.0 } },

    //2013-01-01 00:00:01+00:00
    test_entry{ 1356998401, { 410270468184000000 }, { 63524217601000.0 }, { 63524217601.0, 0.0 } },

    //2013-06-30 23:59:58+00:00
    test_entry{ 1372636798, { 425908865184000000 }, { 63539855998000.0 }, { 63539855998.0, 0.0 } },

    //2013-06-30 23:59:59+00:00
    test_entry{ 1372636799, { 425908866184000000 }, { 63539855999000.0 }, { 63539855999.0, 0.0 } },

    //2013-07-01 00:00:00+00:00
    test_entry{ 1372636800, { 425908867184000000 }, { 63539856000000.0 }, { 63539856000.0, 0.0 } },

    //2013-07-01 00:00:01+00:00
    test_entry{ 1372636801, { 425908868184000000 }, { 63539856001000.0 }, { 63539856001.0, 0.0 } },

    //2013-12-31 23:59:58+00:00
    test_entry{ 1388534398, { 441806465184000000 }, { 63555753598000.0 }, { 63555753598.0, 0.0 } },

    //2013-12-31 23:59:59+00:00
    test_entry{ 1388534399, { 441806466184000000 }, { 63555753599000.0 }, { 63555753599.0, 0.0 } },

    //2014-01-01 00:00:00+00:00
    test_entry{ 1388534400, { 441806467184000000 }, { 63555753600000.0 }, { 63555753600.0, 0.0 } },

    //2014-01-01 00:00:01+00:00
    test_entry{ 1388534401, { 441806468184000000 }, { 63555753601000.0 }, { 63555753601.0, 0.0 } },

    //2014-06-30 23:59:58+00:00
    test_entry{ 1404172798, { 457444865184000000 }, { 63571391998000.0 }, { 63571391998.0, 0.0 } },

    //2014-06-30 23:59:59+00:00
    test_entry{ 1404172799, { 457444866184000000 }, { 63571391999000.0 }, { 63571391999.0, 0.0 } },

    //2014-07-01 00:00:00+00:00
    test_entry{ 1404172800, { 457444867184000000 }, { 63571392000000.0 }, { 63571392000.0, 0.0 } },

    //2014-07-01 00:00:01+00:00
    test_entry{ 1404172801, { 457444868184000000 }, { 63571392001000.0 }, { 63571392001.0, 0.0 } },

    //2014-12-31 23:59:58+00:00
    test_entry{ 1420070398, { 473342465184000000 }, { 63587289598000.0 }, { 63587289598.0, 0.0 } },

    //2014-12-31 23:59:59+00:00
    test_entry{ 1420070399, { 473342466184000000 }, { 63587289599000.0 }, { 63587289599.0, 0.0 } },

    //2015-01-01 00:00:00+00:00
    test_entry{ 1420070400, { 473342467184000000 }, { 63587289600000.0 }, { 63587289600.0, 0.0 } },

    //2015-01-01 00:00:01+00:00
    test_entry{ 1420070401, { 473342468184000000 }, { 63587289601000.0 }, { 63587289601.0, 0.0 } },

    //2015-06-30 23:59:58+00:00
    test_entry{ 1435708798, { 488980865184000000 }, { 63602927998000.0 }, { 63602927998.0, 0.0 } },

    //2015-06-30 23:59:59+00:00
    test_entry{ 1435708799, { 488980866184000000 }, { 63602927999000.0 }, { 63602927999.0, 0.0 } },

    //2015-07-01 00:00:00+00:00
    test_entry{ 1435708800, { 488980868184000000 }, { 63602928000000.0 }, { 63602928000.0, 0.0 } },

    //2015-07-01 00:00:01+00:00
    test_entry{ 1435708801, { 488980869184000000 }, { 63602928001000.0 }, { 63602928001.0, 0.0 } },

    //2015-12-31 23:59:58+00:00
    test_entry{ 1451606398, { 504878466184000000 }, { 63618825598000.0 }, { 63618825598.0, 0.0 } },

    //2015-12-31 23:59:59+00:00
    test_entry{ 1451606399, { 504878467184000000 }, { 63618825599000.0 }, { 63618825599.0, 0.0 } },

    //2016-01-01 00:00:00+00:00
    test_entry{ 1451606400, { 504878468184000000 }, { 63618825600000.0 }, { 63618825600.0, 0.0 } },

    //2016-01-01 00:00:01+00:00
    test_entry{ 1451606401, { 504878469184000000 }, { 63618825601000.0 }, { 63618825601.0, 0.0 } },

    //2016-06-30 23:59:58+00:00
    test_entry{ 1467331198, { 520603266184000000 }, { 63634550398000.0 }, { 63634550398.0, 0.0 } },

    //2016-06-30 23:59:59+00:00
    test_entry{ 1467331199, { 520603267184000000 }, { 63634550399000.0 }, { 63634550399.0, 0.0 } },

    //2016-07-01 00:00:00+00:00
    test_entry{ 1467331200, { 520603268184000000 }, { 63634550400000.0 }, { 63634550400.0, 0.0 } },

    //2016-07-01 00:00:01+00:00
    test_entry{ 1467331201, { 520603269184000000 }, { 63634550401000.0 }, { 63634550401.0, 0.0 } },

    //2016-12-31 23:59:58+00:00
    test_entry{ 1483228798, { 536500866184000000 }, { 63650447998000.0 }, { 63650447998.0, 0.0 } },

    //2016-12-31 23:59:59+00:00
    test_entry{ 1483228799, { 536500867184000000 }, { 63650447999000.0 }, { 63650447999.0, 0.0 } },

    //2017-01-01 00:00:00+00:00
    test_entry{ 1483228800, { 536500869184000000 }, { 63650448000000.0 }, { 63650448000.0, 0.0 } },

    //2017-01-01 00:00:01+00:00
    test_entry{ 1483228801, { 536500870184000000 }, { 63650448001000.0 }, { 63650448001.0, 0.0 } },

    //2017-06-30 23:59:58+00:00
    test_entry{ 1498867198, { 552139267184000000 }, { 63666086398000.0 }, { 63666086398.0, 0.0 } },

    //2017-06-30 23:59:59+00:00
    test_entry{ 1498867199, { 552139268184000000 }, { 63666086399000.0 }, { 63666086399.0, 0.0 } },

    //2017-07-01 00:00:00+00:00
    test_entry{ 1498867200, { 552139269184000000 }, { 63666086400000.0 }, { 63666086400.0, 0.0 } },

    //2017-07-01 00:00:01+00:00
    test_entry{ 1498867201, { 552139270184000000 }, { 63666086401000.0 }, { 63666086401.0, 0.0 } },

    //2017-12-31 23:59:58+00:00
    test_entry{ 1514764798, { 568036867184000000 }, { 63681983998000.0 }, { 63681983998.0, 0.0 } },

    //2017-12-31 23:59:59+00:00
    test_entry{ 1514764799, { 568036868184000000 }, { 63681983999000.0 }, { 63681983999.0, 0.0 } },

    //2018-01-01 00:00:00+00:00
    test_entry{ 1514764800, { 568036869184000000 }, { 63681984000000.0 }, { 63681984000.0, 0.0 } },

    //2018-01-01 00:00:01+00:00
    test_entry{ 1514764801, { 568036870184000000 }, { 63681984001000.0 }, { 63681984001.0, 0.0 } },

    //2018-06-30 23:59:58+00:00
    test_entry{ 1530403198, { 583675267184000000 }, { 63697622398000.0 }, { 63697622398.0, 0.0 } },

    //2018-06-30 23:59:59+00:00
    test_entry{ 1530403199, { 583675268184000000 }, { 63697622399000.0 }, { 63697622399.0, 0.0 } },

    //2018-07-01 00:00:00+00:00
    test_entry{ 1530403200, { 583675269184000000 }, { 63697622400000.0 }, { 63697622400.0, 0.0 } },

    //2018-07-01 00:00:01+00:00
    test_entry{ 1530403201, { 583675270184000000 }, { 63697622401000.0 }, { 63697622401.0, 0.0 } },

    //2018-12-31 23:59:58+00:00
    test_entry{ 1546300798, { 599572867184000000 }, { 63713519998000.0 }, { 63713519998.0, 0.0 } },

    //2018-12-31 23:59:59+00:00
    test_entry{ 1546300799, { 599572868184000000 }, { 63713519999000.0 }, { 63713519999.0, 0.0 } },

    //2019-01-01 00:00:00+00:00
    test_entry{ 1546300800, { 599572869184000000 }, { 63713520000000.0 }, { 63713520000.0, 0.0 } },

    //2019-01-01 00:00:01+00:00
    test_entry{ 1546300801, { 599572870184000000 }, { 63713520001000.0 }, { 63713520001.0, 0.0 } },

    //2019-06-30 23:59:58+00:00
    test_entry{ 1561939198, { 615211267184000000 }, { 63729158398000.0 }, { 63729158398.0, 0.0 } },

    //2019-06-30 23:59:59+00:00
    test_entry{ 1561939199, { 615211268184000000 }, { 63729158399000.0 }, { 63729158399.0, 0.0 } },

    //2019-07-01 00:00:00+00:00
    test_entry{ 1561939200, { 615211269184000000 }, { 63729158400000.0 }, { 63729158400.0, 0.0 } },

    //2019-07-01 00:00:01+00:00
    test_entry{ 1561939201, { 615211270184000000 }, { 63729158401000.0 }, { 63729158401.0, 0.0 } },
};
