# coding: utf-8

"""
    Scheduling (Alpha)

    No description provided (generated API client)  # noqa: E501

    OpenAPI spec version: v2024.14.0
    
    Generated API client
"""

from __future__ import absolute_import

import copy
import logging
import multiprocessing
import sys
import urllib3
import os
from dotenv import load_dotenv
import six
import http.client as httplib
import json
# Import OAuth2 handler
try:
    from .api.oauth2_handler import OAuth2Handler
except ImportError:
    OAuth2Handler = None

load_dotenv()


class TypeWithDefault(type):
    def __init__(cls, name, bases, dct):
        super(TypeWithDefault, cls).__init__(name, bases, dct)
        cls._default = None

    def __call__(cls):
        if cls._default is None:
            cls._default = type.__call__(cls)
        return copy.copy(cls._default)

    def set_default(cls, default):
        cls._default = copy.copy(default)


class Configuration(six.with_metaclass(TypeWithDefault, object)):
    """NOTE: This class is auto generated by the API code generator program.

    Do not edit the class manually.
    """

    def __init__(self):
        """Constructor"""
        # Default Base url
        self.host = os.getenv("OPENONE_API_BASE_URL", "https://api.eu1.alteryxcloud.com")
        # Default Legacy Base url which is the host api without 'api.'
        self.legacy_host = self.host.replace("api.", "")
        self.token_endpoint = os.getenv("OPENONE_TOKEN_ENDPOINT", "https://pingauth-eu1.alteryxcloud.com/as")
        self.refresh_endpoint = self.token_endpoint + "/token"
        self.client_id = os.getenv("OPENONE_CLIENT_ID", "Your Client ID")
        self.access_token = os.getenv("OPENONE_ACCESS_TOKEN", "Your Access Token")
        self.refresh_token = os.getenv("OPENONE_REFRESH_TOKEN", "Your Refresh Token")
        self.persitent_folder = os.getenv("OPENONE_PERSISTENT_FOLDER", "~/.aacp")
        
        # Authentication Settings
        # dict to store API key(s)
        self.api_key = {}
        # dict to store API prefix (e.g. Bearer)
        self.api_key_prefix = {}
  
        
        # Logging Settings
        self.logger = {}
        self.logger["package_logger"] = logging.getLogger("openone_client")
        self.logger["urllib3_logger"] = logging.getLogger("urllib3")
        # Log format
        self.logger_format = '%(asctime)s %(levelname)s %(message)s'
        # Log stream handler
        self.logger_stream_handler = None
        # Log file handler
        self.logger_file_handler = None
        # Debug file location
        self.logger_file = None
        # Debug switch
        self.debug = False

        # SSL/TLS verification
        # Set this to false to skip verifying SSL certificate when calling API
        # from https server.
        self.verify_ssl = os.getenv("OPENONE_VERIFY_SSL", "1").lower() not in ("0", "false", "no")
        # Set this to customize the certificate file to verify the peer.
        self.ssl_ca_cert = None
        # client certificate file
        self.cert_file = None
        # client key file
        self.key_file = None
        # Set this to True/False to enable/disable SSL hostname verification.
        self.assert_hostname = None

        # urllib3 connection pool's maximum number of connections saved
        # per pool. urllib3 uses 1 connection as default value, but this is
        # not the best value when you are making a lot of possibly parallel
        # requests to the same host, which is often the case here.
        # cpu_count * 5 is used as default value to increase performance.
        self.connection_pool_maxsize = multiprocessing.cpu_count() * 5

        # Proxy URL
        self.proxy = None
        # Safe chars for path_param
        self.safe_chars_for_path_param = ''

        # Normalize the persistent folder path
        self.persitent_folder = os.path.expanduser(self.persitent_folder)

        # Create a file in the persistent folder to store the client id and project id
        if not os.path.exists(self.persitent_folder):
            os.mkdir(self.persitent_folder)
        self.config_file = os.path.join(self.persitent_folder, "config.json")

        need_to_update = False
        # If the config file exists, load the client id and project id from it
        if os.path.exists(self.config_file):
            with open(self.config_file, "r") as f:
                config = json.load(f)
            self.client_id = config["client_id"]
            self.access_token = config["access_token"]
            self.refresh_token = config["refresh_token"]
            self.host = config["host"]
            self.token_endpoint = config["token_endpoint"]
            self.refresh_endpoint = config["refresh_endpoint"]
            self.verify_ssl = config["verify_ssl"]
            self.original_client_id = config["original_client_id"] if "original_client_id" in config else None
            self.original_access_token = config["original_access_token"] if "original_access_token" in config else None
            self.original_refresh_token = config["original_refresh_token"] if "original_refresh_token" in config else None
            need_to_update = self.original_client_id != self.client_id or self.original_refresh_token != self.refresh_token

        # If the config file does not exist, create it
        if not os.path.exists(self.config_file) or need_to_update:
            with open(self.config_file, "w") as f:
                json.dump(
                    {
                        "client_id": self.client_id,
                        "access_token": self.access_token, 
                        "refresh_token": self.refresh_token,
                        "original_client_id": self.client_id,
                        "original_access_token": self.access_token,
                        "original_refresh_token": self.refresh_token,
                        "host": self.host, 
                        "token_endpoint": self.token_endpoint, 
                        "refresh_endpoint": self.refresh_endpoint, 
                        "verify_ssl": self.verify_ssl,
                        }, f)

        # OAuth2 Settings
        self.oauth2_handler = OAuth2Handler(
            configuration_file_path=self.config_file,
            expires_in=3600
        )

        # Set up automatic token refresh hook
        self.refresh_api_key_hook = self._refresh_oauth2_token

    @property
    def logger_file(self):
        """The logger file.

        If the logger_file is None, then add stream handler and remove file
        handler. Otherwise, add file handler and remove stream handler.

        :param value: The logger_file path.
        :type: str
        """
        return self.__logger_file

    @logger_file.setter
    def logger_file(self, value):
        """The logger file.

        If the logger_file is None, then add stream handler and remove file
        handler. Otherwise, add file handler and remove stream handler.

        :param value: The logger_file path.
        :type: str
        """
        self.__logger_file = value
        if self.__logger_file:
            # If set logging file,
            # then add file handler and remove stream handler.
            self.logger_file_handler = logging.FileHandler(self.__logger_file)
            self.logger_file_handler.setFormatter(self.logger_formatter)
            for _, logger in six.iteritems(self.logger):
                logger.addHandler(self.logger_file_handler)
                if self.logger_stream_handler:
                    logger.removeHandler(self.logger_stream_handler)
        else:
            # If not set logging file,
            # then add stream handler and remove file handler.
            self.logger_stream_handler = logging.StreamHandler()
            self.logger_stream_handler.setFormatter(self.logger_formatter)
            for _, logger in six.iteritems(self.logger):
                logger.addHandler(self.logger_stream_handler)
                if self.logger_file_handler:
                    logger.removeHandler(self.logger_file_handler)

    @property
    def debug(self):
        """Debug status

        :param value: The debug status, True or False.
        :type: bool
        """
        return self.__debug

    @debug.setter
    def debug(self, value):
        """Debug status

        :param value: The debug status, True or False.
        :type: bool
        """
        self.__debug = value
        if self.__debug:
            # if debug status is True, turn on debug logging
            for _, logger in six.iteritems(self.logger):
                logger.setLevel(logging.DEBUG)
            # turn on httplib debug
            httplib.HTTPConnection.debuglevel = 1
        else:
            # if debug status is False, turn off debug logging,
            # setting log level to default `logging.WARNING`
            for _, logger in six.iteritems(self.logger):
                logger.setLevel(logging.WARNING)
            # turn off httplib debug
            httplib.HTTPConnection.debuglevel = 0

    @property
    def logger_format(self):
        """The logger format.

        The logger_formatter will be updated when sets logger_format.

        :param value: The format string.
        :type: str
        """
        return self.__logger_format

    @logger_format.setter
    def logger_format(self, value):
        """The logger format.

        The logger_formatter will be updated when sets logger_format.

        :param value: The format string.
        :type: str
        """
        self.__logger_format = value
        self.logger_formatter = logging.Formatter(self.__logger_format)

    
    def _refresh_oauth2_token(self, config):
        """
        Internal method to refresh OAuth2 token.
        
        :param config: Configuration instance
        """
        if self.oauth2_handler and self.oauth2_handler.is_token_expired():
            self.oauth2_handler.refresh_access_token()
        
        # Set the new access token in the configuration
        self.access_token = self.oauth2_handler.get_access_token()
        self.refresh_token = self.oauth2_handler.get_refresh_token()
        self.logger["package_logger"].info("OAuth2 token refreshed")
    

    def get_api_key_with_prefix(self, identifier):
        """Gets API key (with prefix if set).

        :param identifier: The identifier of apiKey.
        :return: The token for api key authentication.
        """
        # Fall back to original API key logic
        if self.refresh_api_key_hook:
            self.refresh_api_key_hook(self)

        key = self.api_key.get(identifier)
        if key:
            prefix = self.api_key_prefix.get(identifier)
            if prefix:
                return "%s %s" % (prefix, key)
            else:
                return key

    def get_basic_auth_token(self):
        """Gets HTTP basic authentication header (string).

        :return: The token for basic HTTP authentication.
        """
        token = ""
        if self.username or self.password:
            token = urllib3.util.make_headers(
                basic_auth=self.username + ':' + self.password
            ).get('authorization')
        return token

    def auth_settings(self):
        """Gets Auth Settings dict for api client.

        :return: The Auth Settings information dict.
        """

        # Fall back to original API key logic
        if self.refresh_api_key_hook:
            self.refresh_api_key_hook(self)

        auth_settings = {}
        
        # Add OAuth2 Bearer token authentication if configured
        if self.oauth2_handler:
            auth_settings['Bearer'] = {
                'type': 'oauth2',
                'in': 'header',
                'name': 'Authorization',
                'key': 'Authorization',
                'value': "Bearer " + self.oauth2_handler.get_access_token()
            }
        
        return auth_settings

    def to_debug_report(self):
        """Gets the essential information for debugging.

        :return: The report for debugging.
        """
        return "Python SDK Debug Report:\n"\
               "OS: {env}\n"\
               "Python Version: {pyversion}\n"\
               "Version of the API: v2024.14.0\n"\
               "SDK Package Version: 1.0.0".\
               format(env=sys.platform, pyversion=sys.version)
