# coding: utf-8

"""
    Identity and Access Managment (IAM) (Alpha)

 

    OpenAPI spec version: v2024.14.0
     
"""

import pprint
import re  # noqa: F401

import six

class PersonReadResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'email': 'str',
        'is_disabled': 'bool',
        'state': 'str',
        'validate_export_compliance': 'bool',
        'id': 'AnyOfpersonReadResponseId',
        'output_home_dir': 'str',
        'upload_dir': 'str',
        'last_login_time': 'datetime',
        'last_state_change': 'datetime',
        'maximal_privileges': 'list[Privilege]'
    }

    attribute_map = {
        'email': 'email',
        'is_disabled': 'isDisabled',
        'state': 'state',
        'validate_export_compliance': 'validateExportCompliance',
        'id': 'id',
        'output_home_dir': 'outputHomeDir',
        'upload_dir': 'uploadDir',
        'last_login_time': 'lastLoginTime',
        'last_state_change': 'lastStateChange',
        'maximal_privileges': 'maximalPrivileges'
    }

    def __init__(self, email=None, is_disabled=None, state=None, validate_export_compliance=None, id=None, output_home_dir=None, upload_dir=None, last_login_time=None, last_state_change=None, maximal_privileges=None):  # noqa: E501
        """PersonReadResponse - a model defined in Swagger"""  # noqa: E501
        self._email = None
        self._is_disabled = None
        self._state = None
        self._validate_export_compliance = None
        self._id = None
        self._output_home_dir = None
        self._upload_dir = None
        self._last_login_time = None
        self._last_state_change = None
        self._maximal_privileges = None
        self.discriminator = None
        if email is not None:
            self.email = email
        if is_disabled is not None:
            self.is_disabled = is_disabled
        if state is not None:
            self.state = state
        if validate_export_compliance is not None:
            self.validate_export_compliance = validate_export_compliance
        self.id = id
        if output_home_dir is not None:
            self.output_home_dir = output_home_dir
        if upload_dir is not None:
            self.upload_dir = upload_dir
        if last_login_time is not None:
            self.last_login_time = last_login_time
        if last_state_change is not None:
            self.last_state_change = last_state_change
        if maximal_privileges is not None:
            self.maximal_privileges = maximal_privileges

    @property
    def email(self):
        """Gets the email of this PersonReadResponse.  # noqa: E501


        :return: The email of this PersonReadResponse.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this PersonReadResponse.


        :param email: The email of this PersonReadResponse.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def is_disabled(self):
        """Gets the is_disabled of this PersonReadResponse.  # noqa: E501

        If true, the account is disabled. This property can only be changed by an admin account.  # noqa: E501

        :return: The is_disabled of this PersonReadResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_disabled

    @is_disabled.setter
    def is_disabled(self, is_disabled):
        """Sets the is_disabled of this PersonReadResponse.

        If true, the account is disabled. This property can only be changed by an admin account.  # noqa: E501

        :param is_disabled: The is_disabled of this PersonReadResponse.  # noqa: E501
        :type: bool
        """

        self._is_disabled = is_disabled

    @property
    def state(self):
        """Gets the state of this PersonReadResponse.  # noqa: E501

        Current state of the user account. This property can only be changed by an admin account. * `active` - User is active and usable in the workspace * `hidden` - User cannot access the workspace. User's data remains.  # noqa: E501

        :return: The state of this PersonReadResponse.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this PersonReadResponse.

        Current state of the user account. This property can only be changed by an admin account. * `active` - User is active and usable in the workspace * `hidden` - User cannot access the workspace. User's data remains.  # noqa: E501

        :param state: The state of this PersonReadResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["active", "hidden"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def validate_export_compliance(self):
        """Gets the validate_export_compliance of this PersonReadResponse.  # noqa: E501

        When true, the user is subject to an export compliance check when they register.  # noqa: E501

        :return: The validate_export_compliance of this PersonReadResponse.  # noqa: E501
        :rtype: bool
        """
        return self._validate_export_compliance

    @validate_export_compliance.setter
    def validate_export_compliance(self, validate_export_compliance):
        """Sets the validate_export_compliance of this PersonReadResponse.

        When true, the user is subject to an export compliance check when they register.  # noqa: E501

        :param validate_export_compliance: The validate_export_compliance of this PersonReadResponse.  # noqa: E501
        :type: bool
        """

        self._validate_export_compliance = validate_export_compliance

    @property
    def id(self):
        """Gets the id of this PersonReadResponse.  # noqa: E501


        :return: The id of this PersonReadResponse.  # noqa: E501
        :rtype: AnyOfpersonReadResponseId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PersonReadResponse.


        :param id: The id of this PersonReadResponse.  # noqa: E501
        :type: AnyOfpersonReadResponseId
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def output_home_dir(self):
        """Gets the output_home_dir of this PersonReadResponse.  # noqa: E501

        Home directory where the user's generated results are written  # noqa: E501

        :return: The output_home_dir of this PersonReadResponse.  # noqa: E501
        :rtype: str
        """
        return self._output_home_dir

    @output_home_dir.setter
    def output_home_dir(self, output_home_dir):
        """Sets the output_home_dir of this PersonReadResponse.

        Home directory where the user's generated results are written  # noqa: E501

        :param output_home_dir: The output_home_dir of this PersonReadResponse.  # noqa: E501
        :type: str
        """

        self._output_home_dir = output_home_dir

    @property
    def upload_dir(self):
        """Gets the upload_dir of this PersonReadResponse.  # noqa: E501

        Path on backend datastore where files uploaded from the user's desktop are stored for use as imported datasets.  # noqa: E501

        :return: The upload_dir of this PersonReadResponse.  # noqa: E501
        :rtype: str
        """
        return self._upload_dir

    @upload_dir.setter
    def upload_dir(self, upload_dir):
        """Sets the upload_dir of this PersonReadResponse.

        Path on backend datastore where files uploaded from the user's desktop are stored for use as imported datasets.  # noqa: E501

        :param upload_dir: The upload_dir of this PersonReadResponse.  # noqa: E501
        :type: str
        """

        self._upload_dir = upload_dir

    @property
    def last_login_time(self):
        """Gets the last_login_time of this PersonReadResponse.  # noqa: E501

        Timestamp for when the user last logged in to the product.  # noqa: E501

        :return: The last_login_time of this PersonReadResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_login_time

    @last_login_time.setter
    def last_login_time(self, last_login_time):
        """Sets the last_login_time of this PersonReadResponse.

        Timestamp for when the user last logged in to the product.  # noqa: E501

        :param last_login_time: The last_login_time of this PersonReadResponse.  # noqa: E501
        :type: datetime
        """

        self._last_login_time = last_login_time

    @property
    def last_state_change(self):
        """Gets the last_state_change of this PersonReadResponse.  # noqa: E501

        Timestamp for when the value of the state parameter was changed.  # noqa: E501

        :return: The last_state_change of this PersonReadResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_state_change

    @last_state_change.setter
    def last_state_change(self, last_state_change):
        """Sets the last_state_change of this PersonReadResponse.

        Timestamp for when the value of the state parameter was changed.  # noqa: E501

        :param last_state_change: The last_state_change of this PersonReadResponse.  # noqa: E501
        :type: datetime
        """

        self._last_state_change = last_state_change

    @property
    def maximal_privileges(self):
        """Gets the maximal_privileges of this PersonReadResponse.  # noqa: E501

        List of the maximal privileges that this subject possesses  # noqa: E501

        :return: The maximal_privileges of this PersonReadResponse.  # noqa: E501
        :rtype: list[Privilege]
        """
        return self._maximal_privileges

    @maximal_privileges.setter
    def maximal_privileges(self, maximal_privileges):
        """Sets the maximal_privileges of this PersonReadResponse.

        List of the maximal privileges that this subject possesses  # noqa: E501

        :param maximal_privileges: The maximal_privileges of this PersonReadResponse.  # noqa: E501
        :type: list[Privilege]
        """

        self._maximal_privileges = maximal_privileges

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PersonReadResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PersonReadResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
