# coding: utf-8

"""
    Identity and Access Managment (IAM) (Alpha)

 

    OpenAPI spec version: v2024.14.0
     
"""

import pprint
import re  # noqa: F401

import six

class Workspace(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'tier': 'str',
        'state': 'str',
        'last_state_change': 'datetime',
        'custom_url': 'str',
        'max_user_number': 'int',
        'emrcluster': 'WorkspaceEmrcluster',
        'id': 'AnyOfworkspaceId',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'user_count': 'int',
        'workspacetiers': 'AnyOfworkspaceWorkspacetiers',
        'gid': 'str'
    }

    attribute_map = {
        'name': 'name',
        'tier': 'tier',
        'state': 'state',
        'last_state_change': 'lastStateChange',
        'custom_url': 'custom_url',
        'max_user_number': 'max_user_number',
        'emrcluster': 'emrcluster',
        'id': 'id',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'user_count': 'userCount',
        'workspacetiers': 'workspacetiers',
        'gid': 'gid'
    }

    def __init__(self, name=None, tier=None, state=None, last_state_change=None, custom_url=None, max_user_number=None, emrcluster=None, id=None, created_at=None, updated_at=None, user_count=None, workspacetiers=None, gid=None):  # noqa: E501
        """Workspace - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._tier = None
        self._state = None
        self._last_state_change = None
        self._custom_url = None
        self._max_user_number = None
        self._emrcluster = None
        self._id = None
        self._created_at = None
        self._updated_at = None
        self._user_count = None
        self._workspacetiers = None
        self._gid = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if tier is not None:
            self.tier = tier
        if state is not None:
            self.state = state
        if last_state_change is not None:
            self.last_state_change = last_state_change
        if custom_url is not None:
            self.custom_url = custom_url
        if max_user_number is not None:
            self.max_user_number = max_user_number
        if emrcluster is not None:
            self.emrcluster = emrcluster
        self.id = id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if user_count is not None:
            self.user_count = user_count
        if workspacetiers is not None:
            self.workspacetiers = workspacetiers
        if gid is not None:
            self.gid = gid

    @property
    def name(self):
        """Gets the name of this Workspace.  # noqa: E501

        Workspace name  # noqa: E501

        :return: The name of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Workspace.

        Workspace name  # noqa: E501

        :param name: The name of this Workspace.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def tier(self):
        """Gets the tier of this Workspace.  # noqa: E501


        :return: The tier of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._tier

    @tier.setter
    def tier(self, tier):
        """Sets the tier of this Workspace.


        :param tier: The tier of this Workspace.  # noqa: E501
        :type: str
        """
        allowed_values = ["free", "pro", "none", "legacy", "standard", "premium", "standard-free", "starter", "professional", "professional_trial", "enterprise_cloud", "enterprise_cloud_trial", "starter22", "professional22", "enterprise_cloud22", "enterprise_cloud22_trial", "looker_freemium", "platform_packaging"]  # noqa: E501
        if tier not in allowed_values:
            raise ValueError(
                "Invalid value for `tier` ({0}), must be one of {1}"  # noqa: E501
                .format(tier, allowed_values)
            )

        self._tier = tier

    @property
    def state(self):
        """Gets the state of this Workspace.  # noqa: E501


        :return: The state of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Workspace.


        :param state: The state of this Workspace.  # noqa: E501
        :type: str
        """
        allowed_values = ["active", "hidden", "pending_purge"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def last_state_change(self):
        """Gets the last_state_change of this Workspace.  # noqa: E501


        :return: The last_state_change of this Workspace.  # noqa: E501
        :rtype: datetime
        """
        return self._last_state_change

    @last_state_change.setter
    def last_state_change(self, last_state_change):
        """Sets the last_state_change of this Workspace.


        :param last_state_change: The last_state_change of this Workspace.  # noqa: E501
        :type: datetime
        """

        self._last_state_change = last_state_change

    @property
    def custom_url(self):
        """Gets the custom_url of this Workspace.  # noqa: E501

        Workspace URL  # noqa: E501

        :return: The custom_url of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._custom_url

    @custom_url.setter
    def custom_url(self, custom_url):
        """Sets the custom_url of this Workspace.

        Workspace URL  # noqa: E501

        :param custom_url: The custom_url of this Workspace.  # noqa: E501
        :type: str
        """

        self._custom_url = custom_url

    @property
    def max_user_number(self):
        """Gets the max_user_number of this Workspace.  # noqa: E501

        Maximum number of users for the workspace  # noqa: E501

        :return: The max_user_number of this Workspace.  # noqa: E501
        :rtype: int
        """
        return self._max_user_number

    @max_user_number.setter
    def max_user_number(self, max_user_number):
        """Sets the max_user_number of this Workspace.

        Maximum number of users for the workspace  # noqa: E501

        :param max_user_number: The max_user_number of this Workspace.  # noqa: E501
        :type: int
        """

        self._max_user_number = max_user_number

    @property
    def emrcluster(self):
        """Gets the emrcluster of this Workspace.  # noqa: E501


        :return: The emrcluster of this Workspace.  # noqa: E501
        :rtype: WorkspaceEmrcluster
        """
        return self._emrcluster

    @emrcluster.setter
    def emrcluster(self, emrcluster):
        """Sets the emrcluster of this Workspace.


        :param emrcluster: The emrcluster of this Workspace.  # noqa: E501
        :type: WorkspaceEmrcluster
        """

        self._emrcluster = emrcluster

    @property
    def id(self):
        """Gets the id of this Workspace.  # noqa: E501


        :return: The id of this Workspace.  # noqa: E501
        :rtype: AnyOfworkspaceId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Workspace.


        :param id: The id of this Workspace.  # noqa: E501
        :type: AnyOfworkspaceId
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this Workspace.  # noqa: E501

        The time this object was first created.  # noqa: E501

        :return: The created_at of this Workspace.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Workspace.

        The time this object was first created.  # noqa: E501

        :param created_at: The created_at of this Workspace.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Workspace.  # noqa: E501

        The time this object was last updated.  # noqa: E501

        :return: The updated_at of this Workspace.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Workspace.

        The time this object was last updated.  # noqa: E501

        :param updated_at: The updated_at of this Workspace.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def user_count(self):
        """Gets the user_count of this Workspace.  # noqa: E501


        :return: The user_count of this Workspace.  # noqa: E501
        :rtype: int
        """
        return self._user_count

    @user_count.setter
    def user_count(self, user_count):
        """Sets the user_count of this Workspace.


        :param user_count: The user_count of this Workspace.  # noqa: E501
        :type: int
        """

        self._user_count = user_count

    @property
    def workspacetiers(self):
        """Gets the workspacetiers of this Workspace.  # noqa: E501


        :return: The workspacetiers of this Workspace.  # noqa: E501
        :rtype: AnyOfworkspaceWorkspacetiers
        """
        return self._workspacetiers

    @workspacetiers.setter
    def workspacetiers(self, workspacetiers):
        """Sets the workspacetiers of this Workspace.


        :param workspacetiers: The workspacetiers of this Workspace.  # noqa: E501
        :type: AnyOfworkspaceWorkspacetiers
        """

        self._workspacetiers = workspacetiers

    @property
    def gid(self):
        """Gets the gid of this Workspace.  # noqa: E501

        Workspace ULID  # noqa: E501

        :return: The gid of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this Workspace.

        Workspace ULID  # noqa: E501

        :param gid: The gid of this Workspace.  # noqa: E501
        :type: str
        """

        self._gid = gid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Workspace, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Workspace):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
