# coding: utf-8

# flake8: noqa
"""
    Alteryx Analytics Cloud API

      # Overview  To enable programmatic control over its objects, the Alteryx Analytics Cloud Platform supports a range of REST API endpoints across its objects. This section provides an overview of the API design, methods, and supported use cases.  Most of the endpoints accept `JSON` as input and return `JSON` responses. This means that you must usually add the following headers to your request: ``` Content-type: application/json Accept: application/json ```    <small><!--__VERSION__--></small>  ## Resources  The term `resource` refers to a single type of object in the Alteryx Analytics Cloud Platform metadata. An API is broken up by its endpoint's corresponding resource. The name of a resource is typically plural, and expressed in camelCase. Example: `jobGroups`.  Resource names are used as part of endpoint URLs, as well as in API parameters and responses.  ## CRUD Operations  The platform supports **C**reate, **R**ead, **U**pdate, and **D**elete operations on most resources.  You can review the standards for these operations and their standard parameters below.  Some endpoints have special behavior as exceptions.  ### Create  To create a resource, you typically submit an HTTP `POST` request with the resource's required metadata in the request body. The response returns a `201 Created` response code upon success with the resource's metadata, including its internal `id`, in the response body.  ### Read  An HTTP `GET` request can be used to read a resource or to list a number of resources.  A resource's `id` can be submitted in the request parameters to read a specific resource. The response usually returns a `200 OK` response code upon success, with the resource's metadata in the response body.  If a `GET` request does not include a specific resource `id`, it is treated as a list request. The response usually returns a `200 OK` response code upon success, with an object containing a list of resources' metadata in the response body.   When reading resources, some common query parameters are usually available. e.g.: ``` /v4/jobGroups?limit=100&includeDeleted=true&embed=jobs ```  |Query Parameter|Type|Description| |---------------|----|-----------| |embed|string|Comma-separated list of objects to include part of the response. See [Embedding resources](#section/Overview/Embedding-Resources).| |includeDeleted|string|If set to `true`, response includes deleted objects.| |limit|integer|Maximum number of objects to fetch. Usually 25 by default| |offset|integer|Offset after which to start returning objects. For use with limit query parameter.|  ### Update  Updating a resource requires the resource `id`, and is typically done using an HTTP `PUT` or `PATCH` request, with the fields to modify in the request body. The response usually returns a `200 OK` response code upon success, with minimal information about the modified resource in the response body.  ### Delete  Deleting a resource requires the resource `id` and is typically executing via an HTTP `DELETE` request. The response usually returns a `204 No Content` response code upon success.  ## Conventions - Resource names are plural and expressed in camelCase. - Resource names are consistent between main URL and URL parameter.  - Parameter lists are consistently enveloped in the following manner: ``` { \"data\": [{ ... }] } ```  - Field names are in camelCase and are consistent with the resource name in the URL or with the embed URL parameter. ``` \"creator\": { \"id\": 1 }, \"updater\": { \"id\": 2 }, ```  ## Embedding Resources  When reading a resource, the platform supports an `embed` query parameter for most resources, which allows the caller to ask for associated resources in the response. Use of this parameter requires knowledge of how different resources are related to each other and is suggested for advanced users only.  In the following example, the sub-jobs of a [jobGroup](#tag/JobGroup) are embedded in the response for jobGroup=1:  ``` https://us1.alteryxcloud.com/v4/jobGroups/1?embed=jobs ```  If you provide an invalid embedding, you will get an error message. The response will contain the list of possible resources that can be embedded. e.g. ``` https://us1.alteryxcloud.com/v4/jobGroups/1?embed=* ```  Example error: ``` {   \"exception\": {     \"name\": \"ValidationFailed\",     \"message\": \"Input validation failed\",     \"details\": \"No association * in flows! Valid associations are creator, updater, snapshots...\"   } } ```  ### Fields  It is possible to let the application know that you need fewer data to improve the performance of the endpoints using the `fields` query parameter. e.g. ``` https://us1.alteryxcloud.com/v4/flows?fields=id;name ```  The list of fields need to be separated by semi-colons `;`. Note that the application might sometimes return more fields than requested.  You can also use it while embedding resources. ``` https://us1.alteryxcloud.com/v4/flows?fields=id;name&embed=flownodes(fields=id) ```  ### Limit and sorting You can limit and sort the number of embedded resources for some associations. e.g. ``` https://us1.alteryxcloud.com/v4/flows?fields=id&embed=flownodes(limit=1,fields=id,sort=-id) ```  Note that not all association support this. An error is returned when it is not possible to limit the number of embedded results.  ## Errors The Alteryx Analytics Cloud Platform uses HTTP response codes to indicate the success or failure of an API request.  - Codes in the 2xx range indicate success.  - Codes in the 4xx range indicate that the information provided is invalid (invalid parameters, missing permissions, etc.) - Codes in the 5xx range indicate an error on the servers. These are rare and should usually go away when retrying. If you experience a lot of 5xx errors, contact support.   |HTTP Status Code (client errors)|Notes| |--------------------------------|-----| |400 Bad Request |Potential reasons: <ul><li>Resource doesn't exist</li><li>Request is incorrectly formatted</li><li>Request contains invalid values</li></ul> | |403 Forbidden   |Incorrect permissions to access the Resource.| |404 Not Found   |Resource cannot be found.| |410 Gone        |Resource has been previously deleted.| |415 Unsupported Media Type|Incorrect `Accept` or `Content-type` header|   ## Request Ids  Each request has a request identifier, which can be found in the response headers, in the following form: ``` x-trifacta-request-id: <myRequestId> ```  > ℹ️ **NOTE**: If you have an issue with a specific request, please include the `x-trifacta-request-id` value when you contact support    ## Versioning and Endpoint Lifecycle  - API versioning is not synchronized to specific releases of the platform.  - APIs are designed to be backward compatible. - Any changes to the API will first go through a deprecation phase.  ## Rate limiting  The Alteryx Analytics Cloud Platform applies a per-minute limit to the number of request received by the API for some endpoints. Users who send too many requests receive a HTTP status code `429` error response. For applicable endpoints, the quota is documented under the endpoint description.  Treat these limits as maximums and don't try to generate unnecessary load.  Notes: * Limits may be changed or reduced at any time to prevent abuse. * Some endpoints may queue requests if the rate-limit is reached. * If you have special rate requirements, please contact Support.  ### Handling rate limiting In case you need to trigger many requests on short interval, you can watch for the `429` status code and build a retry mechanism. The retry mechanism should follow an exponential backoff schedule to reduce request volume. Adding some randomness to the backoff schedule is recommended.  ### Response headers For endpoints which are subject to low rate-limits, response headers will be included in the request and indicate how many requests are left for the current interval. You can use these to avoid blindly retrying.   Example response headers for an endpoint limited to 30 requests/user/min and 60 requests/workspace/min  |Header name|Description| |-----------|-----------| |`x-rate-limit-user-limit`|The maximum number of requests you're permitted to make per user per minute (e.g. `30`)| |`x-rate-limit-user-remaining`|The number of requests remaining in the current rate limit window. (e.g. `28`)| |`x-rate-limit-user-reset`|The time at which the current rate limit window resets in UTC epoch seconds (e.g. `1631095033096`)| |`x-rate-limit-workspace-limit`|The maximum number of requests you're permitted to make per workspace per minute (e.g. `60`)| |`x-rate-limit-workspace-remaining`|The number of requests remaining in the current rate limit window. (e.g. `38`)| |`x-rate-limit-workspace-reset`|The time at which the current rate limit window resets in UTC epoch milliseconds (e.g. `1631095033096`)| |`x-retry-after`|Number of seconds until the current rate limit window resets (e.g. `42`)|  #### Example error If you exceed the rate limit, an error response is returned:  ``` curl -i -X POST 'https://api.clouddataprep.com/v4/jobGroups' \\ -H 'Content-Type: application/json' \\ -H 'Authorization: Bearer <token>' \\ -d '{ \"wrangledDataset\": { \"id\": \"<recipe-id>\" } }'  HTTP/1.1 429 Too Many Requests x-rate-limit-user-limit: 30 x-rate-limit-user-remaining: 0 x-rate-limit-user-reset: 1631096271696 x-retry-after: 57  {   \"exception\": {     \"name\": \"TooManyRequestsException\",     \"message\": \"Too Many Requests\",     \"details\": \"API quota reached for \\\"runJobGroup\\\". Wait 57 seconds before making a new request. (Max. 30 requests allowed per minute per user.)\"   } } ```  # Trying the API You can use a third party client, such as [curl](https://curl.haxx.se/), [HTTPie](https://httpie.org/), [Postman](https://www.postman.com/) or the [Insomnia rest client](https://insomnia.rest/) to test the Alteryx Analytics Cloud API.  > ⚠️ **When testing the API, bear in mind that you are working with your live production data, not sample data or test data.**  Note that you will need to pass an API token with each request.   For e.g., here is how to run a job with [curl](https://curl.haxx.se/): ``` curl -X POST 'https://us1.alteryxcloud.com/v4/jobGroups' \\ -H 'Content-Type: application/json' \\ -H 'Authorization: Bearer <token>' \\ -d '{ \"wrangledDataset\": { \"id\": \"<recipe-id>\" } }' ```  Using a graphical tool such as [Postman](https://www.postman.com/) or [Insomnia](https://insomnia.rest/), it is possible to import Lthe API specifications directly: 1. Download the API specification by clicking the **Download** button at top of this document 2. Import the JSON specification in the graphical tool of your choice.    - In *Postman*, you can click the **import** button at the top   - With *Insomnia*, you can just drag-and-drop the file on the UI  Note that with *Postman*, you can also generate code snippets by selecting a request and clicking on the **Code** button.   # noqa: E501

    OpenAPI spec version: v2025.23.2
     
"""

from __future__ import absolute_import

# import Lmodels into model package
from src.client.legacy_models.accepted_credentials import LAcceptedCredentials
from src.client.legacy_models.access_token import LAccessToken
from src.client.legacy_models.account_role import LAccountRole
from src.client.legacy_models.account_user import LAccountUser
from src.client.legacy_models.account_user_id import LAccountUserId
from src.client.legacy_models.account_user_id_list import LAccountUserIdList
from src.client.legacy_models.add_dataset_to_flow_request import LAddDatasetToFlowRequest
from src.client.legacy_models.advanced_credentials_info import LAdvancedCredentialsInfo
from src.client.legacy_models.advanced_view_credentials_info import LAdvancedViewCredentialsInfo
from src.client.legacy_models.any_ofaccepted_credentials_items import LAnyOfacceptedCredentialsItems
from src.client.legacy_models.any_ofaccount_role_id import LAnyOfaccountRoleId
from src.client.legacy_models.any_ofaccount_user_billing_account_id import LAnyOfaccountUserBillingAccountId
from src.client.legacy_models.any_ofadvanced_credentials_info_items import LAnyOfadvancedCredentialsInfoItems
from src.client.legacy_models.any_ofassign_role_items import LAnyOfassignRoleItems
from src.client.legacy_models.any_ofassociated_workspace_object_id import LAnyOfassociatedWorkspaceObjectId
from src.client.legacy_models.any_ofauthorization_role_with_name_policy_id import LAnyOfauthorizationRoleWithNamePolicyId
from src.client.legacy_models.any_ofauthorization_role_with_name_workspace_id import LAnyOfauthorizationRoleWithNameWorkspaceId
from src.client.legacy_models.any_ofauthorization_role_with_tag_policy_id import LAnyOfauthorizationRoleWithTagPolicyId
from src.client.legacy_models.any_ofauthorization_role_with_tag_workspace_id import LAnyOfauthorizationRoleWithTagWorkspaceId
from src.client.legacy_models.any_ofaws_config_create_request_person_id import LAnyOfawsConfigCreateRequestPersonId
from src.client.legacy_models.any_ofaws_config_create_request_workspace_id import LAnyOfawsConfigCreateRequestWorkspaceId
from src.client.legacy_models.any_ofaws_config_update_request_person_id import LAnyOfawsConfigUpdateRequestPersonId
from src.client.legacy_models.any_ofaws_config_update_request_workspace_id import LAnyOfawsConfigUpdateRequestWorkspaceId
from src.client.legacy_models.any_ofaws_role_create_request_person_id import LAnyOfawsRoleCreateRequestPersonId
from src.client.legacy_models.any_ofaws_role_create_request_workspace_id import LAnyOfawsRoleCreateRequestWorkspaceId
from src.client.legacy_models.any_ofaws_role_update_request_person_id import LAnyOfawsRoleUpdateRequestPersonId
from src.client.legacy_models.any_ofaws_role_update_request_workspace_id import LAnyOfawsRoleUpdateRequestWorkspaceId
from src.client.legacy_models.any_ofbase_object_schema_id import LAnyOfbaseObjectSchemaId
from src.client.legacy_models.any_ofbetween_ago_date_range_formats import LAnyOfbetweenAgoDateRangeFormats
from src.client.legacy_models.any_ofcompute_usage_unit_workspace_id import LAnyOfcomputeUsageUnitWorkspaceId
from src.client.legacy_models.any_ofcreate_flow_watcher_from_person_flow_id import LAnyOfcreateFlowWatcherFromPersonFlowId
from src.client.legacy_models.any_ofcreate_flow_watcher_from_person_person_id import LAnyOfcreateFlowWatcherFromPersonPersonId
from src.client.legacy_models.any_ofcreate_group_payload_roles_items import LAnyOfcreateGroupPayloadRolesItems
from src.client.legacy_models.any_ofcreate_group_response_id import LAnyOfcreateGroupResponseId
from src.client.legacy_models.any_ofcreate_group_response_workspace_id import LAnyOfcreateGroupResponseWorkspaceId
from src.client.legacy_models.any_ofcreate_plan_watcher_from_person_person_id import LAnyOfcreatePlanWatcherFromPersonPersonId
from src.client.legacy_models.any_ofcreate_plan_watcher_from_person_plan_id import LAnyOfcreatePlanWatcherFromPersonPlanId
from src.client.legacy_models.any_ofdataset_library_list_object_data_items import LAnyOfdatasetLibraryListObjectDataItems
from src.client.legacy_models.any_ofdelete_workspace_user_response_items import LAnyOfdeleteWorkspaceUserResponseItems
from src.client.legacy_models.any_ofexactly_date_range_formats import LAnyOfexactlyDateRangeFormats
from src.client.legacy_models.any_offlow_id import LAnyOfflowId
from src.client.legacy_models.any_offlow_permission_request_data_items import LAnyOfflowPermissionRequestDataItems
from src.client.legacy_models.any_offlow_permission_with_person_id_request_person_id import LAnyOfflowPermissionWithPersonIdRequestPersonId
from src.client.legacy_models.any_offlow_run_request_schedule_execution_id import LAnyOfflowRunRequestScheduleExecutionId
from src.client.legacy_models.any_offlow_run_request_wrangled_dataset_ids_items import LAnyOfflowRunRequestWrangledDatasetIdsItems
from src.client.legacy_models.any_offlow_watcher_from_email_flow_id import LAnyOfflowWatcherFromEmailFlowId
from src.client.legacy_models.any_offlow_watcher_id import LAnyOfflowWatcherId
from src.client.legacy_models.any_offolder_id import LAnyOffolderId
from src.client.legacy_models.any_ofimport_flow_package_successful_response_primary_flow_ids_items import LAnyOfimportFlowPackageSuccessfulResponsePrimaryFlowIdsItems
from src.client.legacy_models.any_ofin_the_last_date_range_formats import LAnyOfinTheLastDateRangeFormats
from src.client.legacy_models.any_ofinvite_list_of_users_payload_roles import LAnyOfinviteListOfUsersPayloadRoles
from src.client.legacy_models.any_ofis_after_date_range_formats import LAnyOfisAfterDateRangeFormats
from src.client.legacy_models.any_ofjdbc_imported_dataset_request_connection_id import LAnyOfjdbcImportedDatasetRequestConnectionId
from src.client.legacy_models.any_oflast_date_range_formats import LAnyOflastDateRangeFormats
from src.client.legacy_models.any_ofmove_flow_request_folder_id import LAnyOfmoveFlowRequestFolderId
from src.client.legacy_models.any_ofnot_updated_object_schema_id import LAnyOfnotUpdatedObjectSchemaId
from src.client.legacy_models.any_ofnow_formats import LAnyOfnowFormats
from src.client.legacy_models.any_ofoutput_node_edges_flow_id import LAnyOfoutputNodeEdgesFlowId
from src.client.legacy_models.any_ofoutput_node_edges_id import LAnyOfoutputNodeEdgesId
from src.client.legacy_models.any_ofoutput_node_edges_in_flow_node_id import LAnyOfoutputNodeEdgesInFlowNodeId
from src.client.legacy_models.any_ofoutput_node_edges_out_flow_node_id import LAnyOfoutputNodeEdgesOutFlowNodeId
from src.client.legacy_models.any_ofoutput_object_id import LAnyOfoutputObjectId
from src.client.legacy_models.any_ofperson_id import LAnyOfpersonId
from src.client.legacy_models.any_ofperson_id_plan_watcher_person_id import LAnyOfpersonIdPlanWatcherPersonId
from src.client.legacy_models.any_ofperson_id_property_person_id import LAnyOfpersonIdPropertyPersonId
from src.client.legacy_models.any_ofperson_id_with_role_person_id import LAnyOfpersonIdWithRolePersonId
from src.client.legacy_models.any_ofperson_public_info_id import LAnyOfpersonPublicInfoId
from src.client.legacy_models.any_ofperson_read_response_id import LAnyOfpersonReadResponseId
from src.client.legacy_models.any_ofplan_create_request_original_plan_id import LAnyOfplanCreateRequestOriginalPlanId
from src.client.legacy_models.any_ofplan_edge_create_request_in_plan_node_id import LAnyOfplanEdgeCreateRequestInPlanNodeId
from src.client.legacy_models.any_ofplan_edge_create_request_out_plan_node_id import LAnyOfplanEdgeCreateRequestOutPlanNodeId
from src.client.legacy_models.any_ofplan_edge_create_request_plan_id import LAnyOfplanEdgeCreateRequestPlanId
from src.client.legacy_models.any_ofplan_edge_id import LAnyOfplanEdgeId
from src.client.legacy_models.any_ofplan_flow_node_create_request_in_plan_node_ids_items import LAnyOfplanFlowNodeCreateRequestInPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_flow_node_create_request_out_plan_node_ids_items import LAnyOfplanFlowNodeCreateRequestOutPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_flow_node_create_request_plan_id import LAnyOfplanFlowNodeCreateRequestPlanId
from src.client.legacy_models.any_ofplan_flow_task_create_request_flow_id import LAnyOfplanFlowTaskCreateRequestFlowId
from src.client.legacy_models.any_ofplan_flow_task_create_request_flow_node_ids_items import LAnyOfplanFlowTaskCreateRequestFlowNodeIdsItems
from src.client.legacy_models.any_ofplan_flow_task_id import LAnyOfplanFlowTaskId
from src.client.legacy_models.any_ofplan_http_node_create_request_in_plan_node_ids_items import LAnyOfplanHTTPNodeCreateRequestInPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_http_node_create_request_out_plan_node_ids_items import LAnyOfplanHTTPNodeCreateRequestOutPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_http_node_create_request_plan_id import LAnyOfplanHTTPNodeCreateRequestPlanId
from src.client.legacy_models.any_ofplan_id import LAnyOfplanId
from src.client.legacy_models.any_ofplan_node_id import LAnyOfplanNodeId
from src.client.legacy_models.any_ofplan_node_run_parameter_response_plan_node_id import LAnyOfplanNodeRunParameterResponsePlanNodeId
from src.client.legacy_models.any_ofplan_original_plan_id import LAnyOfplanOriginalPlanId
from src.client.legacy_models.any_ofplan_other_node_create_request_in_plan_node_ids_items import LAnyOfplanOtherNodeCreateRequestInPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_other_node_create_request_out_plan_node_ids_items import LAnyOfplanOtherNodeCreateRequestOutPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_other_node_create_request_plan_id import LAnyOfplanOtherNodeCreateRequestPlanId
from src.client.legacy_models.any_ofplan_override_create_request_plan_node_id import LAnyOfplanOverrideCreateRequestPlanNodeId
from src.client.legacy_models.any_ofplan_override_update_request_plan_node_id import LAnyOfplanOverrideUpdateRequestPlanNodeId
from src.client.legacy_models.any_ofplan_schedule_override_id import LAnyOfplanScheduleOverrideId
from src.client.legacy_models.any_ofplan_schedule_override_plan_id import LAnyOfplanScheduleOverridePlanId
from src.client.legacy_models.any_ofplan_schedule_override_plan_node_id import LAnyOfplanScheduleOverridePlanNodeId
from src.client.legacy_models.any_ofplan_schedule_override_schedule_id import LAnyOfplanScheduleOverrideScheduleId
from src.client.legacy_models.any_ofplan_snapshot_run_id import LAnyOfplanSnapshotRunId
from src.client.legacy_models.any_ofplan_snapshot_run_schedule_history_id import LAnyOfplanSnapshotRunScheduleHistoryId
from src.client.legacy_models.any_ofplan_storage_node_create_request_in_plan_node_ids_items import LAnyOfplanStorageNodeCreateRequestInPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_storage_node_create_request_out_plan_node_ids_items import LAnyOfplanStorageNodeCreateRequestOutPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_storage_node_create_request_plan_id import LAnyOfplanStorageNodeCreateRequestPlanId
from src.client.legacy_models.any_ofplan_watcher_from_email_plan_id import LAnyOfplanWatcherFromEmailPlanId
from src.client.legacy_models.any_ofplan_watcher_id import LAnyOfplanWatcherId
from src.client.legacy_models.any_ofplan_workflow_node_create_request_in_plan_node_ids_items import LAnyOfplanWorkflowNodeCreateRequestInPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_workflow_node_create_request_out_plan_node_ids_items import LAnyOfplanWorkflowNodeCreateRequestOutPlanNodeIdsItems
from src.client.legacy_models.any_ofplan_workflow_node_create_request_plan_id import LAnyOfplanWorkflowNodeCreateRequestPlanId
from src.client.legacy_models.any_ofprofile_job_id import LAnyOfprofileJobId
from src.client.legacy_models.any_ofprofile_job_request_emr_config_id import LAnyOfprofileJobRequestEmrConfigId
from src.client.legacy_models.any_ofpublication_id import LAnyOfpublicationId
from src.client.legacy_models.any_ofpublish_job_id import LAnyOfpublishJobId
from src.client.legacy_models.any_ofpublish_job_request_publication_id import LAnyOfpublishJobRequestPublicationId
from src.client.legacy_models.any_ofpublish_job_request_scriptresult_id import LAnyOfpublishJobRequestScriptresultId
from src.client.legacy_models.any_ofquota_limit_object_workspace import LAnyOfquotaLimitObjectWorkspace
from src.client.legacy_models.any_ofrecipe_id import LAnyOfrecipeId
from src.client.legacy_models.any_ofreplace_flow_node_with_imported_dataset_flow_node_id import LAnyOfreplaceFlowNodeWithImportedDatasetFlowNodeId
from src.client.legacy_models.any_ofreplace_flow_node_with_imported_dataset_new_imported_dataset_id import LAnyOfreplaceFlowNodeWithImportedDatasetNewImportedDatasetId
from src.client.legacy_models.any_ofreplace_flow_node_with_wrangled_dataset_flow_node_id import LAnyOfreplaceFlowNodeWithWrangledDatasetFlowNodeId
from src.client.legacy_models.any_ofreplace_flow_node_with_wrangled_dataset_new_wrangled_dataset_id import LAnyOfreplaceFlowNodeWithWrangledDatasetNewWrangledDatasetId
from src.client.legacy_models.any_ofreplace_imported_dataset_with_imported_dataset_imported_dataset_id import LAnyOfreplaceImportedDatasetWithImportedDatasetImportedDatasetId
from src.client.legacy_models.any_ofreplace_imported_dataset_with_imported_dataset_new_imported_dataset_id import LAnyOfreplaceImportedDatasetWithImportedDatasetNewImportedDatasetId
from src.client.legacy_models.any_ofreplace_imported_dataset_with_wrangled_dataset_imported_dataset_id import LAnyOfreplaceImportedDatasetWithWrangledDatasetImportedDatasetId
from src.client.legacy_models.any_ofreplace_imported_dataset_with_wrangled_dataset_new_wrangled_dataset_id import LAnyOfreplaceImportedDatasetWithWrangledDatasetNewWrangledDatasetId
from src.client.legacy_models.any_ofrun_parameter_override_create_response_flow_id import LAnyOfrunParameterOverrideCreateResponseFlowId
from src.client.legacy_models.any_ofrun_parameter_override_create_response_id import LAnyOfrunParameterOverrideCreateResponseId
from src.client.legacy_models.any_ofrun_plan_response_plan_snapshot_run_id import LAnyOfrunPlanResponsePlanSnapshotRunId
from src.client.legacy_models.any_ofsample_id import LAnyOfsampleId
from src.client.legacy_models.any_ofschedule_history_tasks import LAnyOfscheduleHistoryTasks
from src.client.legacy_models.any_ofschedule_history_triggers import LAnyOfscheduleHistoryTriggers
from src.client.legacy_models.any_ofschema_drift_job_id import LAnyOfschemaDriftJobId
from src.client.legacy_models.any_ofschema_drift_job_request_datasource_id import LAnyOfschemaDriftJobRequestDatasourceId
from src.client.legacy_models.any_ofscript_line_id import LAnyOfscriptLineId
from src.client.legacy_models.any_ofscript_result_id import LAnyOfscriptResultId
from src.client.legacy_models.any_ofset_roles_to_group_request_role_ids_items import LAnyOfsetRolesToGroupRequestRoleIdsItems
from src.client.legacy_models.any_ofshare_plan_request_data_items import LAnyOfsharePlanRequestDataItems
from src.client.legacy_models.any_ofshare_request_with_person_id_person_id import LAnyOfshareRequestWithPersonIdPersonId
from src.client.legacy_models.any_ofsnapshot_id import LAnyOfsnapshotId
from src.client.legacy_models.any_ofsql_execution_job_id import LAnyOfsqlExecutionJobId
from src.client.legacy_models.any_ofsql_execution_job_request_sql_script_id import LAnyOfsqlExecutionJobRequestSqlScriptId
from src.client.legacy_models.any_ofsql_script_id import LAnyOfsqlScriptId
from src.client.legacy_models.any_ofstatic_role_schema_id import LAnyOfstaticRoleSchemaId
from src.client.legacy_models.any_ofsuspend_list_users_payload_person_ids_items import LAnyOfsuspendListUsersPayloadPersonIdsItems
from src.client.legacy_models.any_oftransfer_user_assets_payload_with_id_from_person_id import LAnyOftransferUserAssetsPayloadWithIdFromPersonId
from src.client.legacy_models.any_oftransfer_user_assets_payload_with_id_to_person_id import LAnyOftransferUserAssetsPayloadWithIdToPersonId
from src.client.legacy_models.any_oftype_id import LAnyOftypeId
from src.client.legacy_models.any_ofunsuspend_list_users_payload_person_ids_items import LAnyOfunsuspendListUsersPayloadPersonIdsItems
from src.client.legacy_models.any_ofupdate_group_response_id import LAnyOfupdateGroupResponseId
from src.client.legacy_models.any_ofupdate_group_response_workspace_id import LAnyOfupdateGroupResponseWorkspaceId
from src.client.legacy_models.any_ofupdated_object_schema_id import LAnyOfupdatedObjectSchemaId
from src.client.legacy_models.any_ofuser_defined_function_id import LAnyOfuserDefinedFunctionId
from src.client.legacy_models.any_ofuser_preference_id import LAnyOfuserPreferenceId
from src.client.legacy_models.any_ofview_state_id import LAnyOfviewStateId
from src.client.legacy_models.any_ofwebhook_flow_task_create_request_any_flow_id import LAnyOfwebhookFlowTaskCreateRequestAnyFlowId
from src.client.legacy_models.any_ofwebhook_flow_task_create_request_some_flow_id import LAnyOfwebhookFlowTaskCreateRequestSomeFlowId
from src.client.legacy_models.any_ofwebhook_flow_task_create_request_some_flow_node_ids_items import LAnyOfwebhookFlowTaskCreateRequestSomeFlowNodeIdsItems
from src.client.legacy_models.any_ofwebhook_flow_task_flow_node_ids_items import LAnyOfwebhookFlowTaskFlowNodeIdsItems
from src.client.legacy_models.any_ofwebhook_flow_task_id import LAnyOfwebhookFlowTaskId
from src.client.legacy_models.any_ofworkspace_id import LAnyOfworkspaceId
from src.client.legacy_models.any_ofworkspace_tiers_info_id import LAnyOfworkspaceTiersInfoId
from src.client.legacy_models.any_ofworkspace_tiers_info_workspace_id import LAnyOfworkspaceTiersInfoWorkspaceId
from src.client.legacy_models.any_ofworkspace_workspacetiers import LAnyOfworkspaceWorkspacetiers
from src.client.legacy_models.any_ofwrangled_dataset_update_response_id import LAnyOfwrangledDatasetUpdateResponseId
from src.client.legacy_models.any_ofwrite_setting_id import LAnyOfwriteSettingId
from src.client.legacy_models.api_access_token import LApiAccessToken
from src.client.legacy_models.api_access_token_create_request import LApiAccessTokenCreateRequest
from src.client.legacy_models.api_access_token_create_response import LApiAccessTokenCreateResponse
from src.client.legacy_models.api_access_token_list import LApiAccessTokenList
from src.client.legacy_models.api_key import LApiKey
from src.client.legacy_models.api_key_with_token import LApiKeyWithToken
from src.client.legacy_models.artifact_staging_job import LArtifactStagingJob
from src.client.legacy_models.artifact_staging_job_create_request import LArtifactStagingJobCreateRequest
from src.client.legacy_models.artifact_staging_job_request import LArtifactStagingJobRequest
from src.client.legacy_models.artifact_staging_job_response import LArtifactStagingJobResponse
from src.client.legacy_models.assign_role import LAssignRole
from src.client.legacy_models.associated_workspace_object import LAssociatedWorkspaceObject
from src.client.legacy_models.async_refresh_schema_response import LAsyncRefreshSchemaResponse
from src.client.legacy_models.async_run_job_result import LAsyncRunJobResult
from src.client.legacy_models.auth_check_response import LAuthCheckResponse
from src.client.legacy_models.authorization_role import LAuthorizationRole
from src.client.legacy_models.authorization_role_list import LAuthorizationRoleList
from src.client.legacy_models.authorization_role_with_name import LAuthorizationRoleWithName
from src.client.legacy_models.authorization_role_with_tag import LAuthorizationRoleWithTag
from src.client.legacy_models.aws_account import LAwsAccount
from src.client.legacy_models.aws_account_request_schema import LAwsAccountRequestSchema
from src.client.legacy_models.aws_account_response_schema import LAwsAccountResponseSchema
from src.client.legacy_models.aws_cloud_configs_response_schema import LAwsCloudConfigsResponseSchema
from src.client.legacy_models.aws_config import LAwsConfig
from src.client.legacy_models.aws_config_create_request import LAwsConfigCreateRequest
from src.client.legacy_models.aws_config_credential import LAwsConfigCredential
from src.client.legacy_models.aws_config_list import LAwsConfigList
from src.client.legacy_models.aws_config_update_request import LAwsConfigUpdateRequest
from src.client.legacy_models.aws_default_config import LAwsDefaultConfig
from src.client.legacy_models.aws_key_secret import LAwsKeySecret
from src.client.legacy_models.aws_platform_credentials import LAwsPlatformCredentials
from src.client.legacy_models.aws_platform_credentials_schema import LAwsPlatformCredentialsSchema
from src.client.legacy_models.aws_role import LAwsRole
from src.client.legacy_models.aws_role_create_request import LAwsRoleCreateRequest
from src.client.legacy_models.aws_role_create_response import LAwsRoleCreateResponse
from src.client.legacy_models.aws_role_list_response import LAwsRoleListResponse
from src.client.legacy_models.aws_role_update_request import LAwsRoleUpdateRequest
from src.client.legacy_models.aws_temporary_config import LAwsTemporaryConfig
from src.client.legacy_models.aws_user_cloud_configs_request_schema import LAwsUserCloudConfigsRequestSchema
from src.client.legacy_models.aws_workspace_cloud_configs_request_schema import LAwsWorkspaceCloudConfigsRequestSchema
from src.client.legacy_models.azure_account import LAzureAccount
from src.client.legacy_models.azure_account_response_schema import LAzureAccountResponseSchema
from src.client.legacy_models.azure_cloud_auth_configs_request_schema import LAzureCloudAuthConfigsRequestSchema
from src.client.legacy_models.azure_cloud_auth_configs_response_schema import LAzureCloudAuthConfigsResponseSchema
from src.client.legacy_models.azure_cloud_configs_response_schema import LAzureCloudConfigsResponseSchema
from src.client.legacy_models.azure_platform_credentials import LAzurePlatformCredentials
from src.client.legacy_models.azure_platform_credentials_schema import LAzurePlatformCredentialsSchema
from src.client.legacy_models.azure_token_sso import LAzureTokenSso
from src.client.legacy_models.azure_user_cloud_configs_request_schema import LAzureUserCloudConfigsRequestSchema
from src.client.legacy_models.azure_workspace_cloud_configs_request_schema import LAzureWorkspaceCloudConfigsRequestSchema
from src.client.legacy_models.base_job_create_request import LBaseJobCreateRequest
from src.client.legacy_models.base_job_response import LBaseJobResponse
from src.client.legacy_models.base_object_schema import LBaseObjectSchema
from src.client.legacy_models.base_storage_configs_create_or_update_request import LBaseStorageConfigsCreateOrUpdateRequest
from src.client.legacy_models.base_storage_configs_for_protocol import LBaseStorageConfigsForProtocol
from src.client.legacy_models.basic import LBasic
from src.client.legacy_models.basic_app import LBasicApp
from src.client.legacy_models.basic_with_app_token import LBasicWithAppToken
from src.client.legacy_models.between_ago_date_range import LBetweenAgoDateRange
from src.client.legacy_models.billing_account_data import LBillingAccountData
from src.client.legacy_models.billing_project import LBillingProject
from src.client.legacy_models.bucket_histogram import LBucketHistogram
from src.client.legacy_models.bucket_node import LBucketNode
from src.client.legacy_models.capability import LCapability
from src.client.legacy_models.cdf_to_python_overrides import LCdfToPythonOverrides
from src.client.legacy_models.cloud_config_response_schema import LCloudConfigResponseSchema
from src.client.legacy_models.cloud_config_user_request_schema import LCloudConfigUserRequestSchema
from src.client.legacy_models.cloud_config_workspace_request_schema import LCloudConfigWorkspaceRequestSchema
from src.client.legacy_models.column_info import LColumnInfo
from src.client.legacy_models.column_view_state import LColumnViewState
from src.client.legacy_models.commit_edges_payload import LCommitEdgesPayload
from src.client.legacy_models.commit_edges_response import LCommitEdgesResponse
from src.client.legacy_models.compute_usage_unit import LComputeUsageUnit
from src.client.legacy_models.conf import LConf
from src.client.legacy_models.config_response_branch import LConfigResponseBranch
from src.client.legacy_models.configuration_change_payload import LConfigurationChangePayload
from src.client.legacy_models.configuration_key_value_schema import LConfigurationKeyValueSchema
from src.client.legacy_models.configuration_response import LConfigurationResponse
from src.client.legacy_models.configuration_saved_response import LConfigurationSavedResponse
from src.client.legacy_models.connection import LConnection
from src.client.legacy_models.connection_create_request import LConnectionCreateRequest
from src.client.legacy_models.connection_id_info import LConnectionIdInfo
from src.client.legacy_models.connection_id_mapping import LConnectionIdMapping
from src.client.legacy_models.connection_list import LConnectionList
from src.client.legacy_models.connection_metadata_info import LConnectionMetadataInfo
from src.client.legacy_models.connection_permission import LConnectionPermission
from src.client.legacy_models.connection_permission_create_request import LConnectionPermissionCreateRequest
from src.client.legacy_models.connection_permissions import LConnectionPermissions
from src.client.legacy_models.connection_permissions_information_only_person import LConnectionPermissionsInformationOnlyPerson
from src.client.legacy_models.connection_query_post_response_with_columns import LConnectionQueryPostResponseWithColumns
from src.client.legacy_models.connection_query_post_response_with_rows import LConnectionQueryPostResponseWithRows
from src.client.legacy_models.connection_query_result_with_error import LConnectionQueryResultWithError
from src.client.legacy_models.connection_success_info import LConnectionSuccessInfo
from src.client.legacy_models.connector_metadata_info import LConnectorMetadataInfo
from src.client.legacy_models.connector_metadata_request_info import LConnectorMetadataRequestInfo
from src.client.legacy_models.converged_connector_auth import LConvergedConnectorAuth
from src.client.legacy_models.copy_flow_request import LCopyFlowRequest
from src.client.legacy_models.copy_imported_dataset_request import LCopyImportedDatasetRequest
from src.client.legacy_models.count import LCount
from src.client.legacy_models.count_or_usage_metrics import LCountOrUsageMetrics
from src.client.legacy_models.create_flow_watcher_from_person import LCreateFlowWatcherFromPerson
from src.client.legacy_models.create_group_payload import LCreateGroupPayload
from src.client.legacy_models.create_group_response import LCreateGroupResponse
from src.client.legacy_models.create_plan_watcher_from_person import LCreatePlanWatcherFromPerson
from src.client.legacy_models.credentials_info import LCredentialsInfo
from src.client.legacy_models.cron_trigger import LCronTrigger
from src.client.legacy_models.daily_trigger import LDailyTrigger
from src.client.legacy_models.data_quality_rule_result import LDataQualityRuleResult
from src.client.legacy_models.data_source import LDataSource
from src.client.legacy_models.databricks_cluster import LDatabricksCluster
from src.client.legacy_models.databricks_options_update_request import LDatabricksOptionsUpdateRequest
from src.client.legacy_models.dataset_library_count import LDatasetLibraryCount
from src.client.legacy_models.dataset_library_datasource import LDatasetLibraryDatasource
from src.client.legacy_models.dataset_library_list_object import LDatasetLibraryListObject
from src.client.legacy_models.dataset_library_recipe import LDatasetLibraryRecipe
from src.client.legacy_models.dataset_library_reference import LDatasetLibraryReference
from src.client.legacy_models.dataset_permission_person_response import LDatasetPermissionPersonResponse
from src.client.legacy_models.dataset_permission_with_email_request import LDatasetPermissionWithEmailRequest
from src.client.legacy_models.dataset_permission_with_group_id_request import LDatasetPermissionWithGroupIdRequest
from src.client.legacy_models.dataset_permission_with_person_id_request import LDatasetPermissionWithPersonIdRequest
from src.client.legacy_models.dataset_resource import LDatasetResource
from src.client.legacy_models.datasets_filter import LDatasetsFilter
from src.client.legacy_models.datasets_filter1 import LDatasetsFilter1
from src.client.legacy_models.dcm_connection import LDcmConnection
from src.client.legacy_models.dcm_credential import LDcmCredential
from src.client.legacy_models.dcm_datasource import LDcmDatasource
from src.client.legacy_models.delete_settings_request import LDeleteSettingsRequest
from src.client.legacy_models.delete_settings_response import LDeleteSettingsResponse
from src.client.legacy_models.delete_workspace_user_response import LDeleteWorkspaceUserResponse
from src.client.legacy_models.dependency import LDependency
from src.client.legacy_models.dependency_update_request import LDependencyUpdateRequest
from src.client.legacy_models.edit import LEdit
from src.client.legacy_models.edit_create_request_with_editable_script import LEditCreateRequestWithEditableScript
from src.client.legacy_models.edit_create_request_with_recipe import LEditCreateRequestWithRecipe
from src.client.legacy_models.editable_script_update_payload import LEditableScriptUpdatePayload
from src.client.legacy_models.email_plan_watcher import LEmailPlanWatcher
from src.client.legacy_models.email_property import LEmailProperty
from src.client.legacy_models.empty_account import LEmptyAccount
from src.client.legacy_models.empty_array import LEmptyArray
from src.client.legacy_models.emr_cluster import LEmrCluster
from src.client.legacy_models.environment_parameter import LEnvironmentParameter
from src.client.legacy_models.environment_parameter_create_request import LEnvironmentParameterCreateRequest
from src.client.legacy_models.environment_parameter_mapping import LEnvironmentParameterMapping
from src.client.legacy_models.environment_parameter_mapping_to_existing_env_param import LEnvironmentParameterMappingToExistingEnvParam
from src.client.legacy_models.environment_parameter_mapping_to_manual_value import LEnvironmentParameterMappingToManualValue
from src.client.legacy_models.environment_parameters_list import LEnvironmentParametersList
from src.client.legacy_models.exactly_date_range import LExactlyDateRange
from src.client.legacy_models.excluding_roles import LExcludingRoles
from src.client.legacy_models.export_macro_package_response import LExportMacroPackageResponse
from src.client.legacy_models.extended_type import LExtendedType
from src.client.legacy_models.file_converter_job import LFileConverterJob
from src.client.legacy_models.file_converter_job_create_request import LFileConverterJobCreateRequest
from src.client.legacy_models.file_converter_job_request import LFileConverterJobRequest
from src.client.legacy_models.file_converter_job_response import LFileConverterJobResponse
from src.client.legacy_models.file_imported_dataset_request import LFileImportedDatasetRequest
from src.client.legacy_models.file_or_table_input import LFileOrTableInput
from src.client.legacy_models.file_watcher_trigger import LFileWatcherTrigger
from src.client.legacy_models.file_writer_job import LFileWriterJob
from src.client.legacy_models.file_writer_job_create_request import LFileWriterJobCreateRequest
from src.client.legacy_models.file_writer_job_request import LFileWriterJobRequest
from src.client.legacy_models.file_writer_job_response import LFileWriterJobResponse
from src.client.legacy_models.filereader_job import LFilereaderJob
from src.client.legacy_models.filereader_job_create_request import LFilereaderJobCreateRequest
from src.client.legacy_models.filereader_job_request import LFilereaderJobRequest
from src.client.legacy_models.filereader_job_response import LFilereaderJobResponse
from src.client.legacy_models.flow import LFlow
from src.client.legacy_models.flow_count_information import LFlowCountInformation
from src.client.legacy_models.flow_create_request import LFlowCreateRequest
from src.client.legacy_models.flow_edge import LFlowEdge
from src.client.legacy_models.flow_graph_vertex import LFlowGraphVertex
from src.client.legacy_models.flow_graph_vertex_add_vertices_update_request import LFlowGraphVertexAddVerticesUpdateRequest
from src.client.legacy_models.flow_graph_vertex_create_request import LFlowGraphVertexCreateRequest
from src.client.legacy_models.flow_graph_vertex_create_response import LFlowGraphVertexCreateResponse
from src.client.legacy_models.flow_library_response import LFlowLibraryResponse
from src.client.legacy_models.flow_list import LFlowList
from src.client.legacy_models.flow_node import LFlowNode
from src.client.legacy_models.flow_node_info import LFlowNodeInfo
from src.client.legacy_models.flow_node_update_request import LFlowNodeUpdateRequest
from src.client.legacy_models.flow_notification_settings import LFlowNotificationSettings
from src.client.legacy_models.flow_notification_settings_create_request import LFlowNotificationSettingsCreateRequest
from src.client.legacy_models.flow_permission import LFlowPermission
from src.client.legacy_models.flow_permission_information import LFlowPermissionInformation
from src.client.legacy_models.flow_permission_list import LFlowPermissionList
from src.client.legacy_models.flow_permission_only_person_response import LFlowPermissionOnlyPersonResponse
from src.client.legacy_models.flow_permission_request import LFlowPermissionRequest
from src.client.legacy_models.flow_permission_with_email_request import LFlowPermissionWithEmailRequest
from src.client.legacy_models.flow_permission_with_person_id_request import LFlowPermissionWithPersonIdRequest
from src.client.legacy_models.flow_run import LFlowRun
from src.client.legacy_models.flow_run_parameter_override import LFlowRunParameterOverride
from src.client.legacy_models.flow_run_parameter_override_create_request import LFlowRunParameterOverrideCreateRequest
from src.client.legacy_models.flow_run_parameter_override_update_request import LFlowRunParameterOverrideUpdateRequest
from src.client.legacy_models.flow_run_request import LFlowRunRequest
from src.client.legacy_models.flow_run_status import LFlowRunStatus
from src.client.legacy_models.flow_state import LFlowState
from src.client.legacy_models.flow_update_request import LFlowUpdateRequest
from src.client.legacy_models.flow_validate_response import LFlowValidateResponse
from src.client.legacy_models.flow_watcher import LFlowWatcher
from src.client.legacy_models.flow_watcher_from_email import LFlowWatcherFromEmail
from src.client.legacy_models.flow_watcher_schema import LFlowWatcherSchema
from src.client.legacy_models.folder import LFolder
from src.client.legacy_models.folder_create_request import LFolderCreateRequest
from src.client.legacy_models.folder_list import LFolderList
from src.client.legacy_models.folder_update_request import LFolderUpdateRequest
from src.client.legacy_models.gcp_account import LGcpAccount
from src.client.legacy_models.gcp_account_response_schema import LGcpAccountResponseSchema
from src.client.legacy_models.gcp_cloud_config_response_schema import LGcpCloudConfigResponseSchema
from src.client.legacy_models.gcp_platform_credentials import LGcpPlatformCredentials
from src.client.legacy_models.gcp_platform_credentials_schema import LGcpPlatformCredentialsSchema
from src.client.legacy_models.gcp_workspace_cloud_configs_request_schema import LGcpWorkspaceCloudConfigsRequestSchema
from src.client.legacy_models.gcs_fs_auth_data import LGcsFsAuthData
from src.client.legacy_models.generic_json_response import LGenericJsonResponse
from src.client.legacy_models.geo_json import LGeoJSON
from src.client.legacy_models.get_groups_response import LGetGroupsResponse
from src.client.legacy_models.get_python_script_for_output_object_input import LGetPythonScriptForOutputObjectInput
from src.client.legacy_models.get_task_success_response import LGetTaskSuccessResponse
from src.client.legacy_models.google_cloud_auth_configs_request_schema import LGoogleCloudAuthConfigsRequestSchema
from src.client.legacy_models.google_cloud_auth_configs_response_schema import LGoogleCloudAuthConfigsResponseSchema
from src.client.legacy_models.group import LGroup
from src.client.legacy_models.hdfs_fs_auth_data import LHdfsFsAuthData
from src.client.legacy_models.histogram_bucket_value import LHistogramBucketValue
from src.client.legacy_models.hourly_trigger import LHourlyTrigger
from src.client.legacy_models.http_header_based_auth import LHttpHeaderBasedAuth
from src.client.legacy_models.http_query_based_auth import LHttpQueryBasedAuth
from src.client.legacy_models.iam_db_user import LIamDbUser
from src.client.legacy_models.iam_role_arn import LIamRoleArn
from src.client.legacy_models.import_environment_parameter_package_response import LImportEnvironmentParameterPackageResponse
from src.client.legacy_models.import_environment_parameter_package_response_for_confirmation import LImportEnvironmentParameterPackageResponseForConfirmation
from src.client.legacy_models.import_flow_connection_id_mapping import LImportFlowConnectionIdMapping
from src.client.legacy_models.import_flow_environment_parameter_mapping import LImportFlowEnvironmentParameterMapping
from src.client.legacy_models.import_flow_package_holdup_response import LImportFlowPackageHoldupResponse
from src.client.legacy_models.import_flow_package_request import LImportFlowPackageRequest
from src.client.legacy_models.import_flow_package_request_with_environment_parameter_mapping import LImportFlowPackageRequestWithEnvironmentParameterMapping
from src.client.legacy_models.import_flow_package_request_zip import LImportFlowPackageRequestZip
from src.client.legacy_models.import_flow_package_request_zip_with_env_param_mapping import LImportFlowPackageRequestZipWithEnvParamMapping
from src.client.legacy_models.import_flow_package_response import LImportFlowPackageResponse
from src.client.legacy_models.import_flow_package_successful_response import LImportFlowPackageSuccessfulResponse
from src.client.legacy_models.import_macro_package_request import LImportMacroPackageRequest
from src.client.legacy_models.import_macro_package_response import LImportMacroPackageResponse
from src.client.legacy_models.import_plan_data_request import LImportPlanDataRequest
from src.client.legacy_models.import_plan_package_holdup_response import LImportPlanPackageHoldupResponse
from src.client.legacy_models.import_plan_package_request_zip import LImportPlanPackageRequestZip
from src.client.legacy_models.import_plan_package_response import LImportPlanPackageResponse
from src.client.legacy_models.import_plan_package_successful_response import LImportPlanPackageSuccessfulResponse
from src.client.legacy_models.import_plan_zip_request import LImportPlanZipRequest
from src.client.legacy_models.imported_dataset import LImportedDataset
from src.client.legacy_models.imported_dataset_create_request import LImportedDatasetCreateRequest
from src.client.legacy_models.imported_dataset_list import LImportedDatasetList
from src.client.legacy_models.imported_dataset_payload import LImportedDatasetPayload
from src.client.legacy_models.imported_dataset_request_with_path import LImportedDatasetRequestWithPath
from src.client.legacy_models.imported_dataset_request_with_uri import LImportedDatasetRequestWithUri
from src.client.legacy_models.imported_dataset_update_request import LImportedDatasetUpdateRequest
from src.client.legacy_models.in_the_last_date_range import LInTheLastDateRange
from src.client.legacy_models.include_deleted import LIncludeDeleted
from src.client.legacy_models.include_deleted1 import LIncludeDeleted1
from src.client.legacy_models.include_deleted10 import LIncludeDeleted10
from src.client.legacy_models.include_deleted11 import LIncludeDeleted11
from src.client.legacy_models.include_deleted12 import LIncludeDeleted12
from src.client.legacy_models.include_deleted13 import LIncludeDeleted13
from src.client.legacy_models.include_deleted14 import LIncludeDeleted14
from src.client.legacy_models.include_deleted15 import LIncludeDeleted15
from src.client.legacy_models.include_deleted16 import LIncludeDeleted16
from src.client.legacy_models.include_deleted17 import LIncludeDeleted17
from src.client.legacy_models.include_deleted18 import LIncludeDeleted18
from src.client.legacy_models.include_deleted19 import LIncludeDeleted19
from src.client.legacy_models.include_deleted2 import LIncludeDeleted2
from src.client.legacy_models.include_deleted20 import LIncludeDeleted20
from src.client.legacy_models.include_deleted21 import LIncludeDeleted21
from src.client.legacy_models.include_deleted22 import LIncludeDeleted22
from src.client.legacy_models.include_deleted23 import LIncludeDeleted23
from src.client.legacy_models.include_deleted24 import LIncludeDeleted24
from src.client.legacy_models.include_deleted25 import LIncludeDeleted25
from src.client.legacy_models.include_deleted26 import LIncludeDeleted26
from src.client.legacy_models.include_deleted27 import LIncludeDeleted27
from src.client.legacy_models.include_deleted28 import LIncludeDeleted28
from src.client.legacy_models.include_deleted29 import LIncludeDeleted29
from src.client.legacy_models.include_deleted3 import LIncludeDeleted3
from src.client.legacy_models.include_deleted30 import LIncludeDeleted30
from src.client.legacy_models.include_deleted31 import LIncludeDeleted31
from src.client.legacy_models.include_deleted32 import LIncludeDeleted32
from src.client.legacy_models.include_deleted33 import LIncludeDeleted33
from src.client.legacy_models.include_deleted34 import LIncludeDeleted34
from src.client.legacy_models.include_deleted35 import LIncludeDeleted35
from src.client.legacy_models.include_deleted36 import LIncludeDeleted36
from src.client.legacy_models.include_deleted37 import LIncludeDeleted37
from src.client.legacy_models.include_deleted38 import LIncludeDeleted38
from src.client.legacy_models.include_deleted39 import LIncludeDeleted39
from src.client.legacy_models.include_deleted4 import LIncludeDeleted4
from src.client.legacy_models.include_deleted40 import LIncludeDeleted40
from src.client.legacy_models.include_deleted41 import LIncludeDeleted41
from src.client.legacy_models.include_deleted42 import LIncludeDeleted42
from src.client.legacy_models.include_deleted43 import LIncludeDeleted43
from src.client.legacy_models.include_deleted44 import LIncludeDeleted44
from src.client.legacy_models.include_deleted45 import LIncludeDeleted45
from src.client.legacy_models.include_deleted46 import LIncludeDeleted46
from src.client.legacy_models.include_deleted47 import LIncludeDeleted47
from src.client.legacy_models.include_deleted5 import LIncludeDeleted5
from src.client.legacy_models.include_deleted6 import LIncludeDeleted6
from src.client.legacy_models.include_deleted7 import LIncludeDeleted7
from src.client.legacy_models.include_deleted8 import LIncludeDeleted8
from src.client.legacy_models.include_deleted9 import LIncludeDeleted9
from src.client.legacy_models.ingest_job import LIngestJob
from src.client.legacy_models.ingest_job_create_request import LIngestJobCreateRequest
from src.client.legacy_models.ingest_job_request import LIngestJobRequest
from src.client.legacy_models.ingest_job_response import LIngestJobResponse
from src.client.legacy_models.input_example import LInputExample
from src.client.legacy_models.input_io_file_response import LInputIoFileResponse
from src.client.legacy_models.input_parameter import LInputParameter
from src.client.legacy_models.invite_list_of_users_payload import LInviteListOfUsersPayload
from src.client.legacy_models.invite_user_payload import LInviteUserPayload
from src.client.legacy_models.invite_user_response import LInviteUserResponse
from src.client.legacy_models.invite_users_to_account_workspace_request import LInviteUsersToAccountWorkspaceRequest
from src.client.legacy_models.io_table_response import LIoTableResponse
from src.client.legacy_models.is_after_date_range import LIsAfterDateRange
from src.client.legacy_models.jdbc_imported_dataset_request import LJdbcImportedDatasetRequest
from src.client.legacy_models.jdbc_rest_endpoints_info import LJdbcRestEndpointsInfo
from src.client.legacy_models.job import LJob
from src.client.legacy_models.job_files_and_tables_output_list_response import LJobFilesAndTablesOutputListResponse
from src.client.legacy_models.job_group import LJobGroup
from src.client.legacy_models.job_group_cancel_information import LJobGroupCancelInformation
from src.client.legacy_models.job_group_flow_node_profile import LJobGroupFlowNodeProfile
from src.client.legacy_models.job_group_flow_node_profiles import LJobGroupFlowNodeProfiles
from src.client.legacy_models.job_group_input import LJobGroupInput
from src.client.legacy_models.job_group_inputs import LJobGroupInputs
from src.client.legacy_models.job_group_list import LJobGroupList
from src.client.legacy_models.job_group_profile import LJobGroupProfile
from src.client.legacy_models.job_group_status_schema import LJobGroupStatusSchema
from src.client.legacy_models.job_list import LJobList
from src.client.legacy_models.job_status_schema import LJobStatusSchema
from src.client.legacy_models.jobs_error_report_schema import LJobsErrorReportSchema
from src.client.legacy_models.jobs_usage_unit import LJobsUsageUnit
from src.client.legacy_models.kerberos_delegate import LKerberosDelegate
from src.client.legacy_models.kerberos_impersonation import LKerberosImpersonation
from src.client.legacy_models.key_secret import LKeySecret
from src.client.legacy_models.last_date_range import LLastDateRange
from src.client.legacy_models.matching_file import LMatchingFile
from src.client.legacy_models.maximal_capabilities_info import LMaximalCapabilitiesInfo
from src.client.legacy_models.member_information import LMemberInformation
from src.client.legacy_models.members import LMembers
from src.client.legacy_models.monthly_trigger import LMonthlyTrigger
from src.client.legacy_models.monthly_weekday_trigger import LMonthlyWeekdayTrigger
from src.client.legacy_models.move_flow_request import LMoveFlowRequest
from src.client.legacy_models.nested_compute_usage_unit import LNestedComputeUsageUnit
from src.client.legacy_models.nested_imported_dataset_schema import LNestedImportedDatasetSchema
from src.client.legacy_models.nested_jobs_usage_unit import LNestedJobsUsageUnit
from src.client.legacy_models.nested_wrangled_dataset_schema import LNestedWrangledDatasetSchema
from src.client.legacy_models.next_page_url_pagination import LNextPageURLPagination
from src.client.legacy_models.no_auth import LNoAuth
from src.client.legacy_models.not_updated_object_schema import LNotUpdatedObjectSchema
from src.client.legacy_models.note import LNote
from src.client.legacy_models.now import LNow
from src.client.legacy_models.o_auth2_api_token import LOAuth2ApiToken
from src.client.legacy_models.o_auth2_api_token_value import LOAuth2ApiTokenValue
from src.client.legacy_models.oauth2 import LOauth2
from src.client.legacy_models.oauth2_client_detail import LOauth2ClientDetail
from src.client.legacy_models.one_ofadvanced_view_credentials_info_items import LOneOfadvancedViewCredentialsInfoItems
from src.client.legacy_models.one_ofconnection_permission_create_request_data_items import LOneOfconnectionPermissionCreateRequestDataItems
from src.client.legacy_models.one_ofenvironment_parameter_create_request_value import LOneOfenvironmentParameterCreateRequestValue
from src.client.legacy_models.one_ofenvironment_parameter_mapping_to_manual_value_mapped_value import LOneOfenvironmentParameterMappingToManualValueMappedValue
from src.client.legacy_models.one_ofenvironment_parameter_value import LOneOfenvironmentParameterValue
from src.client.legacy_models.one_offlow_run_parameter_override_create_request_value import LOneOfflowRunParameterOverrideCreateRequestValue
from src.client.legacy_models.one_offlow_run_parameter_override_update_request_value import LOneOfflowRunParameterOverrideUpdateRequestValue
from src.client.legacy_models.one_offlow_run_parameter_override_value import LOneOfflowRunParameterOverrideValue
from src.client.legacy_models.one_ofplan_node_override_value import LOneOfplanNodeOverrideValue
from src.client.legacy_models.one_ofplan_override_create_request_value import LOneOfplanOverrideCreateRequestValue
from src.client.legacy_models.one_ofplan_override_update_request_value import LOneOfplanOverrideUpdateRequestValue
from src.client.legacy_models.one_ofplan_schedule_override_value import LOneOfplanScheduleOverrideValue
from src.client.legacy_models.one_ofrun_parameter_date_range_date_range import LOneOfrunParameterDateRangeDateRange
from src.client.legacy_models.one_ofrun_parameter_pattern_pattern import LOneOfrunParameterPatternPattern
from src.client.legacy_models.one_ofschedule_create_request_tasks import LOneOfscheduleCreateRequestTasks
from src.client.legacy_models.one_ofschedule_create_request_triggers import LOneOfscheduleCreateRequestTriggers
from src.client.legacy_models.one_ofschedule_response_with_task_triggers import LOneOfscheduleResponseWithTaskTriggers
from src.client.legacy_models.one_ofschedule_tasks import LOneOfscheduleTasks
from src.client.legacy_models.one_ofschedule_triggers import LOneOfscheduleTriggers
from src.client.legacy_models.one_ofschedule_update_request_tasks import LOneOfscheduleUpdateRequestTasks
from src.client.legacy_models.one_ofschedule_update_request_triggers import LOneOfscheduleUpdateRequestTriggers
from src.client.legacy_models.one_oftime_based_trigger_time_based import LOneOftimeBasedTriggerTimeBased
from src.client.legacy_models.one_ofupdate_group_response_users import LOneOfupdateGroupResponseUsers
from src.client.legacy_models.one_time_trigger import LOneTimeTrigger
from src.client.legacy_models.open_api_spec_response import LOpenApiSpecResponse
from src.client.legacy_models.options import LOptions
from src.client.legacy_models.output_home_dir_option import LOutputHomeDirOption
from src.client.legacy_models.output_io_file_response import LOutputIoFileResponse
from src.client.legacy_models.output_node_edges import LOutputNodeEdges
from src.client.legacy_models.output_object import LOutputObject
from src.client.legacy_models.output_object_create_request import LOutputObjectCreateRequest
from src.client.legacy_models.output_object_dataflow_options_update_request import LOutputObjectDataflowOptionsUpdateRequest
from src.client.legacy_models.output_object_list import LOutputObjectList
from src.client.legacy_models.output_object_python_script_request import LOutputObjectPythonScriptRequest
from src.client.legacy_models.output_object_schema_drift_options_update_request import LOutputObjectSchemaDriftOptionsUpdateRequest
from src.client.legacy_models.output_object_spark_option_update_request import LOutputObjectSparkOptionUpdateRequest
from src.client.legacy_models.output_object_update_request import LOutputObjectUpdateRequest
from src.client.legacy_models.override_value_info_selector import LOverrideValueInfoSelector
from src.client.legacy_models.override_value_info_variable import LOverrideValueInfoVariable
from src.client.legacy_models.page_number_pagination import LPageNumberPagination
from src.client.legacy_models.paging_token_pagination import LPagingTokenPagination
from src.client.legacy_models.parsing_node import LParsingNode
from src.client.legacy_models.parsing_node_request import LParsingNodeRequest
from src.client.legacy_models.password import LPassword
from src.client.legacy_models.patch_aws_user_cloud_configs_schema import LPatchAwsUserCloudConfigsSchema
from src.client.legacy_models.patch_aws_workspace_cloud_configs_schema import LPatchAwsWorkspaceCloudConfigsSchema
from src.client.legacy_models.patch_azure_user_cloud_configs_schema import LPatchAzureUserCloudConfigsSchema
from src.client.legacy_models.patch_azure_workspace_cloud_configs_schema import LPatchAzureWorkspaceCloudConfigsSchema
from src.client.legacy_models.patch_gcp_workspace_cloud_configs_schema import LPatchGcpWorkspaceCloudConfigsSchema
from src.client.legacy_models.patch_workspace_cloud_configs_schema import LPatchWorkspaceCloudConfigsSchema
from src.client.legacy_models.person import LPerson
from src.client.legacy_models.person_id_plan_watcher import LPersonIdPlanWatcher
from src.client.legacy_models.person_id_property import LPersonIdProperty
from src.client.legacy_models.person_id_with_role import LPersonIdWithRole
from src.client.legacy_models.person_list import LPersonList
from src.client.legacy_models.person_object_with_role import LPersonObjectWithRole
from src.client.legacy_models.person_public_info import LPersonPublicInfo
from src.client.legacy_models.person_read_response import LPersonReadResponse
from src.client.legacy_models.person_read_response_list import LPersonReadResponseList
from src.client.legacy_models.person_update_request import LPersonUpdateRequest
from src.client.legacy_models.personal_access_token import LPersonalAccessToken
from src.client.legacy_models.personal_access_token_name_secret import LPersonalAccessTokenNameSecret
from src.client.legacy_models.plan import LPlan
from src.client.legacy_models.plan_create_request import LPlanCreateRequest
from src.client.legacy_models.plan_edge import LPlanEdge
from src.client.legacy_models.plan_edge_create_request import LPlanEdgeCreateRequest
from src.client.legacy_models.plan_flow_node_create_request import LPlanFlowNodeCreateRequest
from src.client.legacy_models.plan_flow_task import LPlanFlowTask
from src.client.legacy_models.plan_flow_task_create_request import LPlanFlowTaskCreateRequest
from src.client.legacy_models.plan_http_node_create_request import LPlanHTTPNodeCreateRequest
from src.client.legacy_models.plan_http_task_create_request import LPlanHTTPTaskCreateRequest
from src.client.legacy_models.plan_list import LPlanList
from src.client.legacy_models.plan_node import LPlanNode
from src.client.legacy_models.plan_node_create_request import LPlanNodeCreateRequest
from src.client.legacy_models.plan_node_override import LPlanNodeOverride
from src.client.legacy_models.plan_node_run_parameter_response import LPlanNodeRunParameterResponse
from src.client.legacy_models.plan_other_node_create_request import LPlanOtherNodeCreateRequest
from src.client.legacy_models.plan_override import LPlanOverride
from src.client.legacy_models.plan_override_create_request import LPlanOverrideCreateRequest
from src.client.legacy_models.plan_override_update_request import LPlanOverrideUpdateRequest
from src.client.legacy_models.plan_permission_person_response import LPlanPermissionPersonResponse
from src.client.legacy_models.plan_run_parameter_selector_schema import LPlanRunParameterSelectorSchema
from src.client.legacy_models.plan_run_parameter_variable_schema import LPlanRunParameterVariableSchema
from src.client.legacy_models.plan_schedule_override import LPlanScheduleOverride
from src.client.legacy_models.plan_snapshot_run import LPlanSnapshotRun
from src.client.legacy_models.plan_snapshot_run_list import LPlanSnapshotRunList
from src.client.legacy_models.plan_storage_node_create_request import LPlanStorageNodeCreateRequest
from src.client.legacy_models.plan_storage_task_create_request import LPlanStorageTaskCreateRequest
from src.client.legacy_models.plan_update_request import LPlanUpdateRequest
from src.client.legacy_models.plan_watcher import LPlanWatcher
from src.client.legacy_models.plan_watcher_from_email import LPlanWatcherFromEmail
from src.client.legacy_models.plan_watcher_schema import LPlanWatcherSchema
from src.client.legacy_models.plan_workflow_node_create_request import LPlanWorkflowNodeCreateRequest
from src.client.legacy_models.plan_workflow_task_create_request import LPlanWorkflowTaskCreateRequest
from src.client.legacy_models.plan_workflow_task_exec_metadata_schema import LPlanWorkflowTaskExecMetadataSchema
from src.client.legacy_models.private_app import LPrivateApp
from src.client.legacy_models.privilege import LPrivilege
from src.client.legacy_models.profile_job import LProfileJob
from src.client.legacy_models.profile_job_create_request import LProfileJobCreateRequest
from src.client.legacy_models.profile_job_request import LProfileJobRequest
from src.client.legacy_models.profile_job_response import LProfileJobResponse
from src.client.legacy_models.project import LProject
from src.client.legacy_models.publication import LPublication
from src.client.legacy_models.publication_create_request import LPublicationCreateRequest
from src.client.legacy_models.publication_list import LPublicationList
from src.client.legacy_models.publication_update_request import LPublicationUpdateRequest
from src.client.legacy_models.publish_info import LPublishInfo
from src.client.legacy_models.publish_job import LPublishJob
from src.client.legacy_models.publish_job_create_request import LPublishJobCreateRequest
from src.client.legacy_models.publish_job_request import LPublishJobRequest
from src.client.legacy_models.publish_job_response import LPublishJobResponse
from src.client.legacy_models.publish_metadata_info import LPublishMetadataInfo
from src.client.legacy_models.quota_limit_object import LQuotaLimitObject
from src.client.legacy_models.recipe import LRecipe
from src.client.legacy_models.recipe_node import LRecipeNode
from src.client.legacy_models.recipe_node_request import LRecipeNodeRequest
from src.client.legacy_models.recipe_view_state import LRecipeViewState
from src.client.legacy_models.record_offset_pagination import LRecordOffsetPagination
from src.client.legacy_models.reference_node import LReferenceNode
from src.client.legacy_models.reference_node_request import LReferenceNodeRequest
from src.client.legacy_models.replace_dataset_payload import LReplaceDatasetPayload
from src.client.legacy_models.replace_dataset_response import LReplaceDatasetResponse
from src.client.legacy_models.replace_flow_node_with_imported_dataset import LReplaceFlowNodeWithImportedDataset
from src.client.legacy_models.replace_flow_node_with_wrangled_dataset import LReplaceFlowNodeWithWrangledDataset
from src.client.legacy_models.replace_imported_dataset_with_imported_dataset import LReplaceImportedDatasetWithImportedDataset
from src.client.legacy_models.replace_imported_dataset_with_wrangled_dataset import LReplaceImportedDatasetWithWrangledDataset
from src.client.legacy_models.resource_operation import LResourceOperation
from src.client.legacy_models.roles import LRoles
from src.client.legacy_models.run_auto_insights_task_schema import LRunAutoInsightsTaskSchema
from src.client.legacy_models.run_auto_insights_task_with_auto_insights_schema import LRunAutoInsightsTaskWithAutoInsightsSchema
from src.client.legacy_models.run_flow_result import LRunFlowResult
from src.client.legacy_models.run_flow_task_schema import LRunFlowTaskSchema
from src.client.legacy_models.run_flow_task_with_flow_schema import LRunFlowTaskWithFlowSchema
from src.client.legacy_models.run_job_request import LRunJobRequest
from src.client.legacy_models.run_job_response import LRunJobResponse
from src.client.legacy_models.run_job_result import LRunJobResult
from src.client.legacy_models.run_job_test_mode_result import LRunJobTestModeResult
from src.client.legacy_models.run_location_intelligence_task_schema import LRunLocationIntelligenceTaskSchema
from src.client.legacy_models.run_location_intelligence_task_with_location_intelligence_schema import LRunLocationIntelligenceTaskWithLocationIntelligenceSchema
from src.client.legacy_models.run_parameter_date_range import LRunParameterDateRange
from src.client.legacy_models.run_parameter_destination_info import LRunParameterDestinationInfo
from src.client.legacy_models.run_parameter_file_based_info import LRunParameterFileBasedInfo
from src.client.legacy_models.run_parameter_info import LRunParameterInfo
from src.client.legacy_models.run_parameter_override_create_response import LRunParameterOverrideCreateResponse
from src.client.legacy_models.run_parameter_override_value import LRunParameterOverrideValue
from src.client.legacy_models.run_parameter_overrides import LRunParameterOverrides
from src.client.legacy_models.run_parameter_pattern import LRunParameterPattern
from src.client.legacy_models.run_parameter_regex_pattern import LRunParameterRegexPattern
from src.client.legacy_models.run_parameter_response import LRunParameterResponse
from src.client.legacy_models.run_parameter_selector import LRunParameterSelector
from src.client.legacy_models.run_parameter_sql_info import LRunParameterSqlInfo
from src.client.legacy_models.run_parameter_sql_script_info import LRunParameterSqlScriptInfo
from src.client.legacy_models.run_parameter_string_pattern import LRunParameterStringPattern
from src.client.legacy_models.run_parameter_timestamp import LRunParameterTimestamp
from src.client.legacy_models.run_parameter_trifacta_pattern import LRunParameterTrifactaPattern
from src.client.legacy_models.run_parameter_value_destination_schema import LRunParameterValueDestinationSchema
from src.client.legacy_models.run_parameter_value_file_based_schema import LRunParameterValueFileBasedSchema
from src.client.legacy_models.run_parameter_value_schema import LRunParameterValueSchema
from src.client.legacy_models.run_parameter_value_sql_schema import LRunParameterValueSqlSchema
from src.client.legacy_models.run_parameter_value_sql_script_schema import LRunParameterValueSqlScriptSchema
from src.client.legacy_models.run_parameter_variable import LRunParameterVariable
from src.client.legacy_models.run_parameter_wildcard_pattern import LRunParameterWildcardPattern
from src.client.legacy_models.run_plan_body import LRunPlanBody
from src.client.legacy_models.run_plan_response import LRunPlanResponse
from src.client.legacy_models.run_plan_task_schema import LRunPlanTaskSchema
from src.client.legacy_models.run_plan_task_with_plan_schema import LRunPlanTaskWithPlanSchema
from src.client.legacy_models.run_report_task_schema import LRunReportTaskSchema
from src.client.legacy_models.run_report_task_with_report_schema import LRunReportTaskWithReportSchema
from src.client.legacy_models.run_task_schema import LRunTaskSchema
from src.client.legacy_models.run_workflow_task_schema import LRunWorkflowTaskSchema
from src.client.legacy_models.run_workflow_task_with_workflow_schema import LRunWorkflowTaskWithWorkflowSchema
from src.client.legacy_models.runtime_metadata_info import LRuntimeMetadataInfo
from src.client.legacy_models.s3_fs_auth_data import LS3FsAuthData
from src.client.legacy_models.sample import LSample
from src.client.legacy_models.sample_error_response import LSampleErrorResponse
from src.client.legacy_models.sampling_params import LSamplingParams
from src.client.legacy_models.schedule import LSchedule
from src.client.legacy_models.schedule_create_request import LScheduleCreateRequest
from src.client.legacy_models.schedule_error_response import LScheduleErrorResponse
from src.client.legacy_models.schedule_history import LScheduleHistory
from src.client.legacy_models.schedule_history_list import LScheduleHistoryList
from src.client.legacy_models.schedule_response_with_task import LScheduleResponseWithTask
from src.client.legacy_models.schedule_response_with_task_list import LScheduleResponseWithTaskList
from src.client.legacy_models.schedule_update_request import LScheduleUpdateRequest
from src.client.legacy_models.schedules_transfer_request import LSchedulesTransferRequest
from src.client.legacy_models.schema_drift_job import LSchemaDriftJob
from src.client.legacy_models.schema_drift_job_create_request import LSchemaDriftJobCreateRequest
from src.client.legacy_models.schema_drift_job_request import LSchemaDriftJobRequest
from src.client.legacy_models.schema_drift_job_response import LSchemaDriftJobResponse
from src.client.legacy_models.script_graph import LScriptGraph
from src.client.legacy_models.script_line import LScriptLine
from src.client.legacy_models.script_line_id_response import LScriptLineIdResponse
from src.client.legacy_models.script_result import LScriptResult
from src.client.legacy_models.security_token import LSecurityToken
from src.client.legacy_models.set_roles_to_group_request import LSetRolesToGroupRequest
from src.client.legacy_models.share_plan_request import LSharePlanRequest
from src.client.legacy_models.share_plan_response import LSharePlanResponse
from src.client.legacy_models.share_request_with_email import LShareRequestWithEmail
from src.client.legacy_models.share_request_with_person_id import LShareRequestWithPersonId
from src.client.legacy_models.simple_connection_query_result import LSimpleConnectionQueryResult
from src.client.legacy_models.snapshot import LSnapshot
from src.client.legacy_models.sql_execution_job import LSqlExecutionJob
from src.client.legacy_models.sql_execution_job_create_request import LSqlExecutionJobCreateRequest
from src.client.legacy_models.sql_execution_job_request import LSqlExecutionJobRequest
from src.client.legacy_models.sql_execution_job_response import LSqlExecutionJobResponse
from src.client.legacy_models.sql_script import LSqlScript
from src.client.legacy_models.sql_script_create_request import LSqlScriptCreateRequest
from src.client.legacy_models.sql_script_list import LSqlScriptList
from src.client.legacy_models.sql_script_update_request import LSqlScriptUpdateRequest
from src.client.legacy_models.ssh_key import LSshKey
from src.client.legacy_models.ssh_tunneling_basic import LSshTunnelingBasic
from src.client.legacy_models.ssh_tunneling_ssh_key import LSshTunnelingSshKey
from src.client.legacy_models.ssh_view_tunneling_basic import LSshViewTunnelingBasic
from src.client.legacy_models.stage import LStage
from src.client.legacy_models.start_task_success_response import LStartTaskSuccessResponse
from src.client.legacy_models.static_role_schema import LStaticRoleSchema
from src.client.legacy_models.status import LStatus
from src.client.legacy_models.storage_location_with_validation_info import LStorageLocationWithValidationInfo
from src.client.legacy_models.storage_metrics import LStorageMetrics
from src.client.legacy_models.string import LString
from src.client.legacy_models.suspend_list_users_payload import LSuspendListUsersPayload
from src.client.legacy_models.suspended_user_response import LSuspendedUserResponse
from src.client.legacy_models.table_watcher_trigger import LTableWatcherTrigger
from src.client.legacy_models.task_entity import LTaskEntity
from src.client.legacy_models.task_error_response import LTaskErrorResponse
from src.client.legacy_models.task_schema import LTaskSchema
from src.client.legacy_models.time_based_trigger import LTimeBasedTrigger
from src.client.legacy_models.token_auth import LTokenAuth
from src.client.legacy_models.token_type import LTokenType
from src.client.legacy_models.topk_chart import LTopkChart
from src.client.legacy_models.topk_value import LTopkValue
from src.client.legacy_models.transaction_key import LTransactionKey
from src.client.legacy_models.transfer_user_assets_payload import LTransferUserAssetsPayload
from src.client.legacy_models.transfer_user_assets_payload_with_email import LTransferUserAssetsPayloadWithEmail
from src.client.legacy_models.transfer_user_assets_payload_with_id import LTransferUserAssetsPayloadWithId
from src.client.legacy_models.type import LType
from src.client.legacy_models.type_check_histogram import LTypeCheckHistogram
from src.client.legacy_models.type_classification_info import LTypeClassificationInfo
from src.client.legacy_models.unsuspend_list_users_payload import LUnsuspendListUsersPayload
from src.client.legacy_models.update_group_payload import LUpdateGroupPayload
from src.client.legacy_models.update_group_response import LUpdateGroupResponse
from src.client.legacy_models.update_imported_dataset_request import LUpdateImportedDatasetRequest
from src.client.legacy_models.updated_object_schema import LUpdatedObjectSchema
from src.client.legacy_models.upload_dir_option import LUploadDirOption
from src.client.legacy_models.upsert_flow_graph_vertex_object import LUpsertFlowGraphVertexObject
from src.client.legacy_models.user_avatar import LUserAvatar
from src.client.legacy_models.user_defined_function import LUserDefinedFunction
from src.client.legacy_models.user_preference import LUserPreference
from src.client.legacy_models.user_with_api_token import LUserWithApiToken
from src.client.legacy_models.valid_value_histogram import LValidValueHistogram
from src.client.legacy_models.vfs_node import LVfsNode
from src.client.legacy_models.view_state import LViewState
from src.client.legacy_models.webhook_flow_task import LWebhookFlowTask
from src.client.legacy_models.webhook_flow_task_create_request import LWebhookFlowTaskCreateRequest
from src.client.legacy_models.webhook_flow_task_create_request_any import LWebhookFlowTaskCreateRequestAny
from src.client.legacy_models.webhook_flow_task_create_request_some import LWebhookFlowTaskCreateRequestSome
from src.client.legacy_models.webhook_override import LWebhookOverride
from src.client.legacy_models.webhook_test_request import LWebhookTestRequest
from src.client.legacy_models.webhook_test_response import LWebhookTestResponse
from src.client.legacy_models.weekly_trigger import LWeeklyTrigger
from src.client.legacy_models.workload_error_report_schema import LWorkloadErrorReportSchema
from src.client.legacy_models.workload_error_schema import LWorkloadErrorSchema
from src.client.legacy_models.workspace import LWorkspace
from src.client.legacy_models.workspace_create_request import LWorkspaceCreateRequest
from src.client.legacy_models.workspace_tiers_info import LWorkspaceTiersInfo
from src.client.legacy_models.workspace_user_id import LWorkspaceUserId
from src.client.legacy_models.workspace_user_id_list import LWorkspaceUserIdList
from src.client.legacy_models.workspaces_list import LWorkspacesList
from src.client.legacy_models.wrangle_job import LWrangleJob
from src.client.legacy_models.wrangle_job_create_request import LWrangleJobCreateRequest
from src.client.legacy_models.wrangle_job_request import LWrangleJobRequest
from src.client.legacy_models.wrangle_job_response import LWrangleJobResponse
from src.client.legacy_models.wrangled_dataset import LWrangledDataset
from src.client.legacy_models.wrangled_dataset_create_request import LWrangledDatasetCreateRequest
from src.client.legacy_models.wrangled_dataset_list import LWrangledDatasetList
from src.client.legacy_models.wrangled_dataset_payload import LWrangledDatasetPayload
from src.client.legacy_models.wrangled_dataset_update_request import LWrangledDatasetUpdateRequest
from src.client.legacy_models.wrangled_dataset_update_response import LWrangledDatasetUpdateResponse
from src.client.legacy_models.wrangled_or_imported_dataset import LWrangledOrImportedDataset
from src.client.legacy_models.write_setting import LWriteSetting
from src.client.legacy_models.write_setting_create_request import LWriteSettingCreateRequest
from src.client.legacy_models.write_setting_list import LWriteSettingList
from src.client.legacy_models.write_setting_update_request import LWriteSettingUpdateRequest
