# coding: utf-8

"""
    Alteryx Analytics Cloud API

      # Overview  To enable programmatic control over its objects, the Alteryx Analytics Cloud Platform supports a range of REST API endpoints across its objects. This section provides an overview of the API design, methods, and supported use cases.  Most of the endpoints accept `JSON` as input and return `JSON` responses. This means that you must usually add the following headers to your request: ``` Content-type: application/json Accept: application/json ```    <small><!--__VERSION__--></small>  ## Resources  The term `resource` refers to a single type of object in the Alteryx Analytics Cloud Platform metadata. An API is broken up by its endpoint's corresponding resource. The name of a resource is typically plural, and expressed in camelCase. Example: `jobGroups`.  Resource names are used as part of endpoint URLs, as well as in API parameters and responses.  ## CRUD Operations  The platform supports **C**reate, **R**ead, **U**pdate, and **D**elete operations on most resources.  You can review the standards for these operations and their standard parameters below.  Some endpoints have special behavior as exceptions.  ### Create  To create a resource, you typically submit an HTTP `POST` request with the resource's required metadata in the request body. The response returns a `201 Created` response code upon success with the resource's metadata, including its internal `id`, in the response body.  ### Read  An HTTP `GET` request can be used to read a resource or to list a number of resources.  A resource's `id` can be submitted in the request parameters to read a specific resource. The response usually returns a `200 OK` response code upon success, with the resource's metadata in the response body.  If a `GET` request does not include a specific resource `id`, it is treated as a list request. The response usually returns a `200 OK` response code upon success, with an object containing a list of resources' metadata in the response body.   When reading resources, some c... [truncated]

    OpenAPI spec version: v2025.23.2
     
"""

import pprint
import re  # noqa: F401

import six
from src.client.legacy_models.base_object_schema import LBaseObjectSchema  # noqa: F401,E501

class LWrangledDataset(LBaseObjectSchema):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'flow': 'object',
        'recipe': 'object',
        'active_sample': 'object',
        'associated_people': 'object',
        'referenceinfo': 'object',
        'wrangled': 'bool'
    }
    if hasattr(LBaseObjectSchema, "swagger_types"):
        swagger_types.update(LBaseObjectSchema.swagger_types)

    attribute_map = {
        'flow': 'flow',
        'recipe': 'recipe',
        'active_sample': 'activeSample',
        'associated_people': 'associatedPeople',
        'referenceinfo': 'referenceinfo',
        'wrangled': 'wrangled'
    }
    if hasattr(LBaseObjectSchema, "attribute_map"):
        attribute_map.update(LBaseObjectSchema.attribute_map)

    def __init__(self, flow=None, recipe=None, active_sample=None, associated_people=None, referenceinfo=None, wrangled=None, *args, **kwargs):  # noqa: E501
        """LWrangledDataset - a model defined in Swagger"""  # noqa: E501
        self._flow = None
        self._recipe = None
        self._active_sample = None
        self._associated_people = None
        self._referenceinfo = None
        self._wrangled = None
        self.discriminator = None
        self.flow = flow
        if recipe is not None:
            self.recipe = recipe
        if active_sample is not None:
            self.active_sample = active_sample
        if associated_people is not None:
            self.associated_people = associated_people
        if referenceinfo is not None:
            self.referenceinfo = referenceinfo
        self.wrangled = wrangled
        LBaseObjectSchema.__init__(self, *args, **kwargs)

    @property
    def flow(self):
        """Gets the flow of this LWrangledDataset.  # noqa: E501


        :return: The flow of this LWrangledDataset.  # noqa: E501
        :rtype: object
        """
        return self._flow

    @flow.setter
    def flow(self, flow):
        """Sets the flow of this LWrangledDataset.


        :param flow: The flow of this LWrangledDataset.  # noqa: E501
        :type: object
        """
        if flow is None:
            raise ValueError("Invalid value for `flow`, must not be `None`")  # noqa: E501

        self._flow = flow

    @property
    def recipe(self):
        """Gets the recipe of this LWrangledDataset.  # noqa: E501


        :return: The recipe of this LWrangledDataset.  # noqa: E501
        :rtype: object
        """
        return self._recipe

    @recipe.setter
    def recipe(self, recipe):
        """Sets the recipe of this LWrangledDataset.


        :param recipe: The recipe of this LWrangled.  # noqa: E501
        :type: object
        """

        self._recipe = recipe

    @property
    def active_sample(self):
        """Gets the active_sample of this LWrangledDataset.  # noqa: E501


        :return: The active_sample of this LWrangledDataset.  # noqa: E501
        :rtype: object
        """
        return self._active_sample

    @active_sample.setter
    def active_sample(self, active_sample):
        """Sets the active_sample of this LWrangledDataset.


        :param active_sample: The active_sample of this LWrangledDataset.  # noqa: E501
        :type: object
        """

        self._active_sample = active_sample

    @property
    def associated_people(self):
        """Gets the associated_people of this LWrangledDataset.  # noqa: E501


        :return: The associated_people of this LWrangledDataset.  # noqa: E501
        :rtype: object
        """
        return self._associated_people

    @associated_people.setter
    def associated_people(self, associated_people):
        """Sets the associated_people of this LWrangledDataset.


        :param associated_people: The associated_people of this LWrangledDataset.  # noqa: E501
        :type: object
        """

        self._associated_people = associated_people

    @property
    def referenceinfo(self):
        """Gets the referenceinfo of this LWrangledDataset.  # noqa: E501


        :return: The referenceinfo of this LWrangledDataset.  # noqa: E501
        :rtype: object
        """
        return self._referenceinfo

    @referenceinfo.setter
    def referenceinfo(self, referenceinfo):
        """Sets the referenceinfo of this LWrangledDataset.


        :param referenceinfo: The referenceinfo of this LWrangledDataset.  # noqa: E501
        :type: object
        """

        self._referenceinfo = referenceinfo

    @property
    def wrangled(self):
        """Gets the wrangled of this LWrangledDataset.  # noqa: E501

        If false, this is an input dataset (i.e. an imported dataset or a reference dataset). If true, this flowNode contains a recipe that can be edited by the user.  # noqa: E501

        :return: The wrangled of this LWrangledDataset.  # noqa: E501
        :rtype: bool
        """
        return self._wrangled

    @wrangled.setter
    def wrangled(self, wrangled):
        """Sets the wrangled of this LWrangledDataset.

        If false, this is an input dataset (i.e. an imported dataset or a reference dataset). If true, this flowNode contains a recipe that can be edited by the user.  # noqa: E501

        :param wrangled: The wrangled of this LWrangledDataset.  # noqa: E501
        :type: bool
        """
        if wrangled is None:
            raise ValueError("Invalid value for `wrangled`, must not be `None`")  # noqa: E501

        self._wrangled = wrangled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LWrangledDataset, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LWrangledDataset):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other