# coding: utf-8

"""
    Plans (Beta)

 

    OpenAPI spec version: v2024.20.0
     
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from  src.client.api.api_client import ApiClient


class PlanApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
     
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def count_plans(self, **kwargs):  # noqa: E501
        """Count plans  # noqa: E501

        Retrieve the total count of existing plans based on the specified query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_plans(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ownership_filter: Filter plans by ownership.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str filter_fields: comma-separated list of fields to match the `filter` parameter against.
        :param str filter: Value for filtering objects. See `filterFields`.
        :return: Count
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.count_plans_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.count_plans_with_http_info(**kwargs)  # noqa: E501
            return data

    def count_plans_with_http_info(self, **kwargs):  # noqa: E501
        """Count plans  # noqa: E501

        Retrieve the total count of existing plans based on the specified query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_plans_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ownership_filter: Filter plans by ownership.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str filter_fields: comma-separated list of fields to match the `filter` parameter against.
        :param str filter: Value for filtering objects. See `filterFields`.
        :return: Count
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ownership_filter', 'filter_type', 'filter_fields', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_plans" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ownership_filter' in params:
            query_params.append(('ownershipFilter', params['ownership_filter']))  # noqa: E501
        if 'filter_type' in params:
            query_params.append(('filterType', params['filter_type']))  # noqa: E501
        if 'filter_fields' in params:
            query_params.append(('filterFields', params['filter_fields']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Count',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_plan(self, body, **kwargs):  # noqa: E501
        """Create plan  # noqa: E501

        Create a new plan by defining the plan's `name` and other optional parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plan(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PlanCreateRequest body: (required)
        :return: Plan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_plan_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_plan_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_plan_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create plan  # noqa: E501

        Create a new plan by defining the plan's `name` and other optional parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_plan_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PlanCreateRequest body: (required)
        :return: Plan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_plan(self, id, **kwargs):  # noqa: E501
        """Delete plan  # noqa: E501

        Delete a specific plan and remove its associated schedules.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plan(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_plan_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_plan_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_plan_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete plan  # noqa: E501

        Delete a specific plan and remove its associated schedules.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plan_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_plan_permissions(self, id, subject_id, **kwargs):  # noqa: E501
        """Delete plan permissions for a user  # noqa: E501

        Remove permissions from a specific plan.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plan_permissions(id, subject_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int subject_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_plan_permissions_with_http_info(id, subject_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_plan_permissions_with_http_info(id, subject_id, **kwargs)  # noqa: E501
            return data

    def delete_plan_permissions_with_http_info(self, id, subject_id, **kwargs):  # noqa: E501
        """Delete plan permissions for a user  # noqa: E501

        Remove permissions from a specific plan.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plan_permissions_with_http_info(id, subject_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int subject_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'subject_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_plan_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_plan_permissions`")  # noqa: E501
        # verify the required parameter 'subject_id' is set
        if ('subject_id' not in params or
                params['subject_id'] is None):
            raise ValueError("Missing the required parameter `subject_id` when calling `delete_plan_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'subject_id' in params:
            path_params['subjectId'] = params['subject_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/permissions/{subjectId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_plan_package(self, id, **kwargs):  # noqa: E501
        """Export plan  # noqa: E501

        Retrieve a package containing the definition of the specified plan.  The response body includes the package contents, which are a ZIP-compressed version of the plan definition.  > ℹ️ **NOTE**: This package can be used to import the plan into another environment. See the [Import Plan Package](#operation/importPackage) for more information.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plan_package(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str comment: comment to be displayed when plan is imported in a deployment package
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_plan_package_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_plan_package_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_plan_package_with_http_info(self, id, **kwargs):  # noqa: E501
        """Export plan  # noqa: E501

        Retrieve a package containing the definition of the specified plan.  The response body includes the package contents, which are a ZIP-compressed version of the plan definition.  > ℹ️ **NOTE**: This package can be used to import the plan into another environment. See the [Import Plan Package](#operation/importPackage) for more information.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plan_package_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str comment: comment to be displayed when plan is imported in a deployment package
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plan_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_plan_package`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'comment' in params:
            query_params.append(('comment', params['comment']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/package', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_plan_permissions(self, id, **kwargs):  # noqa: E501
        """List permissions for plan  # noqa: E501

        Retrieve a list of users with whom the plan is shared.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plan_permissions(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: PlanPermissionPersonResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_plan_permissions_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_plan_permissions_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_plan_permissions_with_http_info(self, id, **kwargs):  # noqa: E501
        """List permissions for plan  # noqa: E501

        Retrieve a list of users with whom the plan is shared.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plan_permissions_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: PlanPermissionPersonResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plan_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_plan_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlanPermissionPersonResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_schedules_for_plan(self, id, **kwargs):  # noqa: E501
        """List plan schedules  # noqa: E501

        Retrieve all schedules configured in a specific plan.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedules_for_plan(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_schedules_for_plan_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_schedules_for_plan_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_schedules_for_plan_with_http_info(self, id, **kwargs):  # noqa: E501
        """List plan schedules  # noqa: E501

        Retrieve all schedules configured in a specific plan.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedules_for_plan_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedules_for_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_schedules_for_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/schedules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_plan_package(self, **kwargs):  # noqa: E501
        """Import plan package  # noqa: E501

        Import the plan and associated flows from the provided package. The endpoint accepts a `ZIP` file exported by the [export plan endpoint](#operation/getPlanPackage).  Before the import, you can perform a dry run to check for errors. See [Import plan package - dry run](#operation/importPackageDryRun).  This endpoint accepts a `multipart/form-data` content type.  Here is how to send the `ZIP` package using [curl](https://curl.haxx.se/):  ``` curl -X POST https://ayx-sandbox.bender.rocks/v4/plans/package \\ -H 'authorization: Bearer <api-token>' \\ -H 'content-type: multipart/form-data' \\ -F 'data=@path/to/plan-package.zip' ```  The response includes a list of created objects.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_plan_package(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportPlanDataRequest body:
        :param int folder_id:
        :param bool from_ui: If true, will return the list of imported environment parameters for confirmation if any are referenced in the plan.
        :return: ImportPlanPackageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_plan_package_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.import_plan_package_with_http_info(**kwargs)  # noqa: E501
            return data

    def import_plan_package_with_http_info(self, **kwargs):  # noqa: E501
        """Import plan package  # noqa: E501

        Import the plan and associated flows from the provided package. The endpoint accepts a `ZIP` file exported by the [export plan endpoint](#operation/getPlanPackage).  Before the import, you can perform a dry run to check for errors. See [Import plan package - dry run](#operation/importPackageDryRun).  This endpoint accepts a `multipart/form-data` content type.  Here is how to send the `ZIP` package using [curl](https://curl.haxx.se/):  ``` curl -X POST https://ayx-sandbox.bender.rocks/v4/plans/package \\ -H 'authorization: Bearer <api-token>' \\ -H 'content-type: multipart/form-data' \\ -F 'data=@path/to/plan-package.zip' ```  The response includes a list of created objects.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_plan_package_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportPlanDataRequest body:
        :param int folder_id:
        :param bool from_ui: If true, will return the list of imported environment parameters for confirmation if any are referenced in the plan.
        :return: ImportPlanPackageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'folder_id', 'from_ui']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_plan_package" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'folder_id' in params:
            query_params.append(('folderId', params['folder_id']))  # noqa: E501
        if 'from_ui' in params:
            query_params.append(('fromUI', params['from_ui']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            form_params.append(('File', params['file']))  # noqa: E501
        if 'environment_parameter_mapping' in params:
            form_params.append(('environmentParameterMapping', params['environment_parameter_mapping']))  # noqa: E501
            collection_formats['environmentParameterMapping'] = 'multi'  # noqa: E501
        if 'connection_id_mapping' in params:
            form_params.append(('connectionIdMapping', params['connection_id_mapping']))  # noqa: E501
            collection_formats['connectionIdMapping'] = 'multi'  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/package', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportPlanPackageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_plan_package(self, **kwargs):  # noqa: E501
        """Import plan package  # noqa: E501

        Import the plan and associated flows from the provided package. The endpoint accepts a `ZIP` file exported by the [export plan endpoint](#operation/getPlanPackage).  Before the import, you can perform a dry run to check for errors. See [Import plan package - dry run](#operation/importPackageDryRun).  This endpoint accepts a `multipart/form-data` content type.  Here is how to send the `ZIP` package using [curl](https://curl.haxx.se/):  ``` curl -X POST https://ayx-sandbox.bender.rocks/v4/plans/package \\ -H 'authorization: Bearer <api-token>' \\ -H 'content-type: multipart/form-data' \\ -F 'data=@path/to/plan-package.zip' ```  The response includes a list of created objects.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_plan_package(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportPlanPackageRequestZip file:
        :param list[EnvironmentParameterMapping] environment_parameter_mapping:
        :param list[ConnectionIdMapping] connection_id_mapping:
        :param int folder_id:
        :param bool from_ui: If true, will return the list of imported environment parameters for confirmation if any are referenced in the plan.
        :return: ImportPlanPackageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_plan_package_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.import_plan_package_with_http_info(**kwargs)  # noqa: E501
            return data

    def import_plan_package_with_http_info(self, **kwargs):  # noqa: E501
        """Import plan package  # noqa: E501

        Import the plan and associated flows from the provided package. The endpoint accepts a `ZIP` file exported by the [export plan endpoint](#operation/getPlanPackage).  Before the import, you can perform a dry run to check for errors. See [Import plan package - dry run](#operation/importPackageDryRun).  This endpoint accepts a `multipart/form-data` content type.  Here is how to send the `ZIP` package using [curl](https://curl.haxx.se/):  ``` curl -X POST https://ayx-sandbox.bender.rocks/v4/plans/package \\ -H 'authorization: Bearer <api-token>' \\ -H 'content-type: multipart/form-data' \\ -F 'data=@path/to/plan-package.zip' ```  The response includes a list of created objects.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_plan_package_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportPlanPackageRequestZip file:
        :param list[EnvironmentParameterMapping] environment_parameter_mapping:
        :param list[ConnectionIdMapping] connection_id_mapping:
        :param int folder_id:
        :param bool from_ui: If true, will return the list of imported environment parameters for confirmation if any are referenced in the plan.
        :return: ImportPlanPackageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'environment_parameter_mapping', 'connection_id_mapping', 'folder_id', 'from_ui']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_plan_package" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'folder_id' in params:
            query_params.append(('folderId', params['folder_id']))  # noqa: E501
        if 'from_ui' in params:
            query_params.append(('fromUI', params['from_ui']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            form_params.append(('File', params['file']))  # noqa: E501
        if 'environment_parameter_mapping' in params:
            form_params.append(('environmentParameterMapping', params['environment_parameter_mapping']))  # noqa: E501
            collection_formats['environmentParameterMapping'] = 'multi'  # noqa: E501
        if 'connection_id_mapping' in params:
            form_params.append(('connectionIdMapping', params['connection_id_mapping']))  # noqa: E501
            collection_formats['connectionIdMapping'] = 'multi'  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/package', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportPlanPackageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plans(self, **kwargs):  # noqa: E501
        """List plans  # noqa: E501

        Retrieve all existing plans along with their details, using query parameters to filter the results.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plans(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields: Semi-colons-separated list of fields
        :param str embed: Comma-separated list of objects to pull in as part of the response. See [Embedding Resources](#section/Overview/Embedding-Resources) for more information.
        :param IncludeDeleted include_deleted: Whether to include all or some of the nested deleted objects.
        :param int limit: Maximum number of objects to fetch.
        :param int offset: Offset after which to start returning objects. For use with `limit`.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param str filter_fields: comma-separated list of fields to match the `filter` parameter against.
        :param str filter: Value for filtering objects. See `filterFields`.
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :param bool include_associated_people: If true, the returned plans will include a list of people with access.
        :param str ownership_filter: Filter plans by ownership. Valid values are 'all', 'shared', and 'owned'.
        :return: PlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plans_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_plans_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_plans_with_http_info(self, **kwargs):  # noqa: E501
        """List plans  # noqa: E501

        Retrieve all existing plans along with their details, using query parameters to filter the results.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plans_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields: Semi-colons-separated list of fields
        :param str embed: Comma-separated list of objects to pull in as part of the response. See [Embedding Resources](#section/Overview/Embedding-Resources) for more information.
        :param IncludeDeleted include_deleted: Whether to include all or some of the nested deleted objects.
        :param int limit: Maximum number of objects to fetch.
        :param int offset: Offset after which to start returning objects. For use with `limit`.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param str filter_fields: comma-separated list of fields to match the `filter` parameter against.
        :param str filter: Value for filtering objects. See `filterFields`.
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :param bool include_associated_people: If true, the returned plans will include a list of people with access.
        :param str ownership_filter: Filter plans by ownership. Valid values are 'all', 'shared', and 'owned'.
        :return: PlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'embed', 'include_deleted', 'limit', 'offset', 'filter_type', 'sort', 'filter_fields', 'filter', 'include_count', 'include_associated_people', 'ownership_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plans" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'embed' in params:
            query_params.append(('embed', params['embed']))  # noqa: E501
        if 'include_deleted' in params:
            query_params.append(('includeDeleted', params['include_deleted']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter_type' in params:
            query_params.append(('filterType', params['filter_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'filter_fields' in params:
            query_params.append(('filterFields', params['filter_fields']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'include_count' in params:
            query_params.append(('includeCount', params['include_count']))  # noqa: E501
        if 'include_associated_people' in params:
            query_params.append(('includeAssociatedPeople', params['include_associated_people']))  # noqa: E501
        if 'ownership_filter' in params:
            query_params.append(('ownershipFilter', params['ownership_filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlanList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def plan_run_parameters(self, id, **kwargs):  # noqa: E501
        """List run parameters  # noqa: E501

        Retrieve a list of run parameters for a specific plan, grouped by plan node.  Each element in the response will include only resources that have defined run parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.plan_run_parameters(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: RunParameterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.plan_run_parameters_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.plan_run_parameters_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def plan_run_parameters_with_http_info(self, id, **kwargs):  # noqa: E501
        """List run parameters  # noqa: E501

        Retrieve a list of run parameters for a specific plan, grouped by plan node.  Each element in the response will include only resources that have defined run parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.plan_run_parameters_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: RunParameterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method plan_run_parameters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `plan_run_parameters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/runParameters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RunParameterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_full(self, id, **kwargs):  # noqa: E501
        """Read plan with all attributes  # noqa: E501

        Retrieve the full plan, including all its nodes, tasks, and edges.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_full(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields: Semi-colons-separated list of fields
        :param str embed: Comma-separated list of objects to pull in as part of the response. See [Embedding Resources](#section/Overview/Embedding-Resources) for more information.
        :param IncludeDeleted1 include_deleted: Whether to include all or some of the nested deleted objects.
        :param bool include_associated_people: If true, the returned plan will include a list of people with access.
        :param bool include_creator_info: If true, the returned plan will include info about the creators of the flows and plan such as name and email address.
        :return: Plan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_full_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.read_full_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def read_full_with_http_info(self, id, **kwargs):  # noqa: E501
        """Read plan with all attributes  # noqa: E501

        Retrieve the full plan, including all its nodes, tasks, and edges.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_full_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields: Semi-colons-separated list of fields
        :param str embed: Comma-separated list of objects to pull in as part of the response. See [Embedding Resources](#section/Overview/Embedding-Resources) for more information.
        :param IncludeDeleted1 include_deleted: Whether to include all or some of the nested deleted objects.
        :param bool include_associated_people: If true, the returned plan will include a list of people with access.
        :param bool include_creator_info: If true, the returned plan will include info about the creators of the flows and plan such as name and email address.
        :return: Plan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'embed', 'include_deleted', 'include_associated_people', 'include_creator_info']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_full" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `read_full`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'embed' in params:
            query_params.append(('embed', params['embed']))  # noqa: E501
        if 'include_deleted' in params:
            query_params.append(('includeDeleted', params['include_deleted']))  # noqa: E501
        if 'include_associated_people' in params:
            query_params.append(('includeAssociatedPeople', params['include_associated_people']))  # noqa: E501
        if 'include_creator_info' in params:
            query_params.append(('includeCreatorInfo', params['include_creator_info']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/full', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def run_plan(self, id, **kwargs):  # noqa: E501
        """Run plan  # noqa: E501

        Run a specific plan. A new snapshot is created if required.  If any flows or outputs referenced by the plan tasks have been deleted, the response includes a `MissingFlowReferences` validation status.  If the plan is valid, it is queued for execution. This endpoint returns a `planSnapshotRunId` that can be used to track the plan execution status using [getPlanSnapshotRun](#operation/getPlanSnapshotRun).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_plan(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param RunPlanBody body:
        :param str x_execution_id: Optional header to safely retry the request without accidentally performing the same operation twice. If a `PlanSnapshotRun` with the same `executionId` already exists, the request will return a `304`.
        :return: RunPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.run_plan_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.run_plan_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def run_plan_with_http_info(self, id, **kwargs):  # noqa: E501
        """Run plan  # noqa: E501

        Run a specific plan. A new snapshot is created if required.  If any flows or outputs referenced by the plan tasks have been deleted, the response includes a `MissingFlowReferences` validation status.  If the plan is valid, it is queued for execution. This endpoint returns a `planSnapshotRunId` that can be used to track the plan execution status using [getPlanSnapshotRun](#operation/getPlanSnapshotRun).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_plan_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param RunPlanBody body:
        :param str x_execution_id: Optional header to safely retry the request without accidentally performing the same operation twice. If a `PlanSnapshotRun` with the same `executionId` already exists, the request will return a `304`.
        :return: RunPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'x_execution_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `run_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_execution_id' in params:
            header_params['x-execution-id'] = params['x_execution_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/run', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RunPlanResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def share_plan(self, body, id, **kwargs):  # noqa: E501
        """Share Plan  # noqa: E501

        Share a plan with other users and assign specific roles and policies.  > ℹ️ **NOTE**: Collaborators have edit permissions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.share_plan(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SharePlanRequest body: (required)
        :param int id: (required)
        :return: SharePlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.share_plan_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.share_plan_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def share_plan_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Share Plan  # noqa: E501

        Share a plan with other users and assign specific roles and policies.  > ℹ️ **NOTE**: Collaborators have edit permissions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.share_plan_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SharePlanRequest body: (required)
        :param int id: (required)
        :return: SharePlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method share_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `share_plan`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `share_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}/permissions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SharePlanResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plan(self, body, id, **kwargs):  # noqa: E501
        """Update plan  # noqa: E501

        Update properties of a specific plan, such as `name` and `description`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plan(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PlanUpdateRequest body: (required)
        :param int id: (required)
        :return: Plan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plan_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plan_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_plan_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update plan  # noqa: E501

        Update properties of a specific plan, such as `name` and `description`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plan_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PlanUpdateRequest body: (required)
        :param int id: (required)
        :return: Plan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_plan`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/plans/v1/plans/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Plan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
