# coding: utf-8

"""
    Plans (Beta)

 

    OpenAPI spec version: v2024.20.0
     
"""

import pprint
import re  # noqa: F401

import six

class OutputObject(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'execution': 'str',
        'profiler': 'bool',
        'is_adhoc': 'bool',
        'flownode': 'FlowWorkspace',
        'id': 'AnyOfoutputObjectId',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'creator': 'BaseObjectSchemaCreator',
        'updater': 'BaseObjectSchemaUpdater',
        'name': 'str',
        'description': 'str'
    }

    attribute_map = {
        'execution': 'execution',
        'profiler': 'profiler',
        'is_adhoc': 'isAdhoc',
        'flownode': 'flownode',
        'id': 'id',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'creator': 'creator',
        'updater': 'updater',
        'name': 'name',
        'description': 'description'
    }

    def __init__(self, execution=None, profiler=None, is_adhoc=True, flownode=None, id=None, created_at=None, updated_at=None, creator=None, updater=None, name=None, description=None):  # noqa: E501
        """OutputObject - a model defined in Swagger"""  # noqa: E501
        self._execution = None
        self._profiler = None
        self._is_adhoc = None
        self._flownode = None
        self._id = None
        self._created_at = None
        self._updated_at = None
        self._creator = None
        self._updater = None
        self._name = None
        self._description = None
        self.discriminator = None
        if execution is not None:
            self.execution = execution
        if profiler is not None:
            self.profiler = profiler
        if is_adhoc is not None:
            self.is_adhoc = is_adhoc
        if flownode is not None:
            self.flownode = flownode
        self.id = id
        self.created_at = created_at
        self.updated_at = updated_at
        if creator is not None:
            self.creator = creator
        if updater is not None:
            self.updater = updater
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description

    @property
    def execution(self):
        """Gets the execution of this OutputObject.  # noqa: E501

        Execution language. Indicate on which engine the job was executed.   Can be null/missing for scheduled jobs that fail during the validation phase.  * `photon` - Photon engine. High performance embedded engine designed for small datasets (up to 1GB).       Not available for all product editions. * `amp` - Amp engine. * `xml-amp` - XML-AMP engine. Only available for standard workflows.    * `emrSpark` - Spark engine running on EMR       # noqa: E501

        :return: The execution of this OutputObject.  # noqa: E501
        :rtype: str
        """
        return self._execution

    @execution.setter
    def execution(self, execution):
        """Sets the execution of this OutputObject.

        Execution language. Indicate on which engine the job was executed.   Can be null/missing for scheduled jobs that fail during the validation phase.  * `photon` - Photon engine. High performance embedded engine designed for small datasets (up to 1GB).       Not available for all product editions. * `amp` - Amp engine. * `xml-amp` - XML-AMP engine. Only available for standard workflows.    * `emrSpark` - Spark engine running on EMR       # noqa: E501

        :param execution: The execution of this OutputObject.  # noqa: E501
        :type: str
        """
        allowed_values = ["photon", "amp", "xml-amp", "emrSpark"]  # noqa: E501
        if execution not in allowed_values:
            raise ValueError(
                "Invalid value for `execution` ({0}), must be one of {1}"  # noqa: E501
                .format(execution, allowed_values)
            )

        self._execution = execution

    @property
    def profiler(self):
        """Gets the profiler of this OutputObject.  # noqa: E501

        Indicate if recipe errors should be ignored for the [jobGroup](#tag/JobGroup).  # noqa: E501

        :return: The profiler of this OutputObject.  # noqa: E501
        :rtype: bool
        """
        return self._profiler

    @profiler.setter
    def profiler(self, profiler):
        """Sets the profiler of this OutputObject.

        Indicate if recipe errors should be ignored for the [jobGroup](#tag/JobGroup).  # noqa: E501

        :param profiler: The profiler of this OutputObject.  # noqa: E501
        :type: bool
        """

        self._profiler = profiler

    @property
    def is_adhoc(self):
        """Gets the is_adhoc of this OutputObject.  # noqa: E501

        Indicate if the [outputObject](#tag/OutputObject) correspond to manual (Adhoc) or scheduled run.  # noqa: E501

        :return: The is_adhoc of this OutputObject.  # noqa: E501
        :rtype: bool
        """
        return self._is_adhoc

    @is_adhoc.setter
    def is_adhoc(self, is_adhoc):
        """Sets the is_adhoc of this OutputObject.

        Indicate if the [outputObject](#tag/OutputObject) correspond to manual (Adhoc) or scheduled run.  # noqa: E501

        :param is_adhoc: The is_adhoc of this OutputObject.  # noqa: E501
        :type: bool
        """

        self._is_adhoc = is_adhoc

    @property
    def flownode(self):
        """Gets the flownode of this OutputObject.  # noqa: E501


        :return: The flownode of this OutputObject.  # noqa: E501
        :rtype: FlowWorkspace
        """
        return self._flownode

    @flownode.setter
    def flownode(self, flownode):
        """Sets the flownode of this OutputObject.


        :param flownode: The flownode of this OutputObject.  # noqa: E501
        :type: FlowWorkspace
        """

        self._flownode = flownode

    @property
    def id(self):
        """Gets the id of this OutputObject.  # noqa: E501


        :return: The id of this OutputObject.  # noqa: E501
        :rtype: AnyOfoutputObjectId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this OutputObject.


        :param id: The id of this OutputObject.  # noqa: E501
        :type: AnyOfoutputObjectId
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this OutputObject.  # noqa: E501

        The time this object was first created.  # noqa: E501

        :return: The created_at of this OutputObject.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this OutputObject.

        The time this object was first created.  # noqa: E501

        :param created_at: The created_at of this OutputObject.  # noqa: E501
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this OutputObject.  # noqa: E501

        The time this object was last updated.  # noqa: E501

        :return: The updated_at of this OutputObject.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this OutputObject.

        The time this object was last updated.  # noqa: E501

        :param updated_at: The updated_at of this OutputObject.  # noqa: E501
        :type: datetime
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    @property
    def creator(self):
        """Gets the creator of this OutputObject.  # noqa: E501


        :return: The creator of this OutputObject.  # noqa: E501
        :rtype: BaseObjectSchemaCreator
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this OutputObject.


        :param creator: The creator of this OutputObject.  # noqa: E501
        :type: BaseObjectSchemaCreator
        """

        self._creator = creator

    @property
    def updater(self):
        """Gets the updater of this OutputObject.  # noqa: E501


        :return: The updater of this OutputObject.  # noqa: E501
        :rtype: BaseObjectSchemaUpdater
        """
        return self._updater

    @updater.setter
    def updater(self, updater):
        """Sets the updater of this OutputObject.


        :param updater: The updater of this OutputObject.  # noqa: E501
        :type: BaseObjectSchemaUpdater
        """

        self._updater = updater

    @property
    def name(self):
        """Gets the name of this OutputObject.  # noqa: E501

        Name of output as it appears in the flow view  # noqa: E501

        :return: The name of this OutputObject.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OutputObject.

        Name of output as it appears in the flow view  # noqa: E501

        :param name: The name of this OutputObject.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this OutputObject.  # noqa: E501

        Description of output  # noqa: E501

        :return: The description of this OutputObject.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this OutputObject.

        Description of output  # noqa: E501

        :param description: The description of this OutputObject.  # noqa: E501
        :type: str
        """

        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OutputObject, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OutputObject):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
