# coding: utf-8

"""
    Plans (Beta)

 

    OpenAPI spec version: v2024.20.0
     
"""

import pprint
import re  # noqa: F401

import six

class Plan(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'AnyOfplanId',
        'name': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'creator': 'BaseObjectSchemaCreator',
        'updater': 'BaseObjectSchemaUpdater',
        'workspace': 'FlowWorkspace',
        'snapshotted': 'bool',
        'original_plan_id': 'AnyOfplanOriginalPlanId',
        'description': 'str',
        'plan_snapshot_run_count': 'int',
        'notifications_enabled': 'bool',
        'latest_plan_snapshot': 'object',
        'latest_plan_snapshot_run': 'object',
        'plan_nodes': 'PlanPlanNodes'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'creator': 'creator',
        'updater': 'updater',
        'workspace': 'workspace',
        'snapshotted': 'snapshotted',
        'original_plan_id': 'originalPlanId',
        'description': 'description',
        'plan_snapshot_run_count': 'planSnapshotRunCount',
        'notifications_enabled': 'notificationsEnabled',
        'latest_plan_snapshot': 'latestPlanSnapshot',
        'latest_plan_snapshot_run': 'latestPlanSnapshotRun',
        'plan_nodes': 'planNodes'
    }

    def __init__(self, id=None, name=None, created_at=None, updated_at=None, creator=None, updater=None, workspace=None, snapshotted=None, original_plan_id=None, description=None, plan_snapshot_run_count=None, notifications_enabled=None, latest_plan_snapshot=None, latest_plan_snapshot_run=None, plan_nodes=None):  # noqa: E501
        """Plan - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._created_at = None
        self._updated_at = None
        self._creator = None
        self._updater = None
        self._workspace = None
        self._snapshotted = None
        self._original_plan_id = None
        self._description = None
        self._plan_snapshot_run_count = None
        self._notifications_enabled = None
        self._latest_plan_snapshot = None
        self._latest_plan_snapshot_run = None
        self._plan_nodes = None
        self.discriminator = None
        self.id = id
        self.name = name
        self.created_at = created_at
        self.updated_at = updated_at
        if creator is not None:
            self.creator = creator
        if updater is not None:
            self.updater = updater
        if workspace is not None:
            self.workspace = workspace
        if snapshotted is not None:
            self.snapshotted = snapshotted
        if original_plan_id is not None:
            self.original_plan_id = original_plan_id
        if description is not None:
            self.description = description
        if plan_snapshot_run_count is not None:
            self.plan_snapshot_run_count = plan_snapshot_run_count
        if notifications_enabled is not None:
            self.notifications_enabled = notifications_enabled
        if latest_plan_snapshot is not None:
            self.latest_plan_snapshot = latest_plan_snapshot
        if latest_plan_snapshot_run is not None:
            self.latest_plan_snapshot_run = latest_plan_snapshot_run
        if plan_nodes is not None:
            self.plan_nodes = plan_nodes

    @property
    def id(self):
        """Gets the id of this Plan.  # noqa: E501


        :return: The id of this Plan.  # noqa: E501
        :rtype: AnyOfplanId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Plan.


        :param id: The id of this Plan.  # noqa: E501
        :type: AnyOfplanId
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this Plan.  # noqa: E501

        Display name of the plan.  # noqa: E501

        :return: The name of this Plan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Plan.

        Display name of the plan.  # noqa: E501

        :param name: The name of this Plan.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def created_at(self):
        """Gets the created_at of this Plan.  # noqa: E501

        The time this object was first created.  # noqa: E501

        :return: The created_at of this Plan.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Plan.

        The time this object was first created.  # noqa: E501

        :param created_at: The created_at of this Plan.  # noqa: E501
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Plan.  # noqa: E501

        The time this object was last updated.  # noqa: E501

        :return: The updated_at of this Plan.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Plan.

        The time this object was last updated.  # noqa: E501

        :param updated_at: The updated_at of this Plan.  # noqa: E501
        :type: datetime
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    @property
    def creator(self):
        """Gets the creator of this Plan.  # noqa: E501


        :return: The creator of this Plan.  # noqa: E501
        :rtype: BaseObjectSchemaCreator
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this Plan.


        :param creator: The creator of this Plan.  # noqa: E501
        :type: BaseObjectSchemaCreator
        """

        self._creator = creator

    @property
    def updater(self):
        """Gets the updater of this Plan.  # noqa: E501


        :return: The updater of this Plan.  # noqa: E501
        :rtype: BaseObjectSchemaUpdater
        """
        return self._updater

    @updater.setter
    def updater(self, updater):
        """Sets the updater of this Plan.


        :param updater: The updater of this Plan.  # noqa: E501
        :type: BaseObjectSchemaUpdater
        """

        self._updater = updater

    @property
    def workspace(self):
        """Gets the workspace of this Plan.  # noqa: E501


        :return: The workspace of this Plan.  # noqa: E501
        :rtype: FlowWorkspace
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this Plan.


        :param workspace: The workspace of this Plan.  # noqa: E501
        :type: FlowWorkspace
        """

        self._workspace = workspace

    @property
    def snapshotted(self):
        """Gets the snapshotted of this Plan.  # noqa: E501


        :return: The snapshotted of this Plan.  # noqa: E501
        :rtype: bool
        """
        return self._snapshotted

    @snapshotted.setter
    def snapshotted(self, snapshotted):
        """Sets the snapshotted of this Plan.


        :param snapshotted: The snapshotted of this Plan.  # noqa: E501
        :type: bool
        """

        self._snapshotted = snapshotted

    @property
    def original_plan_id(self):
        """Gets the original_plan_id of this Plan.  # noqa: E501


        :return: The original_plan_id of this Plan.  # noqa: E501
        :rtype: AnyOfplanOriginalPlanId
        """
        return self._original_plan_id

    @original_plan_id.setter
    def original_plan_id(self, original_plan_id):
        """Sets the original_plan_id of this Plan.


        :param original_plan_id: The original_plan_id of this Plan.  # noqa: E501
        :type: AnyOfplanOriginalPlanId
        """

        self._original_plan_id = original_plan_id

    @property
    def description(self):
        """Gets the description of this Plan.  # noqa: E501

        User-friendly description for the plan.  # noqa: E501

        :return: The description of this Plan.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Plan.

        User-friendly description for the plan.  # noqa: E501

        :param description: The description of this Plan.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def plan_snapshot_run_count(self):
        """Gets the plan_snapshot_run_count of this Plan.  # noqa: E501


        :return: The plan_snapshot_run_count of this Plan.  # noqa: E501
        :rtype: int
        """
        return self._plan_snapshot_run_count

    @plan_snapshot_run_count.setter
    def plan_snapshot_run_count(self, plan_snapshot_run_count):
        """Sets the plan_snapshot_run_count of this Plan.


        :param plan_snapshot_run_count: The plan_snapshot_run_count of this Plan.  # noqa: E501
        :type: int
        """

        self._plan_snapshot_run_count = plan_snapshot_run_count

    @property
    def notifications_enabled(self):
        """Gets the notifications_enabled of this Plan.  # noqa: E501

        Indicate if notification will be sent for this plan  # noqa: E501

        :return: The notifications_enabled of this Plan.  # noqa: E501
        :rtype: bool
        """
        return self._notifications_enabled

    @notifications_enabled.setter
    def notifications_enabled(self, notifications_enabled):
        """Sets the notifications_enabled of this Plan.

        Indicate if notification will be sent for this plan  # noqa: E501

        :param notifications_enabled: The notifications_enabled of this Plan.  # noqa: E501
        :type: bool
        """

        self._notifications_enabled = notifications_enabled

    @property
    def latest_plan_snapshot(self):
        """Gets the latest_plan_snapshot of this Plan.  # noqa: E501

        Latest plan snapshot that is attached to this plan.  # noqa: E501

        :return: The latest_plan_snapshot of this Plan.  # noqa: E501
        :rtype: object
        """
        return self._latest_plan_snapshot

    @latest_plan_snapshot.setter
    def latest_plan_snapshot(self, latest_plan_snapshot):
        """Sets the latest_plan_snapshot of this Plan.

        Latest plan snapshot that is attached to this plan.  # noqa: E501

        :param latest_plan_snapshot: The latest_plan_snapshot of this Plan.  # noqa: E501
        :type: object
        """

        self._latest_plan_snapshot = latest_plan_snapshot

    @property
    def latest_plan_snapshot_run(self):
        """Gets the latest_plan_snapshot_run of this Plan.  # noqa: E501

        Last snapshot of this plan that ran.  # noqa: E501

        :return: The latest_plan_snapshot_run of this Plan.  # noqa: E501
        :rtype: object
        """
        return self._latest_plan_snapshot_run

    @latest_plan_snapshot_run.setter
    def latest_plan_snapshot_run(self, latest_plan_snapshot_run):
        """Sets the latest_plan_snapshot_run of this Plan.

        Last snapshot of this plan that ran.  # noqa: E501

        :param latest_plan_snapshot_run: The latest_plan_snapshot_run of this Plan.  # noqa: E501
        :type: object
        """

        self._latest_plan_snapshot_run = latest_plan_snapshot_run

    @property
    def plan_nodes(self):
        """Gets the plan_nodes of this Plan.  # noqa: E501


        :return: The plan_nodes of this Plan.  # noqa: E501
        :rtype: PlanPlanNodes
        """
        return self._plan_nodes

    @plan_nodes.setter
    def plan_nodes(self, plan_nodes):
        """Sets the plan_nodes of this Plan.


        :param plan_nodes: The plan_nodes of this Plan.  # noqa: E501
        :type: PlanPlanNodes
        """

        self._plan_nodes = plan_nodes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Plan, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Plan):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
