# coding: utf-8

"""
    Plans (Beta)

 

    OpenAPI spec version: v2024.20.0
     
"""

import pprint
import re  # noqa: F401

import six

class PlanNode(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'AnyOfplanNodeId',
        'task_type': 'str',
        'creator': 'BaseObjectSchemaCreator',
        'updater': 'BaseObjectSchemaUpdater',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'coordinates': 'PlanFlowNodeCreateRequestCoordinates',
        'name': 'str'
    }

    attribute_map = {
        'id': 'id',
        'task_type': 'taskType',
        'creator': 'creator',
        'updater': 'updater',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'coordinates': 'coordinates',
        'name': 'name'
    }

    def __init__(self, id=None, task_type=None, creator=None, updater=None, created_at=None, updated_at=None, coordinates=None, name=None):  # noqa: E501
        """PlanNode - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._task_type = None
        self._creator = None
        self._updater = None
        self._created_at = None
        self._updated_at = None
        self._coordinates = None
        self._name = None
        self.discriminator = None
        self.id = id
        self.task_type = task_type
        self.creator = creator
        self.updater = updater
        self.created_at = created_at
        self.updated_at = updated_at
        if coordinates is not None:
            self.coordinates = coordinates
        self.name = name

    @property
    def id(self):
        """Gets the id of this PlanNode.  # noqa: E501


        :return: The id of this PlanNode.  # noqa: E501
        :rtype: AnyOfplanNodeId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PlanNode.


        :param id: The id of this PlanNode.  # noqa: E501
        :type: AnyOfplanNodeId
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def task_type(self):
        """Gets the task_type of this PlanNode.  # noqa: E501

         * `flow` -  * `http` -  * `storage` -  * `workflow` -  * `ml_predict` -  * `ml_retrain` -  * `script_sql` -  * `ml_project_update` -  * `reporting_generate` -   * `cefd_desktop` -  * `li_project_replay` -  * `ai_dataset` -  * `email` -  * `delay` -   # noqa: E501

        :return: The task_type of this PlanNode.  # noqa: E501
        :rtype: str
        """
        return self._task_type

    @task_type.setter
    def task_type(self, task_type):
        """Sets the task_type of this PlanNode.

         * `flow` -  * `http` -  * `storage` -  * `workflow` -  * `ml_predict` -  * `ml_retrain` -  * `script_sql` -  * `ml_project_update` -  * `reporting_generate` -   * `cefd_desktop` -  * `li_project_replay` -  * `ai_dataset` -  * `email` -  * `delay` -   # noqa: E501

        :param task_type: The task_type of this PlanNode.  # noqa: E501
        :type: str
        """
        if task_type is None:
            raise ValueError("Invalid value for `task_type`, must not be `None`")  # noqa: E501
        allowed_values = ["flow", "http", "storage", "workflow", "ml_predict", "ml_retrain", "script_sql", "ml_project_update", "reporting_generate", "cefd_desktop", "li_project_replay", "ai_dataset", "email", "delay"]  # noqa: E501
        if task_type not in allowed_values:
            raise ValueError(
                "Invalid value for `task_type` ({0}), must be one of {1}"  # noqa: E501
                .format(task_type, allowed_values)
            )

        self._task_type = task_type

    @property
    def creator(self):
        """Gets the creator of this PlanNode.  # noqa: E501


        :return: The creator of this PlanNode.  # noqa: E501
        :rtype: BaseObjectSchemaCreator
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this PlanNode.


        :param creator: The creator of this PlanNode.  # noqa: E501
        :type: BaseObjectSchemaCreator
        """
        if creator is None:
            raise ValueError("Invalid value for `creator`, must not be `None`")  # noqa: E501

        self._creator = creator

    @property
    def updater(self):
        """Gets the updater of this PlanNode.  # noqa: E501


        :return: The updater of this PlanNode.  # noqa: E501
        :rtype: BaseObjectSchemaUpdater
        """
        return self._updater

    @updater.setter
    def updater(self, updater):
        """Sets the updater of this PlanNode.


        :param updater: The updater of this PlanNode.  # noqa: E501
        :type: BaseObjectSchemaUpdater
        """
        if updater is None:
            raise ValueError("Invalid value for `updater`, must not be `None`")  # noqa: E501

        self._updater = updater

    @property
    def created_at(self):
        """Gets the created_at of this PlanNode.  # noqa: E501

        The time this object was first created.  # noqa: E501

        :return: The created_at of this PlanNode.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this PlanNode.

        The time this object was first created.  # noqa: E501

        :param created_at: The created_at of this PlanNode.  # noqa: E501
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this PlanNode.  # noqa: E501

        The time this object was last updated.  # noqa: E501

        :return: The updated_at of this PlanNode.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this PlanNode.

        The time this object was last updated.  # noqa: E501

        :param updated_at: The updated_at of this PlanNode.  # noqa: E501
        :type: datetime
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    @property
    def coordinates(self):
        """Gets the coordinates of this PlanNode.  # noqa: E501


        :return: The coordinates of this PlanNode.  # noqa: E501
        :rtype: PlanFlowNodeCreateRequestCoordinates
        """
        return self._coordinates

    @coordinates.setter
    def coordinates(self, coordinates):
        """Sets the coordinates of this PlanNode.


        :param coordinates: The coordinates of this PlanNode.  # noqa: E501
        :type: PlanFlowNodeCreateRequestCoordinates
        """

        self._coordinates = coordinates

    @property
    def name(self):
        """Gets the name of this PlanNode.  # noqa: E501

        Name of the plan node  # noqa: E501

        :return: The name of this PlanNode.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PlanNode.

        Name of the plan node  # noqa: E501

        :param name: The name of this PlanNode.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PlanNode, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlanNode):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
