# coding: utf-8

"""
    Scheduling (Alpha)

    No description provided (generated API client)  # noqa: E501

    OpenAPI spec version: v2024.14.0
    
    Generated API client
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from  src.client.api.api_client import ApiClient


class ScheduleApi(object):
    """NOTE: This class is auto generated by the API code generator program.

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def count_schedules(self, **kwargs):  # noqa: E501
        """Count schedules  # noqa: E501

        Retrieve the total number of schedules owned by the current user based on the specified query parameters such as `filter`, `taskTypeFilter`, `assetId`, `filterType`, `sort`, `includeCount`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_schedules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter schedules using the attached flow name
        :param list[str] task_type_filter: Filter schedules by task types. If not specified, all types are allowed.
        :param str asset_id: Filter by id of asset. The type of the asset must be defined with query parameter taskTypeFilter
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :return: Count
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.count_schedules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.count_schedules_with_http_info(**kwargs)  # noqa: E501
            return data

    def count_schedules_with_http_info(self, **kwargs):  # noqa: E501
        """Count schedules  # noqa: E501

        Retrieve the total number of schedules owned by the current user based on the specified query parameters such as `filter`, `taskTypeFilter`, `assetId`, `filterType`, `sort`, `includeCount`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_schedules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter schedules using the attached flow name
        :param list[str] task_type_filter: Filter schedules by task types. If not specified, all types are allowed.
        :param str asset_id: Filter by id of asset. The type of the asset must be defined with query parameter taskTypeFilter
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :return: Count
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'task_type_filter', 'asset_id', 'filter_type', 'sort', 'include_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'task_type_filter' in params:
            query_params.append(('taskTypeFilter', params['task_type_filter']))  # noqa: E501
            collection_formats['taskTypeFilter'] = 'multi'  # noqa: E501
        if 'asset_id' in params:
            query_params.append(('assetId', params['asset_id']))  # noqa: E501
        if 'filter_type' in params:
            query_params.append(('filterType', params['filter_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'include_count' in params:
            query_params.append(('includeCount', params['include_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Count',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_schedule(self, body, **kwargs):  # noqa: E501
        """Create a schedule  # noqa: E501

        Create a new schedule by defining the schedule's `Name`, `Trigger`, and `Task`.  > ℹ️ **NOTE**: Cron expressions are using Quartz cron format, see [Quartz Cron Format](https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_schedule(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleCreateRequest body: (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_schedule_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_schedule_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_schedule_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a schedule  # noqa: E501

        Create a new schedule by defining the schedule's `Name`, `Trigger`, and `Task`.  > ℹ️ **NOTE**: Cron expressions are using Quartz cron format, see [Quartz Cron Format](https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_schedule_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleCreateRequest body: (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_schedule(self, id, **kwargs):  # noqa: E501
        """Delete schedule  # noqa: E501

        Delete an existing schedule identified by its unique `id`.  Specify the schedule `id` as the <b>path parameter</b> to determine which schedule should be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_schedule(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_schedule_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_schedule_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_schedule_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete schedule  # noqa: E501

        Delete an existing schedule identified by its unique `id`.  Specify the schedule `id` as the <b>path parameter</b> to determine which schedule should be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_schedule_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def disable_schedule(self, id, **kwargs):  # noqa: E501
        """Disable schedule  # noqa: E501

        Disable an existing schedule identified by its unique `id`.  Specify the `id` as the <b>path parameter</b> to specify which schedule to disable.  > ℹ️ **NOTE**: Disabling means the schedule is temporarily deactivated but not deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_schedule(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param object body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.disable_schedule_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.disable_schedule_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def disable_schedule_with_http_info(self, id, **kwargs):  # noqa: E501
        """Disable schedule  # noqa: E501

        Disable an existing schedule identified by its unique `id`.  Specify the `id` as the <b>path parameter</b> to specify which schedule to disable.  > ℹ️ **NOTE**: Disabling means the schedule is temporarily deactivated but not deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_schedule_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param object body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `disable_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules/{id}/disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def enable_schedule(self, id, **kwargs):  # noqa: E501
        """Enable schedule  # noqa: E501

        Enable an existing schedule that is currently disabled.  Specify the `id` as the <b>path parameter</b> to specify which schedule to disable.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_schedule(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param object body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.enable_schedule_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.enable_schedule_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def enable_schedule_with_http_info(self, id, **kwargs):  # noqa: E501
        """Enable schedule  # noqa: E501

        Enable an existing schedule that is currently disabled.  Specify the `id` as the <b>path parameter</b> to specify which schedule to disable.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_schedule_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param object body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `enable_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules/{id}/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_schedule(self, id, **kwargs):  # noqa: E501
        """Get schedule  # noqa: E501

        Retrieve details of a specific schedule using its unique identifier `id`.  Specify the `id` of the schedule as the <b>path parameter</b> to retrieve detailed information about that particular schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedule(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: ScheduleResponseWithTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_schedule_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_schedule_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_schedule_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get schedule  # noqa: E501

        Retrieve details of a specific schedule using its unique identifier `id`.  Specify the `id` of the schedule as the <b>path parameter</b> to retrieve detailed information about that particular schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedule_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: ScheduleResponseWithTask
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleResponseWithTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_schedules(self, **kwargs):  # noqa: E501
        """List schedules  # noqa: E501

        Manage and retrieve the list of schedules along with the details owned by the current user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_schedules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Maximum number of objects to fetch. Value from 1 to 1000. Default is 10.
        :param str filter: Filter schedules using the attached flow name
        :param list[str] task_type_filter: Filter schedules by task types. If not specified, all types are allowed.
        :param str asset_id: Filter by id of asset. The type of the asset must be defined with query parameter taskTypeFilter
        :param int offset: Offset after which to start returning objects. For use with `limit`.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :return: ScheduleResponseWithTaskList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_schedules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_schedules_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_schedules_with_http_info(self, **kwargs):  # noqa: E501
        """List schedules  # noqa: E501

        Manage and retrieve the list of schedules along with the details owned by the current user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_schedules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Maximum number of objects to fetch. Value from 1 to 1000. Default is 10.
        :param str filter: Filter schedules using the attached flow name
        :param list[str] task_type_filter: Filter schedules by task types. If not specified, all types are allowed.
        :param str asset_id: Filter by id of asset. The type of the asset must be defined with query parameter taskTypeFilter
        :param int offset: Offset after which to start returning objects. For use with `limit`.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :return: ScheduleResponseWithTaskList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'filter', 'task_type_filter', 'asset_id', 'offset', 'filter_type', 'sort', 'include_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'task_type_filter' in params:
            query_params.append(('taskTypeFilter', params['task_type_filter']))  # noqa: E501
            collection_formats['taskTypeFilter'] = 'multi'  # noqa: E501
        if 'asset_id' in params:
            query_params.append(('assetId', params['asset_id']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter_type' in params:
            query_params.append(('filterType', params['filter_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'include_count' in params:
            query_params.append(('includeCount', params['include_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleResponseWithTaskList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_schedule(self, body, id, **kwargs):  # noqa: E501
        """Update a schedule  # noqa: E501

        Update an existing schedule's details by its unique identifier `id`.  Specify the `id` of the schedule as the <b>path parameter</b> to identify which schedule to update.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_schedule(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleUpdateRequest body: (required)
        :param int id: (required)
        :return: UpdatedObjectSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_schedule_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_schedule_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_schedule_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a schedule  # noqa: E501

        Update an existing schedule's details by its unique identifier `id`.  Specify the `id` of the schedule as the <b>path parameter</b> to identify which schedule to update.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_schedule_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleUpdateRequest body: (required)
        :param int id: (required)
        :return: UpdatedObjectSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_schedule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/scheduling/v1/schedules/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdatedObjectSchema',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
