"""Models for Automower Connect API - Positions."""

from dataclasses import dataclass

from mashumaro import DataClassDictMixin


@dataclass
class Positions(DataClassDictMixin):
    """List of the GPS positions.

    Latest registered position is first in the
    array and the oldest last in the array.
    Max number of positions is 50 after
    that the latest position is removed
    from the array.
    """

    latitude: float
    longitude: float
