# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupAccessTokensResult',
    'AwaitableGetGroupAccessTokensResult',
    'get_group_access_tokens',
    'get_group_access_tokens_output',
]

@pulumi.output_type
class GetGroupAccessTokensResult:
    """
    A collection of values returned by getGroupAccessTokens.
    """
    def __init__(__self__, access_tokens=None, group=None, id=None):
        if access_tokens and not isinstance(access_tokens, list):
            raise TypeError("Expected argument 'access_tokens' to be a list")
        pulumi.set(__self__, "access_tokens", access_tokens)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="accessTokens")
    def access_tokens(self) -> Sequence['outputs.GetGroupAccessTokensAccessTokenResult']:
        """
        The list of access tokens returned by the search
        """
        return pulumi.get(self, "access_tokens")

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        """
        The name or id of the group.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


class AwaitableGetGroupAccessTokensResult(GetGroupAccessTokensResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupAccessTokensResult(
            access_tokens=self.access_tokens,
            group=self.group,
            id=self.id)


def get_group_access_tokens(group: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupAccessTokensResult:
    """
    The `gitlab_access_tokens` data source allows to retrieve all group-level access tokens.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_access_tokens/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    access_tokens = gitlab.get_group_access_tokens(group="my/example/group")
    ```


    :param _builtins.str group: The name or id of the group.
    """
    __args__ = dict()
    __args__['group'] = group
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getGroupAccessTokens:getGroupAccessTokens', __args__, opts=opts, typ=GetGroupAccessTokensResult).value

    return AwaitableGetGroupAccessTokensResult(
        access_tokens=pulumi.get(__ret__, 'access_tokens'),
        group=pulumi.get(__ret__, 'group'),
        id=pulumi.get(__ret__, 'id'))
def get_group_access_tokens_output(group: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupAccessTokensResult]:
    """
    The `gitlab_access_tokens` data source allows to retrieve all group-level access tokens.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_access_tokens/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    access_tokens = gitlab.get_group_access_tokens(group="my/example/group")
    ```


    :param _builtins.str group: The name or id of the group.
    """
    __args__ = dict()
    __args__['group'] = group
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getGroupAccessTokens:getGroupAccessTokens', __args__, opts=opts, typ=GetGroupAccessTokensResult)
    return __ret__.apply(lambda __response__: GetGroupAccessTokensResult(
        access_tokens=pulumi.get(__response__, 'access_tokens'),
        group=pulumi.get(__response__, 'group'),
        id=pulumi.get(__response__, 'id')))
