# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupMembershipResult',
    'AwaitableGetGroupMembershipResult',
    'get_group_membership',
    'get_group_membership_output',
]

@pulumi.output_type
class GetGroupMembershipResult:
    """
    A collection of values returned by getGroupMembership.
    """
    def __init__(__self__, access_level=None, full_path=None, group_id=None, id=None, inherited=None, members=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if full_path and not isinstance(full_path, str):
            raise TypeError("Expected argument 'full_path' to be a str")
        pulumi.set(__self__, "full_path", full_path)
        if group_id and not isinstance(group_id, int):
            raise TypeError("Expected argument 'group_id' to be a int")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inherited and not isinstance(inherited, bool):
            raise TypeError("Expected argument 'inherited' to be a bool")
        pulumi.set(__self__, "inherited", inherited)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> _builtins.str:
        """
        Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> _builtins.str:
        """
        The full path of the group.
        """
        return pulumi.get(self, "full_path")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.int:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the group membership. In the format of `<group-id:access-level>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def inherited(self) -> Optional[_builtins.bool]:
        """
        Return all project members including members through ancestor groups.
        """
        return pulumi.get(self, "inherited")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetGroupMembershipMemberResult']:
        """
        The list of group members.
        """
        return pulumi.get(self, "members")


class AwaitableGetGroupMembershipResult(GetGroupMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupMembershipResult(
            access_level=self.access_level,
            full_path=self.full_path,
            group_id=self.group_id,
            id=self.id,
            inherited=self.inherited,
            members=self.members)


def get_group_membership(access_level: Optional[_builtins.str] = None,
                         full_path: Optional[_builtins.str] = None,
                         group_id: Optional[_builtins.int] = None,
                         inherited: Optional[_builtins.bool] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupMembershipResult:
    """
    The `GroupMembership` data source allows to list and filter all members of a group specified by either its id or full path.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/members/#list-all-members-of-a-group-or-project)


    :param _builtins.str access_level: Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
    :param _builtins.str full_path: The full path of the group.
    :param _builtins.int group_id: The ID of the group.
    :param _builtins.bool inherited: Return all project members including members through ancestor groups.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['fullPath'] = full_path
    __args__['groupId'] = group_id
    __args__['inherited'] = inherited
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getGroupMembership:getGroupMembership', __args__, opts=opts, typ=GetGroupMembershipResult).value

    return AwaitableGetGroupMembershipResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        full_path=pulumi.get(__ret__, 'full_path'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        inherited=pulumi.get(__ret__, 'inherited'),
        members=pulumi.get(__ret__, 'members'))
def get_group_membership_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                full_path: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                group_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                inherited: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupMembershipResult]:
    """
    The `GroupMembership` data source allows to list and filter all members of a group specified by either its id or full path.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/members/#list-all-members-of-a-group-or-project)


    :param _builtins.str access_level: Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
    :param _builtins.str full_path: The full path of the group.
    :param _builtins.int group_id: The ID of the group.
    :param _builtins.bool inherited: Return all project members including members through ancestor groups.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['fullPath'] = full_path
    __args__['groupId'] = group_id
    __args__['inherited'] = inherited
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getGroupMembership:getGroupMembership', __args__, opts=opts, typ=GetGroupMembershipResult)
    return __ret__.apply(lambda __response__: GetGroupMembershipResult(
        access_level=pulumi.get(__response__, 'access_level'),
        full_path=pulumi.get(__response__, 'full_path'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        inherited=pulumi.get(__response__, 'inherited'),
        members=pulumi.get(__response__, 'members')))
