# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectAccessTokensResult',
    'AwaitableGetProjectAccessTokensResult',
    'get_project_access_tokens',
    'get_project_access_tokens_output',
]

@pulumi.output_type
class GetProjectAccessTokensResult:
    """
    A collection of values returned by getProjectAccessTokens.
    """
    def __init__(__self__, access_tokens=None, id=None, project=None, state=None):
        if access_tokens and not isinstance(access_tokens, list):
            raise TypeError("Expected argument 'access_tokens' to be a list")
        pulumi.set(__self__, "access_tokens", access_tokens)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="accessTokens")
    def access_tokens(self) -> Sequence['outputs.GetProjectAccessTokensAccessTokenResult']:
        """
        The list of access tokens returned by the search
        """
        return pulumi.get(self, "access_tokens")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name or id of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        List all project access token that match the specified state. Valid values are `active`, `inactive`. Returns all project access token if not set.
        """
        return pulumi.get(self, "state")


class AwaitableGetProjectAccessTokensResult(GetProjectAccessTokensResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectAccessTokensResult(
            access_tokens=self.access_tokens,
            id=self.id,
            project=self.project,
            state=self.state)


def get_project_access_tokens(project: Optional[_builtins.str] = None,
                              state: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectAccessTokensResult:
    """
    The `get_project_access_tokens` data source allows to retrieve all project access tokens for a given project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_access_tokens/)


    :param _builtins.str project: The name or id of the project.
    :param _builtins.str state: List all project access token that match the specified state. Valid values are `active`, `inactive`. Returns all project access token if not set.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectAccessTokens:getProjectAccessTokens', __args__, opts=opts, typ=GetProjectAccessTokensResult).value

    return AwaitableGetProjectAccessTokensResult(
        access_tokens=pulumi.get(__ret__, 'access_tokens'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        state=pulumi.get(__ret__, 'state'))
def get_project_access_tokens_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectAccessTokensResult]:
    """
    The `get_project_access_tokens` data source allows to retrieve all project access tokens for a given project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_access_tokens/)


    :param _builtins.str project: The name or id of the project.
    :param _builtins.str state: List all project access token that match the specified state. Valid values are `active`, `inactive`. Returns all project access token if not set.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectAccessTokens:getProjectAccessTokens', __args__, opts=opts, typ=GetProjectAccessTokensResult)
    return __ret__.apply(lambda __response__: GetProjectAccessTokensResult(
        access_tokens=pulumi.get(__response__, 'access_tokens'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        state=pulumi.get(__response__, 'state')))
