# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupProtectedEnvironmentArgs', 'GroupProtectedEnvironment']

@pulumi.input_type
class GroupProtectedEnvironmentArgs:
    def __init__(__self__, *,
                 deploy_access_levels: pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]],
                 environment: pulumi.Input[_builtins.str],
                 group: pulumi.Input[_builtins.str],
                 approval_rules: Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]]] = None):
        """
        The set of arguments for constructing a GroupProtectedEnvironment resource.
        :param pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]] deploy_access_levels: Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
        :param pulumi.Input[_builtins.str] environment: The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
        :param pulumi.Input[_builtins.str] group: The ID or full path of the group which the protected environment is created against.
        :param pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]] approval_rules: Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
        """
        pulumi.set(__self__, "deploy_access_levels", deploy_access_levels)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "group", group)
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)

    @_builtins.property
    @pulumi.getter(name="deployAccessLevels")
    def deploy_access_levels(self) -> pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]]:
        """
        Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
        """
        return pulumi.get(self, "deploy_access_levels")

    @deploy_access_levels.setter
    def deploy_access_levels(self, value: pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]]):
        pulumi.set(self, "deploy_access_levels", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Input[_builtins.str]:
        """
        The ID or full path of the group which the protected environment is created against.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]]]:
        """
        Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]]]):
        pulumi.set(self, "approval_rules", value)


@pulumi.input_type
class _GroupProtectedEnvironmentState:
    def __init__(__self__, *,
                 approval_rules: Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]]] = None,
                 deploy_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GroupProtectedEnvironment resources.
        :param pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]] approval_rules: Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
        :param pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]] deploy_access_levels: Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
        :param pulumi.Input[_builtins.str] environment: The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
        :param pulumi.Input[_builtins.str] group: The ID or full path of the group which the protected environment is created against.
        """
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)
        if deploy_access_levels is not None:
            pulumi.set(__self__, "deploy_access_levels", deploy_access_levels)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if group is not None:
            pulumi.set(__self__, "group", group)

    @_builtins.property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]]]:
        """
        Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentApprovalRuleArgs']]]]):
        pulumi.set(self, "approval_rules", value)

    @_builtins.property
    @pulumi.getter(name="deployAccessLevels")
    def deploy_access_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]]]:
        """
        Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
        """
        return pulumi.get(self, "deploy_access_levels")

    @deploy_access_levels.setter
    def deploy_access_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupProtectedEnvironmentDeployAccessLevelArgs']]]]):
        pulumi.set(self, "deploy_access_levels", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or full path of the group which the protected environment is created against.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)


@pulumi.type_token("gitlab:index/groupProtectedEnvironment:GroupProtectedEnvironment")
class GroupProtectedEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentApprovalRuleArgs', 'GroupProtectedEnvironmentApprovalRuleArgsDict']]]]] = None,
                 deploy_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentDeployAccessLevelArgs', 'GroupProtectedEnvironmentDeployAccessLevelArgsDict']]]]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `GroupProtectedEnvironment` resource allows to manage the lifecycle of a protected environment in a group.

        > In order to use a user_id in the `deploy_access_levels` configuration,
           you need to make sure that users have access to the group with Maintainer role or higher.
           In order to use a group_id in the `deploy_access_levels` configuration,
           the group_id must be a sub-group under the given group.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_protected_environments/)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_group_protected_environment`. For example:

        terraform

        import {

          to = gitlab_group_protected_environment.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab group protected environments can be imported using an id made up of `groupId:environmentName`, e.g.

        ```sh
        $ pulumi import gitlab:index/groupProtectedEnvironment:GroupProtectedEnvironment bar 123:production
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentApprovalRuleArgs', 'GroupProtectedEnvironmentApprovalRuleArgsDict']]]] approval_rules: Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentDeployAccessLevelArgs', 'GroupProtectedEnvironmentDeployAccessLevelArgsDict']]]] deploy_access_levels: Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
        :param pulumi.Input[_builtins.str] environment: The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
        :param pulumi.Input[_builtins.str] group: The ID or full path of the group which the protected environment is created against.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupProtectedEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `GroupProtectedEnvironment` resource allows to manage the lifecycle of a protected environment in a group.

        > In order to use a user_id in the `deploy_access_levels` configuration,
           you need to make sure that users have access to the group with Maintainer role or higher.
           In order to use a group_id in the `deploy_access_levels` configuration,
           the group_id must be a sub-group under the given group.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_protected_environments/)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_group_protected_environment`. For example:

        terraform

        import {

          to = gitlab_group_protected_environment.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab group protected environments can be imported using an id made up of `groupId:environmentName`, e.g.

        ```sh
        $ pulumi import gitlab:index/groupProtectedEnvironment:GroupProtectedEnvironment bar 123:production
        ```

        :param str resource_name: The name of the resource.
        :param GroupProtectedEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupProtectedEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentApprovalRuleArgs', 'GroupProtectedEnvironmentApprovalRuleArgsDict']]]]] = None,
                 deploy_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentDeployAccessLevelArgs', 'GroupProtectedEnvironmentDeployAccessLevelArgsDict']]]]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupProtectedEnvironmentArgs.__new__(GroupProtectedEnvironmentArgs)

            __props__.__dict__["approval_rules"] = approval_rules
            if deploy_access_levels is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_access_levels'")
            __props__.__dict__["deploy_access_levels"] = deploy_access_levels
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
        super(GroupProtectedEnvironment, __self__).__init__(
            'gitlab:index/groupProtectedEnvironment:GroupProtectedEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentApprovalRuleArgs', 'GroupProtectedEnvironmentApprovalRuleArgsDict']]]]] = None,
            deploy_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentDeployAccessLevelArgs', 'GroupProtectedEnvironmentDeployAccessLevelArgsDict']]]]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None) -> 'GroupProtectedEnvironment':
        """
        Get an existing GroupProtectedEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentApprovalRuleArgs', 'GroupProtectedEnvironmentApprovalRuleArgsDict']]]] approval_rules: Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupProtectedEnvironmentDeployAccessLevelArgs', 'GroupProtectedEnvironmentDeployAccessLevelArgsDict']]]] deploy_access_levels: Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
        :param pulumi.Input[_builtins.str] environment: The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
        :param pulumi.Input[_builtins.str] group: The ID or full path of the group which the protected environment is created against.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupProtectedEnvironmentState.__new__(_GroupProtectedEnvironmentState)

        __props__.__dict__["approval_rules"] = approval_rules
        __props__.__dict__["deploy_access_levels"] = deploy_access_levels
        __props__.__dict__["environment"] = environment
        __props__.__dict__["group"] = group
        return GroupProtectedEnvironment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> pulumi.Output[Sequence['outputs.GroupProtectedEnvironmentApprovalRule']]:
        """
        Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
        """
        return pulumi.get(self, "approval_rules")

    @_builtins.property
    @pulumi.getter(name="deployAccessLevels")
    def deploy_access_levels(self) -> pulumi.Output[Sequence['outputs.GroupProtectedEnvironmentDeployAccessLevel']]:
        """
        Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
        """
        return pulumi.get(self, "deploy_access_levels")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[_builtins.str]:
        """
        The ID or full path of the group which the protected environment is created against.
        """
        return pulumi.get(self, "group")

