# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectHookArgs', 'ProjectHook']

@pulumi.input_type
class ProjectHookArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 confidential_issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]]] = None,
                 custom_webhook_template: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ssl_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 pipeline_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_events_branch_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 releases_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_access_token_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 tag_push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 wiki_page_events: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ProjectHook resource.
        :param pulumi.Input[_builtins.str] project: The name or id of the project to add the hook to.
        :param pulumi.Input[_builtins.str] url: The url of the hook to invoke. Forces re-creation to preserve `token`.
        :param pulumi.Input[_builtins.bool] confidential_issues_events: Invoke the hook for confidential issues events.
        :param pulumi.Input[_builtins.bool] confidential_note_events: Invoke the hook for confidential note events.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]] custom_headers: Custom headers for the project webhook.
        :param pulumi.Input[_builtins.str] custom_webhook_template: Custom webhook template.
        :param pulumi.Input[_builtins.bool] deployment_events: Invoke the hook for deployment events.
        :param pulumi.Input[_builtins.str] description: Description of the webhook.
        :param pulumi.Input[_builtins.bool] enable_ssl_verification: Enable SSL verification when invoking the hook.
        :param pulumi.Input[_builtins.bool] issues_events: Invoke the hook for issues events.
        :param pulumi.Input[_builtins.bool] job_events: Invoke the hook for job events.
        :param pulumi.Input[_builtins.bool] merge_requests_events: Invoke the hook for merge requests events.
        :param pulumi.Input[_builtins.str] name: Name of the project webhook.
        :param pulumi.Input[_builtins.bool] note_events: Invoke the hook for note events.
        :param pulumi.Input[_builtins.bool] pipeline_events: Invoke the hook for pipeline events.
        :param pulumi.Input[_builtins.bool] push_events: Invoke the hook for push events.
        :param pulumi.Input[_builtins.str] push_events_branch_filter: Invoke the hook for push events on matching branches only.
        :param pulumi.Input[_builtins.bool] releases_events: Invoke the hook for release events.
        :param pulumi.Input[_builtins.bool] resource_access_token_events: Invoke the hook for project access token expiry events.
        :param pulumi.Input[_builtins.bool] tag_push_events: Invoke the hook for tag push events.
        :param pulumi.Input[_builtins.str] token: A token to present when invoking the hook. The token is not available for imported resources.
        :param pulumi.Input[_builtins.bool] wiki_page_events: Invoke the hook for wiki page events.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "url", url)
        if confidential_issues_events is not None:
            pulumi.set(__self__, "confidential_issues_events", confidential_issues_events)
        if confidential_note_events is not None:
            pulumi.set(__self__, "confidential_note_events", confidential_note_events)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if custom_webhook_template is not None:
            pulumi.set(__self__, "custom_webhook_template", custom_webhook_template)
        if deployment_events is not None:
            pulumi.set(__self__, "deployment_events", deployment_events)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl_verification is not None:
            pulumi.set(__self__, "enable_ssl_verification", enable_ssl_verification)
        if issues_events is not None:
            pulumi.set(__self__, "issues_events", issues_events)
        if job_events is not None:
            pulumi.set(__self__, "job_events", job_events)
        if merge_requests_events is not None:
            pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if note_events is not None:
            pulumi.set(__self__, "note_events", note_events)
        if pipeline_events is not None:
            pulumi.set(__self__, "pipeline_events", pipeline_events)
        if push_events is not None:
            pulumi.set(__self__, "push_events", push_events)
        if push_events_branch_filter is not None:
            pulumi.set(__self__, "push_events_branch_filter", push_events_branch_filter)
        if releases_events is not None:
            pulumi.set(__self__, "releases_events", releases_events)
        if resource_access_token_events is not None:
            pulumi.set(__self__, "resource_access_token_events", resource_access_token_events)
        if tag_push_events is not None:
            pulumi.set(__self__, "tag_push_events", tag_push_events)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if wiki_page_events is not None:
            pulumi.set(__self__, "wiki_page_events", wiki_page_events)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name or id of the project to add the hook to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The url of the hook to invoke. Forces re-creation to preserve `token`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @confidential_issues_events.setter
    def confidential_issues_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_issues_events", value)

    @_builtins.property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @confidential_note_events.setter
    def confidential_note_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_note_events", value)

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]]]:
        """
        Custom headers for the project webhook.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @_builtins.property
    @pulumi.getter(name="customWebhookTemplate")
    def custom_webhook_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom webhook template.
        """
        return pulumi.get(self, "custom_webhook_template")

    @custom_webhook_template.setter
    def custom_webhook_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_webhook_template", value)

    @_builtins.property
    @pulumi.getter(name="deploymentEvents")
    def deployment_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for deployment events.
        """
        return pulumi.get(self, "deployment_events")

    @deployment_events.setter
    def deployment_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deployment_events", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the webhook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableSslVerification")
    def enable_ssl_verification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SSL verification when invoking the hook.
        """
        return pulumi.get(self, "enable_ssl_verification")

    @enable_ssl_verification.setter
    def enable_ssl_verification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ssl_verification", value)

    @_builtins.property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for issues events.
        """
        return pulumi.get(self, "issues_events")

    @issues_events.setter
    def issues_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "issues_events", value)

    @_builtins.property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for job events.
        """
        return pulumi.get(self, "job_events")

    @job_events.setter
    def job_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "job_events", value)

    @_builtins.property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "merge_requests_events", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the project webhook.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for note events.
        """
        return pulumi.get(self, "note_events")

    @note_events.setter
    def note_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "note_events", value)

    @_builtins.property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @pipeline_events.setter
    def pipeline_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pipeline_events", value)

    @_builtins.property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for push events.
        """
        return pulumi.get(self, "push_events")

    @push_events.setter
    def push_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "push_events", value)

    @_builtins.property
    @pulumi.getter(name="pushEventsBranchFilter")
    def push_events_branch_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Invoke the hook for push events on matching branches only.
        """
        return pulumi.get(self, "push_events_branch_filter")

    @push_events_branch_filter.setter
    def push_events_branch_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "push_events_branch_filter", value)

    @_builtins.property
    @pulumi.getter(name="releasesEvents")
    def releases_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for release events.
        """
        return pulumi.get(self, "releases_events")

    @releases_events.setter
    def releases_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "releases_events", value)

    @_builtins.property
    @pulumi.getter(name="resourceAccessTokenEvents")
    def resource_access_token_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for project access token expiry events.
        """
        return pulumi.get(self, "resource_access_token_events")

    @resource_access_token_events.setter
    def resource_access_token_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resource_access_token_events", value)

    @_builtins.property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @tag_push_events.setter
    def tag_push_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tag_push_events", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A token to present when invoking the hook. The token is not available for imported resources.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    @wiki_page_events.setter
    def wiki_page_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wiki_page_events", value)


@pulumi.input_type
class _ProjectHookState:
    def __init__(__self__, *,
                 confidential_issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]]] = None,
                 custom_webhook_template: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ssl_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 hook_id: Optional[pulumi.Input[_builtins.int]] = None,
                 issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 pipeline_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_events_branch_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 releases_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_access_token_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 tag_push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 wiki_page_events: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ProjectHook resources.
        :param pulumi.Input[_builtins.bool] confidential_issues_events: Invoke the hook for confidential issues events.
        :param pulumi.Input[_builtins.bool] confidential_note_events: Invoke the hook for confidential note events.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]] custom_headers: Custom headers for the project webhook.
        :param pulumi.Input[_builtins.str] custom_webhook_template: Custom webhook template.
        :param pulumi.Input[_builtins.bool] deployment_events: Invoke the hook for deployment events.
        :param pulumi.Input[_builtins.str] description: Description of the webhook.
        :param pulumi.Input[_builtins.bool] enable_ssl_verification: Enable SSL verification when invoking the hook.
        :param pulumi.Input[_builtins.int] hook_id: The id of the project hook.
        :param pulumi.Input[_builtins.bool] issues_events: Invoke the hook for issues events.
        :param pulumi.Input[_builtins.bool] job_events: Invoke the hook for job events.
        :param pulumi.Input[_builtins.bool] merge_requests_events: Invoke the hook for merge requests events.
        :param pulumi.Input[_builtins.str] name: Name of the project webhook.
        :param pulumi.Input[_builtins.bool] note_events: Invoke the hook for note events.
        :param pulumi.Input[_builtins.bool] pipeline_events: Invoke the hook for pipeline events.
        :param pulumi.Input[_builtins.str] project: The name or id of the project to add the hook to.
        :param pulumi.Input[_builtins.int] project_id: The id of the project for the hook.
        :param pulumi.Input[_builtins.bool] push_events: Invoke the hook for push events.
        :param pulumi.Input[_builtins.str] push_events_branch_filter: Invoke the hook for push events on matching branches only.
        :param pulumi.Input[_builtins.bool] releases_events: Invoke the hook for release events.
        :param pulumi.Input[_builtins.bool] resource_access_token_events: Invoke the hook for project access token expiry events.
        :param pulumi.Input[_builtins.bool] tag_push_events: Invoke the hook for tag push events.
        :param pulumi.Input[_builtins.str] token: A token to present when invoking the hook. The token is not available for imported resources.
        :param pulumi.Input[_builtins.str] url: The url of the hook to invoke. Forces re-creation to preserve `token`.
        :param pulumi.Input[_builtins.bool] wiki_page_events: Invoke the hook for wiki page events.
        """
        if confidential_issues_events is not None:
            pulumi.set(__self__, "confidential_issues_events", confidential_issues_events)
        if confidential_note_events is not None:
            pulumi.set(__self__, "confidential_note_events", confidential_note_events)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if custom_webhook_template is not None:
            pulumi.set(__self__, "custom_webhook_template", custom_webhook_template)
        if deployment_events is not None:
            pulumi.set(__self__, "deployment_events", deployment_events)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl_verification is not None:
            pulumi.set(__self__, "enable_ssl_verification", enable_ssl_verification)
        if hook_id is not None:
            pulumi.set(__self__, "hook_id", hook_id)
        if issues_events is not None:
            pulumi.set(__self__, "issues_events", issues_events)
        if job_events is not None:
            pulumi.set(__self__, "job_events", job_events)
        if merge_requests_events is not None:
            pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if note_events is not None:
            pulumi.set(__self__, "note_events", note_events)
        if pipeline_events is not None:
            pulumi.set(__self__, "pipeline_events", pipeline_events)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if push_events is not None:
            pulumi.set(__self__, "push_events", push_events)
        if push_events_branch_filter is not None:
            pulumi.set(__self__, "push_events_branch_filter", push_events_branch_filter)
        if releases_events is not None:
            pulumi.set(__self__, "releases_events", releases_events)
        if resource_access_token_events is not None:
            pulumi.set(__self__, "resource_access_token_events", resource_access_token_events)
        if tag_push_events is not None:
            pulumi.set(__self__, "tag_push_events", tag_push_events)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if wiki_page_events is not None:
            pulumi.set(__self__, "wiki_page_events", wiki_page_events)

    @_builtins.property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @confidential_issues_events.setter
    def confidential_issues_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_issues_events", value)

    @_builtins.property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @confidential_note_events.setter
    def confidential_note_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_note_events", value)

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]]]:
        """
        Custom headers for the project webhook.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectHookCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @_builtins.property
    @pulumi.getter(name="customWebhookTemplate")
    def custom_webhook_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom webhook template.
        """
        return pulumi.get(self, "custom_webhook_template")

    @custom_webhook_template.setter
    def custom_webhook_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_webhook_template", value)

    @_builtins.property
    @pulumi.getter(name="deploymentEvents")
    def deployment_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for deployment events.
        """
        return pulumi.get(self, "deployment_events")

    @deployment_events.setter
    def deployment_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deployment_events", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the webhook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableSslVerification")
    def enable_ssl_verification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SSL verification when invoking the hook.
        """
        return pulumi.get(self, "enable_ssl_verification")

    @enable_ssl_verification.setter
    def enable_ssl_verification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ssl_verification", value)

    @_builtins.property
    @pulumi.getter(name="hookId")
    def hook_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The id of the project hook.
        """
        return pulumi.get(self, "hook_id")

    @hook_id.setter
    def hook_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hook_id", value)

    @_builtins.property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for issues events.
        """
        return pulumi.get(self, "issues_events")

    @issues_events.setter
    def issues_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "issues_events", value)

    @_builtins.property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for job events.
        """
        return pulumi.get(self, "job_events")

    @job_events.setter
    def job_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "job_events", value)

    @_builtins.property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "merge_requests_events", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the project webhook.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for note events.
        """
        return pulumi.get(self, "note_events")

    @note_events.setter
    def note_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "note_events", value)

    @_builtins.property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @pipeline_events.setter
    def pipeline_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pipeline_events", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or id of the project to add the hook to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The id of the project for the hook.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for push events.
        """
        return pulumi.get(self, "push_events")

    @push_events.setter
    def push_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "push_events", value)

    @_builtins.property
    @pulumi.getter(name="pushEventsBranchFilter")
    def push_events_branch_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Invoke the hook for push events on matching branches only.
        """
        return pulumi.get(self, "push_events_branch_filter")

    @push_events_branch_filter.setter
    def push_events_branch_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "push_events_branch_filter", value)

    @_builtins.property
    @pulumi.getter(name="releasesEvents")
    def releases_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for release events.
        """
        return pulumi.get(self, "releases_events")

    @releases_events.setter
    def releases_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "releases_events", value)

    @_builtins.property
    @pulumi.getter(name="resourceAccessTokenEvents")
    def resource_access_token_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for project access token expiry events.
        """
        return pulumi.get(self, "resource_access_token_events")

    @resource_access_token_events.setter
    def resource_access_token_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resource_access_token_events", value)

    @_builtins.property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @tag_push_events.setter
    def tag_push_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tag_push_events", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A token to present when invoking the hook. The token is not available for imported resources.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url of the hook to invoke. Forces re-creation to preserve `token`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invoke the hook for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    @wiki_page_events.setter
    def wiki_page_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wiki_page_events", value)


@pulumi.type_token("gitlab:index/projectHook:ProjectHook")
class ProjectHook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confidential_issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectHookCustomHeaderArgs', 'ProjectHookCustomHeaderArgsDict']]]]] = None,
                 custom_webhook_template: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ssl_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 pipeline_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_events_branch_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 releases_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_access_token_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 tag_push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 wiki_page_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The `ProjectHook` resource allows to manage the lifecycle of a project hook.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/projects/#hooks)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.ProjectHook("example",
            project="example/hooked",
            url="https://example.com/hook/example",
            name="example",
            description="Example hook",
            merge_requests_events=True)
        # Using Custom Headers
        # Values of headers can't be imported
        custom_headers = gitlab.ProjectHook("custom_headers",
            project="example/hooked",
            url="https://example.com/hook/example",
            merge_requests_events=True,
            custom_headers=[
                {
                    "key": "X-Custom-Header",
                    "value": "example",
                },
                {
                    "key": "X-Custom-Header-Second",
                    "value": "example-second",
                },
            ])
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_hook`. For example:

        terraform

        import {

          to = gitlab_project_hook.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A GitLab Project Hook can be imported using a key composed of `<project-id>:<hook-id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectHook:ProjectHook example "12345:1"
        ```

        NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] confidential_issues_events: Invoke the hook for confidential issues events.
        :param pulumi.Input[_builtins.bool] confidential_note_events: Invoke the hook for confidential note events.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectHookCustomHeaderArgs', 'ProjectHookCustomHeaderArgsDict']]]] custom_headers: Custom headers for the project webhook.
        :param pulumi.Input[_builtins.str] custom_webhook_template: Custom webhook template.
        :param pulumi.Input[_builtins.bool] deployment_events: Invoke the hook for deployment events.
        :param pulumi.Input[_builtins.str] description: Description of the webhook.
        :param pulumi.Input[_builtins.bool] enable_ssl_verification: Enable SSL verification when invoking the hook.
        :param pulumi.Input[_builtins.bool] issues_events: Invoke the hook for issues events.
        :param pulumi.Input[_builtins.bool] job_events: Invoke the hook for job events.
        :param pulumi.Input[_builtins.bool] merge_requests_events: Invoke the hook for merge requests events.
        :param pulumi.Input[_builtins.str] name: Name of the project webhook.
        :param pulumi.Input[_builtins.bool] note_events: Invoke the hook for note events.
        :param pulumi.Input[_builtins.bool] pipeline_events: Invoke the hook for pipeline events.
        :param pulumi.Input[_builtins.str] project: The name or id of the project to add the hook to.
        :param pulumi.Input[_builtins.bool] push_events: Invoke the hook for push events.
        :param pulumi.Input[_builtins.str] push_events_branch_filter: Invoke the hook for push events on matching branches only.
        :param pulumi.Input[_builtins.bool] releases_events: Invoke the hook for release events.
        :param pulumi.Input[_builtins.bool] resource_access_token_events: Invoke the hook for project access token expiry events.
        :param pulumi.Input[_builtins.bool] tag_push_events: Invoke the hook for tag push events.
        :param pulumi.Input[_builtins.str] token: A token to present when invoking the hook. The token is not available for imported resources.
        :param pulumi.Input[_builtins.str] url: The url of the hook to invoke. Forces re-creation to preserve `token`.
        :param pulumi.Input[_builtins.bool] wiki_page_events: Invoke the hook for wiki page events.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectHookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectHook` resource allows to manage the lifecycle of a project hook.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/projects/#hooks)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.ProjectHook("example",
            project="example/hooked",
            url="https://example.com/hook/example",
            name="example",
            description="Example hook",
            merge_requests_events=True)
        # Using Custom Headers
        # Values of headers can't be imported
        custom_headers = gitlab.ProjectHook("custom_headers",
            project="example/hooked",
            url="https://example.com/hook/example",
            merge_requests_events=True,
            custom_headers=[
                {
                    "key": "X-Custom-Header",
                    "value": "example",
                },
                {
                    "key": "X-Custom-Header-Second",
                    "value": "example-second",
                },
            ])
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_hook`. For example:

        terraform

        import {

          to = gitlab_project_hook.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A GitLab Project Hook can be imported using a key composed of `<project-id>:<hook-id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectHook:ProjectHook example "12345:1"
        ```

        NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.

        :param str resource_name: The name of the resource.
        :param ProjectHookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectHookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confidential_issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectHookCustomHeaderArgs', 'ProjectHookCustomHeaderArgsDict']]]]] = None,
                 custom_webhook_template: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ssl_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 note_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 pipeline_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_events_branch_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 releases_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_access_token_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 tag_push_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 wiki_page_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectHookArgs.__new__(ProjectHookArgs)

            __props__.__dict__["confidential_issues_events"] = confidential_issues_events
            __props__.__dict__["confidential_note_events"] = confidential_note_events
            __props__.__dict__["custom_headers"] = custom_headers
            __props__.__dict__["custom_webhook_template"] = custom_webhook_template
            __props__.__dict__["deployment_events"] = deployment_events
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_ssl_verification"] = enable_ssl_verification
            __props__.__dict__["issues_events"] = issues_events
            __props__.__dict__["job_events"] = job_events
            __props__.__dict__["merge_requests_events"] = merge_requests_events
            __props__.__dict__["name"] = name
            __props__.__dict__["note_events"] = note_events
            __props__.__dict__["pipeline_events"] = pipeline_events
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["push_events"] = push_events
            __props__.__dict__["push_events_branch_filter"] = push_events_branch_filter
            __props__.__dict__["releases_events"] = releases_events
            __props__.__dict__["resource_access_token_events"] = resource_access_token_events
            __props__.__dict__["tag_push_events"] = tag_push_events
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["wiki_page_events"] = wiki_page_events
            __props__.__dict__["hook_id"] = None
            __props__.__dict__["project_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ProjectHook, __self__).__init__(
            'gitlab:index/projectHook:ProjectHook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            confidential_issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
            confidential_note_events: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectHookCustomHeaderArgs', 'ProjectHookCustomHeaderArgsDict']]]]] = None,
            custom_webhook_template: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_events: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_ssl_verification: Optional[pulumi.Input[_builtins.bool]] = None,
            hook_id: Optional[pulumi.Input[_builtins.int]] = None,
            issues_events: Optional[pulumi.Input[_builtins.bool]] = None,
            job_events: Optional[pulumi.Input[_builtins.bool]] = None,
            merge_requests_events: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            note_events: Optional[pulumi.Input[_builtins.bool]] = None,
            pipeline_events: Optional[pulumi.Input[_builtins.bool]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            push_events: Optional[pulumi.Input[_builtins.bool]] = None,
            push_events_branch_filter: Optional[pulumi.Input[_builtins.str]] = None,
            releases_events: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_access_token_events: Optional[pulumi.Input[_builtins.bool]] = None,
            tag_push_events: Optional[pulumi.Input[_builtins.bool]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            wiki_page_events: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ProjectHook':
        """
        Get an existing ProjectHook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] confidential_issues_events: Invoke the hook for confidential issues events.
        :param pulumi.Input[_builtins.bool] confidential_note_events: Invoke the hook for confidential note events.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectHookCustomHeaderArgs', 'ProjectHookCustomHeaderArgsDict']]]] custom_headers: Custom headers for the project webhook.
        :param pulumi.Input[_builtins.str] custom_webhook_template: Custom webhook template.
        :param pulumi.Input[_builtins.bool] deployment_events: Invoke the hook for deployment events.
        :param pulumi.Input[_builtins.str] description: Description of the webhook.
        :param pulumi.Input[_builtins.bool] enable_ssl_verification: Enable SSL verification when invoking the hook.
        :param pulumi.Input[_builtins.int] hook_id: The id of the project hook.
        :param pulumi.Input[_builtins.bool] issues_events: Invoke the hook for issues events.
        :param pulumi.Input[_builtins.bool] job_events: Invoke the hook for job events.
        :param pulumi.Input[_builtins.bool] merge_requests_events: Invoke the hook for merge requests events.
        :param pulumi.Input[_builtins.str] name: Name of the project webhook.
        :param pulumi.Input[_builtins.bool] note_events: Invoke the hook for note events.
        :param pulumi.Input[_builtins.bool] pipeline_events: Invoke the hook for pipeline events.
        :param pulumi.Input[_builtins.str] project: The name or id of the project to add the hook to.
        :param pulumi.Input[_builtins.int] project_id: The id of the project for the hook.
        :param pulumi.Input[_builtins.bool] push_events: Invoke the hook for push events.
        :param pulumi.Input[_builtins.str] push_events_branch_filter: Invoke the hook for push events on matching branches only.
        :param pulumi.Input[_builtins.bool] releases_events: Invoke the hook for release events.
        :param pulumi.Input[_builtins.bool] resource_access_token_events: Invoke the hook for project access token expiry events.
        :param pulumi.Input[_builtins.bool] tag_push_events: Invoke the hook for tag push events.
        :param pulumi.Input[_builtins.str] token: A token to present when invoking the hook. The token is not available for imported resources.
        :param pulumi.Input[_builtins.str] url: The url of the hook to invoke. Forces re-creation to preserve `token`.
        :param pulumi.Input[_builtins.bool] wiki_page_events: Invoke the hook for wiki page events.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectHookState.__new__(_ProjectHookState)

        __props__.__dict__["confidential_issues_events"] = confidential_issues_events
        __props__.__dict__["confidential_note_events"] = confidential_note_events
        __props__.__dict__["custom_headers"] = custom_headers
        __props__.__dict__["custom_webhook_template"] = custom_webhook_template
        __props__.__dict__["deployment_events"] = deployment_events
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_ssl_verification"] = enable_ssl_verification
        __props__.__dict__["hook_id"] = hook_id
        __props__.__dict__["issues_events"] = issues_events
        __props__.__dict__["job_events"] = job_events
        __props__.__dict__["merge_requests_events"] = merge_requests_events
        __props__.__dict__["name"] = name
        __props__.__dict__["note_events"] = note_events
        __props__.__dict__["pipeline_events"] = pipeline_events
        __props__.__dict__["project"] = project
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["push_events"] = push_events
        __props__.__dict__["push_events_branch_filter"] = push_events_branch_filter
        __props__.__dict__["releases_events"] = releases_events
        __props__.__dict__["resource_access_token_events"] = resource_access_token_events
        __props__.__dict__["tag_push_events"] = tag_push_events
        __props__.__dict__["token"] = token
        __props__.__dict__["url"] = url
        __props__.__dict__["wiki_page_events"] = wiki_page_events
        return ProjectHook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @_builtins.property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectHookCustomHeader']]]:
        """
        Custom headers for the project webhook.
        """
        return pulumi.get(self, "custom_headers")

    @_builtins.property
    @pulumi.getter(name="customWebhookTemplate")
    def custom_webhook_template(self) -> pulumi.Output[_builtins.str]:
        """
        Custom webhook template.
        """
        return pulumi.get(self, "custom_webhook_template")

    @_builtins.property
    @pulumi.getter(name="deploymentEvents")
    def deployment_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for deployment events.
        """
        return pulumi.get(self, "deployment_events")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the webhook.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableSslVerification")
    def enable_ssl_verification(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable SSL verification when invoking the hook.
        """
        return pulumi.get(self, "enable_ssl_verification")

    @_builtins.property
    @pulumi.getter(name="hookId")
    def hook_id(self) -> pulumi.Output[_builtins.int]:
        """
        The id of the project hook.
        """
        return pulumi.get(self, "hook_id")

    @_builtins.property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for issues events.
        """
        return pulumi.get(self, "issues_events")

    @_builtins.property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for job events.
        """
        return pulumi.get(self, "job_events")

    @_builtins.property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the project webhook.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for note events.
        """
        return pulumi.get(self, "note_events")

    @_builtins.property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name or id of the project to add the hook to.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        The id of the project for the hook.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for push events.
        """
        return pulumi.get(self, "push_events")

    @_builtins.property
    @pulumi.getter(name="pushEventsBranchFilter")
    def push_events_branch_filter(self) -> pulumi.Output[_builtins.str]:
        """
        Invoke the hook for push events on matching branches only.
        """
        return pulumi.get(self, "push_events_branch_filter")

    @_builtins.property
    @pulumi.getter(name="releasesEvents")
    def releases_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for release events.
        """
        return pulumi.get(self, "releases_events")

    @_builtins.property
    @pulumi.getter(name="resourceAccessTokenEvents")
    def resource_access_token_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for project access token expiry events.
        """
        return pulumi.get(self, "resource_access_token_events")

    @_builtins.property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        A token to present when invoking the hook. The token is not available for imported resources.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The url of the hook to invoke. Forces re-creation to preserve `token`.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> pulumi.Output[_builtins.bool]:
        """
        Invoke the hook for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

