# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectJobTokenScopesArgs', 'ProjectJobTokenScopes']

@pulumi.input_type
class ProjectJobTokenScopesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None):
        """
        The set of arguments for constructing a ProjectJobTokenScopes resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable the given inbound allowlist. If false, will allow any project or group regardless of the values in `target_project_ids` or `target_group_ids`. Deleting the associated `ProjectJobTokenScopes` resource will reset `Enabled` on the group to `true`.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_id is not None:
            warnings.warn("""`project_id` has been deprecated and will be removed in 19.0. Use `project` instead.""", DeprecationWarning)
            pulumi.log.warn("""project_id is deprecated: `project_id` has been deprecated and will be removed in 19.0. Use `project` instead.""")
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if target_group_ids is not None:
            pulumi.set(__self__, "target_group_ids", target_group_ids)
        if target_project_ids is not None:
            pulumi.set(__self__, "target_project_ids", target_project_ids)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the given inbound allowlist. If false, will allow any project or group regardless of the values in `target_project_ids` or `target_group_ids`. Deleting the associated `ProjectJobTokenScopes` resource will reset `Enabled` on the group to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    @_utilities.deprecated("""`project_id` has been deprecated and will be removed in 19.0. Use `project` instead.""")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="targetGroupIds")
    def target_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A set of group IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_group_ids")

    @target_group_ids.setter
    def target_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "target_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="targetProjectIds")
    def target_project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_project_ids")

    @target_project_ids.setter
    def target_project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "target_project_ids", value)


@pulumi.input_type
class _ProjectJobTokenScopesState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None):
        """
        Input properties used for looking up and filtering ProjectJobTokenScopes resources.
        :param pulumi.Input[_builtins.bool] enabled: Enable the given inbound allowlist. If false, will allow any project or group regardless of the values in `target_project_ids` or `target_group_ids`. Deleting the associated `ProjectJobTokenScopes` resource will reset `Enabled` on the group to `true`.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_id is not None:
            warnings.warn("""`project_id` has been deprecated and will be removed in 19.0. Use `project` instead.""", DeprecationWarning)
            pulumi.log.warn("""project_id is deprecated: `project_id` has been deprecated and will be removed in 19.0. Use `project` instead.""")
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if target_group_ids is not None:
            pulumi.set(__self__, "target_group_ids", target_group_ids)
        if target_project_ids is not None:
            pulumi.set(__self__, "target_project_ids", target_project_ids)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the given inbound allowlist. If false, will allow any project or group regardless of the values in `target_project_ids` or `target_group_ids`. Deleting the associated `ProjectJobTokenScopes` resource will reset `Enabled` on the group to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    @_utilities.deprecated("""`project_id` has been deprecated and will be removed in 19.0. Use `project` instead.""")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="targetGroupIds")
    def target_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A set of group IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_group_ids")

    @target_group_ids.setter
    def target_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "target_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="targetProjectIds")
    def target_project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_project_ids")

    @target_project_ids.setter
    def target_project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "target_project_ids", value)


@pulumi.type_token("gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes")
class ProjectJobTokenScopes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 __props__=None):
        """
        The `ProjectJobTokenScopes` resource allows to manage the CI/CD Job Token scopes in a project.
        Any project or group not within the defined set of `target_project_ids` or `target_group_ids`, respectively, will be removed,
        which allows this resource to be used as an explicit deny.

        > Conflicts with the use of `ProjectJobTokenScope` when used on the same project. Use one or the other to ensure the desired state.

        > If the `enabled` property is false, any project or group will be allowed regardless of the given allowlist attributes.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_job_token_scopes/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        allowed_single_project = gitlab.ProjectJobTokenScopes("allowed_single_project",
            project="111",
            target_project_ids=[123])
        allowed_multiple_project = gitlab.ProjectJobTokenScopes("allowed_multiple_project",
            project="111",
            target_project_ids=[
                123,
                456,
                789,
            ])
        allowed_multiple_groups = gitlab.ProjectJobTokenScopes("allowed_multiple_groups",
            project="111",
            target_project_ids=[],
            target_group_ids=[
                321,
                654,
            ])
        # This will remove all job token scopes, even if added outside of TF.
        explicit_deny = gitlab.ProjectJobTokenScopes("explicit_deny",
            project="111",
            target_project_ids=[])
        # This shows the explicit behavior of the enabled flag with a list of projects and groups.
        allow_projects_and_groups = gitlab.ProjectJobTokenScopes("allow_projects_and_groups",
            project="111",
            enabled=True,
            target_project_ids=[
                123,
                456,
                789,
            ],
            target_group_ids=[
                321,
                654,
            ])
        # This allows all projects and groups (disabling the CI Job Token scope protection)
        allow_all = gitlab.ProjectJobTokenScopes("allow_all",
            project="111",
            enabled=False)
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_job_token_scopes`. For example:

        terraform

        import {

          to = gitlab_project_job_token_scopes.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project job token scopes can be imported using an id made up of just the `project_id`

        ```sh
        $ pulumi import gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes bar 123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable the given inbound allowlist. If false, will allow any project or group regardless of the values in `target_project_ids` or `target_group_ids`. Deleting the associated `ProjectJobTokenScopes` resource will reset `Enabled` on the group to `true`.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectJobTokenScopesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectJobTokenScopes` resource allows to manage the CI/CD Job Token scopes in a project.
        Any project or group not within the defined set of `target_project_ids` or `target_group_ids`, respectively, will be removed,
        which allows this resource to be used as an explicit deny.

        > Conflicts with the use of `ProjectJobTokenScope` when used on the same project. Use one or the other to ensure the desired state.

        > If the `enabled` property is false, any project or group will be allowed regardless of the given allowlist attributes.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_job_token_scopes/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        allowed_single_project = gitlab.ProjectJobTokenScopes("allowed_single_project",
            project="111",
            target_project_ids=[123])
        allowed_multiple_project = gitlab.ProjectJobTokenScopes("allowed_multiple_project",
            project="111",
            target_project_ids=[
                123,
                456,
                789,
            ])
        allowed_multiple_groups = gitlab.ProjectJobTokenScopes("allowed_multiple_groups",
            project="111",
            target_project_ids=[],
            target_group_ids=[
                321,
                654,
            ])
        # This will remove all job token scopes, even if added outside of TF.
        explicit_deny = gitlab.ProjectJobTokenScopes("explicit_deny",
            project="111",
            target_project_ids=[])
        # This shows the explicit behavior of the enabled flag with a list of projects and groups.
        allow_projects_and_groups = gitlab.ProjectJobTokenScopes("allow_projects_and_groups",
            project="111",
            enabled=True,
            target_project_ids=[
                123,
                456,
                789,
            ],
            target_group_ids=[
                321,
                654,
            ])
        # This allows all projects and groups (disabling the CI Job Token scope protection)
        allow_all = gitlab.ProjectJobTokenScopes("allow_all",
            project="111",
            enabled=False)
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_job_token_scopes`. For example:

        terraform

        import {

          to = gitlab_project_job_token_scopes.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project job token scopes can be imported using an id made up of just the `project_id`

        ```sh
        $ pulumi import gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes bar 123
        ```

        :param str resource_name: The name of the resource.
        :param ProjectJobTokenScopesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectJobTokenScopesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectJobTokenScopesArgs.__new__(ProjectJobTokenScopesArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["project"] = project
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["target_group_ids"] = target_group_ids
            __props__.__dict__["target_project_ids"] = target_project_ids
        super(ProjectJobTokenScopes, __self__).__init__(
            'gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None) -> 'ProjectJobTokenScopes':
        """
        Get an existing ProjectJobTokenScopes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable the given inbound allowlist. If false, will allow any project or group regardless of the values in `target_project_ids` or `target_group_ids`. Deleting the associated `ProjectJobTokenScopes` resource will reset `Enabled` on the group to `true`.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectJobTokenScopesState.__new__(_ProjectJobTokenScopesState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["project"] = project
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["target_group_ids"] = target_group_ids
        __props__.__dict__["target_project_ids"] = target_project_ids
        return ProjectJobTokenScopes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable the given inbound allowlist. If false, will allow any project or group regardless of the values in `target_project_ids` or `target_group_ids`. Deleting the associated `ProjectJobTokenScopes` resource will reset `Enabled` on the group to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectId")
    @_utilities.deprecated("""`project_id` has been deprecated and will be removed in 19.0. Use `project` instead.""")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="targetGroupIds")
    def target_group_ids(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        A set of group IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_group_ids")

    @_builtins.property
    @pulumi.getter(name="targetProjectIds")
    def target_project_ids(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_project_ids")

