# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectMirrorArgs', 'ProjectMirror']

@pulumi.input_type
class ProjectMirrorArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_divergent_refs: Optional[pulumi.Input[_builtins.bool]] = None,
                 mirror_branch_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 only_protected_branches: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ProjectMirror resource.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.str] url: The URL of the remote repository to be mirrored.
        :param pulumi.Input[_builtins.str] auth_method: Determines the mirror authentication method. Valid values are: `ssh_public_key`, `password`.
        :param pulumi.Input[_builtins.bool] enabled: Determines if the mirror is enabled.
        :param pulumi.Input[_builtins.bool] keep_divergent_refs: Determines if divergent refs are skipped.
        :param pulumi.Input[_builtins.str] mirror_branch_regex: Contains a regular expression. Only branches with names matching the regex are mirrored. Requires only*protected*branches to be disabled. Premium and Ultimate only.
        :param pulumi.Input[_builtins.bool] only_protected_branches: Determines if only protected branches are mirrored.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "url", url)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if keep_divergent_refs is not None:
            pulumi.set(__self__, "keep_divergent_refs", keep_divergent_refs)
        if mirror_branch_regex is not None:
            pulumi.set(__self__, "mirror_branch_regex", mirror_branch_regex)
        if only_protected_branches is not None:
            pulumi.set(__self__, "only_protected_branches", only_protected_branches)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the remote repository to be mirrored.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the mirror authentication method. Valid values are: `ssh_public_key`, `password`.
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the mirror is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="keepDivergentRefs")
    def keep_divergent_refs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if divergent refs are skipped.
        """
        return pulumi.get(self, "keep_divergent_refs")

    @keep_divergent_refs.setter
    def keep_divergent_refs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_divergent_refs", value)

    @_builtins.property
    @pulumi.getter(name="mirrorBranchRegex")
    def mirror_branch_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contains a regular expression. Only branches with names matching the regex are mirrored. Requires only*protected*branches to be disabled. Premium and Ultimate only.
        """
        return pulumi.get(self, "mirror_branch_regex")

    @mirror_branch_regex.setter
    def mirror_branch_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mirror_branch_regex", value)

    @_builtins.property
    @pulumi.getter(name="onlyProtectedBranches")
    def only_protected_branches(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if only protected branches are mirrored.
        """
        return pulumi.get(self, "only_protected_branches")

    @only_protected_branches.setter
    def only_protected_branches(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "only_protected_branches", value)


@pulumi.input_type
class _ProjectMirrorState:
    def __init__(__self__, *,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_divergent_refs: Optional[pulumi.Input[_builtins.bool]] = None,
                 mirror_branch_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 mirror_id: Optional[pulumi.Input[_builtins.int]] = None,
                 only_protected_branches: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectMirror resources.
        :param pulumi.Input[_builtins.str] auth_method: Determines the mirror authentication method. Valid values are: `ssh_public_key`, `password`.
        :param pulumi.Input[_builtins.bool] enabled: Determines if the mirror is enabled.
        :param pulumi.Input[_builtins.bool] keep_divergent_refs: Determines if divergent refs are skipped.
        :param pulumi.Input[_builtins.str] mirror_branch_regex: Contains a regular expression. Only branches with names matching the regex are mirrored. Requires only*protected*branches to be disabled. Premium and Ultimate only.
        :param pulumi.Input[_builtins.int] mirror_id: Mirror ID.
        :param pulumi.Input[_builtins.bool] only_protected_branches: Determines if only protected branches are mirrored.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.str] url: The URL of the remote repository to be mirrored.
        """
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if keep_divergent_refs is not None:
            pulumi.set(__self__, "keep_divergent_refs", keep_divergent_refs)
        if mirror_branch_regex is not None:
            pulumi.set(__self__, "mirror_branch_regex", mirror_branch_regex)
        if mirror_id is not None:
            pulumi.set(__self__, "mirror_id", mirror_id)
        if only_protected_branches is not None:
            pulumi.set(__self__, "only_protected_branches", only_protected_branches)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the mirror authentication method. Valid values are: `ssh_public_key`, `password`.
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the mirror is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="keepDivergentRefs")
    def keep_divergent_refs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if divergent refs are skipped.
        """
        return pulumi.get(self, "keep_divergent_refs")

    @keep_divergent_refs.setter
    def keep_divergent_refs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_divergent_refs", value)

    @_builtins.property
    @pulumi.getter(name="mirrorBranchRegex")
    def mirror_branch_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contains a regular expression. Only branches with names matching the regex are mirrored. Requires only*protected*branches to be disabled. Premium and Ultimate only.
        """
        return pulumi.get(self, "mirror_branch_regex")

    @mirror_branch_regex.setter
    def mirror_branch_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mirror_branch_regex", value)

    @_builtins.property
    @pulumi.getter(name="mirrorId")
    def mirror_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Mirror ID.
        """
        return pulumi.get(self, "mirror_id")

    @mirror_id.setter
    def mirror_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mirror_id", value)

    @_builtins.property
    @pulumi.getter(name="onlyProtectedBranches")
    def only_protected_branches(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if only protected branches are mirrored.
        """
        return pulumi.get(self, "only_protected_branches")

    @only_protected_branches.setter
    def only_protected_branches(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "only_protected_branches", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the remote repository to be mirrored.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("gitlab:index/projectMirror:ProjectMirror")
class ProjectMirror(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_divergent_refs: Optional[pulumi.Input[_builtins.bool]] = None,
                 mirror_branch_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 only_protected_branches: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ProjectMirror` resource allows to manage the lifecycle of a project mirror.

        This is for *pushing* changes to a remote repository. *Pull Mirroring* can be configured using a combination of the
        import_url, mirror, and mirror_trigger_builds properties on the Project resource.

        > **Warning** By default, the provider sets the `keep_divergent_refs` argument to `True`.
           If you manually set `keep_divergent_refs` to `False`, GitLab mirroring removes branches in the target that aren't in the source.
           This action can result in unexpected branch deletions.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/remote_mirrors/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        foo = gitlab.ProjectMirror("foo",
            project="1",
            url="https://username:password@github.com/org/repository.git")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_mirror`. For example:

        terraform

        import {

          to = gitlab_project_mirror.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project mirror can be imported using an id made up of `project_id:mirror_id`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectMirror:ProjectMirror foo "12345:1337"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: Determines the mirror authentication method. Valid values are: `ssh_public_key`, `password`.
        :param pulumi.Input[_builtins.bool] enabled: Determines if the mirror is enabled.
        :param pulumi.Input[_builtins.bool] keep_divergent_refs: Determines if divergent refs are skipped.
        :param pulumi.Input[_builtins.str] mirror_branch_regex: Contains a regular expression. Only branches with names matching the regex are mirrored. Requires only*protected*branches to be disabled. Premium and Ultimate only.
        :param pulumi.Input[_builtins.bool] only_protected_branches: Determines if only protected branches are mirrored.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.str] url: The URL of the remote repository to be mirrored.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectMirrorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectMirror` resource allows to manage the lifecycle of a project mirror.

        This is for *pushing* changes to a remote repository. *Pull Mirroring* can be configured using a combination of the
        import_url, mirror, and mirror_trigger_builds properties on the Project resource.

        > **Warning** By default, the provider sets the `keep_divergent_refs` argument to `True`.
           If you manually set `keep_divergent_refs` to `False`, GitLab mirroring removes branches in the target that aren't in the source.
           This action can result in unexpected branch deletions.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/remote_mirrors/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        foo = gitlab.ProjectMirror("foo",
            project="1",
            url="https://username:password@github.com/org/repository.git")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_mirror`. For example:

        terraform

        import {

          to = gitlab_project_mirror.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project mirror can be imported using an id made up of `project_id:mirror_id`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectMirror:ProjectMirror foo "12345:1337"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectMirrorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectMirrorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_divergent_refs: Optional[pulumi.Input[_builtins.bool]] = None,
                 mirror_branch_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 only_protected_branches: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectMirrorArgs.__new__(ProjectMirrorArgs)

            __props__.__dict__["auth_method"] = auth_method
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["keep_divergent_refs"] = keep_divergent_refs
            __props__.__dict__["mirror_branch_regex"] = mirror_branch_regex
            __props__.__dict__["only_protected_branches"] = only_protected_branches
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = None if url is None else pulumi.Output.secret(url)
            __props__.__dict__["mirror_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["url"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ProjectMirror, __self__).__init__(
            'gitlab:index/projectMirror:ProjectMirror',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_method: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            keep_divergent_refs: Optional[pulumi.Input[_builtins.bool]] = None,
            mirror_branch_regex: Optional[pulumi.Input[_builtins.str]] = None,
            mirror_id: Optional[pulumi.Input[_builtins.int]] = None,
            only_protected_branches: Optional[pulumi.Input[_builtins.bool]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProjectMirror':
        """
        Get an existing ProjectMirror resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: Determines the mirror authentication method. Valid values are: `ssh_public_key`, `password`.
        :param pulumi.Input[_builtins.bool] enabled: Determines if the mirror is enabled.
        :param pulumi.Input[_builtins.bool] keep_divergent_refs: Determines if divergent refs are skipped.
        :param pulumi.Input[_builtins.str] mirror_branch_regex: Contains a regular expression. Only branches with names matching the regex are mirrored. Requires only*protected*branches to be disabled. Premium and Ultimate only.
        :param pulumi.Input[_builtins.int] mirror_id: Mirror ID.
        :param pulumi.Input[_builtins.bool] only_protected_branches: Determines if only protected branches are mirrored.
        :param pulumi.Input[_builtins.str] project: The id of the project.
        :param pulumi.Input[_builtins.str] url: The URL of the remote repository to be mirrored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectMirrorState.__new__(_ProjectMirrorState)

        __props__.__dict__["auth_method"] = auth_method
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["keep_divergent_refs"] = keep_divergent_refs
        __props__.__dict__["mirror_branch_regex"] = mirror_branch_regex
        __props__.__dict__["mirror_id"] = mirror_id
        __props__.__dict__["only_protected_branches"] = only_protected_branches
        __props__.__dict__["project"] = project
        __props__.__dict__["url"] = url
        return ProjectMirror(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> pulumi.Output[_builtins.str]:
        """
        Determines the mirror authentication method. Valid values are: `ssh_public_key`, `password`.
        """
        return pulumi.get(self, "auth_method")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Determines if the mirror is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="keepDivergentRefs")
    def keep_divergent_refs(self) -> pulumi.Output[_builtins.bool]:
        """
        Determines if divergent refs are skipped.
        """
        return pulumi.get(self, "keep_divergent_refs")

    @_builtins.property
    @pulumi.getter(name="mirrorBranchRegex")
    def mirror_branch_regex(self) -> pulumi.Output[_builtins.str]:
        """
        Contains a regular expression. Only branches with names matching the regex are mirrored. Requires only*protected*branches to be disabled. Premium and Ultimate only.
        """
        return pulumi.get(self, "mirror_branch_regex")

    @_builtins.property
    @pulumi.getter(name="mirrorId")
    def mirror_id(self) -> pulumi.Output[_builtins.int]:
        """
        Mirror ID.
        """
        return pulumi.get(self, "mirror_id")

    @_builtins.property
    @pulumi.getter(name="onlyProtectedBranches")
    def only_protected_branches(self) -> pulumi.Output[_builtins.bool]:
        """
        Determines if only protected branches are mirrored.
        """
        return pulumi.get(self, "only_protected_branches")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the remote repository to be mirrored.
        """
        return pulumi.get(self, "url")

