from pigeon_transitions.config import PigeonTransitionsConfig
from pigeon_transitions import Machine, FunctionMachine


def test_config():
    config = PigeonTransitionsConfig.load(
        """
        root: pigeon_transitions.Machine
        machines:
            config:
                this: is
                something: 1
            Child:
                config:
                    more: data
                replace: pigeon_transitions.FunctionMachine
        """
    )

    assert config.root is Machine
    assert config.machines.config == {"this": "is", "something": 1}
    assert config.machines.Child.config == {"more": "data"}
    assert config.machines.Child.replace is FunctionMachine


def test_replace():
    config = PigeonTransitionsConfig.load(
        """
        root: pigeon_transitions.Machine
        machines:
            two:
                replace: pigeon_transitions.Machine
        """
    )

    class Child(Machine):
        def __init__(self, **kwargs):
            super().__init__(
                states=[
                    "three",
                    "four",
                ],
                **kwargs,
            )

    class Root(Machine):
        def __init__(self, config=None):
            super().__init__(
                states=[
                    "one",
                    {
                        "name": "two",
                        "children": Child.init_child("two", config),
                    },
                ],
                initial="one",
            )

    root = Root(config=config.machines, **config.machines.config)

    assert root.__class__.__name__ == "Root"
    assert root._children["two"].__class__.__name__ == "Machine"
