from pigeon_transitions.graph import GraphMachine as Machine


def test_graph():

    class Child(Machine):
        def __init__(self):
            self.check = False
            super().__init__(
                on_enter="machine_enter",
                states=[
                    "three",
                    {
                        "name": "four",
                        "on_enter": self.enter_four,
                    },
                ],
                initial="three",
                transitions=[
                    {
                        "source": "three",
                        "dest": "four",
                        "trigger": "go",
                        "conditions": "check",
                        "after": self.to_four,
                    }
                ],
            )

        def machine_enter(self):
            pass

        def enter_four(self):
            pass

        def to_four(self):
            pass

    class Root(Machine):
        def __init__(self):
            super().__init__(
                states=[
                    "one",
                    {
                        "name": "two",
                        "children": Child(),
                    },
                ],
                initial="one",
                transitions=[
                    {
                        "source": "one",
                        "dest": "two",
                        "trigger": "start",
                        "before": "before_sub",
                        "conditions": self.enabled,
                    },
                ],
            )

        def before_sub(self):
            pass

        def enabled(self):
            return True

    machine = Root()

    machine.get_graph()
