// 🎯 WOT-PDF Minimal Template
// Clean, simple design focused on content

#set document(title: "{title}", author: "{author}")
#set page(
  paper: "a4",
  margin: (left: 3cm, right: 3cm, top: 2.5cm, bottom: 2.5cm),
  numbering: "1",
  number-align: center
)

#set text(
  font: ("Segoe UI", "Arial"),
  size: 11pt,
  lang: "en"
)

#set heading(
  numbering: "1."
)

#show heading.where(level: 1): it => [
  #v(1.5em)
  #text(size: 18pt, weight: "bold")[
    #counter(heading).display() #it.body
  ]
  #line(length: 30%, stroke: 1pt + black)
  #v(1em)
]

#show heading.where(level: 2): it => [
  #v(1.2em)
  #text(size: 14pt, weight: "bold")[
    #counter(heading).display() #it.body
  ]
  #v(0.5em)
]

#show heading.where(level: 3): it => [
  #v(1em)
  #text(size: 12pt, weight: "bold")[
    #counter(heading).display() #it.body
  ]
  #v(0.3em)
]

// Code blocks
#show raw.where(block: true): it => [
  #block(
    fill: rgb("#f8f8f8"),
    stroke: 1pt + rgb("#e0e0e0"),
    width: 100%,
    inset: 1em,
    radius: 2pt,
    text(font: ("SF Mono", "Consolas", "Monaco"), size: 10pt)[#it]
  )
]

#show raw.where(block: false): it => [
  #box(
    fill: rgb("#f0f0f0"),
    inset: (x: 0.2em, y: 0.1em),
    radius: 2pt,
    text(font: ("SF Mono", "Consolas", "Monaco"), size: 0.9em)[#it]
  )
]

// Lists
#set list(indent: 1em, marker: "•")
#set enum(indent: 1em)

// Tables
#show table: it => [
  #v(0.5em)
  #block(
    stroke: 1pt + rgb("#cccccc"),
    width: 100%,
    it
  )
  #v(0.5em)
]

// Simple title page
#align(center)[
  #v(4cm)
  #text(size: 24pt, weight: "bold")[
    {title}
  ]
  
  #v(2cm)
  #text(size: 12pt)[
    {author}
  ]
  
  #v(0.5cm)
  #text(size: 10pt, fill: gray)[
    {date}
  ]
  
  #v(1fr)
  #text(size: 9pt, style: "italic", fill: gray)[
    Generated by WOT-PDF
  ]
]

#pagebreak()

// Simple table of contents
#outline(
  title: [Contents],
  depth: 3
)

#pagebreak()
