// 🎯 WOT-PDF Technical Template
// Professional technical documentation with code highlighting

#set document(title: "{title}", author: "{author}")
#set page(
  paper: "a4",
  margin: (left: 2.5cm, right: 2.5cm, top: 3cm, bottom: 3cm),
  numbering: "1",
  number-align: center,
  header: [
    #set text(size: 9pt, fill: gray)
    #grid(
      columns: (1fr, 1fr),
      align: (left, right),
      [*{title}*], 
      [Technical Documentation]
    )
    #line(length: 100%, stroke: 0.5pt + gray)
  ],
  footer: [
    #set text(size: 9pt, fill: gray)
    #line(length: 100%, stroke: 0.5pt + gray)
    #v(0.3em)
    #grid(
      columns: (1fr, 1fr),
      align: (left, right),
      [Generated by WOT-PDF], 
      context [Page #counter(page).display()]
    )
  ]
)

#set text(
  font: ("Segoe UI", "Arial"),
  size: 11pt,
  lang: "en"
)

#set heading(
  numbering: "1.1"
)

#show heading.where(level: 1): it => [
  #pagebreak(weak: true)
  #v(1em)
  #block(
    fill: rgb("#0066cc"),
    width: 100%,
    inset: 1em,
    radius: 3pt,
    text(fill: white, weight: "bold", size: 18pt)[
      #context counter(heading).display() #it.body
    ]
  )
  #v(0.8em)
]

#show heading.where(level: 2): it => [
  #v(1.2em)
  #text(fill: rgb("#0066cc"), weight: "bold", size: 14pt)[
    #context counter(heading).display() #it.body
  ]
  #line(length: 100%, stroke: 1pt + rgb("#0066cc"))
  #v(0.5em)
]

#show heading.where(level: 3): it => [
  #v(0.8em)
  #text(fill: rgb("#333333"), weight: "bold", size: 12pt)[
    #context counter(heading).display() #it.body
  ]
  #v(0.3em)
]

// Code blocks with syntax highlighting
#show raw.where(block: true): it => [
  #block(
    fill: rgb("#f8f9fa"),
    stroke: 1pt + rgb("#e9ecef"),
    width: 100%,
    inset: 1em,
    radius: 3pt,
    text(font: ("Consolas", "Monaco", "monospace"), size: 10pt)[#it]
  )
]

#show raw.where(block: false): it => [
  #box(
    fill: rgb("#f1f3f4"),
    inset: (x: 0.3em, y: 0.1em),
    radius: 2pt,
    text(font: ("Consolas", "Monaco", "monospace"), size: 0.9em)[#it]
  )
]

// Lists
#set list(indent: 1em, marker: "•")
#set enum(indent: 1em)

// Tables with professional styling
#show table: it => [
  #v(0.8em)
  #block(
    stroke: 1pt + rgb("#dee2e6"),
    radius: 5pt,
    width: 100%,
    fill: white,
    inset: 0.5em,
    it
  )
  #v(0.8em)
]

// Blockquotes with professional styling
#show quote: it => [
  #v(0.8em)
  #block(
    fill: rgb("#f8f9fa"),
    stroke: (left: 4pt + rgb("#0066cc")),
    width: 100%,
    inset: (left: 1.5em, right: 1em, top: 1em, bottom: 1em),
    radius: (right: 3pt),
    [
      #text(fill: rgb("#666666"), style: "italic", size: 10.5pt)[
        💬 #it.body
      ]
    ]
  )
  #v(0.8em)
]

// Title page
#align(center)[
  #v(3cm)
  #text(size: 24pt, weight: "bold", fill: rgb("#0066cc"))[
    {title}
  ]
  
  #v(1cm)
  #text(size: 14pt, fill: rgb("#666666"))[
    Technical Documentation
  ]
  
  #v(2cm)
  #text(size: 12pt)[
    *Author:* {author} \
    *Date:* {date} \
    *Generated by:* WOT-PDF Technical Engine
  ]
  
  #v(1fr)
  #text(size: 10pt, fill: gray)[
    Professional technical documentation created with Typst
  ]
]

#pagebreak()

// Table of contents
#outline(
  title: [Table of Contents],
  depth: 3
)

#pagebreak()
