import * as secretsmanager from 'aws-cdk-lib/aws-secretsmanager';
import { ICluster } from './cluster';
/**
 * (experimental) Properties for accessing a Redshift database.
 *
 * @experimental
 */
export interface DatabaseOptions {
    /**
     * (experimental) The cluster containing the database.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The name of the database.
     *
     * @experimental
     */
    readonly databaseName: string;
    /**
     * (experimental) The secret containing credentials to a Redshift user with administrator privileges.
     *
     * Secret JSON schema: `{ username: string; password: string }`.
     *
     * @default - the admin secret is taken from the cluster
     * @experimental
     */
    readonly adminUser?: secretsmanager.ISecret;
}
