# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from cloudglue.sdk.models.chat_completion_request_filter import ChatCompletionRequestFilter
from cloudglue.sdk.models.chat_message import ChatMessage
from typing import Optional, Set
from typing_extensions import Self

class ChatCompletionRequest(BaseModel):
    """
    ChatCompletionRequest
    """ # noqa: E501
    model: StrictStr = Field(description="Name of the video understanding model to use.")
    messages: List[ChatMessage] = Field(description="A list of messages comprising the conversation so far")
    collections: Annotated[List[StrictStr], Field(min_length=1, max_length=1)] = Field(description="List of collection IDs to use as context for the chat.  Note that 'nimbus-001' only supports collections with collection_type 'rich-transcripts'")
    filter: Optional[ChatCompletionRequestFilter] = None
    force_search: Optional[StrictBool] = Field(default=False, description="Whether to force the model to always perform a search when answering questions, even if it believes it knows the answer")
    include_citations: Optional[StrictBool] = Field(default=True, description="Whether to include citations to specific video segments")
    temperature: Optional[Union[Annotated[float, Field(le=2, strict=True, ge=0)], Annotated[int, Field(le=2, strict=True, ge=0)]]] = Field(default=0.7, description="Sampling temperature to use, between 0 and 2")
    top_p: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=1.0, description="An alternative to sampling with temperature, called nucleus sampling")
    max_tokens: Optional[StrictInt] = Field(default=1024, description="The maximum number of tokens to generate in the chat completion")
    __properties: ClassVar[List[str]] = ["model", "messages", "collections", "filter", "force_search", "include_citations", "temperature", "top_p", "max_tokens"]

    @field_validator('model')
    def model_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['nimbus-001']):
            raise ValueError("must be one of enum values ('nimbus-001')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatCompletionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item_messages in self.messages:
                if _item_messages:
                    _items.append(_item_messages.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatCompletionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "model": obj.get("model"),
            "messages": [ChatMessage.from_dict(_item) for _item in obj["messages"]] if obj.get("messages") is not None else None,
            "collections": obj.get("collections"),
            "filter": ChatCompletionRequestFilter.from_dict(obj["filter"]) if obj.get("filter") is not None else None,
            "force_search": obj.get("force_search") if obj.get("force_search") is not None else False,
            "include_citations": obj.get("include_citations") if obj.get("include_citations") is not None else True,
            "temperature": obj.get("temperature") if obj.get("temperature") is not None else 0.7,
            "top_p": obj.get("top_p") if obj.get("top_p") is not None else 1.0,
            "max_tokens": obj.get("max_tokens") if obj.get("max_tokens") is not None else 1024
        })
        return _obj


