# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.chat_completion_request_filter_file_inner import ChatCompletionRequestFilterFileInner
from cloudglue.sdk.models.chat_completion_request_filter_metadata_inner import ChatCompletionRequestFilterMetadataInner
from cloudglue.sdk.models.chat_completion_request_filter_video_info_inner import ChatCompletionRequestFilterVideoInfoInner
from typing import Optional, Set
from typing_extensions import Self

class ChatCompletionRequestFilter(BaseModel):
    """
    Filter criteria to constrain search results used in chat
    """ # noqa: E501
    metadata: Optional[List[ChatCompletionRequestFilterMetadataInner]] = Field(default=None, description="Filter by file metadata using JSON path expressions")
    video_info: Optional[List[ChatCompletionRequestFilterVideoInfoInner]] = Field(default=None, description="Filter by video information using JSON path expressions")
    file: Optional[List[ChatCompletionRequestFilterFileInner]] = Field(default=None, description="Filter by file properties using JSON path expressions")
    __properties: ClassVar[List[str]] = ["metadata", "video_info", "file"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatCompletionRequestFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in metadata (list)
        _items = []
        if self.metadata:
            for _item_metadata in self.metadata:
                if _item_metadata:
                    _items.append(_item_metadata.to_dict())
            _dict['metadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in video_info (list)
        _items = []
        if self.video_info:
            for _item_video_info in self.video_info:
                if _item_video_info:
                    _items.append(_item_video_info.to_dict())
            _dict['video_info'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in file (list)
        _items = []
        if self.file:
            for _item_file in self.file:
                if _item_file:
                    _items.append(_item_file.to_dict())
            _dict['file'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatCompletionRequestFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metadata": [ChatCompletionRequestFilterMetadataInner.from_dict(_item) for _item in obj["metadata"]] if obj.get("metadata") is not None else None,
            "video_info": [ChatCompletionRequestFilterVideoInfoInner.from_dict(_item) for _item in obj["video_info"]] if obj.get("video_info") is not None else None,
            "file": [ChatCompletionRequestFilterFileInner.from_dict(_item) for _item in obj["file"]] if obj.get("file") is not None else None
        })
        return _obj


