# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.chat_completion_response_choices_inner import ChatCompletionResponseChoicesInner
from cloudglue.sdk.models.chat_completion_response_usage import ChatCompletionResponseUsage
from typing import Optional, Set
from typing_extensions import Self

class ChatCompletionResponse(BaseModel):
    """
    ChatCompletionResponse
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for this chat completion")
    object: Optional[StrictStr] = Field(default=None, description="Object type, always \"chat.completion\"")
    created: Optional[StrictInt] = Field(default=None, description="Unix timestamp of when the chat completion was created")
    model: Optional[StrictStr] = Field(default=None, description="The model used for the chat completion")
    choices: Optional[List[ChatCompletionResponseChoicesInner]] = Field(default=None, description="The generated responses")
    usage: Optional[ChatCompletionResponseUsage] = None
    __properties: ClassVar[List[str]] = ["id", "object", "created", "model", "choices", "usage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatCompletionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in choices (list)
        _items = []
        if self.choices:
            for _item_choices in self.choices:
                if _item_choices:
                    _items.append(_item_choices.to_dict())
            _dict['choices'] = _items
        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict['usage'] = self.usage.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatCompletionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created": obj.get("created"),
            "model": obj.get("model"),
            "choices": [ChatCompletionResponseChoicesInner.from_dict(_item) for _item in obj["choices"]] if obj.get("choices") is not None else None,
            "usage": ChatCompletionResponseUsage.from_dict(obj["usage"]) if obj.get("usage") is not None else None
        })
        return _obj


