# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.chat_completion_response_choices_inner_citations_inner import ChatCompletionResponseChoicesInnerCitationsInner
from cloudglue.sdk.models.chat_message import ChatMessage
from typing import Optional, Set
from typing_extensions import Self

class ChatCompletionResponseChoicesInner(BaseModel):
    """
    ChatCompletionResponseChoicesInner
    """ # noqa: E501
    index: Optional[StrictInt] = Field(default=None, description="The index of this choice")
    message: Optional[ChatMessage] = Field(default=None, description="The chat message generated by the model")
    citations: Optional[List[ChatCompletionResponseChoicesInnerCitationsInner]] = Field(default=None, description="Citations to specific video segments that informed the response")
    __properties: ClassVar[List[str]] = ["index", "message", "citations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatCompletionResponseChoicesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['message'] = self.message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in citations (list)
        _items = []
        if self.citations:
            for _item_citations in self.citations:
                if _item_citations:
                    _items.append(_item_citations.to_dict())
            _dict['citations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatCompletionResponseChoicesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "index": obj.get("index"),
            "message": ChatMessage.from_dict(obj["message"]) if obj.get("message") is not None else None,
            "citations": [ChatCompletionResponseChoicesInnerCitationsInner.from_dict(_item) for _item in obj["citations"]] if obj.get("citations") is not None else None
        })
        return _obj


