# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.chat_completion_response_choices_inner_citations_inner_end_time import ChatCompletionResponseChoicesInnerCitationsInnerEndTime
from cloudglue.sdk.models.chat_completion_response_choices_inner_citations_inner_relevant_sources_inner import ChatCompletionResponseChoicesInnerCitationsInnerRelevantSourcesInner
from cloudglue.sdk.models.chat_completion_response_choices_inner_citations_inner_scene_text_inner import ChatCompletionResponseChoicesInnerCitationsInnerSceneTextInner
from cloudglue.sdk.models.chat_completion_response_choices_inner_citations_inner_speech_inner import ChatCompletionResponseChoicesInnerCitationsInnerSpeechInner
from cloudglue.sdk.models.chat_completion_response_choices_inner_citations_inner_start_time import ChatCompletionResponseChoicesInnerCitationsInnerStartTime
from cloudglue.sdk.models.chat_completion_response_choices_inner_citations_inner_visual_scene_description_inner import ChatCompletionResponseChoicesInnerCitationsInnerVisualSceneDescriptionInner
from typing import Optional, Set
from typing_extensions import Self

class ChatCompletionResponseChoicesInnerCitationsInner(BaseModel):
    """
    ChatCompletionResponseChoicesInnerCitationsInner
    """ # noqa: E501
    collection_id: Optional[StrictStr] = Field(default=None, description="ID of the collection containing the cited video")
    file_id: Optional[StrictStr] = Field(default=None, description="ID of the file being cited")
    segment_id: Optional[StrictStr] = Field(default=None, description="ID of the segment being cited")
    start_time: Optional[ChatCompletionResponseChoicesInnerCitationsInnerStartTime] = None
    end_time: Optional[ChatCompletionResponseChoicesInnerCitationsInnerEndTime] = None
    text: Optional[StrictStr] = Field(default=None, description="(Deprecated) Relevant text from the segment; use context and relevant_sources instead")
    context: Optional[StrictStr] = Field(default=None, description="Short explanation of the relevance of the segment to the query provided as context")
    relevant_sources: Optional[List[ChatCompletionResponseChoicesInnerCitationsInnerRelevantSourcesInner]] = Field(default=None, description="List of source modalities in segment that are relevant for this citation")
    visual_scene_description: Optional[List[ChatCompletionResponseChoicesInnerCitationsInnerVisualSceneDescriptionInner]] = Field(default=None, description="Description of visual content in the segment")
    scene_text: Optional[List[ChatCompletionResponseChoicesInnerCitationsInnerSceneTextInner]] = Field(default=None, description="Text detected on screen in the segment")
    speech: Optional[List[ChatCompletionResponseChoicesInnerCitationsInnerSpeechInner]] = Field(default=None, description="Transcription of speech in the segment")
    __properties: ClassVar[List[str]] = ["collection_id", "file_id", "segment_id", "start_time", "end_time", "text", "context", "relevant_sources", "visual_scene_description", "scene_text", "speech"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatCompletionResponseChoicesInnerCitationsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of start_time
        if self.start_time:
            _dict['start_time'] = self.start_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of end_time
        if self.end_time:
            _dict['end_time'] = self.end_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in relevant_sources (list)
        _items = []
        if self.relevant_sources:
            for _item_relevant_sources in self.relevant_sources:
                if _item_relevant_sources:
                    _items.append(_item_relevant_sources.to_dict())
            _dict['relevant_sources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in visual_scene_description (list)
        _items = []
        if self.visual_scene_description:
            for _item_visual_scene_description in self.visual_scene_description:
                if _item_visual_scene_description:
                    _items.append(_item_visual_scene_description.to_dict())
            _dict['visual_scene_description'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scene_text (list)
        _items = []
        if self.scene_text:
            for _item_scene_text in self.scene_text:
                if _item_scene_text:
                    _items.append(_item_scene_text.to_dict())
            _dict['scene_text'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in speech (list)
        _items = []
        if self.speech:
            for _item_speech in self.speech:
                if _item_speech:
                    _items.append(_item_speech.to_dict())
            _dict['speech'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatCompletionResponseChoicesInnerCitationsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collection_id": obj.get("collection_id"),
            "file_id": obj.get("file_id"),
            "segment_id": obj.get("segment_id"),
            "start_time": ChatCompletionResponseChoicesInnerCitationsInnerStartTime.from_dict(obj["start_time"]) if obj.get("start_time") is not None else None,
            "end_time": ChatCompletionResponseChoicesInnerCitationsInnerEndTime.from_dict(obj["end_time"]) if obj.get("end_time") is not None else None,
            "text": obj.get("text"),
            "context": obj.get("context"),
            "relevant_sources": [ChatCompletionResponseChoicesInnerCitationsInnerRelevantSourcesInner.from_dict(_item) for _item in obj["relevant_sources"]] if obj.get("relevant_sources") is not None else None,
            "visual_scene_description": [ChatCompletionResponseChoicesInnerCitationsInnerVisualSceneDescriptionInner.from_dict(_item) for _item in obj["visual_scene_description"]] if obj.get("visual_scene_description") is not None else None,
            "scene_text": [ChatCompletionResponseChoicesInnerCitationsInnerSceneTextInner.from_dict(_item) for _item in obj["scene_text"]] if obj.get("scene_text") is not None else None,
            "speech": [ChatCompletionResponseChoicesInnerCitationsInnerSpeechInner.from_dict(_item) for _item in obj["speech"]] if obj.get("speech") is not None else None
        })
        return _obj


