# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.collection_extract_config import CollectionExtractConfig
from cloudglue.sdk.models.collection_transcribe_config import CollectionTranscribeConfig
from typing import Optional, Set
from typing_extensions import Self

class Collection(BaseModel):
    """
    Collection
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the collection")
    object: StrictStr = Field(description="Object type, always 'collection'")
    name: StrictStr = Field(description="Name of the collection")
    description: Optional[StrictStr] = Field(default=None, description="Description of the collection's purpose or contents")
    collection_type: StrictStr = Field(description="Type of collection, determines how videos are processed and what data is extracted")
    extract_config: Optional[CollectionExtractConfig] = None
    transcribe_config: Optional[CollectionTranscribeConfig] = None
    created_at: StrictInt = Field(description="Unix timestamp of when the collection was created")
    file_count: StrictInt = Field(description="Number of files in the collection")
    __properties: ClassVar[List[str]] = ["id", "object", "name", "description", "collection_type", "extract_config", "transcribe_config", "created_at", "file_count"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['collection']):
            raise ValueError("must be one of enum values ('collection')")
        return value

    @field_validator('collection_type')
    def collection_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['entities', 'rich-transcripts']):
            raise ValueError("must be one of enum values ('entities', 'rich-transcripts')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Collection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of extract_config
        if self.extract_config:
            _dict['extract_config'] = self.extract_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transcribe_config
        if self.transcribe_config:
            _dict['transcribe_config'] = self.transcribe_config.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Collection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "collection_type": obj.get("collection_type"),
            "extract_config": CollectionExtractConfig.from_dict(obj["extract_config"]) if obj.get("extract_config") is not None else None,
            "transcribe_config": CollectionTranscribeConfig.from_dict(obj["transcribe_config"]) if obj.get("transcribe_config") is not None else None,
            "created_at": obj.get("created_at"),
            "file_count": obj.get("file_count")
        })
        return _obj


