# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.file import File
from typing import Optional, Set
from typing_extensions import Self

class CollectionFile(BaseModel):
    """
    CollectionFile
    """ # noqa: E501
    collection_id: StrictStr = Field(description="ID of the collection")
    file_id: StrictStr = Field(description="ID of the file")
    object: StrictStr = Field(description="Object type, always 'collection_file'")
    added_at: StrictInt = Field(description="Unix timestamp of when the file was added to the collection")
    status: StrictStr = Field(description="Overall processing status of the file in this collection")
    extract_status: Optional[StrictStr] = Field(default=None, description="Status of the entity extraction processing")
    searchable_status: Optional[StrictStr] = Field(default=None, description="Status of the searchable index processing")
    file: Optional[File] = Field(default=None, description="The file object")
    __properties: ClassVar[List[str]] = ["collection_id", "file_id", "object", "added_at", "status", "extract_status", "searchable_status", "file"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['collection_file']):
            raise ValueError("must be one of enum values ('collection_file')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'processing', 'completed', 'failed', 'not_applicable']):
            raise ValueError("must be one of enum values ('pending', 'processing', 'completed', 'failed', 'not_applicable')")
        return value

    @field_validator('extract_status')
    def extract_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'processing', 'completed', 'failed', 'not_applicable']):
            raise ValueError("must be one of enum values ('pending', 'processing', 'completed', 'failed', 'not_applicable')")
        return value

    @field_validator('searchable_status')
    def searchable_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'processing', 'completed', 'failed', 'not_applicable']):
            raise ValueError("must be one of enum values ('pending', 'processing', 'completed', 'failed', 'not_applicable')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollectionFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollectionFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collection_id": obj.get("collection_id"),
            "file_id": obj.get("file_id"),
            "object": obj.get("object"),
            "added_at": obj.get("added_at"),
            "status": obj.get("status"),
            "extract_status": obj.get("extract_status"),
            "searchable_status": obj.get("searchable_status"),
            "file": File.from_dict(obj["file"]) if obj.get("file") is not None else None
        })
        return _obj


